/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

class FloatingDecimal {
    boolean isExceptional;
    boolean isNegative;
    int decExponent;
    char[] digits;
    int nDigits;
    static final long signMask = Long.MIN_VALUE;
    static final long expMask = 0x7FF0000000000000L;
    static final long fractMask = 0xFFFFFFFFFFFFFL;
    static final int expShift = 52;
    static final int expBias = 1023;
    static final long fractHOB = 1L << 52;
    static final long expOne = 1023L << 52;
    static final int maxSmallBinExp = 62;
    static final int minSmallBinExp = -21;
    static final long highbyte = -72057594037927936L;
    static final long highbit = Long.MIN_VALUE;
    static final long lowbytes = 0xFFFFFFFFFFFFFFL;
    static final int singleSignMask = Integer.MIN_VALUE;
    static final int singleExpMask = 2139095040;
    static final int singleFractMask = 0x7FFFFF;
    static final int singleExpShift = 23;
    static final int singleFractHOB = 0x800000;
    static final int singleExpBias = 127;
    private static FDBigInt[] b5p;
    private static final int[] small5pow;
    private static final long[] long5pow;
    private static final int[] n5bits;
    private static final char[] infinity;
    private static final char[] notANumber;
    private static final char[] zero;

    private FloatingDecimal(boolean bl, int n, char[] cArray, int n2, boolean bl2) {
        this.isNegative = bl;
        this.isExceptional = bl2;
        this.decExponent = n;
        this.digits = cArray;
        this.nDigits = n2;
    }

    /*
     * Unable to fully structure code
     */
    private static int countBits(long var0) {
        if (var0 != 0L) ** GOTO lbl4
        return 0;
lbl-1000:
        // 1 sources

        {
            var0 <<= 8;
lbl4:
            // 2 sources

            ** while ((var0 & -72057594037927936L) == 0L)
        }
lbl5:
        // 2 sources

        while (var0 > 0L) {
            var0 <<= 1;
        }
        var2_1 = 0;
        while ((var0 & 0xFFFFFFFFFFFFFFL) != 0L) {
            var0 <<= 8;
            var2_1 += 8;
        }
        while (var0 != 0L) {
            var0 <<= 1;
            ++var2_1;
        }
        return var2_1;
    }

    private static FDBigInt big5pow(int n) {
        if (n < 0) {
            throw new RuntimeException("Assertion botch: negative power of 5");
        }
        if (b5p == null) {
            b5p = new FDBigInt[n + 1];
        } else if (b5p.length <= n) {
            FDBigInt[] fDBigIntArray = new FDBigInt[n + 1];
            System.arraycopy(b5p, 0, fDBigIntArray, 0, b5p.length);
            b5p = fDBigIntArray;
        }
        if (b5p[n] != null) {
            return b5p[n];
        }
        if (n < small5pow.length) {
            FloatingDecimal.b5p[n] = new FDBigInt(small5pow[n]);
            return FloatingDecimal.b5p[n];
        }
        if (n < long5pow.length) {
            FloatingDecimal.b5p[n] = new FDBigInt(long5pow[n]);
            return FloatingDecimal.b5p[n];
        }
        int n2 = n >> 1;
        int n3 = n - n2;
        FDBigInt fDBigInt = b5p[n2];
        if (fDBigInt == null) {
            fDBigInt = FloatingDecimal.big5pow(n2);
        }
        if (n3 < small5pow.length) {
            FloatingDecimal.b5p[n] = fDBigInt.mult(small5pow[n3]);
            return FloatingDecimal.b5p[n];
        }
        FDBigInt fDBigInt2 = b5p[n3];
        if (fDBigInt2 == null) {
            fDBigInt2 = FloatingDecimal.big5pow(n3);
        }
        FloatingDecimal.b5p[n] = fDBigInt.mult(fDBigInt2);
        return FloatingDecimal.b5p[n];
    }

    private void developLongDigits(int n, long l, long l2) {
        char[] cArray;
        int n2;
        char[] cArray2;
        int n3;
        int n4 = 0;
        while (l2 >= 10L) {
            l2 /= 10L;
            ++n4;
        }
        if (n4 != 0) {
            long l3 = long5pow[n4] << n4;
            long l4 = l % l3;
            l /= l3;
            n += n4;
            if (l4 >= l3 >> 1) {
                ++l;
            }
        }
        if (l <= Integer.MAX_VALUE) {
            if (l <= 0L) {
                throw new RuntimeException("Assertion botch: value " + l + " <= 0");
            }
            int n5 = (int)l;
            n3 = 10;
            cArray2 = new char[10];
            n2 = n3 - 1;
            int n6 = n5 % 10;
            n5 /= 10;
            while (n6 == 0) {
                ++n;
                n6 = n5 % 10;
                n5 /= 10;
            }
            while (n5 != 0) {
                cArray2[n2--] = (char)(n6 + 48);
                ++n;
                n6 = n5 % 10;
                n5 /= 10;
            }
            cArray2[n2] = (char)(n6 + 48);
        } else {
            n3 = 20;
            cArray2 = new char[20];
            n2 = n3 - 1;
            int n7 = (int)(l % 10L);
            l /= 10L;
            while (n7 == 0) {
                ++n;
                n7 = (int)(l % 10L);
                l /= 10L;
            }
            while (l != 0L) {
                cArray2[n2--] = (char)(n7 + 48);
                ++n;
                n7 = (int)(l % 10L);
                l /= 10L;
            }
            cArray2[n2] = (char)(n7 + 48);
        }
        n3 -= n2;
        if (n2 == 0) {
            cArray = cArray2;
        } else {
            cArray = new char[n3];
            System.arraycopy(cArray2, n2, cArray, 0, n3);
        }
        this.digits = cArray;
        this.decExponent = n + 1;
        this.nDigits = n3;
    }

    private void roundup() {
        int n = this.nDigits - 1;
        char c = this.digits[n];
        if (c == '9') {
            while (c == '9' && n > 0) {
                this.digits[n] = 48;
                c = this.digits[--n];
            }
            if (c == '9') {
                ++this.decExponent;
                this.digits[0] = 49;
                return;
            }
        }
        this.digits[n] = (char)(c + '\u0001');
    }

    /*
     * Unable to fully structure code
     */
    public FloatingDecimal(double var1_1) {
        block7: {
            block6: {
                super();
                var3_2 = Double.doubleToLongBits(var1_1);
                if ((var3_2 & -9223372036854775808L) != 0L) {
                    this.isNegative = true;
                    var3_2 ^= -9223372036854775808L;
                } else {
                    this.isNegative = false;
                }
                var7_3 = (int)((var3_2 & 0x7FF0000000000000L) >> 52);
                var5_4 = var3_2 & 0xFFFFFFFFFFFFFL;
                if (var7_3 == (int)(0x7FF0000000000000L >> 52)) {
                    this.isExceptional = true;
                    if (var5_4 == 0L) {
                        this.digits = FloatingDecimal.infinity;
                    } else {
                        this.digits = FloatingDecimal.notANumber;
                        this.isNegative = false;
                    }
                    this.nDigits = this.digits.length;
                    return;
                }
                this.isExceptional = false;
                if (var7_3 != 0) break block6;
                if (var5_4 != 0L) ** GOTO lbl28
                this.decExponent = 0;
                this.digits = FloatingDecimal.zero;
                this.nDigits = 1;
                return;
lbl-1000:
                // 1 sources

                {
                    var5_4 <<= 1;
                    --var7_3;
lbl28:
                    // 2 sources

                    ** while ((var5_4 & 1L << 52) == 0L)
                }
lbl29:
                // 1 sources

                var8_5 = 52 + var7_3;
                ++var7_3;
                break block7;
            }
            var5_4 |= 1L << 52;
            var8_5 = 53;
        }
        this.dtoa(var7_3 -= 1023, var5_4, var8_5);
    }

    /*
     * Unable to fully structure code
     */
    public FloatingDecimal(float var1_1) {
        block7: {
            block6: {
                super();
                var2_2 = Float.floatToIntBits(var1_1);
                if ((var2_2 & -2147483648) != 0) {
                    this.isNegative = true;
                    var2_2 ^= -2147483648;
                } else {
                    this.isNegative = false;
                }
                var4_3 = (var2_2 & 2139095040) >> 23;
                var3_4 = var2_2 & 0x7FFFFF;
                if (var4_3 == 255) {
                    this.isExceptional = true;
                    if ((long)var3_4 == 0L) {
                        this.digits = FloatingDecimal.infinity;
                    } else {
                        this.digits = FloatingDecimal.notANumber;
                        this.isNegative = false;
                    }
                    this.nDigits = this.digits.length;
                    return;
                }
                this.isExceptional = false;
                if (var4_3 != 0) break block6;
                if (var3_4 != 0) ** GOTO lbl28
                this.decExponent = 0;
                this.digits = FloatingDecimal.zero;
                this.nDigits = 1;
                return;
lbl-1000:
                // 1 sources

                {
                    var3_4 <<= 1;
                    --var4_3;
lbl28:
                    // 2 sources

                    ** while ((var3_4 & 0x800000) == 0)
                }
lbl29:
                // 1 sources

                var5_5 = 23 + var4_3;
                ++var4_3;
                break block7;
            }
            var3_4 |= 0x800000;
            var5_5 = 24;
        }
        this.dtoa(var4_3 -= 127, (long)var3_4 << 29, var5_5);
    }

    private void dtoa(int n, long l, int n2) {
        block39: {
            block40: {
                block42: {
                    long l2;
                    block41: {
                        boolean bl;
                        boolean bl2;
                        int n3;
                        int n4 = FloatingDecimal.countBits(l);
                        int n5 = n4 - n - 1;
                        int n6 = n3 = n5 <= 0 ? 0 : n5;
                        if (n <= 62 && n >= -21 && n3 < long5pow.length && n4 + n5bits[n3] < 64 && n3 == 0) {
                            long l3 = n > n2 ? 1L << n - n2 - 1 : 0L;
                            l = n >= 52 ? (l <<= n - 52) : (l >>>= 52 - n);
                            this.developLongDigits(0, l, l3);
                            return;
                        }
                        double d = Double.longBitsToDouble(1023L << 52 | l & (1L << 52 ^ 0xFFFFFFFFFFFFFFFFL));
                        int n7 = (int)Math.floor((d - 1.5) * 0.289529654 + 0.176091259 + (double)n * 0.301029995663981);
                        int n8 = -n7;
                        int n9 = n8 <= 0 ? 0 : n8;
                        int n10 = n9 + n3 + n;
                        int n11 = n7 <= 0 ? 0 : n7;
                        int n12 = n11 + n3;
                        int n13 = n9;
                        int n14 = n10 - n2;
                        l >>>= 53 - n4;
                        n8 = (n10 -= n4 - 1) <= n12 ? n10 : n12;
                        n10 -= n8;
                        n12 -= n8;
                        n14 -= n8;
                        if (n4 == 1) {
                            --n14;
                        }
                        if (n14 < 0) {
                            n10 -= n14;
                            n12 -= n14;
                            n14 = 0;
                        }
                        this.digits = new char[18];
                        char[] cArray = this.digits;
                        int n15 = 0;
                        int n16 = n4 + n10 + (n9 < n5bits.length ? n5bits[n9] : n9 * 3);
                        int n17 = n12 + 1 + (n11 + 1 < n5bits.length ? n5bits[n11 + 1] : (n11 + 1) * 3);
                        if (n16 < 64 && n17 < 64) {
                            if (n16 < 32 && n17 < 32) {
                                int n18 = (int)l * small5pow[n9] << n10;
                                int n19 = small5pow[n11] << n12;
                                int n20 = small5pow[n13] << n14;
                                int n21 = n19 * 10;
                                n15 = 0;
                                int n22 = n18 / n19;
                                bl2 = (n18 = 10 * (n18 % n19)) < (n20 *= 10);
                                boolean bl3 = bl = n18 + n20 > n21;
                                if (n22 >= 10) {
                                    throw new RuntimeException("Assertion botch: excessivly large digit " + n22);
                                }
                                if (n22 == 0 && !bl) {
                                    --n7;
                                } else {
                                    cArray[n15++] = (char)(48 + n22);
                                }
                                if (n7 <= -3 || n7 >= 8) {
                                    bl2 = false;
                                    bl = false;
                                }
                                while (!bl2 && !bl) {
                                    n22 = n18 / n19;
                                    n18 = 10 * (n18 % n19);
                                    n20 *= 10;
                                    if (n22 >= 10) {
                                        throw new RuntimeException("Assertion botch: excessivly large digit " + n22);
                                    }
                                    if ((long)n20 > 0L) {
                                        bl2 = n18 < n20;
                                        bl = n18 + n20 > n21;
                                    } else {
                                        bl2 = true;
                                        bl = true;
                                    }
                                    cArray[n15++] = (char)(48 + n22);
                                }
                                l2 = (n18 << 1) - n21;
                            } else {
                                long l4 = l * long5pow[n9] << n10;
                                long l5 = long5pow[n11] << n12;
                                long l6 = long5pow[n13] << n14;
                                long l7 = l5 * 10L;
                                n15 = 0;
                                int n23 = (int)(l4 / l5);
                                bl2 = (l4 = 10L * (l4 % l5)) < (l6 *= 10L);
                                boolean bl4 = bl = l4 + l6 > l7;
                                if (n23 >= 10) {
                                    throw new RuntimeException("Assertion botch: excessivly large digit " + n23);
                                }
                                if (n23 == 0 && !bl) {
                                    --n7;
                                } else {
                                    cArray[n15++] = (char)(48 + n23);
                                }
                                if (n7 <= -3 || n7 >= 8) {
                                    bl2 = false;
                                    bl = false;
                                }
                                while (!bl2 && !bl) {
                                    n23 = (int)(l4 / l5);
                                    l4 = 10L * (l4 % l5);
                                    l6 *= 10L;
                                    if (n23 >= 10) {
                                        throw new RuntimeException("Assertion botch: excessivly large digit " + n23);
                                    }
                                    if (l6 > 0L) {
                                        bl2 = l4 < l6;
                                        bl = l4 + l6 > l7;
                                    } else {
                                        bl2 = true;
                                        bl = true;
                                    }
                                    cArray[n15++] = (char)(48 + n23);
                                }
                                l2 = (l4 << 1) - l7;
                            }
                        } else {
                            FDBigInt fDBigInt = new FDBigInt(l);
                            if (n9 != 0) {
                                fDBigInt = n9 < small5pow.length ? fDBigInt.mult(small5pow[n9]) : fDBigInt.mult(FloatingDecimal.big5pow(n9));
                            }
                            if (n10 != 0) {
                                fDBigInt.lshiftMe(n10);
                            }
                            FDBigInt fDBigInt2 = new FDBigInt(FloatingDecimal.big5pow(n11));
                            if (n12 != 0) {
                                fDBigInt2.lshiftMe(n12);
                            }
                            FDBigInt fDBigInt3 = new FDBigInt(FloatingDecimal.big5pow(n13));
                            if (n14 != 0) {
                                fDBigInt3.lshiftMe(n14);
                            }
                            int n24 = fDBigInt2.normalizeMe();
                            fDBigInt.lshiftMe(n24);
                            fDBigInt3.lshiftMe(n24);
                            FDBigInt fDBigInt4 = fDBigInt2.mult(10);
                            n15 = 0;
                            int n25 = fDBigInt.quoRemIteration(fDBigInt2);
                            fDBigInt3 = fDBigInt3.mult(10);
                            bl2 = fDBigInt.cmp(fDBigInt3) < 0;
                            boolean bl5 = bl = fDBigInt.add(fDBigInt3).cmp(fDBigInt4) > 0;
                            if (n25 >= 10) {
                                throw new RuntimeException("Assertion botch: excessivly large digit " + n25);
                            }
                            if (n25 == 0 && !bl) {
                                --n7;
                            } else {
                                cArray[n15++] = (char)(48 + n25);
                            }
                            if (n7 <= -3 || n7 >= 8) {
                                bl2 = false;
                                bl = false;
                            }
                            while (!bl2 && !bl) {
                                n25 = fDBigInt.quoRemIteration(fDBigInt2);
                                fDBigInt3 = fDBigInt3.mult(10);
                                if (n25 >= 10) {
                                    throw new RuntimeException("Assertion botch: excessivly large digit " + n25);
                                }
                                bl2 = fDBigInt.cmp(fDBigInt3) < 0;
                                bl = fDBigInt.add(fDBigInt3).cmp(fDBigInt4) > 0;
                                cArray[n15++] = (char)(48 + n25);
                            }
                            if (bl && bl2) {
                                fDBigInt.lshiftMe(1);
                                l2 = fDBigInt.cmp(fDBigInt4);
                            } else {
                                l2 = 0L;
                            }
                        }
                        this.decExponent = n7 + 1;
                        this.digits = cArray;
                        this.nDigits = n15;
                        if (!bl) break block39;
                        if (!bl2) break block40;
                        if (l2 != 0L) break block41;
                        if ((cArray[this.nDigits - 1] & '\u0001') != 0) {
                            this.roundup();
                            return;
                        }
                        break block42;
                    }
                    if (l2 <= 0L) break block39;
                    this.roundup();
                }
                return;
            }
            this.roundup();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.nDigits + 8);
        if (this.isNegative) {
            stringBuffer.append('-');
        }
        if (this.isExceptional) {
            stringBuffer.append(this.digits, 0, this.nDigits);
        } else {
            stringBuffer.append("0.");
            stringBuffer.append(this.digits, 0, this.nDigits);
            stringBuffer.append('e');
            int n = this.decExponent;
            stringBuffer.append(Integer.toString(n, 10));
        }
        return new String(stringBuffer);
    }

    public String toJavaFormatString() {
        char[] cArray = new char[this.nDigits + 10];
        int n = 0;
        if (this.isNegative) {
            cArray[0] = 45;
            n = 1;
        }
        if (this.isExceptional) {
            System.arraycopy(this.digits, 0, cArray, n, this.nDigits);
            n += this.nDigits;
        } else if (this.decExponent > 0 && this.decExponent < 8) {
            int n2 = this.nDigits;
            int n3 = this.decExponent;
            n2 = n2 <= n3 ? n2 : n3;
            System.arraycopy(this.digits, 0, cArray, n, n2);
            n += n2;
            if (n2 < this.decExponent) {
                n2 = this.decExponent - n2;
                System.arraycopy(zero, 0, cArray, n, n2);
                n += n2;
                cArray[n++] = 46;
                cArray[n++] = 48;
            } else {
                cArray[n++] = 46;
                if (n2 < this.nDigits) {
                    n3 = this.nDigits - n2;
                    System.arraycopy(this.digits, n2, cArray, n, n3);
                    n += n3;
                } else {
                    cArray[n++] = 48;
                }
            }
        } else if (this.decExponent <= 0 && this.decExponent > -3) {
            cArray[n++] = 48;
            cArray[n++] = 46;
            if (this.decExponent != 0) {
                System.arraycopy(zero, 0, cArray, n, -this.decExponent);
                n -= this.decExponent;
            }
            System.arraycopy(this.digits, 0, cArray, n, this.nDigits);
            n += this.nDigits;
        } else {
            int n4;
            cArray[n++] = this.digits[0];
            cArray[n++] = 46;
            if (this.nDigits > 1) {
                System.arraycopy(this.digits, 1, cArray, n, this.nDigits - 1);
                n += this.nDigits - 1;
            } else {
                cArray[n++] = 48;
            }
            cArray[n++] = 69;
            if (this.decExponent <= 0) {
                cArray[n++] = 45;
                n4 = -this.decExponent + 1;
            } else {
                n4 = this.decExponent - 1;
            }
            if (n4 <= 9) {
                cArray[n++] = (char)(n4 + 48);
            } else if (n4 <= 99) {
                cArray[n++] = (char)(n4 / 10 + 48);
                cArray[n++] = (char)(n4 % 10 + 48);
            } else {
                cArray[n++] = (char)(n4 / 100 + 48);
                cArray[n++] = (char)((n4 %= 100) / 10 + 48);
                cArray[n++] = (char)(n4 % 10 + 48);
            }
        }
        return new String(cArray, 0, n);
    }

    static {
        small5pow = new int[]{1, 5, 25, 125, 625, 3125, 15625, 78125, 390625, 1953125, 9765625, 48828125, 244140625, 1220703125};
        long5pow = new long[]{1L, 5L, 25L, 125L, 625L, 3125L, 15625L, 78125L, 390625L, 1953125L, 9765625L, 48828125L, 244140625L, 1220703125L, 6103515625L, 30517578125L, 152587890625L, 762939453125L, 3814697265625L, 19073486328125L, 95367431640625L, 476837158203125L, 2384185791015625L, 11920928955078125L, 59604644775390625L, 298023223876953125L, 1490116119384765625L};
        n5bits = new int[]{0, 3, 5, 7, 10, 12, 14, 17, 19, 21, 24, 26, 28, 31, 33, 35, 38, 40, 42, 45, 47, 49, 52, 54, 56, 59, 61};
        infinity = new char[]{'I', 'n', 'f', 'i', 'n', 'i', 't', 'y'};
        notANumber = new char[]{'N', 'a', 'N'};
        zero = new char[]{'0', '0', '0', '0', '0', '0', '0', '0'};
    }
}

