/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;

public final class UID
implements Serializable {
    private int unique;
    private long time;
    private short count;
    private static int hostUnique = UID.getHostUniqueNum();
    private static long lastTime = System.currentTimeMillis();
    private static short lastCount = Short.MIN_VALUE;
    private static Object mutex = new Object();
    private static long ONE_SECOND = 1000L;

    private static int getHostUniqueNum() {
        return new Object().hashCode();
    }

    public UID() {
        Object object = mutex;
        synchronized (object) {
            if (lastCount == Short.MAX_VALUE) {
                boolean bl = false;
                while (!bl) {
                    this.time = System.currentTimeMillis();
                    if (this.time < lastTime + ONE_SECOND) {
                        try {
                            Thread.currentThread();
                            Thread.sleep(ONE_SECOND);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    lastTime = this.time;
                    lastCount = Short.MIN_VALUE;
                    bl = true;
                }
            } else {
                this.time = lastTime;
            }
            this.unique = hostUnique;
            short s = lastCount;
            lastCount = (short)(s + 1);
            this.count = s;
            return;
        }
    }

    public UID(short s) {
        this.unique = 0;
        this.time = 0L;
        this.count = s;
    }

    private UID(int n, long l, short s) {
        this.unique = n;
        this.time = l;
        this.count = s;
    }

    public int hashCode() {
        return (int)this.time + this.count;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof UID) {
            UID uID = (UID)object;
            return this.unique == uID.unique && this.count == uID.count && this.time == uID.time;
        }
        return false;
    }

    public String toString() {
        return String.valueOf(Integer.toString(this.unique, 16)) + ":" + Long.toString(this.time, 16) + ":" + Integer.toString(this.count, 16);
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.unique);
        dataOutput.writeLong(this.time);
        dataOutput.writeShort(this.count);
    }

    public static UID read(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        long l = dataInput.readLong();
        short s = dataInput.readShort();
        return new UID(n, l, s);
    }
}

