/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.Security;
import java.security.Sleeper;

class SeedGenerator {
    private static int sleepTime;
    private static final int TARGET_SPIN_COUNT = 55000;
    private static final int MIN_SPIN_COUNT = 33000;
    private static final int MAX_SPIN_COUNT = 110000;

    private static void setSleepTime() {
        sleepTime = 55000000 / SeedGenerator.genSeed(1000);
        Security.debug("Resetting sleep time for seed generation: " + sleepTime + " ms.");
    }

    public static synchronized int genSeed() {
        int n = SeedGenerator.genSeed(sleepTime);
        while (n < 33000) {
            Security.debug("Candidate seed too low: " + n + " ms.");
            SeedGenerator.setSleepTime();
            n = SeedGenerator.genSeed(sleepTime);
        }
        if (n > 110000) {
            Security.debug("Candidate seed too high: " + n + " ms.");
            SeedGenerator.setSleepTime();
        }
        return n;
    }

    private static int genSeed(int n) {
        int n2 = 0;
        Sleeper sleeper = new Sleeper(n);
        sleeper.start();
        while (sleeper.isAlive()) {
            ++n2;
            Thread.yield();
        }
        return n2;
    }

    SeedGenerator() {
    }

    static {
        SeedGenerator.setSleepTime();
    }
}

