/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.text.resources.LocaleData;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;

public abstract class Calendar
implements Serializable,
Cloneable {
    public static final int ERA = 0;
    public static final int YEAR = 1;
    public static final int MONTH = 2;
    public static final int WEEK_OF_YEAR = 3;
    public static final int WEEK_OF_MONTH = 4;
    public static final int DATE = 5;
    public static final int DAY_OF_MONTH = 5;
    public static final int DAY_OF_YEAR = 6;
    public static final int DAY_OF_WEEK = 7;
    public static final int DAY_OF_WEEK_IN_MONTH = 8;
    public static final int AM_PM = 9;
    public static final int HOUR = 10;
    public static final int HOUR_OF_DAY = 11;
    public static final int MINUTE = 12;
    public static final int SECOND = 13;
    public static final int MILLISECOND = 14;
    public static final int ZONE_OFFSET = 15;
    public static final int DST_OFFSET = 16;
    public static final int FIELD_COUNT = 17;
    public static final int SUNDAY = 1;
    public static final int MONDAY = 2;
    public static final int TUESDAY = 3;
    public static final int WEDNESDAY = 4;
    public static final int THURSDAY = 5;
    public static final int FRIDAY = 6;
    public static final int SATURDAY = 7;
    public static final int JANUARY = 0;
    public static final int FEBRUARY = 1;
    public static final int MARCH = 2;
    public static final int APRIL = 3;
    public static final int MAY = 4;
    public static final int JUNE = 5;
    public static final int JULY = 6;
    public static final int AUGUST = 7;
    public static final int SEPTEMBER = 8;
    public static final int OCTOBER = 9;
    public static final int NOVEMBER = 10;
    public static final int DECEMBER = 11;
    public static final int UNDECIMBER = 12;
    public static final int AM = 0;
    public static final int PM = 1;
    protected int[] fields = new int[17];
    protected boolean[] isSet = new boolean[17];
    protected long time;
    protected boolean isTimeSet;
    protected boolean areFieldsSet;
    private boolean lenient = true;
    private TimeZone zone;
    private int firstDayOfWeek;
    private int minimalDaysInFirstWeek;

    protected Calendar() {
        this.zone = TimeZone.getDefault();
        this.setWeekCountData(Locale.getDefault());
    }

    protected Calendar(TimeZone timeZone, Locale locale) {
        this.zone = timeZone;
        this.setWeekCountData(locale);
    }

    public static synchronized Calendar getInstance() {
        return new GregorianCalendar();
    }

    public static synchronized Calendar getInstance(TimeZone timeZone) {
        return new GregorianCalendar(timeZone, Locale.getDefault());
    }

    public static synchronized Calendar getInstance(Locale locale) {
        return new GregorianCalendar(TimeZone.getDefault(), locale);
    }

    public static synchronized Calendar getInstance(TimeZone timeZone, Locale locale) {
        return new GregorianCalendar(timeZone, locale);
    }

    public static synchronized Locale[] getAvailableLocales() {
        return LocaleData.getAvailableLocales("DateTimePatterns");
    }

    protected abstract void computeTime();

    protected abstract void computeFields();

    public final Date getTime() {
        return new Date(this.getTimeInMillis());
    }

    public final void setTime(Date date) {
        this.setTimeInMillis(date.getTime());
    }

    protected long getTimeInMillis() {
        if (!this.isTimeSet) {
            this.computeTime();
        }
        return this.time;
    }

    protected void setTimeInMillis(long l) {
        this.areFieldsSet = false;
        this.isTimeSet = true;
        this.time = l;
    }

    public final int get(int n) {
        if (!this.areFieldsSet) {
            this.computeFields();
        }
        return this.fields[n];
    }

    protected final int internalGet(int n) {
        return this.fields[n];
    }

    public final void set(int n, int n2) {
        this.isTimeSet = false;
        this.fields[n] = n2;
        this.isSet[n] = true;
        this.areFieldsSet = true;
    }

    public final void set(int n, int n2, int n3) {
        this.set(1, n);
        this.set(2, n2);
        this.set(5, n3);
    }

    public final void set(int n, int n2, int n3, int n4, int n5) {
        this.set(1, n);
        this.set(2, n2);
        this.set(5, n3);
        this.set(11, n4);
        this.set(12, n5);
    }

    public final void set(int n, int n2, int n3, int n4, int n5, int n6) {
        this.set(1, n);
        this.set(2, n2);
        this.set(5, n3);
        this.set(11, n4);
        this.set(12, n5);
        this.set(13, n6);
    }

    public final void clear() {
        this.isSet = new boolean[17];
        this.fields = new int[17];
        this.areFieldsSet = false;
    }

    public final void clear(int n) {
        this.isSet[n] = false;
        this.fields[n] = 0;
    }

    public final boolean isSet(int n) {
        return this.isSet[n];
    }

    protected void complete() {
        this.computeTime();
        this.computeFields();
    }

    public abstract boolean equals(Object var1);

    public abstract boolean before(Object var1);

    public abstract boolean after(Object var1);

    public abstract void add(int var1, int var2);

    public abstract void roll(int var1, boolean var2);

    public void setTimeZone(TimeZone timeZone) {
        this.zone = timeZone;
    }

    public TimeZone getTimeZone() {
        return this.zone;
    }

    public void setLenient(boolean bl) {
        this.lenient = bl;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public void setFirstDayOfWeek(int n) {
        this.firstDayOfWeek = n;
    }

    public int getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    public void setMinimalDaysInFirstWeek(int n) {
        this.minimalDaysInFirstWeek = n;
    }

    public int getMinimalDaysInFirstWeek() {
        return this.minimalDaysInFirstWeek;
    }

    public abstract int getMinimum(int var1);

    public abstract int getMaximum(int var1);

    public abstract int getGreatestMinimum(int var1);

    public abstract int getLeastMaximum(int var1);

    public Object clone() {
        try {
            Calendar calendar = (Calendar)super.clone();
            calendar.fields = new int[17];
            calendar.isSet = new boolean[17];
            System.arraycopy(this.fields, 0, calendar.fields, 0, 17);
            System.arraycopy(this.isSet, 0, calendar.isSet, 0, 17);
            calendar.zone = (TimeZone)this.zone.clone();
            return calendar;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    private void setWeekCountData(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("java.text.resources.LocaleElements", locale);
        String[] stringArray = (String[])resourceBundle.getObject("DateTimeElements");
        String string = stringArray[0];
        this.firstDayOfWeek = Integer.parseInt(string, 10);
        string = stringArray[1];
        this.minimalDaysInFirstWeek = Integer.parseInt(string, 10);
    }
}

