/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class SimpleTimeZone
extends TimeZone {
    private int startMonth;
    private int startDay;
    private int startDayOfWeek;
    private int startTime;
    private int endMonth;
    private int endDay;
    private int endDayOfWeek;
    private int endTime;
    private int startYear;
    private int rawOffset;
    private boolean useDaylight = false;
    private static final int millisPerHour = 3600000;
    private final byte[] monthLength = new byte[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    public SimpleTimeZone(int n, String string) {
        this.rawOffset = n;
        this.setID(string);
    }

    public SimpleTimeZone(int n, String string, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.setID(string);
        this.rawOffset = n;
        this.startMonth = n2;
        this.startDay = n3;
        this.startTime = n5;
        this.endMonth = n6;
        this.endDay = n7;
        this.endTime = n9;
        this.useDaylight = true;
    }

    public void setStartYear(int n) {
        this.startYear = n;
        if (!this.useDaylight) {
            this.useDaylight = true;
        }
    }

    public void setStartRule(int n, int n2, int n3, int n4) {
        this.startMonth = n;
        this.startDay = n2;
        this.startDayOfWeek = n3;
        this.startTime = n4;
        if (!this.useDaylight) {
            this.useDaylight = true;
        }
    }

    public void setEndRule(int n, int n2, int n3, int n4) {
        this.endMonth = n;
        this.endDay = n2;
        this.endDayOfWeek = n3;
        this.endTime = n4;
        if (!this.useDaylight) {
            this.useDaylight = true;
        }
    }

    public int getOffset(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = this.rawOffset;
        if (n3 < this.startMonth || n3 > this.endMonth || n2 < this.startYear || n != 1) {
            return n7;
        }
        if (n3 == this.startMonth) {
            int n8 = this.startDay > 0 ? 1 + (this.startDay - 1) * 7 + (7 + this.startDayOfWeek - (n5 - n4 + 1)) % 7 : this.monthLength[n3] + (this.startDay + 1) * 7 - (7 + (n5 + this.monthLength[n3] - n4) - this.startDayOfWeek) % 7;
            if (n4 > n8 || n4 == n8 && n6 >= this.startTime) {
                n7 += 3600000;
            }
        } else if (n3 == this.endMonth) {
            int n9 = this.endDay > 0 ? 1 + (this.endDay - 1) * 7 + (7 + this.endDayOfWeek - (n5 - n4 + 1)) % 7 : this.monthLength[n3] + (this.endDay + 1) * 7 - (7 + (n5 + this.monthLength[n3] - n4) - this.endDayOfWeek) % 7;
            if (n4 < n9 || n4 == n9 && n6 < this.endTime) {
                n7 += 3600000;
            }
        } else {
            n7 += 3600000;
        }
        return n7;
    }

    public int getRawOffset() {
        return this.rawOffset;
    }

    public void setRawOffset(int n) {
        this.rawOffset = n;
    }

    public boolean useDaylightTime() {
        return this.useDaylight;
    }

    public boolean inDaylightTime(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(date.getTime());
        int n = this.getRawOffset();
        if (!gregorianCalendar.areFieldsSet) {
            ((Calendar)gregorianCalendar).computeFields();
        }
        int n2 = gregorianCalendar.fields[1];
        if (!gregorianCalendar.areFieldsSet) {
            ((Calendar)gregorianCalendar).computeFields();
        }
        int n3 = gregorianCalendar.fields[2];
        if (!gregorianCalendar.areFieldsSet) {
            ((Calendar)gregorianCalendar).computeFields();
        }
        int n4 = gregorianCalendar.fields[5];
        if (!gregorianCalendar.areFieldsSet) {
            ((Calendar)gregorianCalendar).computeFields();
        }
        return n != this.getOffset(1, n2, n3, n4, gregorianCalendar.fields[7], 0);
    }

    public Object clone() {
        return (SimpleTimeZone)super.clone();
    }

    public synchronized int hashCode() {
        return this.startMonth ^ this.startDay ^ this.startDayOfWeek ^ this.startTime ^ this.endMonth ^ this.endDay ^ this.endDayOfWeek ^ this.endTime ^ this.rawOffset;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SimpleTimeZone)) {
            return false;
        }
        SimpleTimeZone simpleTimeZone = (SimpleTimeZone)object;
        if (this.hashCode() != simpleTimeZone.hashCode()) {
            return false;
        }
        if (!this.getID().equals(simpleTimeZone.getID())) {
            return false;
        }
        if (this.startMonth != simpleTimeZone.startMonth) {
            return false;
        }
        if (this.startDay != simpleTimeZone.startDay) {
            return false;
        }
        if (this.startDayOfWeek != simpleTimeZone.startDayOfWeek) {
            return false;
        }
        if (this.startTime != simpleTimeZone.startTime) {
            return false;
        }
        if (this.endMonth != simpleTimeZone.endMonth) {
            return false;
        }
        if (this.endDay != simpleTimeZone.endDay) {
            return false;
        }
        if (this.endDayOfWeek != simpleTimeZone.endDayOfWeek) {
            return false;
        }
        if (this.endTime != simpleTimeZone.endTime) {
            return false;
        }
        if (this.startYear != simpleTimeZone.startYear) {
            return false;
        }
        if (this.rawOffset != simpleTimeZone.rawOffset) {
            return false;
        }
        return this.useDaylight == simpleTimeZone.useDaylight;
    }
}

