/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.AWTEvent;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.PrintJob;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.peer.ButtonPeer;
import java.awt.peer.CanvasPeer;
import java.awt.peer.CheckboxMenuItemPeer;
import java.awt.peer.CheckboxPeer;
import java.awt.peer.ChoicePeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FileDialogPeer;
import java.awt.peer.FontPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.LabelPeer;
import java.awt.peer.ListPeer;
import java.awt.peer.MenuBarPeer;
import java.awt.peer.MenuItemPeer;
import java.awt.peer.MenuPeer;
import java.awt.peer.PanelPeer;
import java.awt.peer.PopupMenuPeer;
import java.awt.peer.ScrollPanePeer;
import java.awt.peer.ScrollbarPeer;
import java.awt.peer.TextAreaPeer;
import java.awt.peer.TextFieldPeer;
import java.awt.peer.WindowPeer;
import java.util.Properties;
import sun.awt.SunToolkit;
import sun.awt.image.ImageRepresentation;
import sun.awt.motif.InputThread;
import sun.awt.motif.MButtonPeer;
import sun.awt.motif.MCanvasPeer;
import sun.awt.motif.MCheckboxMenuItemPeer;
import sun.awt.motif.MCheckboxPeer;
import sun.awt.motif.MChoicePeer;
import sun.awt.motif.MDialogPeer;
import sun.awt.motif.MFileDialogPeer;
import sun.awt.motif.MFontPeer;
import sun.awt.motif.MFramePeer;
import sun.awt.motif.MLabelPeer;
import sun.awt.motif.MListPeer;
import sun.awt.motif.MMenuBarPeer;
import sun.awt.motif.MMenuItemPeer;
import sun.awt.motif.MMenuPeer;
import sun.awt.motif.MPanelPeer;
import sun.awt.motif.MPopupMenuPeer;
import sun.awt.motif.MScrollPanePeer;
import sun.awt.motif.MScrollbarPeer;
import sun.awt.motif.MTextAreaPeer;
import sun.awt.motif.MTextFieldPeer;
import sun.awt.motif.MWindowPeer;
import sun.awt.motif.PSPrintControl;
import sun.awt.motif.X11Clipboard;
import sun.awt.motif.X11FontMetrics;
import sun.awt.motif.X11Image;

public class MToolkit
extends SunToolkit
implements Runnable {
    static final boolean useMotifChoiceWidget = true;
    X11Clipboard clipboard;
    static ColorModel screenmodel;

    public MToolkit() {
        this.init();
        new InputThread();
        new Thread(this, "AWT-Motif").start();
    }

    public native void init();

    public native void run();

    public ButtonPeer createButton(Button button) {
        MButtonPeer mButtonPeer = new MButtonPeer(button);
        SunToolkit.peerMap.put(button, mButtonPeer);
        return mButtonPeer;
    }

    public TextFieldPeer createTextField(TextField textField) {
        MTextFieldPeer mTextFieldPeer = new MTextFieldPeer(textField);
        SunToolkit.peerMap.put(textField, mTextFieldPeer);
        return mTextFieldPeer;
    }

    public LabelPeer createLabel(Label label) {
        MLabelPeer mLabelPeer = new MLabelPeer(label);
        SunToolkit.peerMap.put(label, mLabelPeer);
        return mLabelPeer;
    }

    public ListPeer createList(List list) {
        MListPeer mListPeer = new MListPeer(list);
        SunToolkit.peerMap.put(list, mListPeer);
        return mListPeer;
    }

    public CheckboxPeer createCheckbox(Checkbox checkbox) {
        MCheckboxPeer mCheckboxPeer = new MCheckboxPeer(checkbox);
        SunToolkit.peerMap.put(checkbox, mCheckboxPeer);
        return mCheckboxPeer;
    }

    public ScrollbarPeer createScrollbar(Scrollbar scrollbar) {
        MScrollbarPeer mScrollbarPeer = new MScrollbarPeer(scrollbar);
        SunToolkit.peerMap.put(scrollbar, mScrollbarPeer);
        return mScrollbarPeer;
    }

    public ScrollPanePeer createScrollPane(ScrollPane scrollPane) {
        MScrollPanePeer mScrollPanePeer = new MScrollPanePeer(scrollPane);
        SunToolkit.peerMap.put(scrollPane, mScrollPanePeer);
        return mScrollPanePeer;
    }

    public TextAreaPeer createTextArea(TextArea textArea) {
        MTextAreaPeer mTextAreaPeer = new MTextAreaPeer(textArea);
        SunToolkit.peerMap.put(textArea, mTextAreaPeer);
        return mTextAreaPeer;
    }

    public ChoicePeer createChoice(Choice choice) {
        MChoicePeer mChoicePeer = null;
        mChoicePeer = new MChoicePeer(choice);
        SunToolkit.peerMap.put(choice, mChoicePeer);
        return mChoicePeer;
    }

    public FramePeer createFrame(Frame frame) {
        MFramePeer mFramePeer = new MFramePeer(frame);
        SunToolkit.peerMap.put(frame, mFramePeer);
        return mFramePeer;
    }

    public CanvasPeer createCanvas(Canvas canvas) {
        MCanvasPeer mCanvasPeer = new MCanvasPeer(canvas);
        SunToolkit.peerMap.put(canvas, mCanvasPeer);
        return mCanvasPeer;
    }

    public PanelPeer createPanel(Panel panel) {
        MPanelPeer mPanelPeer = new MPanelPeer(panel);
        SunToolkit.peerMap.put(panel, mPanelPeer);
        return mPanelPeer;
    }

    public WindowPeer createWindow(Window window) {
        MWindowPeer mWindowPeer = new MWindowPeer(window);
        SunToolkit.peerMap.put(window, mWindowPeer);
        return mWindowPeer;
    }

    public DialogPeer createDialog(Dialog dialog) {
        MDialogPeer mDialogPeer = new MDialogPeer(dialog);
        SunToolkit.peerMap.put(dialog, mDialogPeer);
        return mDialogPeer;
    }

    public FileDialogPeer createFileDialog(FileDialog fileDialog) {
        MFileDialogPeer mFileDialogPeer = new MFileDialogPeer(fileDialog);
        SunToolkit.peerMap.put(fileDialog, mFileDialogPeer);
        return mFileDialogPeer;
    }

    public MenuBarPeer createMenuBar(MenuBar menuBar) {
        MMenuBarPeer mMenuBarPeer = new MMenuBarPeer(menuBar);
        SunToolkit.peerMap.put(menuBar, mMenuBarPeer);
        return mMenuBarPeer;
    }

    public MenuPeer createMenu(Menu menu) {
        MMenuPeer mMenuPeer = new MMenuPeer(menu);
        SunToolkit.peerMap.put(menu, mMenuPeer);
        return mMenuPeer;
    }

    public PopupMenuPeer createPopupMenu(PopupMenu popupMenu) {
        MPopupMenuPeer mPopupMenuPeer = new MPopupMenuPeer(popupMenu);
        SunToolkit.peerMap.put(popupMenu, mPopupMenuPeer);
        return mPopupMenuPeer;
    }

    public MenuItemPeer createMenuItem(MenuItem menuItem) {
        MMenuItemPeer mMenuItemPeer = new MMenuItemPeer(menuItem);
        SunToolkit.peerMap.put(menuItem, mMenuItemPeer);
        return mMenuItemPeer;
    }

    public CheckboxMenuItemPeer createCheckboxMenuItem(CheckboxMenuItem checkboxMenuItem) {
        MCheckboxMenuItemPeer mCheckboxMenuItemPeer = new MCheckboxMenuItemPeer(checkboxMenuItem);
        SunToolkit.peerMap.put(checkboxMenuItem, mCheckboxMenuItemPeer);
        return mCheckboxMenuItemPeer;
    }

    public FontPeer getFontPeer(String string, int n) {
        return new MFontPeer(string, n);
    }

    static native ColorModel makeColorModel();

    static ColorModel getStaticColorModel() {
        if (screenmodel == null) {
            screenmodel = MToolkit.makeColorModel();
        }
        return screenmodel;
    }

    public ColorModel getColorModel() {
        return MToolkit.getStaticColorModel();
    }

    public native int getScreenResolution();

    protected native int getScreenWidth();

    protected native int getScreenHeight();

    public FontMetrics getFontMetrics(Font font) {
        return X11FontMetrics.getFontMetrics(font);
    }

    public native void sync();

    static boolean prepareScrImage(Image image, int n, int n2, ImageObserver imageObserver) {
        if (n == 0 || n2 == 0) {
            return true;
        }
        X11Image x11Image = (X11Image)image;
        if (x11Image.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        ImageRepresentation imageRepresentation = x11Image.getImageRep();
        return imageRepresentation.prepare(imageObserver);
    }

    static int checkScrImage(Image image, int n, int n2, ImageObserver imageObserver) {
        X11Image x11Image = (X11Image)image;
        int n3 = n == 0 || n2 == 0 ? 32 : x11Image.getImageRep().check(imageObserver);
        return x11Image.check(imageObserver) | n3;
    }

    public int checkImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return MToolkit.checkScrImage(image, n, n2, imageObserver);
    }

    public boolean prepareImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return MToolkit.prepareScrImage(image, n, n2, imageObserver);
    }

    public Image createImage(ImageProducer imageProducer) {
        return new X11Image(imageProducer);
    }

    public PrintJob getPrintJob(Frame frame, String string, Properties properties) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        PSPrintControl pSPrintControl = new PSPrintControl(frame);
        return pSPrintControl.initJob(string, properties, true);
    }

    public native void beep();

    public Clipboard getSystemClipboard() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSystemClipboardAccess();
        }
        if (this.clipboard == null) {
            this.clipboard = new X11Clipboard("System");
        }
        return this.clipboard;
    }

    public native void loadSystemColors(int[] var1);

    public static Container getNativeContainer(Component component) {
        return Toolkit.getNativeContainer(component);
    }

    static void postEvent(AWTEvent aWTEvent) {
        SunToolkit.theEventQueue.postEvent(aWTEvent);
    }

    public static final Object targetToPeer(Object object) {
        return SunToolkit.targetToPeer(object);
    }

    public static final void targetDisposedPeer(Object object, Object object2) {
        SunToolkit.targetDisposedPeer(object, object2);
    }

    static {
        System.loadLibrary("awt");
    }
}

