/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.io.Serializable;
import java.rmi.ConnectException;
import java.rmi.RemoteException;
import java.rmi.dgc.DGC;
import java.rmi.dgc.Lease;
import java.rmi.dgc.VMID;
import java.rmi.server.LogStream;
import java.rmi.server.ObjID;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import sun.rmi.transport.CleanRequest;
import sun.rmi.transport.DGCImpl;
import sun.rmi.transport.Endpoint;
import sun.rmi.transport.LeaseRenewer;
import sun.rmi.transport.LiveRef;
import sun.rmi.transport.LocateDGC;
import sun.rmi.transport.RMIThread;
import sun.rmi.transport.RefCount;
import sun.rmi.transport.RefList;
import sun.rmi.transport.Utils;

final class DGCClient
implements Runnable {
    private static final long leaseValue = Utils.getLong("java.rmi.dgc.leaseValue", 600000L);
    static final long leaseRenewInterval = Utils.getLong("sun.rmi.dgc.renewInterval", 480000L);
    private static Hashtable countTable = new Hashtable();
    private static Hashtable refTable = new Hashtable();
    private static Vector cleanList = new Vector();
    private static Vector unrefList = new Vector();
    private static VMID vmid = VMID.isUnique() ? new VMID() : null;
    private static long nextSequenceNum = Long.MIN_VALUE;
    private static Thread cleaner = null;
    private static Thread leasee = null;

    private DGCClient() {
    }

    static void referenced(LiveRef liveRef) throws RemoteException {
        Hashtable hashtable = countTable;
        synchronized (hashtable) {
            RefCount refCount = (RefCount)countTable.get(liveRef);
            if (refCount == null) {
                LiveRef liveRef2 = liveRef.copy();
                ObjID objID = liveRef2.getObjID();
                Endpoint endpoint = liveRef2.getEndpoint();
                if (DGCImpl.logLevel >= 20) {
                    LogStream.log("dgc").println("DGCClient.referenced: add ref " + objID);
                }
                refCount = new RefCount();
                countTable.put(liveRef2, refCount);
                RefList refList = (RefList)refTable.get(endpoint);
                if (refList == null) {
                    refList = new RefList(endpoint);
                    refTable.put(endpoint, refList);
                    if (leasee == null) {
                        leasee = RMIThread.newThread(new LeaseRenewer(), "LeaseRenewer", true);
                        leasee.start();
                    }
                    if (cleaner == null) {
                        cleaner = RMIThread.newThread(new DGCClient(), "Cleaner", true);
                        cleaner.start();
                    }
                }
                refList.ids.addElement(objID);
                DGC dGC = LocateDGC.getDGC(endpoint);
                try {
                    if (DGCImpl.logLevel >= 20) {
                        LogStream.log("dgc").println("DGCClient.referenced: making dirty call...");
                    }
                    ObjID[] objIDArray = new ObjID[]{objID};
                    Lease lease = dGC.dirty(objIDArray, DGCClient.getNextSequenceNum(), new Lease(vmid, leaseValue));
                    vmid = lease.getVMID();
                }
                catch (RemoteException remoteException) {
                    if (DGCImpl.logLevel >= 10) {
                        LogStream.log("dgc").println("DGCClient.referenced: dirty call failed");
                    }
                    DGCClient.scheduleClean(liveRef2, true);
                    throw remoteException;
                }
            }
            liveRef.counted();
            ++refCount.count;
            return;
        }
    }

    static void unreferenced(LiveRef liveRef) {
        Vector vector = unrefList;
        synchronized (vector) {
            unrefList.addElement(liveRef);
            unrefList.notifyAll();
            return;
        }
    }

    private static synchronized long getNextSequenceNum() {
        return nextSequenceNum++;
    }

    private static void handleDecrements() {
        while (!unrefList.isEmpty()) {
            LiveRef liveRef;
            Cloneable cloneable = unrefList;
            synchronized (cloneable) {
                liveRef = (LiveRef)unrefList.lastElement();
                unrefList.removeElementAt(unrefList.size() - 1);
            }
            cloneable = countTable;
            synchronized (cloneable) {
                RefCount refCount = (RefCount)countTable.get(liveRef);
                if (refCount != null) {
                    Endpoint endpoint = liveRef.getEndpoint();
                    RefList refList = (RefList)refTable.get(endpoint);
                    if (refList != null) {
                        refList.ids.removeElement(liveRef.getObjID());
                        if (refList.ids.isEmpty()) {
                            refTable.remove(endpoint);
                        }
                    }
                    if (--refCount.count == 0) {
                        if (DGCImpl.logLevel >= 20) {
                            LogStream.log("dgc").println("DGCClient.unreferenced: " + liveRef.getObjID());
                        }
                        DGCClient.scheduleClean(liveRef, false);
                    }
                }
            }
        }
    }

    private static void scheduleClean(LiveRef liveRef, boolean bl) {
        cleanList.addElement(new CleanRequest(liveRef, DGCClient.getNextSequenceNum(), bl));
        countTable.remove(liveRef);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void sendCleans() {
        Enumeration enumeration = cleanList.elements();
        try {
            while (true) {
                DGC dGC;
                if (!enumeration.hasMoreElements()) {
                    return;
                }
                CleanRequest cleanRequest = (CleanRequest)enumeration.nextElement();
                try {
                    dGC = LocateDGC.getDGC(cleanRequest.ref.getEndpoint());
                }
                catch (RemoteException remoteException) {
                    continue;
                }
                try {
                    if (vmid != null) {
                        if (DGCImpl.logLevel >= 20) {
                            LogStream.log("dgc").println("DGCClient.sendCleans: making clean call: " + cleanRequest.ref.getObjID());
                        }
                        ObjID[] objIDArray = new ObjID[]{cleanRequest.ref.getObjID()};
                        dGC.clean(objIDArray, cleanRequest.sequenceNum, vmid, cleanRequest.strong);
                    }
                    cleanList.removeElement(cleanRequest);
                }
                catch (ConnectException connectException) {
                    cleanList.removeElement(cleanRequest);
                }
                catch (RemoteException remoteException) {
                    if (DGCImpl.logLevel < 20) continue;
                    LogStream.log("dgc").println("DGCClient.sendCleans: clean call failed");
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
    }

    public void run() {
        while (true) {
            long l = Utils.getLong("sun.rmi.transport.cleanInterval", 180000L);
            System.runFinalization();
            Vector vector = unrefList;
            synchronized (vector) {
                if (unrefList.isEmpty()) {
                    try {
                        unrefList.wait(l);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            DGCClient.handleDecrements();
            DGCClient.sendCleans();
        }
    }

    static boolean renewLeases() {
        Hashtable hashtable = countTable;
        synchronized (hashtable) {
            Enumeration enumeration = refTable.elements();
            while (enumeration.hasMoreElements()) {
                RefList refList = (RefList)enumeration.nextElement();
                try {
                    Object[] objectArray;
                    DGC dGC = LocateDGC.getDGC(refList.ep);
                    Serializable serializable = refList.ids;
                    synchronized (serializable) {
                        objectArray = new ObjID[refList.ids.size()];
                        refList.ids.copyInto(objectArray);
                    }
                    if (DGCImpl.logLevel >= 10) {
                        LogStream.log("dgc").println("DGCClient.renewLeases: renew " + refList.ep);
                    }
                    serializable = dGC.dirty((ObjID[])objectArray, DGCClient.getNextSequenceNum(), new Lease(vmid, leaseValue));
                    vmid = ((Lease)serializable).getVMID();
                }
                catch (RemoteException remoteException) {
                    refTable.remove(refList.ep);
                }
            }
            if (refTable.isEmpty()) {
                leasee = null;
                boolean bl = false;
                Object var2_8 = null;
                return bl;
            }
            boolean bl = true;
            Object var2_9 = null;
            return bl;
        }
    }
}

