/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

public class CertException
extends SecurityException {
    public static final int verf_INVALID_SIG = 1;
    public static final int verf_INVALID_REVOKED = 2;
    public static final int verf_INVALID_NOTBEFORE = 3;
    public static final int verf_INVALID_EXPIRED = 4;
    public static final int verf_CA_UNTRUSTED = 5;
    public static final int verf_CHAIN_LENGTH = 6;
    public static final int verf_PARSE_ERROR = 7;
    public static final int err_CONSTRUCTION = 8;
    public static final int err_INVALID_PUBLIC_KEY = 9;
    private int verfCode;
    private String moreData;

    public CertException(int n, String string) {
        this.verfCode = n;
        this.moreData = string;
    }

    public CertException(int n) {
        this.verfCode = n;
    }

    public int getVerfCode() {
        return this.verfCode;
    }

    public String getMoreData() {
        return this.moreData;
    }

    public String getVerfDescription() {
        switch (this.verfCode) {
            case 1: {
                return "The signature in the certificate is not valid.";
            }
            case 2: {
                return "The certificate was revoked.";
            }
            case 3: {
                return "The certificate is not yet valid.";
            }
            case 4: {
                return "The certificate expired.";
            }
            case 5: {
                return "The Authority which issued the is not trusted.";
            }
            case 6: {
                return "The certificate path to a trusted authority is too long.";
            }
            case 7: {
                return "The certificate could not be parsed.";
            }
            case 8: {
                return "There was an error when constructing the certificate.";
            }
            case 9: {
                return "The public key was not in the correct format.";
            }
        }
        return "Unknown code:  " + this.verfCode;
    }

    public String toString() {
        return "[Certificate Exception:  " + this.getVerfDescription() + (this.moreData != null ? "\n  (" + this.moreData + ")" : "") + "]";
    }
}

