/*
 * @(#)context_md.h	1.20 96/12/16
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

/*
 * genunix32-dependent API
 */

#ifndef _GENUNIX32_CONTEXT_MD_H_
#define _GENUNIX32_CONTEXT_MD_H_

#include <errno.h>

#include <sys/types.h>
#include <sys/signal.h>
#include <setjmp.h>

typedef struct genunix_ucontext {
	sigjmp_buf	jmpbuf;
/* #if defined(__linux__) && defined(__i386__) */
	char		floatbuf[108];
/* #endif */
} genunix_ucontext_t;
			    
/*
 * Routines that call getcontext have strange control flow graphs,
 * since a call to a routine that calls setcontext will eventually
 * return at the getcontext site, not the original call site.  This
 * utterly wrecks control flow analysis.
 */
#pragma unknown_control_flow(getcontext)

/*
 * A genunix context.  Everything else is on the stack.
 */
typedef struct {
    unsigned int unix_errno;
    genunix_ucontext_t ucontext;
} context_t;

/* Save state of the current content and call rescheduler */

void reschedule(void);

#if defined(__linux__) && defined(__i386__)  
/* #if defined(__linux__)  */
#define yieldContext(contextp) \
{ \
		char * fdata = (char *)contextp->ucontext.floatbuf; \
		__asm__ ("fsave %0"::"m" (*fdata)); \
		if (!sigsetjmp(contextp->ucontext.jmpbuf,-1)) { \
		  (contextp)->unix_errno = errno; \
		  reschedule(); \
		} \
  }
#else
#define yieldContext(contextp) \
{ \
		if (!sigsetjmp(contextp->ucontext.jmpbuf,-1)) { \
		  (contextp)->unix_errno = errno; \
		  reschedule(); \
		} \
  }
#endif

/* switch to the new context */

#define switchContext(contextp) { \
   errno = (contextp)->unix_errno; \
   genunix_setcontext(&((contextp)->ucontext)); \
}

#endif /* !_GENUNIX32_CONTEXT_MD_H_ */

