/*
 * @(#)typedefs_md.h	1.31 97/01/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

/*
 * Solaris-dependent types for Green threads
 */

#ifndef BITSPERCHAR
#define BITSPERCHAR 8
#endif

#ifndef _UINTT_
#define _UINTT_
typedef unsigned int uint_t;
#endif

#ifndef _SOLARIS_TYPES_MD_H_
#define _SOLARIS_TYPES_MD_H_

#include <sys/types.h>
#include <sys/stat.h>
#include "bool.h"

/* #if defined(__sparc__) */
#if (0)
typedef unsigned long ptr_int;
/* #define PTR_IS_64 1 */
#define PTR_IS_32 1
#define LONG_IS_64 1
#else
typedef unsigned int ptr_int;
#define PTR_IS_32 1
#endif

/* don't redefine typedef's on Solaris 2.6 or Later */

#if !defined(_ILP32) && !defined(_LP64)

#ifndef	_UINT64_T
#define	_UINT64_T
typedef unsigned long long uint64_t;
#define _UINT32_T
typedef unsigned long uint32_t;
#endif

/* 
#ifndef	_INT64_T
#define	_INT64_T
typedef long long int64_t;
#define _INT32_T
typedef long int32_t;
#endif
*/

#endif	/* !defined(_ILP32) && !defined(_LP64) */

/* use these macros when the compiler supports the long long type */

#define ll_high(a)	((long)((a)>>32))
#define ll_low(a)	((long)(a))
#define int2ll(a)	((int64_t)(a))
#define ll2int(a)	((int)(a))
#define ll_add(a, b)	((a) + (b))
#define ll_and(a, b)	((a) & (b))
#define ll_div(a, b)	((a) / (b))
#define ll_mul(a, b)	((a) * (b))
#define ll_neg(a)	(-(a))
#define ll_not(a)	(~(a))
#define ll_or(a, b)	((a) | (b))
#define ll_shl(a, n)	((a) << (n))
#define ll_shr(a, n)	((a) >> (n))
#define ll_sub(a, b)	((a) - (b))
#define ll_ushr(a, n)	((unsigned long long)(a) >> (n))
#define ll_xor(a, b)	((a) ^ (b))
#define uint2ll(a)	((uint64_t)(unsigned long)(a))
#define ll_rem(a,b)	((a) % (b))

#define INT_OP(x,op,y)  ((x) op (y))
#define NAN_CHECK(l,r,x) x
/* #define IS_NAN(x) isnand(x) johan */
#define IS_NAN(x) isnan(x)

#define float2l(f)	(f)
#define double2l(f)	(f)
#define float2ll(f)	((int64_t) (f))
#define ll2float(a)	((float) (a))
#define ll2double(a)	((double) (a))
#define double2ll(f)	((int64_t) (f))

/* comparison operators */
#define ll_ltz(ll)	((ll)<0)
#define ll_gez(ll)	((ll)>=0)
#define ll_eqz(a)	((a) == 0)
#define ll_eq(a, b)	((a) == (b))
#define ll_ne(a,b)	((a) != (b))
#define ll_ge(a,b)	((a) >= (b))
#define ll_le(a,b)	((a) <= (b))
#define ll_lt(a,b)	((a) < (b))
#define ll_gt(a,b)	((a) > (b))

#define ll_zero_const	((int64_t) 0)
#define ll_one_const	((int64_t) 1)

extern void ll2str(int64_t a, char *s, char *limit);

/* #ifdef ppc */
#define HAVE_ALIGNED_DOUBLES
#define HAVE_ALIGNED_LONGLONGS
/* #endif */

#endif /* !_SOLARIS_TYPES_MD_H_ */
