/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.io.Serializable;

class FocusManager
implements Serializable {
    Container focusRoot;
    Component focusOwner;

    FocusManager(Container container) {
        this.focusRoot = container;
    }

    void activateFocus() {
        boolean bl = false;
        if (this.focusOwner != null) {
            bl = this.assignFocus(this.focusOwner, false);
            if (!bl) {
                bl = this.focusNext(this.focusOwner);
            }
        } else {
            bl = this.focusForward(this.focusRoot);
        }
        if (!bl) {
            this.focusRoot.requestFocus();
        }
    }

    void setFocusOwner(Component component) {
        Object object = Component.LOCK;
        synchronized (object) {
            this.focusOwner = component;
            return;
        }
    }

    Component getFocusOwner() {
        return this.focusOwner;
    }

    boolean focusNext() {
        return this.focusNext(this.focusOwner);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean focusNext(Component component) {
        Object object = Component.LOCK;
        synchronized (object) {
            Container container;
            Component component2 = component;
            if (component2 == null) return false;
            if (component2.parent == null) {
                return false;
            }
            do {
                boolean bl = false;
                container = component2.parent;
                int n = 0;
                while (n < container.ncomponents) {
                    Component component3 = container.component[n];
                    if (bl) {
                        if (this.assignFocus(component3)) {
                            return true;
                        }
                        if (component3 instanceof Container && component3.isVisible() && component3.isEnabled() && this.focusForward((Container)component3)) {
                            return true;
                        }
                    } else if (component3 == component2) {
                        bl = true;
                    }
                    ++n;
                }
            } while ((component2 = container) != this.focusRoot);
            if (!this.focusForward(this.focusRoot)) return false;
            return true;
        }
    }

    boolean focusPrevious() {
        return this.focusPrevious(this.focusOwner);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean focusPrevious(Component component) {
        Object object = Component.LOCK;
        synchronized (object) {
            Container container;
            Component component2 = component;
            if (component2 == null) return false;
            if (component2.parent == null) {
                return false;
            }
            do {
                boolean bl = false;
                container = component2.parent;
                int n = container.ncomponents - 1;
                while (n >= 0) {
                    Component component3 = container.component[n];
                    if (bl) {
                        if (this.assignFocus(component3)) {
                            return true;
                        }
                        if (component3 instanceof Container && component3.isVisible() && component3.isEnabled() && this.focusBackward((Container)component3)) {
                            return true;
                        }
                    } else if (component3 == component2) {
                        bl = true;
                    }
                    --n;
                }
            } while ((component2 = container) != this.focusRoot);
            if (!this.focusBackward(this.focusRoot)) return false;
            return true;
        }
    }

    boolean assignFocus(Component component) {
        return this.assignFocus(component, true);
    }

    boolean assignFocus(Component component, boolean bl) {
        Object object = Component.LOCK;
        synchronized (object) {
            if (component.isVisible() && component.isEnabled() && (!bl || component.isFocusTraversable())) {
                component.requestFocus();
                boolean bl2 = true;
                Object var5_6 = null;
                return bl2;
            }
            boolean bl3 = false;
            Object var5_7 = null;
            return bl3;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean focusForward(Container container) {
        Object object = Component.LOCK;
        synchronized (object) {
            int n = 0;
            while (n < container.ncomponents) {
                Component component = container.component[n];
                if (this.assignFocus(component)) {
                    return true;
                }
                if (component instanceof Container && component.isVisible() && component.isEnabled() && this.focusForward((Container)component)) {
                    return true;
                }
                ++n;
            }
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean focusBackward(Container container) {
        Object object = Component.LOCK;
        synchronized (object) {
            int n = container.ncomponents - 1;
            while (n >= 0) {
                Component component = container.component[n];
                if (this.assignFocus(component)) {
                    return true;
                }
                if (component instanceof Container && component.isVisible() && component.isEnabled() && this.focusBackward((Container)component)) {
                    return true;
                }
                --n;
            }
            return false;
        }
    }
}

