/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.InputStream;

public class ByteArrayInputStream
extends InputStream {
    protected byte[] buf;
    protected int pos;
    protected int mark;
    protected int count;

    public ByteArrayInputStream(byte[] byArray) {
        this.buf = byArray;
        this.pos = 0;
        this.count = byArray.length;
    }

    public ByteArrayInputStream(byte[] byArray, int n, int n2) {
        this.buf = byArray;
        this.pos = n;
        int n3 = n + n2;
        int n4 = byArray.length;
        this.count = n3 <= n4 ? n3 : n4;
    }

    public synchronized int read() {
        if (this.pos < this.count) {
            return this.buf[this.pos++] & 0xFF;
        }
        return -1;
    }

    public synchronized int read(byte[] byArray, int n, int n2) {
        if (this.pos >= this.count) {
            return -1;
        }
        if (this.pos + n2 > this.count) {
            n2 = this.count - this.pos;
        }
        if (n2 <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.pos, byArray, n, n2);
        this.pos += n2;
        return n2;
    }

    public synchronized long skip(long l) {
        if ((long)this.pos + l > (long)this.count) {
            l = this.count - this.pos;
        }
        if (l < 0L) {
            return 0L;
        }
        this.pos = (int)((long)this.pos + l);
        return l;
    }

    public synchronized int available() {
        return this.count - this.pos;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int n) {
        this.mark = this.pos;
    }

    public synchronized void reset() {
        this.pos = this.mark;
    }
}

