/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;

public class SimpleDateFormat
extends DateFormat {
    static final long serialVersionUID = 4774881970558875024L;
    static final int currentSerialVersion = 1;
    private int serialVersionOnStream = 1;
    private String pattern;
    private DateFormatSymbols formatData;
    private Date defaultCenturyStart;
    private transient int defaultCenturyDelta;
    private static final int millisPerHour = 3600000;
    private static final int millisPerMinute = 60000;
    private static final String GMT_PLUS = "GMT+";
    private static final String GMT_MINUS = "GMT-";
    private static final String GMT = "GMT";
    private static final int[] PATTERN_INDEX_TO_FIELD;

    public SimpleDateFormat() {
        this(3, 7, Locale.getDefault());
    }

    public SimpleDateFormat(String string) {
        this(string, Locale.getDefault());
    }

    public SimpleDateFormat(String string, Locale locale) {
        this.pattern = string;
        this.formatData = new DateFormatSymbols(locale);
        this.initialize(locale);
    }

    public SimpleDateFormat(String string, DateFormatSymbols dateFormatSymbols) {
        this.pattern = string;
        this.formatData = dateFormatSymbols;
        this.initialize(Locale.getDefault());
    }

    SimpleDateFormat(int n, int n2, Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("java.text.resources.LocaleElements", locale);
        this.formatData = new DateFormatSymbols(locale);
        String[] stringArray = (String[])resourceBundle.getObject("DateTimePatterns");
        if (n >= 0 && n2 >= 0) {
            Object[] objectArray = new Object[]{stringArray[n], stringArray[n2]};
            this.pattern = MessageFormat.format(stringArray[8], objectArray);
        } else if (n >= 0) {
            this.pattern = stringArray[n];
        } else if (n2 >= 0) {
            this.pattern = stringArray[n2];
        } else {
            throw new IllegalArgumentException("No date or time style specified");
        }
        this.initialize(locale);
    }

    private void initialize(Locale locale) {
        this.calendar = Calendar.getInstance(TimeZone.getTimeZone(this.formatData.zoneStrings[0][0]), locale);
        this.numberFormat = NumberFormat.getInstance(locale);
        this.numberFormat.setGroupingUsed(false);
        if (this.numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)this.numberFormat).setDecimalSeparatorAlwaysShown(false);
        }
        this.numberFormat.setParseIntegerOnly(true);
        this.initializeDefaultCentury();
    }

    private void initializeDefaultCentury() {
        this.calendar.setTime(new Date());
        this.calendar.add(1, -80);
        this.parseAmbiguousDatesAsAfter(this.calendar.getTime());
    }

    private void parseAmbiguousDatesAsAfter(Date date) {
        this.defaultCenturyStart = date;
        this.calendar.setTime(date);
        this.defaultCenturyDelta = this.calendar.get(1) / 100 * 100;
    }

    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        fieldPosition.endIndex = 0;
        fieldPosition.beginIndex = 0;
        this.calendar.setTime(date);
        boolean bl = false;
        char c = '\u0000';
        int n = 0;
        int n2 = 1;
        int n3 = 0;
        while (n3 < this.pattern.length()) {
            char c2 = this.pattern.charAt(n3);
            if (bl) {
                if (c2 == '\'') {
                    bl = false;
                    if (n == 0) {
                        stringBuffer.append(c2);
                    } else {
                        n = 0;
                    }
                    n2 = 0;
                } else {
                    stringBuffer.append(c2);
                    ++n;
                }
            } else {
                if (c2 == '\'') {
                    bl = true;
                    if (n > 0) {
                        stringBuffer.append(this.subFormat(c, n, stringBuffer.length(), fieldPosition));
                        n = 0;
                        c = '\u0000';
                    }
                    if (n2 == 0) {
                        stringBuffer.append(c2);
                        n = 1;
                    }
                } else if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z') {
                    if (c2 != c && n > 0) {
                        stringBuffer.append(this.subFormat(c, n, stringBuffer.length(), fieldPosition));
                        c = c2;
                        n = 1;
                    } else {
                        if (c2 != c) {
                            c = c2;
                        }
                        ++n;
                    }
                } else if (n > 0) {
                    stringBuffer.append(this.subFormat(c, n, stringBuffer.length(), fieldPosition));
                    stringBuffer.append(c2);
                    c = '\u0000';
                    n = 0;
                } else {
                    stringBuffer.append(c2);
                }
                ++n2;
            }
            ++n3;
        }
        if (n > 0) {
            stringBuffer.append(this.subFormat(c, n, stringBuffer.length(), fieldPosition));
        }
        return stringBuffer;
    }

    private String subFormat(char n, int n2, int n3, FieldPosition fieldPosition) throws IllegalArgumentException {
        int n4 = -1;
        String string = "";
        int n5 = n;
        n4 = "GyMdkHmsSEDFwWahKz".indexOf(n5, 0);
        if (n4 == -1) {
            throw new IllegalArgumentException("Illegal pattern character '" + (char)n + "'");
        }
        n5 = PATTERN_INDEX_TO_FIELD[n4];
        int n6 = this.calendar.get(n5);
        switch (n4) {
            case 0: {
                string = this.formatData.eras[n6];
                break;
            }
            case 1: {
                if (n2 >= 4) {
                    long l = n6;
                    this.numberFormat.setMinimumIntegerDigits(4);
                    this.numberFormat.setMaximumIntegerDigits(10);
                    NumberFormat numberFormat = this.numberFormat;
                    StringBuffer stringBuffer = numberFormat.format(l, new StringBuffer(), new FieldPosition(0));
                    string = new String(stringBuffer);
                    break;
                }
                long l = n6;
                this.numberFormat.setMinimumIntegerDigits(2);
                this.numberFormat.setMaximumIntegerDigits(2);
                NumberFormat numberFormat = this.numberFormat;
                StringBuffer stringBuffer = numberFormat.format(l, new StringBuffer(), new FieldPosition(0));
                string = new String(stringBuffer);
                break;
            }
            case 2: {
                if (n2 >= 4) {
                    string = this.formatData.months[n6];
                    break;
                }
                if (n2 == 3) {
                    string = this.formatData.shortMonths[n6];
                    break;
                }
                long l = n6 + 1;
                this.numberFormat.setMinimumIntegerDigits(n2);
                this.numberFormat.setMaximumIntegerDigits(10);
                NumberFormat numberFormat = this.numberFormat;
                StringBuffer stringBuffer = numberFormat.format(l, new StringBuffer(), new FieldPosition(0));
                string = new String(stringBuffer);
                break;
            }
            case 4: {
                if (n6 == 0) {
                    long l = this.calendar.getMaximum(11) + 1;
                    this.numberFormat.setMinimumIntegerDigits(n2);
                    this.numberFormat.setMaximumIntegerDigits(10);
                    NumberFormat numberFormat = this.numberFormat;
                    StringBuffer stringBuffer = numberFormat.format(l, new StringBuffer(), new FieldPosition(0));
                    string = new String(stringBuffer);
                    break;
                }
                long l = n6;
                this.numberFormat.setMinimumIntegerDigits(n2);
                this.numberFormat.setMaximumIntegerDigits(10);
                NumberFormat numberFormat = this.numberFormat;
                StringBuffer stringBuffer = numberFormat.format(l, new StringBuffer(), new FieldPosition(0));
                string = new String(stringBuffer);
                break;
            }
            case 8: {
                if (n2 > 3) {
                    n2 = 3;
                } else if (n2 == 2) {
                    n6 /= 10;
                } else if (n2 == 1) {
                    n6 /= 100;
                }
                long l = n6;
                this.numberFormat.setMinimumIntegerDigits(n2);
                this.numberFormat.setMaximumIntegerDigits(10);
                NumberFormat numberFormat = this.numberFormat;
                StringBuffer stringBuffer = numberFormat.format(l, new StringBuffer(), new FieldPosition(0));
                string = new String(stringBuffer);
                break;
            }
            case 9: {
                if (n2 >= 4) {
                    string = this.formatData.weekdays[n6];
                    break;
                }
                string = this.formatData.shortWeekdays[n6];
                break;
            }
            case 14: {
                string = this.formatData.ampms[n6];
                break;
            }
            case 15: {
                if (n6 == 0) {
                    long l = this.calendar.getLeastMaximum(10) + 1;
                    this.numberFormat.setMinimumIntegerDigits(n2);
                    this.numberFormat.setMaximumIntegerDigits(10);
                    NumberFormat numberFormat = this.numberFormat;
                    StringBuffer stringBuffer = numberFormat.format(l, new StringBuffer(), new FieldPosition(0));
                    string = new String(stringBuffer);
                    break;
                }
                long l = n6;
                this.numberFormat.setMinimumIntegerDigits(n2);
                this.numberFormat.setMaximumIntegerDigits(10);
                NumberFormat numberFormat = this.numberFormat;
                StringBuffer stringBuffer = numberFormat.format(l, new StringBuffer(), new FieldPosition(0));
                string = new String(stringBuffer);
                break;
            }
            case 17: {
                int n7 = this.formatData.getZoneIndex(this.calendar.getTimeZone().getID());
                if (n7 == -1) {
                    StringBuffer stringBuffer = new StringBuffer();
                    n6 = this.calendar.get(15) + this.calendar.get(16);
                    if (n6 < 0) {
                        stringBuffer.append(GMT_MINUS);
                        n6 = -n6;
                    } else {
                        stringBuffer.append(GMT_PLUS);
                    }
                    long l = n6 / 3600000;
                    this.numberFormat.setMinimumIntegerDigits(2);
                    this.numberFormat.setMaximumIntegerDigits(2);
                    NumberFormat numberFormat = this.numberFormat;
                    StringBuffer stringBuffer2 = numberFormat.format(l, new StringBuffer(), new FieldPosition(0));
                    stringBuffer.append(new String(stringBuffer2));
                    stringBuffer.append(':');
                    l = n6 % 3600000 / 60000;
                    this.numberFormat.setMinimumIntegerDigits(2);
                    this.numberFormat.setMaximumIntegerDigits(2);
                    numberFormat = this.numberFormat;
                    stringBuffer2 = numberFormat.format(l, new StringBuffer(), new FieldPosition(0));
                    stringBuffer.append(new String(stringBuffer2));
                    string = new String(stringBuffer);
                    break;
                }
                if (this.calendar.get(16) != 0) {
                    if (n2 >= 4) {
                        string = this.formatData.zoneStrings[n7][3];
                        break;
                    }
                    string = this.formatData.zoneStrings[n7][4];
                    break;
                }
                if (n2 >= 4) {
                    string = this.formatData.zoneStrings[n7][1];
                    break;
                }
                string = this.formatData.zoneStrings[n7][2];
                break;
            }
            default: {
                long l = n6;
                this.numberFormat.setMinimumIntegerDigits(n2);
                this.numberFormat.setMaximumIntegerDigits(10);
                NumberFormat numberFormat = this.numberFormat;
                StringBuffer stringBuffer = numberFormat.format(l, new StringBuffer(), new FieldPosition(0));
                string = new String(stringBuffer);
            }
        }
        if (fieldPosition.field == n5 && fieldPosition.beginIndex == 0 && fieldPosition.endIndex == 0) {
            fieldPosition.beginIndex = n3;
            fieldPosition.endIndex = n3 + string.length();
        }
        return string;
    }

    private String zeroPaddingNumber(long l, int n, int n2) {
        this.numberFormat.setMinimumIntegerDigits(n);
        this.numberFormat.setMaximumIntegerDigits(n2);
        NumberFormat numberFormat = this.numberFormat;
        StringBuffer stringBuffer = numberFormat.format(l, new StringBuffer(), new FieldPosition(0));
        return new String(stringBuffer);
    }

    public Date parse(String string, ParsePosition parsePosition) {
        int n;
        int n2 = n = parsePosition.index;
        boolean[] blArray = new boolean[1];
        this.calendar.clear();
        boolean bl = false;
        char c = '\u0000';
        int n3 = 0;
        int n4 = 1;
        int n5 = 0;
        while (n5 < this.pattern.length()) {
            char c2 = this.pattern.charAt(n5);
            if (bl) {
                if (c2 == '\'') {
                    bl = false;
                    if (n3 == 0) {
                        if (c2 != string.charAt(n)) {
                            parsePosition.index = n2;
                            return null;
                        }
                        ++n;
                    }
                    n3 = 0;
                    n4 = 0;
                } else {
                    if (c2 != string.charAt(n)) {
                        parsePosition.index = n2;
                        return null;
                    }
                    ++n3;
                    ++n;
                }
            } else {
                if (c2 == '\'') {
                    bl = true;
                    if (n3 > 0) {
                        if ((n = this.subParse(string, n, c, n3, false, blArray)) < 0) {
                            parsePosition.index = n2;
                            return null;
                        }
                        n3 = 0;
                    }
                    if (n4 == 0) {
                        if (c2 != string.charAt(n)) {
                            parsePosition.index = n2;
                            return null;
                        }
                        ++n;
                        n3 = 1;
                    }
                } else if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z') {
                    if (c2 != c && n3 > 0) {
                        if ((n = this.subParse(string, n, c, n3, true, blArray)) < 0) {
                            parsePosition.index = n2;
                            return null;
                        }
                        c = c2;
                        n3 = 1;
                    } else {
                        if (c2 != c) {
                            c = c2;
                        }
                        ++n3;
                    }
                } else if (n3 > 0) {
                    if ((n = this.subParse(string, n, c, n3, false, blArray)) < 0) {
                        parsePosition.index = n2;
                        return null;
                    }
                    if (n >= string.length() || c2 != string.charAt(n)) {
                        parsePosition.index = n2;
                        return null;
                    }
                    ++n;
                    n3 = 0;
                    c = '\u0000';
                } else {
                    if (c2 != string.charAt(n)) {
                        parsePosition.index = n2;
                        return null;
                    }
                    ++n;
                }
                ++n4;
            }
            ++n5;
        }
        if (n3 > 0 && (n = this.subParse(string, n, c, n3, false, blArray)) < 0) {
            parsePosition.index = n2;
            return null;
        }
        parsePosition.index = n;
        if (!this.calendar.isSet(1)) {
            this.calendar.set(1, 1970);
        }
        if (!this.calendar.isSet(0)) {
            this.calendar.set(0, 1);
        }
        if (!(this.calendar.isSet(2) && (this.calendar.isSet(5) || this.calendar.isSet(7) && (this.calendar.isSet(4) || this.calendar.isSet(8))) || this.calendar.isSet(6) || this.calendar.isSet(7) && this.calendar.isSet(3))) {
            if (this.calendar.isSet(2)) {
                if (this.calendar.isSet(7)) {
                    this.calendar.set(8, 1);
                } else if (this.calendar.isSet(4) || this.calendar.isSet(8)) {
                    this.calendar.set(7, this.calendar.getFirstDayOfWeek());
                } else {
                    this.calendar.set(5, 1);
                }
            } else if (this.calendar.isSet(7)) {
                this.calendar.set(3, 1);
            } else if (this.calendar.isSet(3)) {
                this.calendar.set(7, this.calendar.getFirstDayOfWeek());
            } else {
                this.calendar.set(6, 1);
            }
        }
        if (!this.calendar.isSet(11) && !this.calendar.isSet(10)) {
            this.calendar.set(11, 0);
        }
        if (!this.calendar.isSet(12)) {
            this.calendar.set(12, 0);
        }
        if (!this.calendar.isSet(13)) {
            this.calendar.set(13, 0);
        }
        if (!this.calendar.isSet(14)) {
            this.calendar.set(14, 0);
        }
        Date date = this.calendar.getTime();
        if (blArray[0] && !date.after(this.defaultCenturyStart)) {
            this.calendar.add(1, 100);
            date = this.calendar.getTime();
        }
        return date;
    }

    private int matchString(String string, int n, int n2, String[] stringArray) {
        int n3 = 0;
        int n4 = stringArray.length;
        if (n2 == 7) {
            n3 = 1;
        }
        while (n3 < n4) {
            if (stringArray[n3].length() != 0 && string.regionMatches(true, n, stringArray[n3], 0, stringArray[n3].length())) break;
            ++n3;
        }
        if (n3 >= n4) {
            return -n;
        }
        this.calendar.set(n2, n3);
        return n + stringArray[n3].length();
    }

    private int subParse(String string, int n, char n2, int n3, boolean bl, boolean[] blArray) {
        Number number;
        int n4 = 0;
        ParsePosition parsePosition = new ParsePosition(0);
        int n5 = -1;
        int n6 = n2;
        n5 = "GyMdkHmsSEDFwWahKz".indexOf(n6, 0);
        if (n5 == -1) {
            return -n;
        }
        parsePosition.index = n;
        n6 = PATTERN_INDEX_TO_FIELD[n5];
        if (n5 == 4 || n5 == 15 || n5 == 2 && n3 <= 2 || n5 == 1) {
            if (bl) {
                if (n + n3 > string.length()) {
                    return -n;
                }
                number = this.numberFormat.parse(string.substring(0, n + n3), parsePosition);
            } else {
                number = this.numberFormat.parse(string, parsePosition);
            }
            if (number == null) {
                return -n;
            }
            n4 = number.intValue();
        }
        switch (n5) {
            case 0: {
                return this.matchString(string, n, 0, this.formatData.eras);
            }
            case 1: {
                if (n3 < 4) {
                    blArray[0] = true;
                    n4 += this.defaultCenturyDelta;
                }
                this.calendar.set(1, n4);
                return parsePosition.index;
            }
            case 2: {
                if (n3 <= 2) {
                    this.calendar.set(2, n4 - 1);
                    return parsePosition.index;
                }
                int n7 = 0;
                n7 = this.matchString(string, n, 2, this.formatData.months);
                if (n7 > 0) {
                    return n7;
                }
                return this.matchString(string, n, 2, this.formatData.shortMonths);
            }
            case 4: {
                if (n4 == this.calendar.getMaximum(11) + 1) {
                    n4 = 0;
                }
                this.calendar.set(11, n4);
                return parsePosition.index;
            }
            case 9: {
                int n8 = 0;
                n8 = this.matchString(string, n, 7, this.formatData.weekdays);
                if (n8 > 0) {
                    return n8;
                }
                return this.matchString(string, n, 7, this.formatData.shortWeekdays);
            }
            case 14: {
                return this.matchString(string, n, 9, this.formatData.ampms);
            }
            case 15: {
                if (n4 == this.calendar.getLeastMaximum(10) + 1) {
                    n4 = 0;
                }
                this.calendar.set(10, n4);
                return parsePosition.index;
            }
            case 17: {
                int n9;
                int n10 = 0;
                while (n10 < this.formatData.zoneStrings.length) {
                    n9 = 1;
                    while (n9 <= 4) {
                        if (string.regionMatches(true, n, this.formatData.zoneStrings[n10][n9], 0, this.formatData.zoneStrings[n10][n9].length())) break;
                        ++n9;
                    }
                    if (n9 <= 4) {
                        this.calendar.set(15, TimeZone.getTimeZone(this.formatData.zoneStrings[n10][0]).getRawOffset());
                        if (n9 >= 3) {
                            this.calendar.set(16, 3600000);
                        }
                        return n + this.formatData.zoneStrings[n10][n9].length();
                    }
                    ++n10;
                }
                if (string.regionMatches(true, n, GMT, 0, GMT.length())) {
                    int n11;
                    this.calendar.set(16, 0);
                    parsePosition.index = n + GMT.length();
                    n9 = 0;
                    if (string.regionMatches(parsePosition.index, "+", 0, 1)) {
                        n11 = 1;
                    } else if (string.regionMatches(parsePosition.index, "-", 0, 1)) {
                        n11 = -1;
                    } else {
                        this.calendar.set(15, 0);
                        return parsePosition.index;
                    }
                    ++parsePosition.index;
                    Number number2 = this.numberFormat.parse(string, parsePosition);
                    if (number2 == null) {
                        return -n;
                    }
                    if (string.regionMatches(parsePosition.index, ":", 0, 1)) {
                        n9 = number2.intValue() * 60;
                        ++parsePosition.index;
                        number2 = this.numberFormat.parse(string, parsePosition);
                        if (number2 == null) {
                            return -n;
                        }
                        n9 += number2.intValue();
                    } else {
                        int n12 = number2.intValue();
                        n9 = n12 < 24 ? n12 * 60 : n12 % 100 + n12 / 100 * 60;
                    }
                    this.calendar.set(15, n9 * 60000 * n11);
                    return parsePosition.index;
                }
                DecimalFormat decimalFormat = new DecimalFormat("+####;-####", new DecimalFormatSymbols(Locale.US));
                Number number3 = decimalFormat.parse(string, parsePosition);
                if (number3 == null) {
                    return -n;
                }
                int n13 = number3.intValue();
                int n14 = 1;
                if (n13 < 0) {
                    n14 = -1;
                    n13 *= -1;
                }
                n13 = n13 < 24 ? (n13 *= 60) : n13 % 100 + n13 / 100 * 60;
                n13 *= 60000 * n14;
                if (this.calendar.getTimeZone().useDaylightTime()) {
                    this.calendar.set(16, 3600000);
                    this.calendar.set(15, n13 - 3600000);
                } else {
                    this.calendar.set(15, n13);
                }
                return parsePosition.index;
            }
        }
        if (bl) {
            if (n + n3 > string.length()) {
                return -n;
            }
            number = this.numberFormat.parse(string.substring(0, n + n3), parsePosition);
        } else {
            number = this.numberFormat.parse(string, parsePosition);
        }
        if (number != null) {
            this.calendar.set(n6, number.intValue());
            return parsePosition.index;
        }
        return -n;
    }

    private String translatePattern(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (bl) {
                if (c == '\'') {
                    bl = false;
                }
            } else if (c == '\'') {
                bl = true;
            } else if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                int n2 = c;
                if ((n2 = string2.indexOf(n2, 0)) == -1) {
                    throw new IllegalArgumentException("Illegal pattern  character '" + c + "'");
                }
                c = string3.charAt(n2);
            }
            stringBuffer.append(c);
            ++n;
        }
        if (bl) {
            throw new IllegalArgumentException("Unfinished quote in pattern");
        }
        return new String(stringBuffer);
    }

    public String toPattern() {
        return this.pattern;
    }

    public String toLocalizedPattern() {
        return this.translatePattern(this.pattern, "GyMdkHmsSEDFwWahKz", this.formatData.localPatternChars);
    }

    public void applyPattern(String string) {
        this.pattern = string;
    }

    public void applyLocalizedPattern(String string) {
        this.pattern = this.translatePattern(string, this.formatData.localPatternChars, "GyMdkHmsSEDFwWahKz");
    }

    public DateFormatSymbols getDateFormatSymbols() {
        return (DateFormatSymbols)this.formatData.clone();
    }

    public void setDateFormatSymbols(DateFormatSymbols dateFormatSymbols) {
        this.formatData = (DateFormatSymbols)dateFormatSymbols.clone();
    }

    public Object clone() {
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)super.clone();
        simpleDateFormat.formatData = (DateFormatSymbols)this.formatData.clone();
        return simpleDateFormat;
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)object;
        return this.pattern.equals(simpleDateFormat.pattern) && this.formatData.equals(simpleDateFormat.formatData);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            this.initializeDefaultCentury();
        } else {
            this.parseAmbiguousDatesAsAfter(this.defaultCenturyStart);
        }
        this.serialVersionOnStream = 1;
    }

    static {
        int[] nArray = new int[18];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 5;
        nArray[4] = 11;
        nArray[5] = 11;
        nArray[6] = 12;
        nArray[7] = 13;
        nArray[8] = 14;
        nArray[9] = 7;
        nArray[10] = 6;
        nArray[11] = 8;
        nArray[12] = 3;
        nArray[13] = 4;
        nArray[14] = 9;
        nArray[15] = 10;
        nArray[16] = 10;
        nArray[17] = 15;
        PATTERN_INDEX_TO_FIELD = nArray;
    }
}

