/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Vector;
import sun.applet.AppletClassEntry;
import sun.applet.AppletIOException;
import sun.applet.AppletMessageHandler;
import sun.applet.AppletResourceLoader;
import sun.applet.AppletThreadGroup;
import sun.net.www.protocol.http.HttpURLConnection;

public class AppletClassLoader
extends ClassLoader {
    private static boolean debug;
    Vector archives = new Vector();
    protected boolean verboseClassLoading = false;
    URL base;
    AppletResourceLoader resources;
    AppletThreadGroup threadGroup;
    private final Object threadGroupSynchronizer = new Object();
    protected Hashtable rawClasses = new Hashtable();
    private static AppletMessageHandler amh;

    protected AppletClassLoader(URL uRL) {
        this.base = uRL;
        this.resources = new AppletResourceLoader(this);
    }

    protected AppletClassLoader(URL uRL, AppletResourceLoader appletResourceLoader) {
        this.base = uRL;
        this.resources = appletResourceLoader;
    }

    protected URL getCodeBase() {
        return this.base;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Class loadClass(String string, URL uRL) throws IOException {
        Class clazz;
        InputStream inputStream = null;
        try {
            try {
                int n;
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.setAllowUserInteraction(false);
                inputStream = HttpURLConnection.openConnectionCheckRedirects(uRLConnection);
                int n2 = uRLConnection.getContentLength();
                byte[] byArray = new byte[n2 == -1 ? 4096 : n2];
                int n3 = 0;
                Thread thread = Thread.currentThread();
                while ((n = inputStream.read(byArray, n3, byArray.length - n3)) >= 0 && !thread.isInterrupted()) {
                    if ((n3 += n) != byArray.length) continue;
                    if (n2 >= 0) break;
                    byte[] byArray2 = new byte[n3 * 2];
                    System.arraycopy(byArray, 0, byArray2, 0, n3);
                    byArray = byArray2;
                }
                if (thread.isInterrupted()) {
                    throw new AppletIOException("loadclass.throw.interrupted", uRL);
                }
                clazz = this.defineClass(string, byArray, 0, n3);
                Object var6_13 = null;
                if (inputStream == null) return clazz;
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Throwable throwable) {
                throw new AppletIOException("loadclass.throw.notloaded", uRL);
            }
        }
        catch (Throwable throwable) {
            Object var6_14 = null;
            if (inputStream == null) throw throwable;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return clazz;
    }

    static URL makeRelativeURLWithSecurity(URL uRL, String string) throws MalformedURLException {
        URL uRL2 = new URL(uRL, string);
        String string2 = uRL.getHost();
        String string3 = uRL2.getHost();
        if (!uRL.getProtocol().equals(uRL2.getProtocol()) || string2 == null && string3 != null || string2 != null && !string2.equals(string3) || uRL.getPort() != uRL2.getPort()) {
            throw new SecurityException("illegal relative URL");
        }
        return uRL2;
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(string, true);
    }

    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class clazz = this.findLoadedClass(string);
        if (clazz == null) {
            int n;
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null && (n = string.lastIndexOf(46)) >= 0) {
                securityManager.checkPackageAccess(string.substring(0, n));
            }
            try {
                return this.findSystemClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = this.findClass(string);
            }
        }
        if (clazz == null) {
            throw new ClassNotFoundException(string);
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private synchronized Class loadCode(String string, String string2, String string3) throws ClassNotFoundException, IOException {
        int n;
        Class clazz = this.findLoadedClass(string3);
        if (clazz != null) {
            return clazz;
        }
        AppletClassEntry appletClassEntry = (AppletClassEntry)this.rawClasses.get(string3);
        if (appletClassEntry != null) {
            Class clazz2;
            try {
                Class clazz3 = super.defineClass(appletClassEntry.classBuf, appletClassEntry.start, appletClassEntry.len);
                if (appletClassEntry.ids != null) {
                    this.setSigners(clazz3, appletClassEntry.ids);
                }
                clazz2 = clazz3;
                Object var8_9 = null;
                this.rawClasses.remove(string3);
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                this.rawClasses.remove(string3);
                throw throwable;
            }
            return clazz2;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (n = string3.lastIndexOf(46)) >= 0) {
            String string4 = string3.substring(0, n);
            securityManager.checkPackageAccess(string4);
        }
        try {
            return this.findSystemClass(string3);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                URL uRL = AppletClassLoader.makeRelativeURLWithSecurity(this.base, String.valueOf(string) + string2);
                this.verbose(amh.getMessage("loadcode.verbose", uRL.toString(), string3));
                clazz = this.loadClass(string3, uRL);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.errorMsg("filenotfound", string3);
            }
            catch (ClassFormatError classFormatError) {
                this.errorMsg("fileformat", string3);
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                this.errorMsg("fileexception", exception.toString(), string3);
            }
            catch (ThreadDeath threadDeath) {
                this.errorMsg("filedeath", string3);
                throw threadDeath;
            }
            catch (Error error) {
                this.errorMsg("fileerror", error.toString(), string3);
            }
            if (clazz != null) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
    }

    Class loadCode(String string) throws ClassNotFoundException {
        this.debug("AppletClassLoader(" + this.base.toString() + ").loadCode(" + string + ")");
        String string2 = ".class";
        String string3 = ".java";
        int n = string.lastIndexOf(46);
        String string4 = "";
        if (n != -1) {
            string4 = string.substring(n);
        }
        if (n != -1 && string.indexOf(47) != -1) {
            String string5 = string.substring(0, n);
            String string6 = string5.replace('/', '.');
            try {
                return this.loadCode(string5, string4, string6);
            }
            catch (IOException iOException) {
                throw new ClassNotFoundException(string6);
            }
        }
        if (string4.equals(string3) || string4.equals(string2)) {
            String string7 = string.substring(0, n);
            string7 = string7.replace('.', '/');
            string4 = string2;
            String string8 = string7.replace('/', '.');
            try {
                return this.loadCode(string7, string4, string8);
            }
            catch (IOException iOException) {
                throw new ClassNotFoundException(string8);
            }
        }
        String string9 = string.replace('.', '/');
        string4 = string2;
        String string10 = string9.replace('/', '.');
        try {
            return this.loadCode(string9, string4, string10);
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {}
        if (n < 0) {
            n = string.length();
        }
        string9 = string.substring(0, n);
        string9 = string9.replace('.', '/');
        string4 = string.substring(n);
        string10 = string9.replace('/', '.');
        try {
            return this.loadCode(string9, string4, string10);
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {}
        string9 = string.substring(0, n);
        string9 = string9.replace('.', '/');
        string4 = string.substring(n);
        string10 = string.replace('/', '.');
        try {
            return this.loadCode(string9, string4, string10);
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException(string10);
        }
    }

    public AppletClassEntry defineClassFromBytes(String string, byte[] byArray, int n, int n2) {
        SecurityManager securityManager = System.getSecurityManager();
        String string2 = "";
        int n3 = string.lastIndexOf(46);
        if (n3 >= 0) {
            string2 = string.substring(0, n3);
        }
        if (securityManager != null) {
            securityManager.checkPackageDefinition(string2);
        }
        AppletClassEntry appletClassEntry = new AppletClassEntry(byArray, n, n2, string, null);
        this.rawClasses.put(appletClassEntry, appletClassEntry);
        this.rawClasses.put(string, appletClassEntry);
        return appletClassEntry;
    }

    void errorMsg(String string, String string2) {
        System.err.println(amh.getMessage(string, string2));
    }

    void errorMsg(String string, String string2, String string3) {
        System.err.println(amh.getMessage(string, string2, string3));
    }

    private synchronized Class findClass(String string) {
        int n;
        Class clazz = this.findLoadedClass(string);
        if (clazz != null) {
            return clazz;
        }
        AppletClassEntry appletClassEntry = (AppletClassEntry)this.rawClasses.get(string);
        if (appletClassEntry != null) {
            Class clazz2;
            try {
                Class clazz3 = super.defineClass(appletClassEntry.classBuf, appletClassEntry.start, appletClassEntry.len);
                if (appletClassEntry.ids != null) {
                    this.setSigners(clazz3, appletClassEntry.ids);
                }
                clazz2 = clazz3;
                Object var6_7 = null;
                this.rawClasses.remove(string);
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                this.rawClasses.remove(string);
                throw throwable;
            }
            return clazz2;
        }
        this.verbose(amh.getMessage("findclass.verbose.findclass", Thread.currentThread().getName(), string));
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (n = string.lastIndexOf(46)) >= 0) {
            securityManager.checkPackageDefinition(string.substring(0, n));
        }
        String string2 = String.valueOf(string.replace('.', '/')) + ".class";
        try {
            URL uRL = AppletClassLoader.makeRelativeURLWithSecurity(this.base, string2);
            this.verbose(amh.getMessage("findclass.verbose.openstream", uRL.toString(), string));
            clazz = this.loadClass(string, uRL);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.errorMsg("filenotfound", string);
        }
        catch (ClassFormatError classFormatError) {
            this.errorMsg("fileformat", string);
        }
        catch (IOException iOException) {
            this.errorMsg("fileioexception", string);
        }
        catch (Exception exception) {
            this.errorMsg("fileexception", exception.toString(), string);
        }
        catch (ThreadDeath threadDeath) {
            this.errorMsg("filedeath", string);
            throw threadDeath;
        }
        catch (Error error) {
            this.errorMsg("fileerror", error.toString(), string);
        }
        return clazz;
    }

    public AppletResourceLoader getResourceLoader() {
        return this.resources;
    }

    private boolean resourceExists(URL uRL) {
        boolean bl = true;
        try {
            URLConnection uRLConnection = uRL.openConnection();
            if (uRLConnection instanceof java.net.HttpURLConnection) {
                java.net.HttpURLConnection httpURLConnection = (java.net.HttpURLConnection)uRLConnection;
                int n = httpURLConnection.getResponseCode();
                if (n == 200) {
                    return true;
                }
                if (n >= 400) {
                    return false;
                }
            } else {
                InputStream inputStream = uRL.openStream();
                inputStream.close();
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public URL getResource(String string) {
        this.verbose(amh.getMessage("getresource.verbose.forname", string));
        URL uRL = ClassLoader.getSystemResource(string);
        if (uRL != null) {
            this.verbose(amh.getMessage("getresource.verbose.found", string));
            return uRL;
        }
        String string2 = this.resources.getResourceAsName(string);
        try {
            uRL = new URL(string2);
            if (!this.resourceExists(uRL)) {
                uRL = null;
            }
        }
        catch (Exception exception) {
            uRL = null;
        }
        return uRL;
    }

    public InputStream getResourceAsStream(String string) {
        this.verbose("AppletClassLoader.getResourceAsStream for name: " + string);
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(string);
        if (inputStream != null) {
            this.verbose(amh.getMessage("getresourceasstream.verbose", string));
            return inputStream;
        }
        return this.resources.getResourceAsStream(string);
    }

    protected ThreadGroup getThreadGroup() {
        Object object = this.threadGroupSynchronizer;
        synchronized (object) {
            if (this.threadGroup == null || this.threadGroup.isDestroyed()) {
                this.threadGroup = new AppletThreadGroup(String.valueOf(this.base) + "-threadGroup");
                this.threadGroup.setDaemon(true);
            }
        }
        return this.threadGroup;
    }

    private void debug(String string) {
        if (debug) {
            System.err.println(string);
        }
    }

    private void verbose(String string) {
        if (this.verboseClassLoading) {
            System.out.println(string);
        }
    }

    static {
        amh = new AppletMessageHandler("appletclassloader");
    }
}

