/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;

public class BorderLayout
implements LayoutManager2,
Serializable {
    int hgap;
    int vgap;
    Component north;
    Component west;
    Component east;
    Component south;
    Component center;
    public static final String NORTH = "North";
    public static final String SOUTH = "South";
    public static final String EAST = "East";
    public static final String WEST = "West";
    public static final String CENTER = "Center";
    private static final long serialVersionUID = -8658291919501921765L;

    public BorderLayout() {
        this(0, 0);
    }

    public BorderLayout(int n, int n2) {
        this.hgap = n;
        this.vgap = n2;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int n) {
        this.hgap = n;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int n) {
        this.vgap = n;
    }

    public void addLayoutComponent(Component component, Object object) {
        if (object == null || object instanceof String) {
            this.addLayoutComponent((String)object, component);
            return;
        }
        throw new IllegalArgumentException("cannot add to layout: constraint must be a string (or null)");
    }

    public void addLayoutComponent(String string, Component component) {
        if (string == null) {
            string = CENTER;
        }
        if (CENTER.equals(string)) {
            this.center = component;
            return;
        }
        if (NORTH.equals(string)) {
            this.north = component;
            return;
        }
        if (SOUTH.equals(string)) {
            this.south = component;
            return;
        }
        if (EAST.equals(string)) {
            this.east = component;
            return;
        }
        if (WEST.equals(string)) {
            this.west = component;
            return;
        }
        throw new IllegalArgumentException("cannot add to layout: unknown constraint: " + string);
    }

    public void removeLayoutComponent(Component component) {
        if (component == this.center) {
            this.center = null;
            return;
        }
        if (component == this.north) {
            this.north = null;
            return;
        }
        if (component == this.south) {
            this.south = null;
            return;
        }
        if (component == this.east) {
            this.east = null;
            return;
        }
        if (component == this.west) {
            this.west = null;
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        Serializable serializable;
        Dimension dimension = new Dimension(0, 0);
        if (this.east != null && this.east.visible) {
            serializable = this.east.getMinimumSize();
            dimension.width += serializable.width + this.hgap;
            dimension.height = Math.max(serializable.height, dimension.height);
        }
        if (this.west != null && this.west.visible) {
            serializable = this.west.getMinimumSize();
            dimension.width += serializable.width + this.hgap;
            dimension.height = Math.max(serializable.height, dimension.height);
        }
        if (this.center != null && this.center.visible) {
            serializable = this.center.getMinimumSize();
            dimension.width += serializable.width;
            dimension.height = Math.max(serializable.height, dimension.height);
        }
        if (this.north != null && this.north.visible) {
            serializable = this.north.getMinimumSize();
            dimension.width = Math.max(serializable.width, dimension.width);
            dimension.height += serializable.height + this.vgap;
        }
        if (this.south != null && this.south.visible) {
            serializable = this.south.getMinimumSize();
            dimension.width = Math.max(serializable.width, dimension.width);
            dimension.height += serializable.height + this.vgap;
        }
        serializable = container.getInsets();
        dimension.width += ((Insets)serializable).left + ((Insets)serializable).right;
        dimension.height += ((Insets)serializable).top + ((Insets)serializable).bottom;
        return dimension;
    }

    public Dimension preferredLayoutSize(Container container) {
        Serializable serializable;
        Dimension dimension = new Dimension(0, 0);
        if (this.east != null && this.east.visible) {
            serializable = this.east.getPreferredSize();
            dimension.width += serializable.width + this.hgap;
            dimension.height = Math.max(serializable.height, dimension.height);
        }
        if (this.west != null && this.west.visible) {
            serializable = this.west.getPreferredSize();
            dimension.width += serializable.width + this.hgap;
            dimension.height = Math.max(serializable.height, dimension.height);
        }
        if (this.center != null && this.center.visible) {
            serializable = this.center.getPreferredSize();
            dimension.width += serializable.width;
            dimension.height = Math.max(serializable.height, dimension.height);
        }
        if (this.north != null && this.north.visible) {
            serializable = this.north.getPreferredSize();
            dimension.width = Math.max(serializable.width, dimension.width);
            dimension.height += serializable.height + this.vgap;
        }
        if (this.south != null && this.south.visible) {
            serializable = this.south.getPreferredSize();
            dimension.width = Math.max(serializable.width, dimension.width);
            dimension.height += serializable.height + this.vgap;
        }
        serializable = container.getInsets();
        dimension.width += ((Insets)serializable).left + ((Insets)serializable).right;
        dimension.height += ((Insets)serializable).top + ((Insets)serializable).bottom;
        return dimension;
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
    }

    public void layoutContainer(Container container) {
        Dimension dimension;
        Insets insets = container.getInsets();
        int n = insets.top;
        int n2 = container.height - insets.bottom;
        int n3 = insets.left;
        int n4 = container.width - insets.right;
        if (this.north != null && this.north.visible) {
            this.north.setSize(n4 - n3, this.north.height);
            dimension = this.north.getPreferredSize();
            this.north.setBounds(n3, n, n4 - n3, dimension.height);
            n += dimension.height + this.vgap;
        }
        if (this.south != null && this.south.visible) {
            this.south.setSize(n4 - n3, this.south.height);
            dimension = this.south.getPreferredSize();
            this.south.setBounds(n3, n2 - dimension.height, n4 - n3, dimension.height);
            n2 -= dimension.height + this.vgap;
        }
        if (this.east != null && this.east.visible) {
            this.east.setSize(this.east.width, n2 - n);
            dimension = this.east.getPreferredSize();
            this.east.setBounds(n4 - dimension.width, n, dimension.width, n2 - n);
            n4 -= dimension.width + this.hgap;
        }
        if (this.west != null && this.west.visible) {
            this.west.setSize(this.west.width, n2 - n);
            dimension = this.west.getPreferredSize();
            this.west.setBounds(n3, n, dimension.width, n2 - n);
            n3 += dimension.width + this.hgap;
        }
        if (this.center != null && this.center.visible) {
            this.center.setBounds(n3, n, n4 - n3, n2 - n);
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[hgap=" + this.hgap + ",vgap=" + this.vgap + "]";
    }
}

