/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.CompactByteArray;
import java.text.CompactShortArray;

class DecompositionIterator {
    public static final char NULLORDER = '\uffff';
    private static final short SHORT_MAX_VALUE = Short.MAX_VALUE;
    private static final char STERMINATOR = '\u0000';
    private static final short[] kOffsetIndex;
    private static final short[] kOffsetValues;
    private static final short[] kCanonicalIndex;
    private static final byte[] kCanonicalValues;
    private static String contents;
    private static int maximumDecomposition;
    private static int maximumCanonical;
    private StringBuffer parsedStr;
    private String str;
    private int pIndex;
    private int sIndex;
    private int getEndIndex;
    private int decmpMode;
    private int getBeginIndex;
    private int uptoOffset;
    private static final CompactShortArray startOffsets;
    static final byte BASE = -128;
    private static CompactByteArray canonicals;

    public DecompositionIterator(String string, int n, int n2, int n3) {
        this.str = string;
        this.parsedStr = new StringBuffer(string.length());
        this.sIndex = n;
        this.pIndex = 0;
        this.getBeginIndex = n;
        this.getEndIndex = n2;
        this.decmpMode = n3;
    }

    public char next() {
        if (this.decmpMode == 0) {
            if (this.sIndex >= this.str.length()) {
                return '\uffff';
            }
            return this.str.charAt(this.sIndex++);
        }
        if (this.pIndex >= this.parsedStr.length()) {
            this.parsedStr.setLength(0);
            this.pIndex = 0;
            this.uptoOffset = this.sIndex;
            if (this.sIndex >= this.getEndIndex) {
                return '\uffff';
            }
            char c = this.str.charAt(this.uptoOffset++);
            this.parsedStr.append(c);
            while (this.uptoOffset < this.getEndIndex) {
                c = this.str.charAt(this.uptoOffset);
                if ((448 >> Character.getType(c) & 1) != 0) break;
                this.parsedStr.append(c);
                ++this.uptoOffset;
            }
            DecompositionIterator.decompose(this.parsedStr, this.decmpMode);
            DecompositionIterator.fixCanonical(this.parsedStr);
            this.uptoOffset -= this.sIndex;
            this.sIndex += this.uptoOffset;
        }
        return this.parsedStr.charAt(this.pIndex++);
    }

    public char previous() {
        if (this.decmpMode == 0) {
            if (this.sIndex <= this.getBeginIndex) {
                return '\uffff';
            }
            return this.str.charAt(--this.sIndex);
        }
        if (this.pIndex <= this.parsedStr.length()) {
            if (this.pIndex > 1) {
                --this.pIndex;
                return this.parsedStr.charAt(this.pIndex);
            }
            this.parsedStr.setLength(0);
            this.pIndex = 0;
            this.sIndex -= this.uptoOffset;
        }
        if (this.sIndex < this.str.length()) {
            return this.str.charAt(this.sIndex);
        }
        return '\uffff';
    }

    public void reset() {
        this.sIndex = this.getBeginIndex;
        this.pIndex = 0;
    }

    static String decompose(char c, int n) {
        char c2;
        if (n == 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(c);
            return stringBuffer.toString();
        }
        int n2 = n == 1 ? maximumCanonical : Short.MAX_VALUE;
        int n3 = startOffsets.elementAt(c);
        if (n3 >= n2) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        while ((c2 = contents.charAt(n3++)) != '\u0000') {
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    static void decompose(StringBuffer stringBuffer, int n) {
        DecompositionIterator.decompose(stringBuffer, 0, stringBuffer.length(), n);
    }

    static void decompose(StringBuffer stringBuffer, int n, int n2, int n3) {
        if (n3 == 0) {
            String string = stringBuffer.toString().substring(n, n2);
            stringBuffer.setLength(0);
            stringBuffer.append(string);
        }
        int n4 = n3 == 1 ? maximumCanonical : Short.MAX_VALUE;
        StringBuffer stringBuffer2 = new StringBuffer();
        int n5 = n;
        while (n5 < n2) {
            char c = stringBuffer.charAt(n5);
            int n6 = startOffsets.elementAt(c);
            if (n6 >= n4) {
                stringBuffer2.append(c);
            } else {
                while ((c = contents.charAt(n6++)) != '\u0000') {
                    stringBuffer2.append(c);
                }
            }
            ++n5;
        }
        stringBuffer.setLength(0);
        stringBuffer.append(stringBuffer2.toString());
    }

    static String decompose(String string, int n) {
        return DecompositionIterator.decompose(string, 0, string.length(), n);
    }

    static String decompose(String string, int n, int n2, int n3) {
        if (n3 == 0) {
            return string.substring(n, n2);
        }
        int n4 = n3 == 1 ? maximumCanonical : Short.MAX_VALUE;
        StringBuffer stringBuffer = new StringBuffer();
        int n5 = n;
        while (n5 < n2) {
            char c = string.charAt(n5);
            int n6 = startOffsets.elementAt(c);
            if (n6 >= n4) {
                stringBuffer.append(c);
            } else {
                while ((c = contents.charAt(n6++)) != '\u0000') {
                    stringBuffer.append(c);
                }
            }
            ++n5;
        }
        return stringBuffer.toString();
    }

    static int decompose(char c, char[] cArray, int n) {
        char c2;
        if (n == 0) {
            cArray[0] = c;
            cArray[1] = '\u0000';
            return 1;
        }
        int n2 = n == 1 ? maximumCanonical : Short.MAX_VALUE;
        int n3 = startOffsets.elementAt(c);
        if (n3 >= n2) {
            return 0;
        }
        int n4 = 0;
        while ((c2 = contents.charAt(n3++)) != '\u0000') {
            cArray[n4++] = c2;
        }
        return n4;
    }

    static int getMaximumDecomposition() {
        return maximumDecomposition;
    }

    private static void fixCanonical(StringBuffer stringBuffer) {
        int n = stringBuffer.length() - 1;
        byte by = canonicals.elementAt(stringBuffer.charAt(n));
        --n;
        while (n >= 0) {
            byte by2 = by;
            by = canonicals.elementAt(stringBuffer.charAt(n));
            if (by > by2 && by2 != -128) {
                char c = stringBuffer.charAt(n);
                stringBuffer.setCharAt(n, stringBuffer.charAt(n + 1));
                stringBuffer.setCharAt(n + 1, c);
                if (n < stringBuffer.length() - 2) {
                    n += 2;
                }
                by = canonicals.elementAt(stringBuffer.charAt(n));
            }
            --n;
        }
    }

    /*
     * Opcode count of 18544 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        short[] sArray = new short[512];
        sArray[1] = 128;
        sArray[2] = 256;
        sArray[3] = 384;
        sArray[4] = 512;
        sArray[5] = 640;
        sArray[6] = 768;
        sArray[7] = 768;
        sArray[8] = 768;
        sArray[9] = 768;
        sArray[10] = 768;
        sArray[11] = 768;
        sArray[12] = 768;
        sArray[13] = 768;
        sArray[14] = 768;
        sArray[15] = 768;
        sArray[16] = 768;
        sArray[17] = 768;
        sArray[18] = 768;
        sArray[19] = 768;
        sArray[20] = 768;
        sArray[21] = 768;
        sArray[22] = 768;
        sArray[23] = 768;
        sArray[24] = 768;
        sArray[25] = 768;
        sArray[26] = 768;
        sArray[27] = 768;
        sArray[28] = 768;
        sArray[29] = 768;
        sArray[30] = 768;
        sArray[31] = 768;
        sArray[32] = 768;
        sArray[33] = 768;
        sArray[34] = 768;
        sArray[35] = 768;
        sArray[36] = 768;
        sArray[37] = 768;
        sArray[38] = 768;
        sArray[39] = 768;
        sArray[40] = 768;
        sArray[41] = 768;
        sArray[42] = 768;
        sArray[43] = 768;
        sArray[44] = 768;
        sArray[45] = 768;
        sArray[46] = 768;
        sArray[47] = 768;
        sArray[48] = 768;
        sArray[49] = 768;
        sArray[50] = 768;
        sArray[51] = 768;
        sArray[52] = 768;
        sArray[53] = 768;
        sArray[54] = 768;
        sArray[55] = 768;
        sArray[56] = 768;
        sArray[57] = 768;
        sArray[58] = 768;
        sArray[59] = 768;
        sArray[60] = 768;
        sArray[61] = 768;
        sArray[62] = 768;
        sArray[63] = 768;
        sArray[64] = 768;
        sArray[65] = 896;
        sArray[66] = 768;
        sArray[67] = 768;
        sArray[68] = 768;
        sArray[69] = 768;
        sArray[70] = 768;
        sArray[71] = 768;
        sArray[72] = 768;
        sArray[73] = 768;
        sArray[74] = 768;
        sArray[75] = 768;
        sArray[76] = 768;
        sArray[77] = 768;
        sArray[78] = 768;
        sArray[79] = 768;
        sArray[80] = 768;
        sArray[81] = 768;
        sArray[82] = 768;
        sArray[83] = 768;
        sArray[84] = 768;
        sArray[85] = 768;
        sArray[86] = 768;
        sArray[87] = 768;
        sArray[88] = 768;
        sArray[89] = 768;
        sArray[90] = 768;
        sArray[91] = 768;
        sArray[92] = 768;
        sArray[93] = 768;
        sArray[94] = 768;
        sArray[95] = 768;
        sArray[96] = 768;
        sArray[97] = 768;
        sArray[98] = 768;
        sArray[99] = 768;
        sArray[100] = 768;
        sArray[101] = 768;
        sArray[102] = 768;
        sArray[103] = 768;
        sArray[104] = 768;
        sArray[105] = 768;
        sArray[106] = 768;
        sArray[107] = 768;
        sArray[108] = 768;
        sArray[109] = 768;
        sArray[110] = 768;
        sArray[111] = 768;
        sArray[112] = 768;
        sArray[113] = 768;
        sArray[114] = 768;
        sArray[115] = 768;
        sArray[116] = 768;
        sArray[117] = 768;
        sArray[118] = 768;
        sArray[119] = 768;
        sArray[120] = 768;
        sArray[121] = 768;
        sArray[122] = 768;
        sArray[123] = 768;
        sArray[124] = 768;
        sArray[125] = 768;
        sArray[126] = 768;
        sArray[127] = 768;
        sArray[128] = 768;
        sArray[129] = 768;
        sArray[130] = 768;
        sArray[131] = 768;
        sArray[132] = 768;
        sArray[133] = 768;
        sArray[134] = 768;
        sArray[135] = 768;
        sArray[136] = 768;
        sArray[137] = 768;
        sArray[138] = 768;
        sArray[139] = 768;
        sArray[140] = 768;
        sArray[141] = 768;
        sArray[142] = 768;
        sArray[143] = 768;
        sArray[144] = 768;
        sArray[145] = 768;
        sArray[146] = 768;
        sArray[147] = 768;
        sArray[148] = 768;
        sArray[149] = 768;
        sArray[150] = 768;
        sArray[151] = 768;
        sArray[152] = 768;
        sArray[153] = 768;
        sArray[154] = 768;
        sArray[155] = 768;
        sArray[156] = 768;
        sArray[157] = 768;
        sArray[158] = 768;
        sArray[159] = 768;
        sArray[160] = 768;
        sArray[161] = 768;
        sArray[162] = 768;
        sArray[163] = 768;
        sArray[164] = 768;
        sArray[165] = 768;
        sArray[166] = 768;
        sArray[167] = 768;
        sArray[168] = 768;
        sArray[169] = 768;
        sArray[170] = 768;
        sArray[171] = 768;
        sArray[172] = 768;
        sArray[173] = 768;
        sArray[174] = 768;
        sArray[175] = 768;
        sArray[176] = 768;
        sArray[177] = 768;
        sArray[178] = 768;
        sArray[179] = 768;
        sArray[180] = 768;
        sArray[181] = 768;
        sArray[182] = 768;
        sArray[183] = 768;
        sArray[184] = 768;
        sArray[185] = 768;
        sArray[186] = 768;
        sArray[187] = 768;
        sArray[188] = 768;
        sArray[189] = 768;
        sArray[190] = 768;
        sArray[191] = 768;
        sArray[192] = 768;
        sArray[193] = 768;
        sArray[194] = 768;
        sArray[195] = 768;
        sArray[196] = 768;
        sArray[197] = 768;
        sArray[198] = 768;
        sArray[199] = 768;
        sArray[200] = 768;
        sArray[201] = 768;
        sArray[202] = 768;
        sArray[203] = 768;
        sArray[204] = 768;
        sArray[205] = 768;
        sArray[206] = 768;
        sArray[207] = 768;
        sArray[208] = 768;
        sArray[209] = 768;
        sArray[210] = 768;
        sArray[211] = 768;
        sArray[212] = 768;
        sArray[213] = 768;
        sArray[214] = 768;
        sArray[215] = 768;
        sArray[216] = 768;
        sArray[217] = 768;
        sArray[218] = 768;
        sArray[219] = 768;
        sArray[220] = 768;
        sArray[221] = 768;
        sArray[222] = 768;
        sArray[223] = 768;
        sArray[224] = 768;
        sArray[225] = 768;
        sArray[226] = 768;
        sArray[227] = 768;
        sArray[228] = 768;
        sArray[229] = 768;
        sArray[230] = 768;
        sArray[231] = 768;
        sArray[232] = 768;
        sArray[233] = 768;
        sArray[234] = 768;
        sArray[235] = 768;
        sArray[236] = 768;
        sArray[237] = 768;
        sArray[238] = 768;
        sArray[239] = 768;
        sArray[240] = 768;
        sArray[241] = 768;
        sArray[242] = 768;
        sArray[243] = 768;
        sArray[244] = 768;
        sArray[245] = 768;
        sArray[246] = 768;
        sArray[247] = 768;
        sArray[248] = 768;
        sArray[249] = 768;
        sArray[250] = 768;
        sArray[251] = 768;
        sArray[252] = 768;
        sArray[253] = 768;
        sArray[254] = 768;
        sArray[255] = 768;
        sArray[256] = 768;
        sArray[257] = 768;
        sArray[258] = 768;
        sArray[259] = 768;
        sArray[260] = 768;
        sArray[261] = 768;
        sArray[262] = 768;
        sArray[263] = 768;
        sArray[264] = 768;
        sArray[265] = 768;
        sArray[266] = 768;
        sArray[267] = 768;
        sArray[268] = 768;
        sArray[269] = 768;
        sArray[270] = 768;
        sArray[271] = 768;
        sArray[272] = 768;
        sArray[273] = 768;
        sArray[274] = 768;
        sArray[275] = 768;
        sArray[276] = 768;
        sArray[277] = 768;
        sArray[278] = 768;
        sArray[279] = 768;
        sArray[280] = 768;
        sArray[281] = 768;
        sArray[282] = 768;
        sArray[283] = 768;
        sArray[284] = 768;
        sArray[285] = 768;
        sArray[286] = 768;
        sArray[287] = 768;
        sArray[288] = 768;
        sArray[289] = 768;
        sArray[290] = 768;
        sArray[291] = 768;
        sArray[292] = 768;
        sArray[293] = 768;
        sArray[294] = 768;
        sArray[295] = 768;
        sArray[296] = 768;
        sArray[297] = 768;
        sArray[298] = 768;
        sArray[299] = 768;
        sArray[300] = 768;
        sArray[301] = 768;
        sArray[302] = 768;
        sArray[303] = 768;
        sArray[304] = 768;
        sArray[305] = 768;
        sArray[306] = 768;
        sArray[307] = 768;
        sArray[308] = 768;
        sArray[309] = 768;
        sArray[310] = 768;
        sArray[311] = 768;
        sArray[312] = 768;
        sArray[313] = 768;
        sArray[314] = 768;
        sArray[315] = 768;
        sArray[316] = 768;
        sArray[317] = 768;
        sArray[318] = 768;
        sArray[319] = 768;
        sArray[320] = 768;
        sArray[321] = 768;
        sArray[322] = 768;
        sArray[323] = 768;
        sArray[324] = 768;
        sArray[325] = 768;
        sArray[326] = 768;
        sArray[327] = 768;
        sArray[328] = 768;
        sArray[329] = 768;
        sArray[330] = 768;
        sArray[331] = 768;
        sArray[332] = 768;
        sArray[333] = 768;
        sArray[334] = 768;
        sArray[335] = 768;
        sArray[336] = 768;
        sArray[337] = 768;
        sArray[338] = 768;
        sArray[339] = 768;
        sArray[340] = 768;
        sArray[341] = 768;
        sArray[342] = 768;
        sArray[343] = 768;
        sArray[344] = 768;
        sArray[345] = 768;
        sArray[346] = 768;
        sArray[347] = 768;
        sArray[348] = 768;
        sArray[349] = 768;
        sArray[350] = 768;
        sArray[351] = 768;
        sArray[352] = 768;
        sArray[353] = 768;
        sArray[354] = 768;
        sArray[355] = 768;
        sArray[356] = 768;
        sArray[357] = 768;
        sArray[358] = 768;
        sArray[359] = 768;
        sArray[360] = 768;
        sArray[361] = 768;
        sArray[362] = 768;
        sArray[363] = 768;
        sArray[364] = 768;
        sArray[365] = 768;
        sArray[366] = 768;
        sArray[367] = 768;
        sArray[368] = 768;
        sArray[369] = 768;
        sArray[370] = 768;
        sArray[371] = 768;
        sArray[372] = 768;
        sArray[373] = 768;
        sArray[374] = 768;
        sArray[375] = 768;
        sArray[376] = 768;
        sArray[377] = 768;
        sArray[378] = 768;
        sArray[379] = 768;
        sArray[380] = 768;
        sArray[381] = 768;
        sArray[382] = 768;
        sArray[383] = 768;
        sArray[384] = 768;
        sArray[385] = 768;
        sArray[386] = 768;
        sArray[387] = 768;
        sArray[388] = 768;
        sArray[389] = 768;
        sArray[390] = 768;
        sArray[391] = 768;
        sArray[392] = 768;
        sArray[393] = 768;
        sArray[394] = 768;
        sArray[395] = 768;
        sArray[396] = 768;
        sArray[397] = 768;
        sArray[398] = 768;
        sArray[399] = 768;
        sArray[400] = 768;
        sArray[401] = 768;
        sArray[402] = 768;
        sArray[403] = 768;
        sArray[404] = 768;
        sArray[405] = 768;
        sArray[406] = 768;
        sArray[407] = 768;
        sArray[408] = 768;
        sArray[409] = 768;
        sArray[410] = 768;
        sArray[411] = 768;
        sArray[412] = 768;
        sArray[413] = 768;
        sArray[414] = 768;
        sArray[415] = 768;
        sArray[416] = 768;
        sArray[417] = 768;
        sArray[418] = 768;
        sArray[419] = 768;
        sArray[420] = 768;
        sArray[421] = 768;
        sArray[422] = 768;
        sArray[423] = 768;
        sArray[424] = 768;
        sArray[425] = 768;
        sArray[426] = 768;
        sArray[427] = 768;
        sArray[428] = 768;
        sArray[429] = 768;
        sArray[430] = 768;
        sArray[431] = 768;
        sArray[432] = 768;
        sArray[433] = 768;
        sArray[434] = 768;
        sArray[435] = 768;
        sArray[436] = 768;
        sArray[437] = 768;
        sArray[438] = 768;
        sArray[439] = 768;
        sArray[440] = 768;
        sArray[441] = 768;
        sArray[442] = 768;
        sArray[443] = 768;
        sArray[444] = 768;
        sArray[445] = 768;
        sArray[446] = 768;
        sArray[447] = 768;
        sArray[448] = 768;
        sArray[449] = 768;
        sArray[450] = 768;
        sArray[451] = 768;
        sArray[452] = 768;
        sArray[453] = 768;
        sArray[454] = 768;
        sArray[455] = 768;
        sArray[456] = 768;
        sArray[457] = 768;
        sArray[458] = 768;
        sArray[459] = 768;
        sArray[460] = 768;
        sArray[461] = 768;
        sArray[462] = 768;
        sArray[463] = 768;
        sArray[464] = 768;
        sArray[465] = 768;
        sArray[466] = 768;
        sArray[467] = 768;
        sArray[468] = 768;
        sArray[469] = 768;
        sArray[470] = 768;
        sArray[471] = 768;
        sArray[472] = 768;
        sArray[473] = 768;
        sArray[474] = 768;
        sArray[475] = 768;
        sArray[476] = 768;
        sArray[477] = 768;
        sArray[478] = 768;
        sArray[479] = 768;
        sArray[480] = 768;
        sArray[481] = 768;
        sArray[482] = 768;
        sArray[483] = 768;
        sArray[484] = 768;
        sArray[485] = 768;
        sArray[486] = 768;
        sArray[487] = 768;
        sArray[488] = 768;
        sArray[489] = 768;
        sArray[490] = 768;
        sArray[491] = 768;
        sArray[492] = 768;
        sArray[493] = 768;
        sArray[494] = 768;
        sArray[495] = 768;
        sArray[496] = 768;
        sArray[497] = 768;
        sArray[498] = 768;
        sArray[499] = 768;
        sArray[500] = 768;
        sArray[501] = 768;
        sArray[502] = 768;
        sArray[503] = 768;
        sArray[504] = 768;
        sArray[505] = 768;
        sArray[506] = 768;
        sArray[507] = 768;
        sArray[508] = 768;
        sArray[509] = 768;
        sArray[510] = 768;
        sArray[511] = 768;
        kOffsetIndex = sArray;
        short[] sArray2 = new short[1024];
        sArray2[0] = Short.MAX_VALUE;
        sArray2[1] = Short.MAX_VALUE;
        sArray2[2] = Short.MAX_VALUE;
        sArray2[3] = Short.MAX_VALUE;
        sArray2[4] = Short.MAX_VALUE;
        sArray2[5] = Short.MAX_VALUE;
        sArray2[6] = Short.MAX_VALUE;
        sArray2[7] = Short.MAX_VALUE;
        sArray2[8] = Short.MAX_VALUE;
        sArray2[9] = Short.MAX_VALUE;
        sArray2[10] = Short.MAX_VALUE;
        sArray2[11] = Short.MAX_VALUE;
        sArray2[12] = Short.MAX_VALUE;
        sArray2[13] = Short.MAX_VALUE;
        sArray2[14] = Short.MAX_VALUE;
        sArray2[15] = Short.MAX_VALUE;
        sArray2[16] = Short.MAX_VALUE;
        sArray2[17] = Short.MAX_VALUE;
        sArray2[18] = Short.MAX_VALUE;
        sArray2[19] = Short.MAX_VALUE;
        sArray2[20] = Short.MAX_VALUE;
        sArray2[21] = Short.MAX_VALUE;
        sArray2[22] = Short.MAX_VALUE;
        sArray2[23] = Short.MAX_VALUE;
        sArray2[24] = Short.MAX_VALUE;
        sArray2[25] = Short.MAX_VALUE;
        sArray2[26] = Short.MAX_VALUE;
        sArray2[27] = Short.MAX_VALUE;
        sArray2[28] = Short.MAX_VALUE;
        sArray2[29] = Short.MAX_VALUE;
        sArray2[30] = Short.MAX_VALUE;
        sArray2[31] = Short.MAX_VALUE;
        sArray2[32] = Short.MAX_VALUE;
        sArray2[33] = Short.MAX_VALUE;
        sArray2[34] = Short.MAX_VALUE;
        sArray2[35] = Short.MAX_VALUE;
        sArray2[36] = Short.MAX_VALUE;
        sArray2[37] = Short.MAX_VALUE;
        sArray2[38] = Short.MAX_VALUE;
        sArray2[39] = Short.MAX_VALUE;
        sArray2[40] = Short.MAX_VALUE;
        sArray2[41] = Short.MAX_VALUE;
        sArray2[42] = Short.MAX_VALUE;
        sArray2[43] = Short.MAX_VALUE;
        sArray2[44] = Short.MAX_VALUE;
        sArray2[45] = Short.MAX_VALUE;
        sArray2[46] = Short.MAX_VALUE;
        sArray2[47] = Short.MAX_VALUE;
        sArray2[48] = Short.MAX_VALUE;
        sArray2[49] = Short.MAX_VALUE;
        sArray2[50] = Short.MAX_VALUE;
        sArray2[51] = Short.MAX_VALUE;
        sArray2[52] = Short.MAX_VALUE;
        sArray2[53] = Short.MAX_VALUE;
        sArray2[54] = Short.MAX_VALUE;
        sArray2[55] = Short.MAX_VALUE;
        sArray2[56] = Short.MAX_VALUE;
        sArray2[57] = Short.MAX_VALUE;
        sArray2[58] = Short.MAX_VALUE;
        sArray2[59] = Short.MAX_VALUE;
        sArray2[60] = Short.MAX_VALUE;
        sArray2[61] = Short.MAX_VALUE;
        sArray2[62] = Short.MAX_VALUE;
        sArray2[63] = Short.MAX_VALUE;
        sArray2[64] = Short.MAX_VALUE;
        sArray2[65] = Short.MAX_VALUE;
        sArray2[66] = Short.MAX_VALUE;
        sArray2[67] = Short.MAX_VALUE;
        sArray2[68] = Short.MAX_VALUE;
        sArray2[69] = Short.MAX_VALUE;
        sArray2[70] = Short.MAX_VALUE;
        sArray2[71] = Short.MAX_VALUE;
        sArray2[72] = Short.MAX_VALUE;
        sArray2[73] = Short.MAX_VALUE;
        sArray2[74] = Short.MAX_VALUE;
        sArray2[75] = Short.MAX_VALUE;
        sArray2[76] = Short.MAX_VALUE;
        sArray2[77] = Short.MAX_VALUE;
        sArray2[78] = Short.MAX_VALUE;
        sArray2[79] = Short.MAX_VALUE;
        sArray2[80] = Short.MAX_VALUE;
        sArray2[81] = Short.MAX_VALUE;
        sArray2[82] = Short.MAX_VALUE;
        sArray2[83] = Short.MAX_VALUE;
        sArray2[84] = Short.MAX_VALUE;
        sArray2[85] = Short.MAX_VALUE;
        sArray2[86] = Short.MAX_VALUE;
        sArray2[87] = Short.MAX_VALUE;
        sArray2[88] = Short.MAX_VALUE;
        sArray2[89] = Short.MAX_VALUE;
        sArray2[90] = Short.MAX_VALUE;
        sArray2[91] = Short.MAX_VALUE;
        sArray2[92] = Short.MAX_VALUE;
        sArray2[93] = Short.MAX_VALUE;
        sArray2[94] = 736;
        sArray2[95] = 739;
        sArray2[96] = 742;
        sArray2[97] = Short.MAX_VALUE;
        sArray2[98] = Short.MAX_VALUE;
        sArray2[99] = Short.MAX_VALUE;
        sArray2[100] = Short.MAX_VALUE;
        sArray2[101] = Short.MAX_VALUE;
        sArray2[102] = Short.MAX_VALUE;
        sArray2[103] = Short.MAX_VALUE;
        sArray2[104] = Short.MAX_VALUE;
        sArray2[105] = Short.MAX_VALUE;
        sArray2[106] = Short.MAX_VALUE;
        sArray2[107] = Short.MAX_VALUE;
        sArray2[108] = Short.MAX_VALUE;
        sArray2[109] = Short.MAX_VALUE;
        sArray2[110] = Short.MAX_VALUE;
        sArray2[111] = Short.MAX_VALUE;
        sArray2[112] = Short.MAX_VALUE;
        sArray2[113] = Short.MAX_VALUE;
        sArray2[114] = Short.MAX_VALUE;
        sArray2[115] = Short.MAX_VALUE;
        sArray2[116] = Short.MAX_VALUE;
        sArray2[117] = Short.MAX_VALUE;
        sArray2[118] = Short.MAX_VALUE;
        sArray2[119] = Short.MAX_VALUE;
        sArray2[120] = Short.MAX_VALUE;
        sArray2[121] = Short.MAX_VALUE;
        sArray2[122] = Short.MAX_VALUE;
        sArray2[123] = Short.MAX_VALUE;
        sArray2[124] = Short.MAX_VALUE;
        sArray2[125] = Short.MAX_VALUE;
        sArray2[126] = Short.MAX_VALUE;
        sArray2[127] = Short.MAX_VALUE;
        sArray2[128] = Short.MAX_VALUE;
        sArray2[129] = Short.MAX_VALUE;
        sArray2[130] = Short.MAX_VALUE;
        sArray2[131] = Short.MAX_VALUE;
        sArray2[132] = Short.MAX_VALUE;
        sArray2[133] = Short.MAX_VALUE;
        sArray2[134] = Short.MAX_VALUE;
        sArray2[135] = Short.MAX_VALUE;
        sArray2[136] = Short.MAX_VALUE;
        sArray2[137] = Short.MAX_VALUE;
        sArray2[138] = Short.MAX_VALUE;
        sArray2[139] = Short.MAX_VALUE;
        sArray2[140] = Short.MAX_VALUE;
        sArray2[141] = Short.MAX_VALUE;
        sArray2[142] = Short.MAX_VALUE;
        sArray2[143] = Short.MAX_VALUE;
        sArray2[144] = Short.MAX_VALUE;
        sArray2[145] = Short.MAX_VALUE;
        sArray2[146] = Short.MAX_VALUE;
        sArray2[147] = Short.MAX_VALUE;
        sArray2[148] = Short.MAX_VALUE;
        sArray2[149] = Short.MAX_VALUE;
        sArray2[150] = Short.MAX_VALUE;
        sArray2[151] = Short.MAX_VALUE;
        sArray2[152] = Short.MAX_VALUE;
        sArray2[153] = Short.MAX_VALUE;
        sArray2[154] = Short.MAX_VALUE;
        sArray2[155] = Short.MAX_VALUE;
        sArray2[156] = Short.MAX_VALUE;
        sArray2[157] = Short.MAX_VALUE;
        sArray2[158] = Short.MAX_VALUE;
        sArray2[159] = Short.MAX_VALUE;
        sArray2[160] = 745;
        sArray2[161] = Short.MAX_VALUE;
        sArray2[162] = Short.MAX_VALUE;
        sArray2[163] = Short.MAX_VALUE;
        sArray2[164] = Short.MAX_VALUE;
        sArray2[165] = Short.MAX_VALUE;
        sArray2[166] = Short.MAX_VALUE;
        sArray2[167] = Short.MAX_VALUE;
        sArray2[168] = 747;
        sArray2[169] = Short.MAX_VALUE;
        sArray2[170] = 750;
        sArray2[171] = Short.MAX_VALUE;
        sArray2[172] = Short.MAX_VALUE;
        sArray2[173] = Short.MAX_VALUE;
        sArray2[174] = Short.MAX_VALUE;
        sArray2[175] = 752;
        sArray2[176] = Short.MAX_VALUE;
        sArray2[177] = Short.MAX_VALUE;
        sArray2[178] = 755;
        sArray2[179] = 757;
        sArray2[180] = 759;
        sArray2[181] = 762;
        sArray2[182] = Short.MAX_VALUE;
        sArray2[183] = Short.MAX_VALUE;
        sArray2[184] = 764;
        sArray2[185] = 767;
        sArray2[186] = 769;
        sArray2[187] = Short.MAX_VALUE;
        sArray2[188] = 771;
        sArray2[189] = 775;
        sArray2[190] = 779;
        sArray2[191] = Short.MAX_VALUE;
        sArray2[193] = 3;
        sArray2[194] = 6;
        sArray2[195] = 9;
        sArray2[196] = 12;
        sArray2[197] = 15;
        sArray2[198] = Short.MAX_VALUE;
        sArray2[199] = 18;
        sArray2[200] = 24;
        sArray2[201] = 27;
        sArray2[202] = 30;
        sArray2[203] = 33;
        sArray2[204] = 39;
        sArray2[205] = 42;
        sArray2[206] = 45;
        sArray2[207] = 48;
        sArray2[208] = Short.MAX_VALUE;
        sArray2[209] = 54;
        sArray2[210] = 57;
        sArray2[211] = 60;
        sArray2[212] = 63;
        sArray2[213] = 66;
        sArray2[214] = 69;
        sArray2[215] = Short.MAX_VALUE;
        sArray2[216] = 72;
        sArray2[217] = 78;
        sArray2[218] = 81;
        sArray2[219] = 84;
        sArray2[220] = 87;
        sArray2[221] = 90;
        sArray2[222] = Short.MAX_VALUE;
        sArray2[223] = Short.MAX_VALUE;
        sArray2[224] = 93;
        sArray2[225] = 96;
        sArray2[226] = 99;
        sArray2[227] = 102;
        sArray2[228] = 105;
        sArray2[229] = 108;
        sArray2[230] = Short.MAX_VALUE;
        sArray2[231] = 111;
        sArray2[232] = 117;
        sArray2[233] = 120;
        sArray2[234] = 123;
        sArray2[235] = 126;
        sArray2[236] = 132;
        sArray2[237] = 135;
        sArray2[238] = 138;
        sArray2[239] = 141;
        sArray2[240] = Short.MAX_VALUE;
        sArray2[241] = 147;
        sArray2[242] = 150;
        sArray2[243] = 153;
        sArray2[244] = 156;
        sArray2[245] = 159;
        sArray2[246] = 162;
        sArray2[247] = Short.MAX_VALUE;
        sArray2[248] = 165;
        sArray2[249] = 171;
        sArray2[250] = 174;
        sArray2[251] = 177;
        sArray2[252] = 180;
        sArray2[253] = 183;
        sArray2[254] = Short.MAX_VALUE;
        sArray2[255] = 186;
        sArray2[256] = 189;
        sArray2[257] = 192;
        sArray2[258] = 195;
        sArray2[259] = 198;
        sArray2[260] = 201;
        sArray2[261] = 204;
        sArray2[262] = 207;
        sArray2[263] = 210;
        sArray2[264] = 213;
        sArray2[265] = 216;
        sArray2[266] = 219;
        sArray2[267] = 222;
        sArray2[268] = 225;
        sArray2[269] = 228;
        sArray2[270] = 231;
        sArray2[271] = 234;
        sArray2[272] = 21;
        sArray2[273] = 114;
        sArray2[274] = 237;
        sArray2[275] = 240;
        sArray2[276] = 243;
        sArray2[277] = 246;
        sArray2[278] = 249;
        sArray2[279] = 252;
        sArray2[280] = 255;
        sArray2[281] = 258;
        sArray2[282] = 261;
        sArray2[283] = 264;
        sArray2[284] = 267;
        sArray2[285] = 270;
        sArray2[286] = 273;
        sArray2[287] = 276;
        sArray2[288] = 279;
        sArray2[289] = 282;
        sArray2[290] = 285;
        sArray2[291] = 288;
        sArray2[292] = 291;
        sArray2[293] = 294;
        sArray2[294] = 36;
        sArray2[295] = 129;
        sArray2[296] = 297;
        sArray2[297] = 300;
        sArray2[298] = 303;
        sArray2[299] = 306;
        sArray2[300] = 309;
        sArray2[301] = 312;
        sArray2[302] = 315;
        sArray2[303] = 318;
        sArray2[304] = 321;
        sArray2[305] = Short.MAX_VALUE;
        sArray2[306] = 783;
        sArray2[307] = 786;
        sArray2[308] = 324;
        sArray2[309] = 327;
        sArray2[310] = 330;
        sArray2[311] = 333;
        sArray2[312] = Short.MAX_VALUE;
        sArray2[313] = 336;
        sArray2[314] = 339;
        sArray2[315] = 342;
        sArray2[316] = 345;
        sArray2[317] = 348;
        sArray2[318] = 351;
        sArray2[319] = 789;
        sArray2[320] = 792;
        sArray2[321] = 51;
        sArray2[322] = 144;
        sArray2[323] = 354;
        sArray2[324] = 357;
        sArray2[325] = 360;
        sArray2[326] = 363;
        sArray2[327] = 366;
        sArray2[328] = 369;
        sArray2[329] = 795;
        sArray2[330] = Short.MAX_VALUE;
        sArray2[331] = Short.MAX_VALUE;
        sArray2[332] = 372;
        sArray2[333] = 375;
        sArray2[334] = 378;
        sArray2[335] = 381;
        sArray2[336] = 384;
        sArray2[337] = 387;
        sArray2[338] = Short.MAX_VALUE;
        sArray2[339] = Short.MAX_VALUE;
        sArray2[340] = 390;
        sArray2[341] = 393;
        sArray2[342] = 396;
        sArray2[343] = 399;
        sArray2[344] = 402;
        sArray2[345] = 405;
        sArray2[346] = 408;
        sArray2[347] = 411;
        sArray2[348] = 414;
        sArray2[349] = 417;
        sArray2[350] = 420;
        sArray2[351] = 423;
        sArray2[352] = 426;
        sArray2[353] = 429;
        sArray2[354] = 432;
        sArray2[355] = 435;
        sArray2[356] = 438;
        sArray2[357] = 441;
        sArray2[358] = 75;
        sArray2[359] = 168;
        sArray2[360] = 444;
        sArray2[361] = 447;
        sArray2[362] = 450;
        sArray2[363] = 453;
        sArray2[364] = 456;
        sArray2[365] = 459;
        sArray2[366] = 462;
        sArray2[367] = 465;
        sArray2[368] = 468;
        sArray2[369] = 471;
        sArray2[370] = 474;
        sArray2[371] = 477;
        sArray2[372] = 480;
        sArray2[373] = 483;
        sArray2[374] = 486;
        sArray2[375] = 489;
        sArray2[376] = 492;
        sArray2[377] = 495;
        sArray2[378] = 498;
        sArray2[379] = 501;
        sArray2[380] = 504;
        sArray2[381] = 507;
        sArray2[382] = 510;
        sArray2[383] = 798;
        sArray2[384] = Short.MAX_VALUE;
        sArray2[385] = Short.MAX_VALUE;
        sArray2[386] = Short.MAX_VALUE;
        sArray2[387] = Short.MAX_VALUE;
        sArray2[388] = Short.MAX_VALUE;
        sArray2[389] = Short.MAX_VALUE;
        sArray2[390] = Short.MAX_VALUE;
        sArray2[391] = Short.MAX_VALUE;
        sArray2[392] = Short.MAX_VALUE;
        sArray2[393] = Short.MAX_VALUE;
        sArray2[394] = Short.MAX_VALUE;
        sArray2[395] = Short.MAX_VALUE;
        sArray2[396] = Short.MAX_VALUE;
        sArray2[397] = Short.MAX_VALUE;
        sArray2[398] = Short.MAX_VALUE;
        sArray2[399] = Short.MAX_VALUE;
        sArray2[400] = Short.MAX_VALUE;
        sArray2[401] = Short.MAX_VALUE;
        sArray2[402] = Short.MAX_VALUE;
        sArray2[403] = Short.MAX_VALUE;
        sArray2[404] = Short.MAX_VALUE;
        sArray2[405] = Short.MAX_VALUE;
        sArray2[406] = Short.MAX_VALUE;
        sArray2[407] = Short.MAX_VALUE;
        sArray2[408] = Short.MAX_VALUE;
        sArray2[409] = Short.MAX_VALUE;
        sArray2[410] = Short.MAX_VALUE;
        sArray2[411] = Short.MAX_VALUE;
        sArray2[412] = Short.MAX_VALUE;
        sArray2[413] = Short.MAX_VALUE;
        sArray2[414] = Short.MAX_VALUE;
        sArray2[415] = Short.MAX_VALUE;
        sArray2[416] = 513;
        sArray2[417] = 516;
        sArray2[418] = Short.MAX_VALUE;
        sArray2[419] = Short.MAX_VALUE;
        sArray2[420] = Short.MAX_VALUE;
        sArray2[421] = Short.MAX_VALUE;
        sArray2[422] = Short.MAX_VALUE;
        sArray2[423] = Short.MAX_VALUE;
        sArray2[424] = Short.MAX_VALUE;
        sArray2[425] = Short.MAX_VALUE;
        sArray2[426] = Short.MAX_VALUE;
        sArray2[427] = Short.MAX_VALUE;
        sArray2[428] = Short.MAX_VALUE;
        sArray2[429] = Short.MAX_VALUE;
        sArray2[430] = Short.MAX_VALUE;
        sArray2[431] = 519;
        sArray2[432] = 522;
        sArray2[433] = Short.MAX_VALUE;
        sArray2[434] = Short.MAX_VALUE;
        sArray2[435] = Short.MAX_VALUE;
        sArray2[436] = Short.MAX_VALUE;
        sArray2[437] = Short.MAX_VALUE;
        sArray2[438] = Short.MAX_VALUE;
        sArray2[439] = Short.MAX_VALUE;
        sArray2[440] = Short.MAX_VALUE;
        sArray2[441] = Short.MAX_VALUE;
        sArray2[442] = Short.MAX_VALUE;
        sArray2[443] = Short.MAX_VALUE;
        sArray2[444] = Short.MAX_VALUE;
        sArray2[445] = Short.MAX_VALUE;
        sArray2[446] = Short.MAX_VALUE;
        sArray2[447] = Short.MAX_VALUE;
        sArray2[448] = Short.MAX_VALUE;
        sArray2[449] = Short.MAX_VALUE;
        sArray2[450] = Short.MAX_VALUE;
        sArray2[451] = Short.MAX_VALUE;
        sArray2[452] = 800;
        sArray2[453] = 804;
        sArray2[454] = 808;
        sArray2[455] = 812;
        sArray2[456] = 815;
        sArray2[457] = 818;
        sArray2[458] = 821;
        sArray2[459] = 824;
        sArray2[460] = 827;
        sArray2[461] = 525;
        sArray2[462] = 528;
        sArray2[463] = 531;
        sArray2[464] = 534;
        sArray2[465] = 537;
        sArray2[466] = 540;
        sArray2[467] = 543;
        sArray2[468] = 546;
        sArray2[469] = 549;
        sArray2[470] = 553;
        sArray2[471] = 557;
        sArray2[472] = 561;
        sArray2[473] = 565;
        sArray2[474] = 569;
        sArray2[475] = 573;
        sArray2[476] = 577;
        sArray2[477] = Short.MAX_VALUE;
        sArray2[478] = 581;
        sArray2[479] = 585;
        sArray2[480] = 589;
        sArray2[481] = 593;
        sArray2[482] = 597;
        sArray2[483] = 600;
        sArray2[484] = Short.MAX_VALUE;
        sArray2[485] = Short.MAX_VALUE;
        sArray2[486] = 603;
        sArray2[487] = 606;
        sArray2[488] = 609;
        sArray2[489] = 612;
        sArray2[490] = 615;
        sArray2[491] = 618;
        sArray2[492] = 621;
        sArray2[493] = 625;
        sArray2[494] = 629;
        sArray2[495] = 632;
        sArray2[496] = 635;
        sArray2[497] = 830;
        sArray2[498] = 833;
        sArray2[499] = 836;
        sArray2[500] = 638;
        sArray2[501] = 641;
        sArray2[502] = Short.MAX_VALUE;
        sArray2[503] = Short.MAX_VALUE;
        sArray2[504] = Short.MAX_VALUE;
        sArray2[505] = Short.MAX_VALUE;
        sArray2[506] = 644;
        sArray2[507] = 648;
        sArray2[508] = 652;
        sArray2[509] = 655;
        sArray2[510] = 658;
        sArray2[511] = 661;
        sArray2[512] = 664;
        sArray2[513] = 667;
        sArray2[514] = 670;
        sArray2[515] = 673;
        sArray2[516] = 676;
        sArray2[517] = 679;
        sArray2[518] = 682;
        sArray2[519] = 685;
        sArray2[520] = 688;
        sArray2[521] = 691;
        sArray2[522] = 694;
        sArray2[523] = 697;
        sArray2[524] = 700;
        sArray2[525] = 703;
        sArray2[526] = 706;
        sArray2[527] = 709;
        sArray2[528] = 712;
        sArray2[529] = 715;
        sArray2[530] = 718;
        sArray2[531] = 721;
        sArray2[532] = 724;
        sArray2[533] = 727;
        sArray2[534] = 730;
        sArray2[535] = 733;
        sArray2[536] = Short.MAX_VALUE;
        sArray2[537] = Short.MAX_VALUE;
        sArray2[538] = Short.MAX_VALUE;
        sArray2[539] = Short.MAX_VALUE;
        sArray2[540] = Short.MAX_VALUE;
        sArray2[541] = Short.MAX_VALUE;
        sArray2[542] = Short.MAX_VALUE;
        sArray2[543] = Short.MAX_VALUE;
        sArray2[544] = Short.MAX_VALUE;
        sArray2[545] = Short.MAX_VALUE;
        sArray2[546] = Short.MAX_VALUE;
        sArray2[547] = Short.MAX_VALUE;
        sArray2[548] = Short.MAX_VALUE;
        sArray2[549] = Short.MAX_VALUE;
        sArray2[550] = Short.MAX_VALUE;
        sArray2[551] = Short.MAX_VALUE;
        sArray2[552] = Short.MAX_VALUE;
        sArray2[553] = Short.MAX_VALUE;
        sArray2[554] = Short.MAX_VALUE;
        sArray2[555] = Short.MAX_VALUE;
        sArray2[556] = Short.MAX_VALUE;
        sArray2[557] = Short.MAX_VALUE;
        sArray2[558] = Short.MAX_VALUE;
        sArray2[559] = Short.MAX_VALUE;
        sArray2[560] = Short.MAX_VALUE;
        sArray2[561] = Short.MAX_VALUE;
        sArray2[562] = Short.MAX_VALUE;
        sArray2[563] = Short.MAX_VALUE;
        sArray2[564] = Short.MAX_VALUE;
        sArray2[565] = Short.MAX_VALUE;
        sArray2[566] = Short.MAX_VALUE;
        sArray2[567] = Short.MAX_VALUE;
        sArray2[568] = Short.MAX_VALUE;
        sArray2[569] = Short.MAX_VALUE;
        sArray2[570] = Short.MAX_VALUE;
        sArray2[571] = Short.MAX_VALUE;
        sArray2[572] = Short.MAX_VALUE;
        sArray2[573] = Short.MAX_VALUE;
        sArray2[574] = Short.MAX_VALUE;
        sArray2[575] = Short.MAX_VALUE;
        sArray2[576] = Short.MAX_VALUE;
        sArray2[577] = Short.MAX_VALUE;
        sArray2[578] = Short.MAX_VALUE;
        sArray2[579] = Short.MAX_VALUE;
        sArray2[580] = Short.MAX_VALUE;
        sArray2[581] = Short.MAX_VALUE;
        sArray2[582] = Short.MAX_VALUE;
        sArray2[583] = Short.MAX_VALUE;
        sArray2[584] = Short.MAX_VALUE;
        sArray2[585] = Short.MAX_VALUE;
        sArray2[586] = Short.MAX_VALUE;
        sArray2[587] = Short.MAX_VALUE;
        sArray2[588] = Short.MAX_VALUE;
        sArray2[589] = Short.MAX_VALUE;
        sArray2[590] = Short.MAX_VALUE;
        sArray2[591] = Short.MAX_VALUE;
        sArray2[592] = Short.MAX_VALUE;
        sArray2[593] = Short.MAX_VALUE;
        sArray2[594] = Short.MAX_VALUE;
        sArray2[595] = Short.MAX_VALUE;
        sArray2[596] = Short.MAX_VALUE;
        sArray2[597] = Short.MAX_VALUE;
        sArray2[598] = Short.MAX_VALUE;
        sArray2[599] = Short.MAX_VALUE;
        sArray2[600] = Short.MAX_VALUE;
        sArray2[601] = Short.MAX_VALUE;
        sArray2[602] = Short.MAX_VALUE;
        sArray2[603] = Short.MAX_VALUE;
        sArray2[604] = Short.MAX_VALUE;
        sArray2[605] = Short.MAX_VALUE;
        sArray2[606] = Short.MAX_VALUE;
        sArray2[607] = Short.MAX_VALUE;
        sArray2[608] = Short.MAX_VALUE;
        sArray2[609] = Short.MAX_VALUE;
        sArray2[610] = Short.MAX_VALUE;
        sArray2[611] = Short.MAX_VALUE;
        sArray2[612] = Short.MAX_VALUE;
        sArray2[613] = Short.MAX_VALUE;
        sArray2[614] = Short.MAX_VALUE;
        sArray2[615] = Short.MAX_VALUE;
        sArray2[616] = Short.MAX_VALUE;
        sArray2[617] = Short.MAX_VALUE;
        sArray2[618] = Short.MAX_VALUE;
        sArray2[619] = Short.MAX_VALUE;
        sArray2[620] = Short.MAX_VALUE;
        sArray2[621] = Short.MAX_VALUE;
        sArray2[622] = Short.MAX_VALUE;
        sArray2[623] = Short.MAX_VALUE;
        sArray2[624] = Short.MAX_VALUE;
        sArray2[625] = Short.MAX_VALUE;
        sArray2[626] = Short.MAX_VALUE;
        sArray2[627] = Short.MAX_VALUE;
        sArray2[628] = Short.MAX_VALUE;
        sArray2[629] = Short.MAX_VALUE;
        sArray2[630] = Short.MAX_VALUE;
        sArray2[631] = Short.MAX_VALUE;
        sArray2[632] = Short.MAX_VALUE;
        sArray2[633] = Short.MAX_VALUE;
        sArray2[634] = Short.MAX_VALUE;
        sArray2[635] = Short.MAX_VALUE;
        sArray2[636] = Short.MAX_VALUE;
        sArray2[637] = Short.MAX_VALUE;
        sArray2[638] = Short.MAX_VALUE;
        sArray2[639] = Short.MAX_VALUE;
        sArray2[640] = Short.MAX_VALUE;
        sArray2[641] = Short.MAX_VALUE;
        sArray2[642] = Short.MAX_VALUE;
        sArray2[643] = Short.MAX_VALUE;
        sArray2[644] = Short.MAX_VALUE;
        sArray2[645] = Short.MAX_VALUE;
        sArray2[646] = Short.MAX_VALUE;
        sArray2[647] = Short.MAX_VALUE;
        sArray2[648] = Short.MAX_VALUE;
        sArray2[649] = Short.MAX_VALUE;
        sArray2[650] = Short.MAX_VALUE;
        sArray2[651] = Short.MAX_VALUE;
        sArray2[652] = Short.MAX_VALUE;
        sArray2[653] = Short.MAX_VALUE;
        sArray2[654] = Short.MAX_VALUE;
        sArray2[655] = Short.MAX_VALUE;
        sArray2[656] = Short.MAX_VALUE;
        sArray2[657] = Short.MAX_VALUE;
        sArray2[658] = Short.MAX_VALUE;
        sArray2[659] = Short.MAX_VALUE;
        sArray2[660] = Short.MAX_VALUE;
        sArray2[661] = Short.MAX_VALUE;
        sArray2[662] = Short.MAX_VALUE;
        sArray2[663] = Short.MAX_VALUE;
        sArray2[664] = Short.MAX_VALUE;
        sArray2[665] = Short.MAX_VALUE;
        sArray2[666] = Short.MAX_VALUE;
        sArray2[667] = Short.MAX_VALUE;
        sArray2[668] = Short.MAX_VALUE;
        sArray2[669] = Short.MAX_VALUE;
        sArray2[670] = Short.MAX_VALUE;
        sArray2[671] = Short.MAX_VALUE;
        sArray2[672] = Short.MAX_VALUE;
        sArray2[673] = Short.MAX_VALUE;
        sArray2[674] = Short.MAX_VALUE;
        sArray2[675] = Short.MAX_VALUE;
        sArray2[676] = Short.MAX_VALUE;
        sArray2[677] = Short.MAX_VALUE;
        sArray2[678] = Short.MAX_VALUE;
        sArray2[679] = Short.MAX_VALUE;
        sArray2[680] = Short.MAX_VALUE;
        sArray2[681] = Short.MAX_VALUE;
        sArray2[682] = Short.MAX_VALUE;
        sArray2[683] = Short.MAX_VALUE;
        sArray2[684] = Short.MAX_VALUE;
        sArray2[685] = Short.MAX_VALUE;
        sArray2[686] = Short.MAX_VALUE;
        sArray2[687] = Short.MAX_VALUE;
        sArray2[688] = 839;
        sArray2[689] = 841;
        sArray2[690] = 843;
        sArray2[691] = 845;
        sArray2[692] = 847;
        sArray2[693] = 849;
        sArray2[694] = 851;
        sArray2[695] = 853;
        sArray2[696] = 855;
        sArray2[697] = Short.MAX_VALUE;
        sArray2[698] = Short.MAX_VALUE;
        sArray2[699] = Short.MAX_VALUE;
        sArray2[700] = Short.MAX_VALUE;
        sArray2[701] = Short.MAX_VALUE;
        sArray2[702] = Short.MAX_VALUE;
        sArray2[703] = Short.MAX_VALUE;
        sArray2[704] = Short.MAX_VALUE;
        sArray2[705] = Short.MAX_VALUE;
        sArray2[706] = Short.MAX_VALUE;
        sArray2[707] = Short.MAX_VALUE;
        sArray2[708] = Short.MAX_VALUE;
        sArray2[709] = Short.MAX_VALUE;
        sArray2[710] = Short.MAX_VALUE;
        sArray2[711] = Short.MAX_VALUE;
        sArray2[712] = Short.MAX_VALUE;
        sArray2[713] = Short.MAX_VALUE;
        sArray2[714] = Short.MAX_VALUE;
        sArray2[715] = Short.MAX_VALUE;
        sArray2[716] = Short.MAX_VALUE;
        sArray2[717] = Short.MAX_VALUE;
        sArray2[718] = Short.MAX_VALUE;
        sArray2[719] = Short.MAX_VALUE;
        sArray2[720] = Short.MAX_VALUE;
        sArray2[721] = Short.MAX_VALUE;
        sArray2[722] = Short.MAX_VALUE;
        sArray2[723] = Short.MAX_VALUE;
        sArray2[724] = Short.MAX_VALUE;
        sArray2[725] = Short.MAX_VALUE;
        sArray2[726] = Short.MAX_VALUE;
        sArray2[727] = Short.MAX_VALUE;
        sArray2[728] = 857;
        sArray2[729] = 860;
        sArray2[730] = 863;
        sArray2[731] = 866;
        sArray2[732] = 869;
        sArray2[733] = 872;
        sArray2[734] = Short.MAX_VALUE;
        sArray2[735] = Short.MAX_VALUE;
        sArray2[736] = 875;
        sArray2[737] = 877;
        sArray2[738] = 879;
        sArray2[739] = 881;
        sArray2[740] = 883;
        sArray2[741] = Short.MAX_VALUE;
        sArray2[742] = Short.MAX_VALUE;
        sArray2[743] = Short.MAX_VALUE;
        sArray2[744] = Short.MAX_VALUE;
        sArray2[745] = Short.MAX_VALUE;
        sArray2[746] = Short.MAX_VALUE;
        sArray2[747] = Short.MAX_VALUE;
        sArray2[748] = Short.MAX_VALUE;
        sArray2[749] = Short.MAX_VALUE;
        sArray2[750] = Short.MAX_VALUE;
        sArray2[751] = Short.MAX_VALUE;
        sArray2[752] = Short.MAX_VALUE;
        sArray2[753] = Short.MAX_VALUE;
        sArray2[754] = Short.MAX_VALUE;
        sArray2[755] = Short.MAX_VALUE;
        sArray2[756] = Short.MAX_VALUE;
        sArray2[757] = Short.MAX_VALUE;
        sArray2[758] = Short.MAX_VALUE;
        sArray2[759] = Short.MAX_VALUE;
        sArray2[760] = Short.MAX_VALUE;
        sArray2[761] = Short.MAX_VALUE;
        sArray2[762] = Short.MAX_VALUE;
        sArray2[763] = Short.MAX_VALUE;
        sArray2[764] = Short.MAX_VALUE;
        sArray2[765] = Short.MAX_VALUE;
        sArray2[766] = Short.MAX_VALUE;
        sArray2[767] = Short.MAX_VALUE;
        sArray2[768] = Short.MAX_VALUE;
        sArray2[769] = Short.MAX_VALUE;
        sArray2[770] = Short.MAX_VALUE;
        sArray2[771] = Short.MAX_VALUE;
        sArray2[772] = Short.MAX_VALUE;
        sArray2[773] = Short.MAX_VALUE;
        sArray2[774] = Short.MAX_VALUE;
        sArray2[775] = Short.MAX_VALUE;
        sArray2[776] = Short.MAX_VALUE;
        sArray2[777] = Short.MAX_VALUE;
        sArray2[778] = Short.MAX_VALUE;
        sArray2[779] = Short.MAX_VALUE;
        sArray2[780] = Short.MAX_VALUE;
        sArray2[781] = Short.MAX_VALUE;
        sArray2[782] = Short.MAX_VALUE;
        sArray2[783] = Short.MAX_VALUE;
        sArray2[784] = Short.MAX_VALUE;
        sArray2[785] = Short.MAX_VALUE;
        sArray2[786] = Short.MAX_VALUE;
        sArray2[787] = Short.MAX_VALUE;
        sArray2[788] = Short.MAX_VALUE;
        sArray2[789] = Short.MAX_VALUE;
        sArray2[790] = Short.MAX_VALUE;
        sArray2[791] = Short.MAX_VALUE;
        sArray2[792] = Short.MAX_VALUE;
        sArray2[793] = Short.MAX_VALUE;
        sArray2[794] = Short.MAX_VALUE;
        sArray2[795] = Short.MAX_VALUE;
        sArray2[796] = Short.MAX_VALUE;
        sArray2[797] = Short.MAX_VALUE;
        sArray2[798] = Short.MAX_VALUE;
        sArray2[799] = Short.MAX_VALUE;
        sArray2[800] = Short.MAX_VALUE;
        sArray2[801] = Short.MAX_VALUE;
        sArray2[802] = Short.MAX_VALUE;
        sArray2[803] = Short.MAX_VALUE;
        sArray2[804] = Short.MAX_VALUE;
        sArray2[805] = Short.MAX_VALUE;
        sArray2[806] = Short.MAX_VALUE;
        sArray2[807] = Short.MAX_VALUE;
        sArray2[808] = Short.MAX_VALUE;
        sArray2[809] = Short.MAX_VALUE;
        sArray2[810] = Short.MAX_VALUE;
        sArray2[811] = Short.MAX_VALUE;
        sArray2[812] = Short.MAX_VALUE;
        sArray2[813] = Short.MAX_VALUE;
        sArray2[814] = Short.MAX_VALUE;
        sArray2[815] = Short.MAX_VALUE;
        sArray2[816] = Short.MAX_VALUE;
        sArray2[817] = Short.MAX_VALUE;
        sArray2[818] = Short.MAX_VALUE;
        sArray2[819] = Short.MAX_VALUE;
        sArray2[820] = Short.MAX_VALUE;
        sArray2[821] = Short.MAX_VALUE;
        sArray2[822] = Short.MAX_VALUE;
        sArray2[823] = Short.MAX_VALUE;
        sArray2[824] = Short.MAX_VALUE;
        sArray2[825] = Short.MAX_VALUE;
        sArray2[826] = Short.MAX_VALUE;
        sArray2[827] = Short.MAX_VALUE;
        sArray2[828] = Short.MAX_VALUE;
        sArray2[829] = Short.MAX_VALUE;
        sArray2[830] = Short.MAX_VALUE;
        sArray2[831] = Short.MAX_VALUE;
        sArray2[832] = Short.MAX_VALUE;
        sArray2[833] = Short.MAX_VALUE;
        sArray2[834] = Short.MAX_VALUE;
        sArray2[835] = Short.MAX_VALUE;
        sArray2[836] = Short.MAX_VALUE;
        sArray2[837] = Short.MAX_VALUE;
        sArray2[838] = Short.MAX_VALUE;
        sArray2[839] = Short.MAX_VALUE;
        sArray2[840] = Short.MAX_VALUE;
        sArray2[841] = Short.MAX_VALUE;
        sArray2[842] = Short.MAX_VALUE;
        sArray2[843] = Short.MAX_VALUE;
        sArray2[844] = Short.MAX_VALUE;
        sArray2[845] = Short.MAX_VALUE;
        sArray2[846] = Short.MAX_VALUE;
        sArray2[847] = Short.MAX_VALUE;
        sArray2[848] = Short.MAX_VALUE;
        sArray2[849] = Short.MAX_VALUE;
        sArray2[850] = Short.MAX_VALUE;
        sArray2[851] = Short.MAX_VALUE;
        sArray2[852] = Short.MAX_VALUE;
        sArray2[853] = Short.MAX_VALUE;
        sArray2[854] = Short.MAX_VALUE;
        sArray2[855] = Short.MAX_VALUE;
        sArray2[856] = Short.MAX_VALUE;
        sArray2[857] = Short.MAX_VALUE;
        sArray2[858] = Short.MAX_VALUE;
        sArray2[859] = Short.MAX_VALUE;
        sArray2[860] = Short.MAX_VALUE;
        sArray2[861] = Short.MAX_VALUE;
        sArray2[862] = Short.MAX_VALUE;
        sArray2[863] = Short.MAX_VALUE;
        sArray2[864] = Short.MAX_VALUE;
        sArray2[865] = Short.MAX_VALUE;
        sArray2[866] = Short.MAX_VALUE;
        sArray2[867] = Short.MAX_VALUE;
        sArray2[868] = Short.MAX_VALUE;
        sArray2[869] = Short.MAX_VALUE;
        sArray2[870] = Short.MAX_VALUE;
        sArray2[871] = Short.MAX_VALUE;
        sArray2[872] = Short.MAX_VALUE;
        sArray2[873] = Short.MAX_VALUE;
        sArray2[874] = Short.MAX_VALUE;
        sArray2[875] = Short.MAX_VALUE;
        sArray2[876] = Short.MAX_VALUE;
        sArray2[877] = Short.MAX_VALUE;
        sArray2[878] = Short.MAX_VALUE;
        sArray2[879] = Short.MAX_VALUE;
        sArray2[880] = Short.MAX_VALUE;
        sArray2[881] = Short.MAX_VALUE;
        sArray2[882] = Short.MAX_VALUE;
        sArray2[883] = Short.MAX_VALUE;
        sArray2[884] = Short.MAX_VALUE;
        sArray2[885] = Short.MAX_VALUE;
        sArray2[886] = Short.MAX_VALUE;
        sArray2[887] = Short.MAX_VALUE;
        sArray2[888] = Short.MAX_VALUE;
        sArray2[889] = Short.MAX_VALUE;
        sArray2[890] = Short.MAX_VALUE;
        sArray2[891] = Short.MAX_VALUE;
        sArray2[892] = Short.MAX_VALUE;
        sArray2[893] = Short.MAX_VALUE;
        sArray2[894] = Short.MAX_VALUE;
        sArray2[895] = Short.MAX_VALUE;
        sArray2[896] = Short.MAX_VALUE;
        sArray2[897] = Short.MAX_VALUE;
        sArray2[898] = Short.MAX_VALUE;
        sArray2[899] = Short.MAX_VALUE;
        sArray2[900] = Short.MAX_VALUE;
        sArray2[901] = Short.MAX_VALUE;
        sArray2[902] = Short.MAX_VALUE;
        sArray2[903] = Short.MAX_VALUE;
        sArray2[904] = Short.MAX_VALUE;
        sArray2[905] = Short.MAX_VALUE;
        sArray2[906] = Short.MAX_VALUE;
        sArray2[907] = Short.MAX_VALUE;
        sArray2[908] = Short.MAX_VALUE;
        sArray2[909] = Short.MAX_VALUE;
        sArray2[910] = Short.MAX_VALUE;
        sArray2[911] = Short.MAX_VALUE;
        sArray2[912] = Short.MAX_VALUE;
        sArray2[913] = Short.MAX_VALUE;
        sArray2[914] = Short.MAX_VALUE;
        sArray2[915] = Short.MAX_VALUE;
        sArray2[916] = Short.MAX_VALUE;
        sArray2[917] = Short.MAX_VALUE;
        sArray2[918] = Short.MAX_VALUE;
        sArray2[919] = Short.MAX_VALUE;
        sArray2[920] = Short.MAX_VALUE;
        sArray2[921] = Short.MAX_VALUE;
        sArray2[922] = Short.MAX_VALUE;
        sArray2[923] = Short.MAX_VALUE;
        sArray2[924] = Short.MAX_VALUE;
        sArray2[925] = Short.MAX_VALUE;
        sArray2[926] = Short.MAX_VALUE;
        sArray2[927] = Short.MAX_VALUE;
        sArray2[928] = Short.MAX_VALUE;
        sArray2[929] = Short.MAX_VALUE;
        sArray2[930] = Short.MAX_VALUE;
        sArray2[931] = 885;
        sArray2[932] = Short.MAX_VALUE;
        sArray2[933] = Short.MAX_VALUE;
        sArray2[934] = Short.MAX_VALUE;
        sArray2[935] = Short.MAX_VALUE;
        sArray2[936] = Short.MAX_VALUE;
        sArray2[937] = Short.MAX_VALUE;
        sArray2[938] = Short.MAX_VALUE;
        sArray2[939] = Short.MAX_VALUE;
        sArray2[940] = Short.MAX_VALUE;
        sArray2[941] = Short.MAX_VALUE;
        sArray2[942] = Short.MAX_VALUE;
        sArray2[943] = Short.MAX_VALUE;
        sArray2[944] = Short.MAX_VALUE;
        sArray2[945] = Short.MAX_VALUE;
        sArray2[946] = Short.MAX_VALUE;
        sArray2[947] = Short.MAX_VALUE;
        sArray2[948] = Short.MAX_VALUE;
        sArray2[949] = Short.MAX_VALUE;
        sArray2[950] = Short.MAX_VALUE;
        sArray2[951] = Short.MAX_VALUE;
        sArray2[952] = Short.MAX_VALUE;
        sArray2[953] = Short.MAX_VALUE;
        sArray2[954] = Short.MAX_VALUE;
        sArray2[955] = Short.MAX_VALUE;
        sArray2[956] = Short.MAX_VALUE;
        sArray2[957] = Short.MAX_VALUE;
        sArray2[958] = Short.MAX_VALUE;
        sArray2[959] = Short.MAX_VALUE;
        sArray2[960] = Short.MAX_VALUE;
        sArray2[961] = Short.MAX_VALUE;
        sArray2[962] = Short.MAX_VALUE;
        sArray2[963] = Short.MAX_VALUE;
        sArray2[964] = Short.MAX_VALUE;
        sArray2[965] = Short.MAX_VALUE;
        sArray2[966] = Short.MAX_VALUE;
        sArray2[967] = Short.MAX_VALUE;
        sArray2[968] = Short.MAX_VALUE;
        sArray2[969] = Short.MAX_VALUE;
        sArray2[970] = Short.MAX_VALUE;
        sArray2[971] = Short.MAX_VALUE;
        sArray2[972] = Short.MAX_VALUE;
        sArray2[973] = Short.MAX_VALUE;
        sArray2[974] = Short.MAX_VALUE;
        sArray2[975] = Short.MAX_VALUE;
        sArray2[976] = Short.MAX_VALUE;
        sArray2[977] = Short.MAX_VALUE;
        sArray2[978] = Short.MAX_VALUE;
        sArray2[979] = Short.MAX_VALUE;
        sArray2[980] = Short.MAX_VALUE;
        sArray2[981] = Short.MAX_VALUE;
        sArray2[982] = Short.MAX_VALUE;
        sArray2[983] = Short.MAX_VALUE;
        sArray2[984] = Short.MAX_VALUE;
        sArray2[985] = Short.MAX_VALUE;
        sArray2[986] = Short.MAX_VALUE;
        sArray2[987] = Short.MAX_VALUE;
        sArray2[988] = Short.MAX_VALUE;
        sArray2[989] = Short.MAX_VALUE;
        sArray2[990] = Short.MAX_VALUE;
        sArray2[991] = Short.MAX_VALUE;
        sArray2[992] = Short.MAX_VALUE;
        sArray2[993] = Short.MAX_VALUE;
        sArray2[994] = Short.MAX_VALUE;
        sArray2[995] = Short.MAX_VALUE;
        sArray2[996] = Short.MAX_VALUE;
        sArray2[997] = Short.MAX_VALUE;
        sArray2[998] = Short.MAX_VALUE;
        sArray2[999] = Short.MAX_VALUE;
        sArray2[1000] = Short.MAX_VALUE;
        sArray2[1001] = Short.MAX_VALUE;
        sArray2[1002] = Short.MAX_VALUE;
        sArray2[1003] = Short.MAX_VALUE;
        sArray2[1004] = Short.MAX_VALUE;
        sArray2[1005] = Short.MAX_VALUE;
        sArray2[1006] = Short.MAX_VALUE;
        sArray2[1007] = Short.MAX_VALUE;
        sArray2[1008] = Short.MAX_VALUE;
        sArray2[1009] = Short.MAX_VALUE;
        sArray2[1010] = Short.MAX_VALUE;
        sArray2[1011] = Short.MAX_VALUE;
        sArray2[1012] = Short.MAX_VALUE;
        sArray2[1013] = Short.MAX_VALUE;
        sArray2[1014] = Short.MAX_VALUE;
        sArray2[1015] = Short.MAX_VALUE;
        sArray2[1016] = Short.MAX_VALUE;
        sArray2[1017] = Short.MAX_VALUE;
        sArray2[1018] = Short.MAX_VALUE;
        sArray2[1019] = Short.MAX_VALUE;
        sArray2[1020] = Short.MAX_VALUE;
        sArray2[1021] = Short.MAX_VALUE;
        sArray2[1022] = Short.MAX_VALUE;
        sArray2[1023] = Short.MAX_VALUE;
        kOffsetValues = sArray2;
        short[] sArray3 = new short[512];
        sArray3[6] = 128;
        sArray3[9] = 256;
        sArray3[11] = 384;
        sArray3[12] = 512;
        sArray3[13] = 640;
        sArray3[18] = 768;
        sArray3[19] = 896;
        sArray3[20] = 1024;
        sArray3[21] = 1152;
        sArray3[22] = 1280;
        sArray3[23] = 1408;
        sArray3[24] = 1536;
        sArray3[25] = 1664;
        sArray3[26] = 1792;
        sArray3[28] = 1920;
        sArray3[29] = 2048;
        sArray3[30] = 2176;
        sArray3[31] = 2304;
        sArray3[65] = 2432;
        sArray3[96] = 2560;
        sArray3[97] = 2688;
        sArray3[502] = 2816;
        sArray3[508] = 2944;
        kCanonicalIndex = sArray3;
        byte[] byArray = new byte[3072];
        byArray[0] = -128;
        byArray[1] = -128;
        byArray[2] = -128;
        byArray[3] = -128;
        byArray[4] = -128;
        byArray[5] = -128;
        byArray[6] = -128;
        byArray[7] = -128;
        byArray[8] = -128;
        byArray[9] = -128;
        byArray[10] = -128;
        byArray[11] = -128;
        byArray[12] = -128;
        byArray[13] = -128;
        byArray[14] = -128;
        byArray[15] = -128;
        byArray[16] = -128;
        byArray[17] = -128;
        byArray[18] = -128;
        byArray[19] = -128;
        byArray[20] = -128;
        byArray[21] = -128;
        byArray[22] = -128;
        byArray[23] = -128;
        byArray[24] = -128;
        byArray[25] = -128;
        byArray[26] = -128;
        byArray[27] = -128;
        byArray[28] = -128;
        byArray[29] = -128;
        byArray[30] = -128;
        byArray[31] = -128;
        byArray[32] = -128;
        byArray[33] = -128;
        byArray[34] = -128;
        byArray[35] = -128;
        byArray[36] = -128;
        byArray[37] = -128;
        byArray[38] = -128;
        byArray[39] = -128;
        byArray[40] = -128;
        byArray[41] = -128;
        byArray[42] = -128;
        byArray[43] = -128;
        byArray[44] = -128;
        byArray[45] = -128;
        byArray[46] = -128;
        byArray[47] = -128;
        byArray[48] = -128;
        byArray[49] = -128;
        byArray[50] = -128;
        byArray[51] = -128;
        byArray[52] = -128;
        byArray[53] = -128;
        byArray[54] = -128;
        byArray[55] = -128;
        byArray[56] = -128;
        byArray[57] = -128;
        byArray[58] = -128;
        byArray[59] = -128;
        byArray[60] = -128;
        byArray[61] = -128;
        byArray[62] = -128;
        byArray[63] = -128;
        byArray[64] = -128;
        byArray[65] = -128;
        byArray[66] = -128;
        byArray[67] = -128;
        byArray[68] = -128;
        byArray[69] = -128;
        byArray[70] = -128;
        byArray[71] = -128;
        byArray[72] = -128;
        byArray[73] = -128;
        byArray[74] = -128;
        byArray[75] = -128;
        byArray[76] = -128;
        byArray[77] = -128;
        byArray[78] = -128;
        byArray[79] = -128;
        byArray[80] = -128;
        byArray[81] = -128;
        byArray[82] = -128;
        byArray[83] = -128;
        byArray[84] = -128;
        byArray[85] = -128;
        byArray[86] = -128;
        byArray[87] = -128;
        byArray[88] = -128;
        byArray[89] = -128;
        byArray[90] = -128;
        byArray[91] = -128;
        byArray[92] = -128;
        byArray[93] = -128;
        byArray[94] = -128;
        byArray[95] = -128;
        byArray[96] = -128;
        byArray[97] = -128;
        byArray[98] = -128;
        byArray[99] = -128;
        byArray[100] = -128;
        byArray[101] = -128;
        byArray[102] = -128;
        byArray[103] = -128;
        byArray[104] = -128;
        byArray[105] = -128;
        byArray[106] = -128;
        byArray[107] = -128;
        byArray[108] = -128;
        byArray[109] = -128;
        byArray[110] = -128;
        byArray[111] = -128;
        byArray[112] = -128;
        byArray[113] = -128;
        byArray[114] = -128;
        byArray[115] = -128;
        byArray[116] = -128;
        byArray[117] = -128;
        byArray[118] = -128;
        byArray[119] = -128;
        byArray[120] = -128;
        byArray[121] = -128;
        byArray[122] = -128;
        byArray[123] = -128;
        byArray[124] = -128;
        byArray[125] = -128;
        byArray[126] = -128;
        byArray[127] = -128;
        byArray[128] = 102;
        byArray[129] = 102;
        byArray[130] = 102;
        byArray[131] = 102;
        byArray[132] = 102;
        byArray[133] = 102;
        byArray[134] = 102;
        byArray[135] = 102;
        byArray[136] = 102;
        byArray[137] = 102;
        byArray[138] = 102;
        byArray[139] = 102;
        byArray[140] = 102;
        byArray[141] = 102;
        byArray[142] = 102;
        byArray[143] = 102;
        byArray[144] = 102;
        byArray[145] = 102;
        byArray[146] = 102;
        byArray[147] = 102;
        byArray[148] = 102;
        byArray[149] = 104;
        byArray[150] = 92;
        byArray[151] = 92;
        byArray[152] = 92;
        byArray[153] = 92;
        byArray[154] = 104;
        byArray[155] = 88;
        byArray[156] = 92;
        byArray[157] = 92;
        byArray[158] = 92;
        byArray[159] = 92;
        byArray[160] = 92;
        byArray[161] = 74;
        byArray[162] = 74;
        byArray[163] = 92;
        byArray[164] = 92;
        byArray[165] = 92;
        byArray[166] = 92;
        byArray[167] = 74;
        byArray[168] = 74;
        byArray[169] = 92;
        byArray[170] = 92;
        byArray[171] = 92;
        byArray[172] = 92;
        byArray[173] = 92;
        byArray[174] = 92;
        byArray[175] = 92;
        byArray[176] = 92;
        byArray[177] = 92;
        byArray[178] = 92;
        byArray[179] = 92;
        byArray[180] = -127;
        byArray[181] = -127;
        byArray[182] = -127;
        byArray[183] = -127;
        byArray[184] = -127;
        byArray[185] = 92;
        byArray[186] = 92;
        byArray[187] = 92;
        byArray[188] = 92;
        byArray[189] = 102;
        byArray[190] = 102;
        byArray[191] = 102;
        byArray[192] = 102;
        byArray[193] = 102;
        byArray[194] = 102;
        byArray[195] = 102;
        byArray[196] = 102;
        byArray[197] = 92;
        byArray[198] = -128;
        byArray[199] = -128;
        byArray[200] = -128;
        byArray[201] = -128;
        byArray[202] = -128;
        byArray[203] = -128;
        byArray[204] = -128;
        byArray[205] = -128;
        byArray[206] = -128;
        byArray[207] = -128;
        byArray[208] = -128;
        byArray[209] = -128;
        byArray[210] = -128;
        byArray[211] = -128;
        byArray[212] = -128;
        byArray[213] = -128;
        byArray[214] = -128;
        byArray[215] = -128;
        byArray[216] = -128;
        byArray[217] = -128;
        byArray[218] = -128;
        byArray[219] = -128;
        byArray[220] = -128;
        byArray[221] = -128;
        byArray[222] = -128;
        byArray[223] = -128;
        byArray[224] = 106;
        byArray[225] = 106;
        byArray[226] = -128;
        byArray[227] = -128;
        byArray[228] = -128;
        byArray[229] = -128;
        byArray[230] = -128;
        byArray[231] = -128;
        byArray[232] = -128;
        byArray[233] = -128;
        byArray[234] = -128;
        byArray[235] = -128;
        byArray[236] = -128;
        byArray[237] = -128;
        byArray[238] = -128;
        byArray[239] = -128;
        byArray[240] = -128;
        byArray[241] = -128;
        byArray[242] = -128;
        byArray[243] = -128;
        byArray[244] = -128;
        byArray[245] = -128;
        byArray[246] = -128;
        byArray[247] = -128;
        byArray[248] = -128;
        byArray[249] = -128;
        byArray[250] = -128;
        byArray[251] = -128;
        byArray[252] = -128;
        byArray[253] = -128;
        byArray[254] = -128;
        byArray[255] = -128;
        byArray[256] = -128;
        byArray[257] = -128;
        byArray[258] = -128;
        byArray[259] = 102;
        byArray[260] = 102;
        byArray[261] = 102;
        byArray[262] = 102;
        byArray[263] = -128;
        byArray[264] = -128;
        byArray[265] = -128;
        byArray[266] = -128;
        byArray[267] = -128;
        byArray[268] = -128;
        byArray[269] = -128;
        byArray[270] = -128;
        byArray[271] = -128;
        byArray[272] = -128;
        byArray[273] = -128;
        byArray[274] = -128;
        byArray[275] = -128;
        byArray[276] = -128;
        byArray[277] = -128;
        byArray[278] = -128;
        byArray[279] = -128;
        byArray[280] = -128;
        byArray[281] = -128;
        byArray[282] = -128;
        byArray[283] = -128;
        byArray[284] = -128;
        byArray[285] = -128;
        byArray[286] = -128;
        byArray[287] = -128;
        byArray[288] = -128;
        byArray[289] = -128;
        byArray[290] = -128;
        byArray[291] = -128;
        byArray[292] = -128;
        byArray[293] = -128;
        byArray[294] = -128;
        byArray[295] = -128;
        byArray[296] = -128;
        byArray[297] = -128;
        byArray[298] = -128;
        byArray[299] = -128;
        byArray[300] = -128;
        byArray[301] = -128;
        byArray[302] = -128;
        byArray[303] = -128;
        byArray[304] = -128;
        byArray[305] = -128;
        byArray[306] = -128;
        byArray[307] = -128;
        byArray[308] = -128;
        byArray[309] = -128;
        byArray[310] = -128;
        byArray[311] = -128;
        byArray[312] = -128;
        byArray[313] = -128;
        byArray[314] = -128;
        byArray[315] = -128;
        byArray[316] = -128;
        byArray[317] = -128;
        byArray[318] = -128;
        byArray[319] = -128;
        byArray[320] = -128;
        byArray[321] = -128;
        byArray[322] = -128;
        byArray[323] = -128;
        byArray[324] = -128;
        byArray[325] = -128;
        byArray[326] = -128;
        byArray[327] = -128;
        byArray[328] = -128;
        byArray[329] = -128;
        byArray[330] = -128;
        byArray[331] = -128;
        byArray[332] = -128;
        byArray[333] = -128;
        byArray[334] = -128;
        byArray[335] = -128;
        byArray[336] = -128;
        byArray[337] = -128;
        byArray[338] = -128;
        byArray[339] = -128;
        byArray[340] = -128;
        byArray[341] = -128;
        byArray[342] = -128;
        byArray[343] = -128;
        byArray[344] = -128;
        byArray[345] = -128;
        byArray[346] = -128;
        byArray[347] = -128;
        byArray[348] = -128;
        byArray[349] = -128;
        byArray[350] = -128;
        byArray[351] = -128;
        byArray[352] = -128;
        byArray[353] = -128;
        byArray[354] = -128;
        byArray[355] = -128;
        byArray[356] = -128;
        byArray[357] = -128;
        byArray[358] = -128;
        byArray[359] = -128;
        byArray[360] = -128;
        byArray[361] = -128;
        byArray[362] = -128;
        byArray[363] = -128;
        byArray[364] = -128;
        byArray[365] = -128;
        byArray[366] = -128;
        byArray[367] = -128;
        byArray[368] = -128;
        byArray[369] = -128;
        byArray[370] = -128;
        byArray[371] = -128;
        byArray[372] = -128;
        byArray[373] = -128;
        byArray[374] = -128;
        byArray[375] = -128;
        byArray[376] = -128;
        byArray[377] = -128;
        byArray[378] = -128;
        byArray[379] = -128;
        byArray[380] = -128;
        byArray[381] = -128;
        byArray[382] = -128;
        byArray[383] = -128;
        byArray[384] = -128;
        byArray[385] = -128;
        byArray[386] = -128;
        byArray[387] = -128;
        byArray[388] = -128;
        byArray[389] = -128;
        byArray[390] = -128;
        byArray[391] = -128;
        byArray[392] = -128;
        byArray[393] = -128;
        byArray[394] = -128;
        byArray[395] = -128;
        byArray[396] = -128;
        byArray[397] = -128;
        byArray[398] = -128;
        byArray[399] = -128;
        byArray[400] = -128;
        byArray[401] = 92;
        byArray[402] = 102;
        byArray[403] = 102;
        byArray[404] = 102;
        byArray[405] = 102;
        byArray[406] = 92;
        byArray[407] = 102;
        byArray[408] = 102;
        byArray[409] = 102;
        byArray[410] = 94;
        byArray[411] = 92;
        byArray[412] = 102;
        byArray[413] = 102;
        byArray[414] = 102;
        byArray[415] = 102;
        byArray[416] = 102;
        byArray[417] = 102;
        byArray[418] = -128;
        byArray[419] = 92;
        byArray[420] = 92;
        byArray[421] = 92;
        byArray[422] = 92;
        byArray[423] = 92;
        byArray[424] = 102;
        byArray[425] = 102;
        byArray[426] = 92;
        byArray[427] = 102;
        byArray[428] = 102;
        byArray[429] = 94;
        byArray[430] = 102;
        byArray[431] = 102;
        byArray[432] = -118;
        byArray[433] = -117;
        byArray[434] = -116;
        byArray[435] = -115;
        byArray[436] = -114;
        byArray[437] = -113;
        byArray[438] = -112;
        byArray[439] = -111;
        byArray[440] = -110;
        byArray[441] = -109;
        byArray[442] = -128;
        byArray[443] = -108;
        byArray[444] = -107;
        byArray[445] = -106;
        byArray[446] = -128;
        byArray[447] = -105;
        byArray[448] = -128;
        byArray[449] = -104;
        byArray[450] = -103;
        byArray[451] = -128;
        byArray[452] = 102;
        byArray[453] = -128;
        byArray[454] = -128;
        byArray[455] = -128;
        byArray[456] = -128;
        byArray[457] = -128;
        byArray[458] = -128;
        byArray[459] = -128;
        byArray[460] = -128;
        byArray[461] = -128;
        byArray[462] = -128;
        byArray[463] = -128;
        byArray[464] = -128;
        byArray[465] = -128;
        byArray[466] = -128;
        byArray[467] = -128;
        byArray[468] = -128;
        byArray[469] = -128;
        byArray[470] = -128;
        byArray[471] = -128;
        byArray[472] = -128;
        byArray[473] = -128;
        byArray[474] = -128;
        byArray[475] = -128;
        byArray[476] = -128;
        byArray[477] = -128;
        byArray[478] = -128;
        byArray[479] = -128;
        byArray[480] = -128;
        byArray[481] = -128;
        byArray[482] = -128;
        byArray[483] = -128;
        byArray[484] = -128;
        byArray[485] = -128;
        byArray[486] = -128;
        byArray[487] = -128;
        byArray[488] = -128;
        byArray[489] = -128;
        byArray[490] = -128;
        byArray[491] = -128;
        byArray[492] = -128;
        byArray[493] = -128;
        byArray[494] = -128;
        byArray[495] = -128;
        byArray[496] = -128;
        byArray[497] = -128;
        byArray[498] = -128;
        byArray[499] = -128;
        byArray[500] = -128;
        byArray[501] = -128;
        byArray[502] = -128;
        byArray[503] = -128;
        byArray[504] = -128;
        byArray[505] = -128;
        byArray[506] = -128;
        byArray[507] = -128;
        byArray[508] = -128;
        byArray[509] = -128;
        byArray[510] = -128;
        byArray[511] = -128;
        byArray[512] = -128;
        byArray[513] = -128;
        byArray[514] = -128;
        byArray[515] = -128;
        byArray[516] = -128;
        byArray[517] = -128;
        byArray[518] = -128;
        byArray[519] = -128;
        byArray[520] = -128;
        byArray[521] = -128;
        byArray[522] = -128;
        byArray[523] = -128;
        byArray[524] = -128;
        byArray[525] = -128;
        byArray[526] = -128;
        byArray[527] = -128;
        byArray[528] = -128;
        byArray[529] = -128;
        byArray[530] = -128;
        byArray[531] = -128;
        byArray[532] = -128;
        byArray[533] = -128;
        byArray[534] = -128;
        byArray[535] = -128;
        byArray[536] = -128;
        byArray[537] = -128;
        byArray[538] = -128;
        byArray[539] = -128;
        byArray[540] = -128;
        byArray[541] = -128;
        byArray[542] = -128;
        byArray[543] = -128;
        byArray[544] = -128;
        byArray[545] = -128;
        byArray[546] = -128;
        byArray[547] = -128;
        byArray[548] = -128;
        byArray[549] = -128;
        byArray[550] = -128;
        byArray[551] = -128;
        byArray[552] = -128;
        byArray[553] = -128;
        byArray[554] = -128;
        byArray[555] = -128;
        byArray[556] = -128;
        byArray[557] = -128;
        byArray[558] = -128;
        byArray[559] = -128;
        byArray[560] = -128;
        byArray[561] = -128;
        byArray[562] = -128;
        byArray[563] = -128;
        byArray[564] = -128;
        byArray[565] = -128;
        byArray[566] = -128;
        byArray[567] = -128;
        byArray[568] = -128;
        byArray[569] = -128;
        byArray[570] = -128;
        byArray[571] = -128;
        byArray[572] = -128;
        byArray[573] = -128;
        byArray[574] = -128;
        byArray[575] = -128;
        byArray[576] = -128;
        byArray[577] = -128;
        byArray[578] = -128;
        byArray[579] = -128;
        byArray[580] = -128;
        byArray[581] = -128;
        byArray[582] = -128;
        byArray[583] = -128;
        byArray[584] = -128;
        byArray[585] = -128;
        byArray[586] = -128;
        byArray[587] = -101;
        byArray[588] = -100;
        byArray[589] = -99;
        byArray[590] = -98;
        byArray[591] = -97;
        byArray[592] = -96;
        byArray[593] = -95;
        byArray[594] = -94;
        byArray[595] = -128;
        byArray[596] = -128;
        byArray[597] = -128;
        byArray[598] = -128;
        byArray[599] = -128;
        byArray[600] = -128;
        byArray[601] = -128;
        byArray[602] = -128;
        byArray[603] = -128;
        byArray[604] = -128;
        byArray[605] = -128;
        byArray[606] = -128;
        byArray[607] = -128;
        byArray[608] = -128;
        byArray[609] = -128;
        byArray[610] = -128;
        byArray[611] = -128;
        byArray[612] = -128;
        byArray[613] = -128;
        byArray[614] = -128;
        byArray[615] = -128;
        byArray[616] = -128;
        byArray[617] = -128;
        byArray[618] = -128;
        byArray[619] = -128;
        byArray[620] = -128;
        byArray[621] = -128;
        byArray[622] = -128;
        byArray[623] = -128;
        byArray[624] = -93;
        byArray[625] = -128;
        byArray[626] = -128;
        byArray[627] = -128;
        byArray[628] = -128;
        byArray[629] = -128;
        byArray[630] = -128;
        byArray[631] = -128;
        byArray[632] = -128;
        byArray[633] = -128;
        byArray[634] = -128;
        byArray[635] = -128;
        byArray[636] = -128;
        byArray[637] = -128;
        byArray[638] = -128;
        byArray[639] = -128;
        byArray[640] = -128;
        byArray[641] = -128;
        byArray[642] = -128;
        byArray[643] = -128;
        byArray[644] = -128;
        byArray[645] = -128;
        byArray[646] = -128;
        byArray[647] = -128;
        byArray[648] = -128;
        byArray[649] = -128;
        byArray[650] = -128;
        byArray[651] = -128;
        byArray[652] = -128;
        byArray[653] = -128;
        byArray[654] = -128;
        byArray[655] = -128;
        byArray[656] = -128;
        byArray[657] = -128;
        byArray[658] = -128;
        byArray[659] = -128;
        byArray[660] = -128;
        byArray[661] = -128;
        byArray[662] = -128;
        byArray[663] = -128;
        byArray[664] = -128;
        byArray[665] = -128;
        byArray[666] = -128;
        byArray[667] = -128;
        byArray[668] = -128;
        byArray[669] = -128;
        byArray[670] = -128;
        byArray[671] = -128;
        byArray[672] = -128;
        byArray[673] = -128;
        byArray[674] = -128;
        byArray[675] = -128;
        byArray[676] = -128;
        byArray[677] = -128;
        byArray[678] = -128;
        byArray[679] = -128;
        byArray[680] = -128;
        byArray[681] = -128;
        byArray[682] = -128;
        byArray[683] = -128;
        byArray[684] = -128;
        byArray[685] = -128;
        byArray[686] = -128;
        byArray[687] = -128;
        byArray[688] = -128;
        byArray[689] = -128;
        byArray[690] = -128;
        byArray[691] = -128;
        byArray[692] = -128;
        byArray[693] = -128;
        byArray[694] = -128;
        byArray[695] = -128;
        byArray[696] = -128;
        byArray[697] = -128;
        byArray[698] = -128;
        byArray[699] = -128;
        byArray[700] = -128;
        byArray[701] = -128;
        byArray[702] = -128;
        byArray[703] = -128;
        byArray[704] = -128;
        byArray[705] = -128;
        byArray[706] = -128;
        byArray[707] = -128;
        byArray[708] = -128;
        byArray[709] = -128;
        byArray[710] = -128;
        byArray[711] = -128;
        byArray[712] = -128;
        byArray[713] = -128;
        byArray[714] = -128;
        byArray[715] = -128;
        byArray[716] = -128;
        byArray[717] = -128;
        byArray[718] = -128;
        byArray[719] = -128;
        byArray[720] = -128;
        byArray[721] = -128;
        byArray[722] = -128;
        byArray[723] = -128;
        byArray[724] = -128;
        byArray[725] = -128;
        byArray[726] = 102;
        byArray[727] = 102;
        byArray[728] = 102;
        byArray[729] = 102;
        byArray[730] = 102;
        byArray[731] = 102;
        byArray[732] = 102;
        byArray[733] = -128;
        byArray[734] = -128;
        byArray[735] = 102;
        byArray[736] = 102;
        byArray[737] = 102;
        byArray[738] = 102;
        byArray[739] = 92;
        byArray[740] = 102;
        byArray[741] = -128;
        byArray[742] = -128;
        byArray[743] = 102;
        byArray[744] = 102;
        byArray[745] = -128;
        byArray[746] = 92;
        byArray[747] = 102;
        byArray[748] = 102;
        byArray[749] = 92;
        byArray[750] = -128;
        byArray[751] = -128;
        byArray[752] = -128;
        byArray[753] = -128;
        byArray[754] = -128;
        byArray[755] = -128;
        byArray[756] = -128;
        byArray[757] = -128;
        byArray[758] = -128;
        byArray[759] = -128;
        byArray[760] = -128;
        byArray[761] = -128;
        byArray[762] = -128;
        byArray[763] = -128;
        byArray[764] = -128;
        byArray[765] = -128;
        byArray[766] = -128;
        byArray[767] = -128;
        byArray[768] = -128;
        byArray[769] = -91;
        byArray[770] = -92;
        byArray[771] = -128;
        byArray[772] = -128;
        byArray[773] = -128;
        byArray[774] = -128;
        byArray[775] = -128;
        byArray[776] = -128;
        byArray[777] = -128;
        byArray[778] = -128;
        byArray[779] = -128;
        byArray[780] = -128;
        byArray[781] = -128;
        byArray[782] = -128;
        byArray[783] = -128;
        byArray[784] = -128;
        byArray[785] = -128;
        byArray[786] = -128;
        byArray[787] = -128;
        byArray[788] = -128;
        byArray[789] = -128;
        byArray[790] = -128;
        byArray[791] = -128;
        byArray[792] = -128;
        byArray[793] = -128;
        byArray[794] = -128;
        byArray[795] = -128;
        byArray[796] = -128;
        byArray[797] = -128;
        byArray[798] = -128;
        byArray[799] = -128;
        byArray[800] = -128;
        byArray[801] = -128;
        byArray[802] = -128;
        byArray[803] = -128;
        byArray[804] = -128;
        byArray[805] = -128;
        byArray[806] = -128;
        byArray[807] = -128;
        byArray[808] = -128;
        byArray[809] = -128;
        byArray[810] = -128;
        byArray[811] = -128;
        byArray[812] = -128;
        byArray[813] = -128;
        byArray[814] = -128;
        byArray[815] = -128;
        byArray[816] = -128;
        byArray[817] = -128;
        byArray[818] = -128;
        byArray[819] = -128;
        byArray[820] = -128;
        byArray[821] = -128;
        byArray[822] = -128;
        byArray[823] = -128;
        byArray[824] = -128;
        byArray[825] = -128;
        byArray[826] = -128;
        byArray[827] = -128;
        byArray[828] = -121;
        byArray[829] = -128;
        byArray[830] = -128;
        byArray[831] = -128;
        byArray[832] = -128;
        byArray[833] = -90;
        byArray[834] = -89;
        byArray[835] = -88;
        byArray[836] = -87;
        byArray[837] = -86;
        byArray[838] = -85;
        byArray[839] = -84;
        byArray[840] = -83;
        byArray[841] = -128;
        byArray[842] = -128;
        byArray[843] = -128;
        byArray[844] = -128;
        byArray[845] = -119;
        byArray[846] = -128;
        byArray[847] = -128;
        byArray[848] = -128;
        byArray[849] = -82;
        byArray[850] = -81;
        byArray[851] = 102;
        byArray[852] = 102;
        byArray[853] = -128;
        byArray[854] = -128;
        byArray[855] = -128;
        byArray[856] = -128;
        byArray[857] = -128;
        byArray[858] = -128;
        byArray[859] = -128;
        byArray[860] = -128;
        byArray[861] = -128;
        byArray[862] = -128;
        byArray[863] = -128;
        byArray[864] = -128;
        byArray[865] = -128;
        byArray[866] = -80;
        byArray[867] = -79;
        byArray[868] = -128;
        byArray[869] = -128;
        byArray[870] = -128;
        byArray[871] = -128;
        byArray[872] = -128;
        byArray[873] = -128;
        byArray[874] = -128;
        byArray[875] = -128;
        byArray[876] = -128;
        byArray[877] = -128;
        byArray[878] = -128;
        byArray[879] = -128;
        byArray[880] = -128;
        byArray[881] = -128;
        byArray[882] = -128;
        byArray[883] = -128;
        byArray[884] = -128;
        byArray[885] = -128;
        byArray[886] = -128;
        byArray[887] = -128;
        byArray[888] = -128;
        byArray[889] = -128;
        byArray[890] = -128;
        byArray[891] = -128;
        byArray[892] = -128;
        byArray[893] = -128;
        byArray[894] = -128;
        byArray[895] = -128;
        byArray[896] = -128;
        byArray[897] = -78;
        byArray[898] = -128;
        byArray[899] = -128;
        byArray[900] = -128;
        byArray[901] = -128;
        byArray[902] = -128;
        byArray[903] = -128;
        byArray[904] = -128;
        byArray[905] = -128;
        byArray[906] = -128;
        byArray[907] = -128;
        byArray[908] = -128;
        byArray[909] = -128;
        byArray[910] = -128;
        byArray[911] = -128;
        byArray[912] = -128;
        byArray[913] = -128;
        byArray[914] = -128;
        byArray[915] = -128;
        byArray[916] = -128;
        byArray[917] = -128;
        byArray[918] = -128;
        byArray[919] = -128;
        byArray[920] = -128;
        byArray[921] = -128;
        byArray[922] = -128;
        byArray[923] = -128;
        byArray[924] = -128;
        byArray[925] = -128;
        byArray[926] = -128;
        byArray[927] = -128;
        byArray[928] = -128;
        byArray[929] = -128;
        byArray[930] = -128;
        byArray[931] = -128;
        byArray[932] = -128;
        byArray[933] = -128;
        byArray[934] = -128;
        byArray[935] = -128;
        byArray[936] = -128;
        byArray[937] = -128;
        byArray[938] = -128;
        byArray[939] = -128;
        byArray[940] = -128;
        byArray[941] = -128;
        byArray[942] = -128;
        byArray[943] = -128;
        byArray[944] = -128;
        byArray[945] = -128;
        byArray[946] = -128;
        byArray[947] = -128;
        byArray[948] = -128;
        byArray[949] = -128;
        byArray[950] = -128;
        byArray[951] = -128;
        byArray[952] = -128;
        byArray[953] = -128;
        byArray[954] = -128;
        byArray[955] = -128;
        byArray[956] = -121;
        byArray[957] = -128;
        byArray[958] = -128;
        byArray[959] = -128;
        byArray[960] = -128;
        byArray[961] = -77;
        byArray[962] = -76;
        byArray[963] = -75;
        byArray[964] = -74;
        byArray[965] = -128;
        byArray[966] = -128;
        byArray[967] = -128;
        byArray[968] = -128;
        byArray[969] = -128;
        byArray[970] = -128;
        byArray[971] = -128;
        byArray[972] = -128;
        byArray[973] = -119;
        byArray[974] = -128;
        byArray[975] = -128;
        byArray[976] = -128;
        byArray[977] = -128;
        byArray[978] = -128;
        byArray[979] = -128;
        byArray[980] = -128;
        byArray[981] = -128;
        byArray[982] = -128;
        byArray[983] = -128;
        byArray[984] = -128;
        byArray[985] = -128;
        byArray[986] = -128;
        byArray[987] = -128;
        byArray[988] = -128;
        byArray[989] = -128;
        byArray[990] = -128;
        byArray[991] = -128;
        byArray[992] = -128;
        byArray[993] = -128;
        byArray[994] = -73;
        byArray[995] = -72;
        byArray[996] = -128;
        byArray[997] = -128;
        byArray[998] = -128;
        byArray[999] = -128;
        byArray[1000] = -128;
        byArray[1001] = -128;
        byArray[1002] = -128;
        byArray[1003] = -128;
        byArray[1004] = -128;
        byArray[1005] = -128;
        byArray[1006] = -128;
        byArray[1007] = -128;
        byArray[1008] = -128;
        byArray[1009] = -128;
        byArray[1010] = -128;
        byArray[1011] = -128;
        byArray[1012] = -128;
        byArray[1013] = -128;
        byArray[1014] = -128;
        byArray[1015] = -128;
        byArray[1016] = -128;
        byArray[1017] = -128;
        byArray[1018] = -128;
        byArray[1019] = -128;
        byArray[1020] = -128;
        byArray[1021] = -128;
        byArray[1022] = -128;
        byArray[1023] = -128;
        byArray[1024] = -128;
        byArray[1025] = -128;
        byArray[1026] = -71;
        byArray[1027] = -128;
        byArray[1028] = -128;
        byArray[1029] = -128;
        byArray[1030] = -128;
        byArray[1031] = -128;
        byArray[1032] = -128;
        byArray[1033] = -128;
        byArray[1034] = -128;
        byArray[1035] = -128;
        byArray[1036] = -128;
        byArray[1037] = -128;
        byArray[1038] = -128;
        byArray[1039] = -128;
        byArray[1040] = -128;
        byArray[1041] = -128;
        byArray[1042] = -128;
        byArray[1043] = -128;
        byArray[1044] = -128;
        byArray[1045] = -128;
        byArray[1046] = -128;
        byArray[1047] = -128;
        byArray[1048] = -128;
        byArray[1049] = -128;
        byArray[1050] = -128;
        byArray[1051] = -128;
        byArray[1052] = -128;
        byArray[1053] = -128;
        byArray[1054] = -128;
        byArray[1055] = -128;
        byArray[1056] = -128;
        byArray[1057] = -128;
        byArray[1058] = -128;
        byArray[1059] = -128;
        byArray[1060] = -128;
        byArray[1061] = -128;
        byArray[1062] = -128;
        byArray[1063] = -128;
        byArray[1064] = -128;
        byArray[1065] = -128;
        byArray[1066] = -128;
        byArray[1067] = -128;
        byArray[1068] = -128;
        byArray[1069] = -128;
        byArray[1070] = -128;
        byArray[1071] = -128;
        byArray[1072] = -128;
        byArray[1073] = -128;
        byArray[1074] = -128;
        byArray[1075] = -128;
        byArray[1076] = -128;
        byArray[1077] = -128;
        byArray[1078] = -128;
        byArray[1079] = -128;
        byArray[1080] = -128;
        byArray[1081] = -128;
        byArray[1082] = -128;
        byArray[1083] = -128;
        byArray[1084] = -121;
        byArray[1085] = -128;
        byArray[1086] = -128;
        byArray[1087] = -128;
        byArray[1088] = -128;
        byArray[1089] = -70;
        byArray[1090] = -69;
        byArray[1091] = -128;
        byArray[1092] = -128;
        byArray[1093] = -128;
        byArray[1094] = -128;
        byArray[1095] = -68;
        byArray[1096] = -67;
        byArray[1097] = -128;
        byArray[1098] = -128;
        byArray[1099] = -66;
        byArray[1100] = -65;
        byArray[1101] = -119;
        byArray[1102] = -128;
        byArray[1103] = -128;
        byArray[1104] = -128;
        byArray[1105] = -128;
        byArray[1106] = -128;
        byArray[1107] = -128;
        byArray[1108] = -128;
        byArray[1109] = -128;
        byArray[1110] = -128;
        byArray[1111] = -128;
        byArray[1112] = -128;
        byArray[1113] = -128;
        byArray[1114] = -128;
        byArray[1115] = -128;
        byArray[1116] = -128;
        byArray[1117] = -128;
        byArray[1118] = -128;
        byArray[1119] = -128;
        byArray[1120] = -128;
        byArray[1121] = -128;
        byArray[1122] = -128;
        byArray[1123] = -128;
        byArray[1124] = -128;
        byArray[1125] = -128;
        byArray[1126] = -128;
        byArray[1127] = -128;
        byArray[1128] = -128;
        byArray[1129] = -128;
        byArray[1130] = -128;
        byArray[1131] = -128;
        byArray[1132] = -128;
        byArray[1133] = -128;
        byArray[1134] = -128;
        byArray[1135] = -128;
        byArray[1136] = -64;
        byArray[1137] = -63;
        byArray[1138] = -128;
        byArray[1139] = -128;
        byArray[1140] = -128;
        byArray[1141] = -128;
        byArray[1142] = -128;
        byArray[1143] = -128;
        byArray[1144] = -128;
        byArray[1145] = -128;
        byArray[1146] = -128;
        byArray[1147] = -128;
        byArray[1148] = -128;
        byArray[1149] = -128;
        byArray[1150] = -128;
        byArray[1151] = -128;
        byArray[1152] = -128;
        byArray[1153] = -61;
        byArray[1154] = -62;
        byArray[1155] = -128;
        byArray[1156] = -128;
        byArray[1157] = -128;
        byArray[1158] = -128;
        byArray[1159] = -128;
        byArray[1160] = -128;
        byArray[1161] = -128;
        byArray[1162] = -128;
        byArray[1163] = -128;
        byArray[1164] = -128;
        byArray[1165] = -128;
        byArray[1166] = -128;
        byArray[1167] = -128;
        byArray[1168] = -128;
        byArray[1169] = -128;
        byArray[1170] = -128;
        byArray[1171] = -128;
        byArray[1172] = -128;
        byArray[1173] = -128;
        byArray[1174] = -128;
        byArray[1175] = -128;
        byArray[1176] = -128;
        byArray[1177] = -128;
        byArray[1178] = -128;
        byArray[1179] = -128;
        byArray[1180] = -128;
        byArray[1181] = -128;
        byArray[1182] = -128;
        byArray[1183] = -128;
        byArray[1184] = -128;
        byArray[1185] = -128;
        byArray[1186] = -128;
        byArray[1187] = -128;
        byArray[1188] = -128;
        byArray[1189] = -128;
        byArray[1190] = -128;
        byArray[1191] = -128;
        byArray[1192] = -128;
        byArray[1193] = -128;
        byArray[1194] = -128;
        byArray[1195] = -128;
        byArray[1196] = -128;
        byArray[1197] = -128;
        byArray[1198] = -128;
        byArray[1199] = -128;
        byArray[1200] = -128;
        byArray[1201] = -128;
        byArray[1202] = -128;
        byArray[1203] = -128;
        byArray[1204] = -128;
        byArray[1205] = -128;
        byArray[1206] = -128;
        byArray[1207] = -128;
        byArray[1208] = -128;
        byArray[1209] = -128;
        byArray[1210] = -128;
        byArray[1211] = -128;
        byArray[1212] = -121;
        byArray[1213] = -128;
        byArray[1214] = -128;
        byArray[1215] = -128;
        byArray[1216] = -128;
        byArray[1217] = -60;
        byArray[1218] = -59;
        byArray[1219] = -58;
        byArray[1220] = -57;
        byArray[1221] = -56;
        byArray[1222] = -128;
        byArray[1223] = -55;
        byArray[1224] = -54;
        byArray[1225] = -128;
        byArray[1226] = -128;
        byArray[1227] = -128;
        byArray[1228] = -128;
        byArray[1229] = -119;
        byArray[1230] = -128;
        byArray[1231] = -128;
        byArray[1232] = -128;
        byArray[1233] = -128;
        byArray[1234] = -128;
        byArray[1235] = -128;
        byArray[1236] = -128;
        byArray[1237] = -128;
        byArray[1238] = -128;
        byArray[1239] = -128;
        byArray[1240] = -128;
        byArray[1241] = -128;
        byArray[1242] = -128;
        byArray[1243] = -128;
        byArray[1244] = -128;
        byArray[1245] = -128;
        byArray[1246] = -128;
        byArray[1247] = -128;
        byArray[1248] = -128;
        byArray[1249] = -128;
        byArray[1250] = -128;
        byArray[1251] = -128;
        byArray[1252] = -128;
        byArray[1253] = -128;
        byArray[1254] = -128;
        byArray[1255] = -128;
        byArray[1256] = -128;
        byArray[1257] = -128;
        byArray[1258] = -128;
        byArray[1259] = -128;
        byArray[1260] = -128;
        byArray[1261] = -128;
        byArray[1262] = -128;
        byArray[1263] = -128;
        byArray[1264] = -128;
        byArray[1265] = -128;
        byArray[1266] = -128;
        byArray[1267] = -128;
        byArray[1268] = -128;
        byArray[1269] = -128;
        byArray[1270] = -128;
        byArray[1271] = -128;
        byArray[1272] = -128;
        byArray[1273] = -128;
        byArray[1274] = -128;
        byArray[1275] = -128;
        byArray[1276] = -128;
        byArray[1277] = -128;
        byArray[1278] = -128;
        byArray[1279] = -128;
        byArray[1280] = -128;
        byArray[1281] = -53;
        byArray[1282] = -128;
        byArray[1283] = -128;
        byArray[1284] = -128;
        byArray[1285] = -128;
        byArray[1286] = -128;
        byArray[1287] = -128;
        byArray[1288] = -128;
        byArray[1289] = -128;
        byArray[1290] = -128;
        byArray[1291] = -128;
        byArray[1292] = -128;
        byArray[1293] = -128;
        byArray[1294] = -128;
        byArray[1295] = -128;
        byArray[1296] = -128;
        byArray[1297] = -128;
        byArray[1298] = -128;
        byArray[1299] = -128;
        byArray[1300] = -128;
        byArray[1301] = -128;
        byArray[1302] = -128;
        byArray[1303] = -128;
        byArray[1304] = -128;
        byArray[1305] = -128;
        byArray[1306] = -128;
        byArray[1307] = -128;
        byArray[1308] = -128;
        byArray[1309] = -128;
        byArray[1310] = -128;
        byArray[1311] = -128;
        byArray[1312] = -128;
        byArray[1313] = -128;
        byArray[1314] = -128;
        byArray[1315] = -128;
        byArray[1316] = -128;
        byArray[1317] = -128;
        byArray[1318] = -128;
        byArray[1319] = -128;
        byArray[1320] = -128;
        byArray[1321] = -128;
        byArray[1322] = -128;
        byArray[1323] = -128;
        byArray[1324] = -128;
        byArray[1325] = -128;
        byArray[1326] = -128;
        byArray[1327] = -128;
        byArray[1328] = -128;
        byArray[1329] = -128;
        byArray[1330] = -128;
        byArray[1331] = -128;
        byArray[1332] = -128;
        byArray[1333] = -128;
        byArray[1334] = -128;
        byArray[1335] = -128;
        byArray[1336] = -128;
        byArray[1337] = -128;
        byArray[1338] = -128;
        byArray[1339] = -128;
        byArray[1340] = -121;
        byArray[1341] = -128;
        byArray[1342] = -128;
        byArray[1343] = -52;
        byArray[1344] = -128;
        byArray[1345] = -51;
        byArray[1346] = -50;
        byArray[1347] = -49;
        byArray[1348] = -128;
        byArray[1349] = -128;
        byArray[1350] = -128;
        byArray[1351] = -128;
        byArray[1352] = -128;
        byArray[1353] = -128;
        byArray[1354] = -128;
        byArray[1355] = -128;
        byArray[1356] = -128;
        byArray[1357] = -119;
        byArray[1358] = -128;
        byArray[1359] = -128;
        byArray[1360] = -128;
        byArray[1361] = -128;
        byArray[1362] = -128;
        byArray[1363] = -128;
        byArray[1364] = -128;
        byArray[1365] = -128;
        byArray[1366] = 102;
        byArray[1367] = -128;
        byArray[1368] = -128;
        byArray[1369] = -128;
        byArray[1370] = -128;
        byArray[1371] = -128;
        byArray[1372] = -128;
        byArray[1373] = -128;
        byArray[1374] = -128;
        byArray[1375] = -128;
        byArray[1376] = -128;
        byArray[1377] = -128;
        byArray[1378] = -128;
        byArray[1379] = -128;
        byArray[1380] = -128;
        byArray[1381] = -128;
        byArray[1382] = -128;
        byArray[1383] = -128;
        byArray[1384] = -128;
        byArray[1385] = -128;
        byArray[1386] = -128;
        byArray[1387] = -128;
        byArray[1388] = -128;
        byArray[1389] = -128;
        byArray[1390] = -128;
        byArray[1391] = -128;
        byArray[1392] = -128;
        byArray[1393] = -128;
        byArray[1394] = -128;
        byArray[1395] = -128;
        byArray[1396] = -128;
        byArray[1397] = -128;
        byArray[1398] = -128;
        byArray[1399] = -128;
        byArray[1400] = -128;
        byArray[1401] = -128;
        byArray[1402] = -128;
        byArray[1403] = -128;
        byArray[1404] = -128;
        byArray[1405] = -128;
        byArray[1406] = -128;
        byArray[1407] = -128;
        byArray[1408] = -128;
        byArray[1409] = -128;
        byArray[1410] = -128;
        byArray[1411] = -128;
        byArray[1412] = -128;
        byArray[1413] = -128;
        byArray[1414] = -128;
        byArray[1415] = -128;
        byArray[1416] = -128;
        byArray[1417] = -128;
        byArray[1418] = -128;
        byArray[1419] = -128;
        byArray[1420] = -128;
        byArray[1421] = -128;
        byArray[1422] = -128;
        byArray[1423] = -128;
        byArray[1424] = -128;
        byArray[1425] = -128;
        byArray[1426] = -128;
        byArray[1427] = -128;
        byArray[1428] = -128;
        byArray[1429] = -128;
        byArray[1430] = -128;
        byArray[1431] = -128;
        byArray[1432] = -128;
        byArray[1433] = -128;
        byArray[1434] = -128;
        byArray[1435] = -128;
        byArray[1436] = -128;
        byArray[1437] = -128;
        byArray[1438] = -128;
        byArray[1439] = -128;
        byArray[1440] = -128;
        byArray[1441] = -128;
        byArray[1442] = -128;
        byArray[1443] = -128;
        byArray[1444] = -128;
        byArray[1445] = -128;
        byArray[1446] = -128;
        byArray[1447] = -128;
        byArray[1448] = -128;
        byArray[1449] = -128;
        byArray[1450] = -128;
        byArray[1451] = -128;
        byArray[1452] = -128;
        byArray[1453] = -128;
        byArray[1454] = -128;
        byArray[1455] = -128;
        byArray[1456] = -128;
        byArray[1457] = -128;
        byArray[1458] = -128;
        byArray[1459] = -128;
        byArray[1460] = -128;
        byArray[1461] = -128;
        byArray[1462] = -128;
        byArray[1463] = -128;
        byArray[1464] = -128;
        byArray[1465] = -128;
        byArray[1466] = -128;
        byArray[1467] = -128;
        byArray[1468] = -128;
        byArray[1469] = -128;
        byArray[1470] = -128;
        byArray[1471] = -128;
        byArray[1472] = -48;
        byArray[1473] = -128;
        byArray[1474] = -128;
        byArray[1475] = -128;
        byArray[1476] = -128;
        byArray[1477] = -128;
        byArray[1478] = -128;
        byArray[1479] = -128;
        byArray[1480] = -128;
        byArray[1481] = -128;
        byArray[1482] = -128;
        byArray[1483] = -128;
        byArray[1484] = -128;
        byArray[1485] = -119;
        byArray[1486] = -128;
        byArray[1487] = -128;
        byArray[1488] = -128;
        byArray[1489] = -128;
        byArray[1490] = -128;
        byArray[1491] = -128;
        byArray[1492] = -128;
        byArray[1493] = -128;
        byArray[1494] = -128;
        byArray[1495] = -128;
        byArray[1496] = -128;
        byArray[1497] = -128;
        byArray[1498] = -128;
        byArray[1499] = -128;
        byArray[1500] = -128;
        byArray[1501] = -128;
        byArray[1502] = -128;
        byArray[1503] = -128;
        byArray[1504] = -128;
        byArray[1505] = -128;
        byArray[1506] = -128;
        byArray[1507] = -128;
        byArray[1508] = -128;
        byArray[1509] = -128;
        byArray[1510] = -128;
        byArray[1511] = -128;
        byArray[1512] = -128;
        byArray[1513] = -128;
        byArray[1514] = -128;
        byArray[1515] = -128;
        byArray[1516] = -128;
        byArray[1517] = -128;
        byArray[1518] = -128;
        byArray[1519] = -128;
        byArray[1520] = -128;
        byArray[1521] = -128;
        byArray[1522] = -128;
        byArray[1523] = -128;
        byArray[1524] = -128;
        byArray[1525] = -128;
        byArray[1526] = -128;
        byArray[1527] = -128;
        byArray[1528] = -128;
        byArray[1529] = -128;
        byArray[1530] = -128;
        byArray[1531] = -128;
        byArray[1532] = -128;
        byArray[1533] = -128;
        byArray[1534] = -128;
        byArray[1535] = -128;
        byArray[1536] = -128;
        byArray[1537] = -128;
        byArray[1538] = -128;
        byArray[1539] = -128;
        byArray[1540] = -128;
        byArray[1541] = -128;
        byArray[1542] = -128;
        byArray[1543] = -128;
        byArray[1544] = -128;
        byArray[1545] = -128;
        byArray[1546] = -128;
        byArray[1547] = -128;
        byArray[1548] = -128;
        byArray[1549] = -128;
        byArray[1550] = -128;
        byArray[1551] = -128;
        byArray[1552] = -128;
        byArray[1553] = -128;
        byArray[1554] = -128;
        byArray[1555] = -128;
        byArray[1556] = -128;
        byArray[1557] = -128;
        byArray[1558] = -128;
        byArray[1559] = -128;
        byArray[1560] = -128;
        byArray[1561] = -128;
        byArray[1562] = -128;
        byArray[1563] = -128;
        byArray[1564] = -128;
        byArray[1565] = -128;
        byArray[1566] = -128;
        byArray[1567] = -128;
        byArray[1568] = -128;
        byArray[1569] = -128;
        byArray[1570] = -128;
        byArray[1571] = -128;
        byArray[1572] = -128;
        byArray[1573] = -128;
        byArray[1574] = -128;
        byArray[1575] = -128;
        byArray[1576] = -128;
        byArray[1577] = -128;
        byArray[1578] = -128;
        byArray[1579] = -128;
        byArray[1580] = -128;
        byArray[1581] = -128;
        byArray[1582] = -128;
        byArray[1583] = -128;
        byArray[1584] = -128;
        byArray[1585] = -128;
        byArray[1586] = -128;
        byArray[1587] = -128;
        byArray[1588] = -128;
        byArray[1589] = -128;
        byArray[1590] = -128;
        byArray[1591] = -128;
        byArray[1592] = -128;
        byArray[1593] = -128;
        byArray[1594] = -128;
        byArray[1595] = -128;
        byArray[1596] = -128;
        byArray[1597] = -128;
        byArray[1598] = -47;
        byArray[1599] = -46;
        byArray[1600] = -45;
        byArray[1601] = -128;
        byArray[1602] = -128;
        byArray[1603] = -128;
        byArray[1604] = -128;
        byArray[1605] = -128;
        byArray[1606] = -44;
        byArray[1607] = -43;
        byArray[1608] = -42;
        byArray[1609] = -128;
        byArray[1610] = -41;
        byArray[1611] = -40;
        byArray[1612] = -39;
        byArray[1613] = -119;
        byArray[1614] = -128;
        byArray[1615] = -128;
        byArray[1616] = -128;
        byArray[1617] = -128;
        byArray[1618] = -128;
        byArray[1619] = -128;
        byArray[1620] = -128;
        byArray[1621] = -38;
        byArray[1622] = -37;
        byArray[1623] = -128;
        byArray[1624] = -128;
        byArray[1625] = -128;
        byArray[1626] = -128;
        byArray[1627] = -128;
        byArray[1628] = -128;
        byArray[1629] = -128;
        byArray[1630] = -128;
        byArray[1631] = -128;
        byArray[1632] = -128;
        byArray[1633] = -128;
        byArray[1634] = -128;
        byArray[1635] = -128;
        byArray[1636] = -128;
        byArray[1637] = -128;
        byArray[1638] = -128;
        byArray[1639] = -128;
        byArray[1640] = -128;
        byArray[1641] = -128;
        byArray[1642] = -128;
        byArray[1643] = -128;
        byArray[1644] = -128;
        byArray[1645] = -128;
        byArray[1646] = -128;
        byArray[1647] = -128;
        byArray[1648] = -128;
        byArray[1649] = -128;
        byArray[1650] = -128;
        byArray[1651] = -128;
        byArray[1652] = -128;
        byArray[1653] = -128;
        byArray[1654] = -128;
        byArray[1655] = -128;
        byArray[1656] = -128;
        byArray[1657] = -128;
        byArray[1658] = -128;
        byArray[1659] = -128;
        byArray[1660] = -128;
        byArray[1661] = -128;
        byArray[1662] = -128;
        byArray[1663] = -128;
        byArray[1664] = -128;
        byArray[1665] = -128;
        byArray[1666] = -128;
        byArray[1667] = -128;
        byArray[1668] = -128;
        byArray[1669] = -128;
        byArray[1670] = -128;
        byArray[1671] = -128;
        byArray[1672] = -128;
        byArray[1673] = -128;
        byArray[1674] = -128;
        byArray[1675] = -128;
        byArray[1676] = -128;
        byArray[1677] = -128;
        byArray[1678] = -128;
        byArray[1679] = -128;
        byArray[1680] = -128;
        byArray[1681] = -128;
        byArray[1682] = -128;
        byArray[1683] = -128;
        byArray[1684] = -128;
        byArray[1685] = -128;
        byArray[1686] = -128;
        byArray[1687] = -128;
        byArray[1688] = -128;
        byArray[1689] = -128;
        byArray[1690] = -128;
        byArray[1691] = -128;
        byArray[1692] = -128;
        byArray[1693] = -128;
        byArray[1694] = -128;
        byArray[1695] = -128;
        byArray[1696] = -128;
        byArray[1697] = -128;
        byArray[1698] = -128;
        byArray[1699] = -128;
        byArray[1700] = -128;
        byArray[1701] = -128;
        byArray[1702] = -128;
        byArray[1703] = -128;
        byArray[1704] = -128;
        byArray[1705] = -128;
        byArray[1706] = -128;
        byArray[1707] = -128;
        byArray[1708] = -128;
        byArray[1709] = -128;
        byArray[1710] = -128;
        byArray[1711] = -128;
        byArray[1712] = -128;
        byArray[1713] = -128;
        byArray[1714] = -128;
        byArray[1715] = -128;
        byArray[1716] = -128;
        byArray[1717] = -128;
        byArray[1718] = -128;
        byArray[1719] = -128;
        byArray[1720] = -128;
        byArray[1721] = -128;
        byArray[1722] = -128;
        byArray[1723] = -128;
        byArray[1724] = -128;
        byArray[1725] = -128;
        byArray[1726] = -128;
        byArray[1727] = -36;
        byArray[1728] = -128;
        byArray[1729] = -128;
        byArray[1730] = -128;
        byArray[1731] = -128;
        byArray[1732] = -128;
        byArray[1733] = -128;
        byArray[1734] = -35;
        byArray[1735] = -128;
        byArray[1736] = -128;
        byArray[1737] = -128;
        byArray[1738] = -128;
        byArray[1739] = -128;
        byArray[1740] = -34;
        byArray[1741] = -119;
        byArray[1742] = -128;
        byArray[1743] = -128;
        byArray[1744] = -128;
        byArray[1745] = -128;
        byArray[1746] = -128;
        byArray[1747] = -128;
        byArray[1748] = -128;
        byArray[1749] = -128;
        byArray[1750] = -128;
        byArray[1751] = -128;
        byArray[1752] = -128;
        byArray[1753] = -128;
        byArray[1754] = -128;
        byArray[1755] = -128;
        byArray[1756] = -128;
        byArray[1757] = -128;
        byArray[1758] = -128;
        byArray[1759] = -128;
        byArray[1760] = -128;
        byArray[1761] = -128;
        byArray[1762] = -128;
        byArray[1763] = -128;
        byArray[1764] = -128;
        byArray[1765] = -128;
        byArray[1766] = -128;
        byArray[1767] = -128;
        byArray[1768] = -128;
        byArray[1769] = -128;
        byArray[1770] = -128;
        byArray[1771] = -128;
        byArray[1772] = -128;
        byArray[1773] = -128;
        byArray[1774] = -128;
        byArray[1775] = -128;
        byArray[1776] = -128;
        byArray[1777] = -128;
        byArray[1778] = -128;
        byArray[1779] = -128;
        byArray[1780] = -128;
        byArray[1781] = -128;
        byArray[1782] = -128;
        byArray[1783] = -128;
        byArray[1784] = -128;
        byArray[1785] = -128;
        byArray[1786] = -128;
        byArray[1787] = -128;
        byArray[1788] = -128;
        byArray[1789] = -128;
        byArray[1790] = -128;
        byArray[1791] = -128;
        byArray[1792] = -128;
        byArray[1793] = -128;
        byArray[1794] = -128;
        byArray[1795] = -128;
        byArray[1796] = -128;
        byArray[1797] = -128;
        byArray[1798] = -128;
        byArray[1799] = -128;
        byArray[1800] = -128;
        byArray[1801] = -128;
        byArray[1802] = -128;
        byArray[1803] = -128;
        byArray[1804] = -128;
        byArray[1805] = -128;
        byArray[1806] = -128;
        byArray[1807] = -128;
        byArray[1808] = -128;
        byArray[1809] = -128;
        byArray[1810] = -128;
        byArray[1811] = -128;
        byArray[1812] = -128;
        byArray[1813] = -128;
        byArray[1814] = -128;
        byArray[1815] = -128;
        byArray[1816] = -128;
        byArray[1817] = -128;
        byArray[1818] = -128;
        byArray[1819] = -128;
        byArray[1820] = -128;
        byArray[1821] = -128;
        byArray[1822] = -128;
        byArray[1823] = -128;
        byArray[1824] = -128;
        byArray[1825] = -128;
        byArray[1826] = -128;
        byArray[1827] = -128;
        byArray[1828] = -128;
        byArray[1829] = -128;
        byArray[1830] = -128;
        byArray[1831] = -128;
        byArray[1832] = -128;
        byArray[1833] = -128;
        byArray[1834] = -128;
        byArray[1835] = -128;
        byArray[1836] = -128;
        byArray[1837] = -128;
        byArray[1838] = -128;
        byArray[1839] = -128;
        byArray[1840] = -128;
        byArray[1841] = -128;
        byArray[1842] = -128;
        byArray[1843] = -128;
        byArray[1844] = -128;
        byArray[1845] = -128;
        byArray[1846] = -128;
        byArray[1847] = -128;
        byArray[1848] = -128;
        byArray[1849] = -128;
        byArray[1850] = -128;
        byArray[1851] = -128;
        byArray[1852] = -128;
        byArray[1853] = -128;
        byArray[1854] = -128;
        byArray[1855] = -128;
        byArray[1856] = -128;
        byArray[1857] = -33;
        byArray[1858] = -32;
        byArray[1859] = -31;
        byArray[1860] = -128;
        byArray[1861] = -128;
        byArray[1862] = -128;
        byArray[1863] = -128;
        byArray[1864] = -128;
        byArray[1865] = -128;
        byArray[1866] = -128;
        byArray[1867] = -128;
        byArray[1868] = -128;
        byArray[1869] = -119;
        byArray[1870] = -128;
        byArray[1871] = -128;
        byArray[1872] = -128;
        byArray[1873] = -128;
        byArray[1874] = -128;
        byArray[1875] = -128;
        byArray[1876] = -128;
        byArray[1877] = -128;
        byArray[1878] = -128;
        byArray[1879] = -128;
        byArray[1880] = -128;
        byArray[1881] = -128;
        byArray[1882] = -128;
        byArray[1883] = -128;
        byArray[1884] = -128;
        byArray[1885] = -128;
        byArray[1886] = -128;
        byArray[1887] = -128;
        byArray[1888] = -128;
        byArray[1889] = -128;
        byArray[1890] = -128;
        byArray[1891] = -128;
        byArray[1892] = -128;
        byArray[1893] = -128;
        byArray[1894] = -128;
        byArray[1895] = -128;
        byArray[1896] = -128;
        byArray[1897] = -128;
        byArray[1898] = -128;
        byArray[1899] = -128;
        byArray[1900] = -128;
        byArray[1901] = -128;
        byArray[1902] = -128;
        byArray[1903] = -128;
        byArray[1904] = -128;
        byArray[1905] = -128;
        byArray[1906] = -128;
        byArray[1907] = -128;
        byArray[1908] = -128;
        byArray[1909] = -128;
        byArray[1910] = -128;
        byArray[1911] = -128;
        byArray[1912] = -128;
        byArray[1913] = -128;
        byArray[1914] = -128;
        byArray[1915] = -128;
        byArray[1916] = -128;
        byArray[1917] = -128;
        byArray[1918] = -128;
        byArray[1919] = -128;
        byArray[1920] = -128;
        byArray[1921] = -128;
        byArray[1922] = -128;
        byArray[1923] = -128;
        byArray[1924] = -128;
        byArray[1925] = -128;
        byArray[1926] = -128;
        byArray[1927] = -128;
        byArray[1928] = -128;
        byArray[1929] = -128;
        byArray[1930] = -128;
        byArray[1931] = -128;
        byArray[1932] = -128;
        byArray[1933] = -128;
        byArray[1934] = -128;
        byArray[1935] = -128;
        byArray[1936] = -128;
        byArray[1937] = -128;
        byArray[1938] = -128;
        byArray[1939] = -128;
        byArray[1940] = -128;
        byArray[1941] = -128;
        byArray[1942] = -128;
        byArray[1943] = -128;
        byArray[1944] = -128;
        byArray[1945] = -128;
        byArray[1946] = -128;
        byArray[1947] = -128;
        byArray[1948] = -128;
        byArray[1949] = -128;
        byArray[1950] = -128;
        byArray[1951] = -128;
        byArray[1952] = -128;
        byArray[1953] = -128;
        byArray[1954] = -128;
        byArray[1955] = -128;
        byArray[1956] = -128;
        byArray[1957] = -128;
        byArray[1958] = -128;
        byArray[1959] = -128;
        byArray[1960] = -128;
        byArray[1961] = -128;
        byArray[1962] = -128;
        byArray[1963] = -128;
        byArray[1964] = -128;
        byArray[1965] = -128;
        byArray[1966] = -128;
        byArray[1967] = -128;
        byArray[1968] = -128;
        byArray[1969] = -30;
        byArray[1970] = -128;
        byArray[1971] = -128;
        byArray[1972] = -29;
        byArray[1973] = -28;
        byArray[1974] = -27;
        byArray[1975] = -26;
        byArray[1976] = -25;
        byArray[1977] = -24;
        byArray[1978] = -23;
        byArray[1979] = -128;
        byArray[1980] = -128;
        byArray[1981] = -128;
        byArray[1982] = -128;
        byArray[1983] = -128;
        byArray[1984] = -128;
        byArray[1985] = -128;
        byArray[1986] = -128;
        byArray[1987] = -128;
        byArray[1988] = -128;
        byArray[1989] = -128;
        byArray[1990] = -128;
        byArray[1991] = -22;
        byArray[1992] = -21;
        byArray[1993] = -20;
        byArray[1994] = -19;
        byArray[1995] = -18;
        byArray[1996] = -17;
        byArray[1997] = -16;
        byArray[1999] = -128;
        byArray[2000] = -128;
        byArray[2001] = -128;
        byArray[2002] = -128;
        byArray[2003] = -128;
        byArray[2004] = -128;
        byArray[2005] = -128;
        byArray[2006] = -128;
        byArray[2007] = -128;
        byArray[2008] = -128;
        byArray[2009] = -128;
        byArray[2010] = -128;
        byArray[2011] = -128;
        byArray[2012] = -128;
        byArray[2013] = -128;
        byArray[2014] = -128;
        byArray[2015] = -128;
        byArray[2016] = -128;
        byArray[2017] = -128;
        byArray[2018] = -128;
        byArray[2019] = -128;
        byArray[2020] = -128;
        byArray[2021] = -128;
        byArray[2022] = -128;
        byArray[2023] = -128;
        byArray[2024] = -128;
        byArray[2025] = -128;
        byArray[2026] = -128;
        byArray[2027] = -128;
        byArray[2028] = -128;
        byArray[2029] = -128;
        byArray[2030] = -128;
        byArray[2031] = -128;
        byArray[2032] = -128;
        byArray[2033] = -128;
        byArray[2034] = -128;
        byArray[2035] = -128;
        byArray[2036] = -128;
        byArray[2037] = -128;
        byArray[2038] = -128;
        byArray[2039] = -128;
        byArray[2040] = -128;
        byArray[2041] = -128;
        byArray[2042] = -128;
        byArray[2043] = -128;
        byArray[2044] = -128;
        byArray[2045] = -128;
        byArray[2046] = -128;
        byArray[2047] = -128;
        byArray[2048] = -128;
        byArray[2049] = -128;
        byArray[2050] = -128;
        byArray[2051] = -128;
        byArray[2052] = -128;
        byArray[2053] = -128;
        byArray[2054] = -128;
        byArray[2055] = -128;
        byArray[2056] = -128;
        byArray[2057] = -128;
        byArray[2058] = -128;
        byArray[2059] = -128;
        byArray[2060] = -128;
        byArray[2061] = -128;
        byArray[2062] = -128;
        byArray[2063] = -128;
        byArray[2064] = -128;
        byArray[2065] = -128;
        byArray[2066] = -128;
        byArray[2067] = -128;
        byArray[2068] = -128;
        byArray[2069] = -128;
        byArray[2070] = -128;
        byArray[2071] = -128;
        byArray[2072] = -128;
        byArray[2073] = -128;
        byArray[2074] = -128;
        byArray[2075] = -128;
        byArray[2076] = -128;
        byArray[2077] = -128;
        byArray[2078] = -128;
        byArray[2079] = -128;
        byArray[2080] = -128;
        byArray[2081] = -128;
        byArray[2082] = -128;
        byArray[2083] = -128;
        byArray[2084] = -128;
        byArray[2085] = -128;
        byArray[2086] = -128;
        byArray[2087] = -128;
        byArray[2088] = -128;
        byArray[2089] = -128;
        byArray[2090] = -128;
        byArray[2091] = -128;
        byArray[2092] = -128;
        byArray[2093] = -128;
        byArray[2094] = -128;
        byArray[2095] = -128;
        byArray[2096] = -128;
        byArray[2097] = -15;
        byArray[2098] = -128;
        byArray[2099] = -128;
        byArray[2100] = -14;
        byArray[2101] = -13;
        byArray[2102] = -12;
        byArray[2103] = -11;
        byArray[2104] = -10;
        byArray[2105] = -9;
        byArray[2106] = -128;
        byArray[2107] = -8;
        byArray[2108] = -7;
        byArray[2109] = -128;
        byArray[2110] = -128;
        byArray[2111] = -128;
        byArray[2112] = -128;
        byArray[2113] = -128;
        byArray[2114] = -128;
        byArray[2115] = -128;
        byArray[2116] = -128;
        byArray[2117] = -128;
        byArray[2118] = -128;
        byArray[2119] = -128;
        byArray[2120] = -6;
        byArray[2121] = -5;
        byArray[2122] = -4;
        byArray[2123] = -3;
        byArray[2124] = -2;
        byArray[2125] = -1;
        byArray[2126] = -128;
        byArray[2127] = -128;
        byArray[2128] = -128;
        byArray[2129] = -128;
        byArray[2130] = -128;
        byArray[2131] = -128;
        byArray[2132] = -128;
        byArray[2133] = -128;
        byArray[2134] = -128;
        byArray[2135] = -128;
        byArray[2136] = -128;
        byArray[2137] = -128;
        byArray[2138] = -128;
        byArray[2139] = -128;
        byArray[2140] = -128;
        byArray[2141] = -128;
        byArray[2142] = -128;
        byArray[2143] = -128;
        byArray[2144] = -128;
        byArray[2145] = -128;
        byArray[2146] = -128;
        byArray[2147] = -128;
        byArray[2148] = -128;
        byArray[2149] = -128;
        byArray[2150] = -128;
        byArray[2151] = -128;
        byArray[2152] = -128;
        byArray[2153] = -128;
        byArray[2154] = -128;
        byArray[2155] = -128;
        byArray[2156] = -128;
        byArray[2157] = -128;
        byArray[2158] = -128;
        byArray[2159] = -128;
        byArray[2160] = -128;
        byArray[2161] = -128;
        byArray[2162] = -128;
        byArray[2163] = -128;
        byArray[2164] = -128;
        byArray[2165] = -128;
        byArray[2166] = -128;
        byArray[2167] = -128;
        byArray[2168] = -128;
        byArray[2169] = -128;
        byArray[2170] = -128;
        byArray[2171] = -128;
        byArray[2172] = -128;
        byArray[2173] = -128;
        byArray[2174] = -128;
        byArray[2175] = -128;
        byArray[2176] = -128;
        byArray[2177] = -128;
        byArray[2178] = -128;
        byArray[2179] = -128;
        byArray[2180] = -128;
        byArray[2181] = -128;
        byArray[2182] = -128;
        byArray[2183] = -128;
        byArray[2184] = -128;
        byArray[2185] = -128;
        byArray[2186] = -128;
        byArray[2187] = -128;
        byArray[2188] = -128;
        byArray[2189] = -128;
        byArray[2190] = -128;
        byArray[2191] = -128;
        byArray[2192] = -128;
        byArray[2193] = -128;
        byArray[2194] = -128;
        byArray[2195] = -128;
        byArray[2196] = -128;
        byArray[2197] = -128;
        byArray[2198] = -128;
        byArray[2199] = -128;
        byArray[2200] = 92;
        byArray[2201] = 92;
        byArray[2202] = -128;
        byArray[2203] = -128;
        byArray[2204] = -128;
        byArray[2205] = -128;
        byArray[2206] = -128;
        byArray[2207] = -128;
        byArray[2208] = -128;
        byArray[2209] = -128;
        byArray[2210] = -128;
        byArray[2211] = -128;
        byArray[2212] = -128;
        byArray[2213] = -128;
        byArray[2214] = -128;
        byArray[2215] = -128;
        byArray[2216] = -128;
        byArray[2217] = -128;
        byArray[2218] = -128;
        byArray[2219] = -128;
        byArray[2220] = -128;
        byArray[2221] = -128;
        byArray[2222] = -128;
        byArray[2223] = -128;
        byArray[2224] = -128;
        byArray[2225] = -128;
        byArray[2226] = -128;
        byArray[2227] = -128;
        byArray[2228] = -128;
        byArray[2229] = 102;
        byArray[2230] = -128;
        byArray[2231] = 102;
        byArray[2232] = -128;
        byArray[2233] = 88;
        byArray[2234] = -128;
        byArray[2235] = -128;
        byArray[2236] = -128;
        byArray[2237] = -128;
        byArray[2238] = 92;
        byArray[2239] = 92;
        byArray[2240] = -128;
        byArray[2241] = -128;
        byArray[2242] = -128;
        byArray[2243] = -128;
        byArray[2244] = -128;
        byArray[2245] = -128;
        byArray[2246] = -128;
        byArray[2247] = -128;
        byArray[2248] = -128;
        byArray[2249] = -128;
        byArray[2250] = -128;
        byArray[2251] = -128;
        byArray[2252] = -128;
        byArray[2253] = -128;
        byArray[2254] = -128;
        byArray[2255] = -128;
        byArray[2256] = -128;
        byArray[2257] = -128;
        byArray[2258] = -128;
        byArray[2259] = -128;
        byArray[2260] = -128;
        byArray[2261] = -128;
        byArray[2262] = -128;
        byArray[2263] = -128;
        byArray[2264] = -128;
        byArray[2265] = -128;
        byArray[2266] = -128;
        byArray[2267] = -128;
        byArray[2268] = -128;
        byArray[2269] = -128;
        byArray[2270] = -128;
        byArray[2271] = -128;
        byArray[2272] = -128;
        byArray[2273] = -128;
        byArray[2274] = -128;
        byArray[2275] = -128;
        byArray[2276] = -128;
        byArray[2277] = -128;
        byArray[2278] = -128;
        byArray[2279] = -128;
        byArray[2280] = -128;
        byArray[2281] = -128;
        byArray[2282] = -128;
        byArray[2283] = -128;
        byArray[2284] = -128;
        byArray[2285] = -128;
        byArray[2286] = -128;
        byArray[2287] = -128;
        byArray[2288] = -128;
        byArray[2289] = 1;
        byArray[2290] = 2;
        byArray[2291] = 3;
        byArray[2292] = 4;
        byArray[2293] = 5;
        byArray[2294] = 6;
        byArray[2295] = 7;
        byArray[2296] = 8;
        byArray[2297] = 9;
        byArray[2298] = 10;
        byArray[2299] = 11;
        byArray[2300] = 12;
        byArray[2301] = 13;
        byArray[2302] = 14;
        byArray[2303] = -128;
        byArray[2304] = 15;
        byArray[2305] = 16;
        byArray[2306] = 102;
        byArray[2307] = 102;
        byArray[2308] = -119;
        byArray[2309] = -128;
        byArray[2310] = 102;
        byArray[2311] = 102;
        byArray[2312] = 102;
        byArray[2313] = 102;
        byArray[2314] = 102;
        byArray[2315] = 102;
        byArray[2316] = -128;
        byArray[2317] = -128;
        byArray[2318] = -128;
        byArray[2319] = -128;
        byArray[2320] = -122;
        byArray[2321] = -122;
        byArray[2322] = -122;
        byArray[2323] = -122;
        byArray[2324] = -122;
        byArray[2325] = -122;
        byArray[2326] = -128;
        byArray[2327] = -122;
        byArray[2328] = -128;
        byArray[2329] = -122;
        byArray[2330] = -122;
        byArray[2331] = -122;
        byArray[2332] = -122;
        byArray[2333] = -122;
        byArray[2334] = -122;
        byArray[2335] = -122;
        byArray[2336] = -122;
        byArray[2337] = -122;
        byArray[2338] = -122;
        byArray[2339] = -122;
        byArray[2340] = -122;
        byArray[2341] = -122;
        byArray[2342] = -122;
        byArray[2343] = -122;
        byArray[2344] = -122;
        byArray[2345] = -122;
        byArray[2346] = -122;
        byArray[2347] = -122;
        byArray[2348] = -122;
        byArray[2349] = -122;
        byArray[2350] = -128;
        byArray[2351] = -128;
        byArray[2352] = -128;
        byArray[2353] = -122;
        byArray[2354] = -122;
        byArray[2355] = -122;
        byArray[2356] = -122;
        byArray[2357] = -122;
        byArray[2358] = -122;
        byArray[2359] = -122;
        byArray[2360] = -128;
        byArray[2361] = -122;
        byArray[2362] = -128;
        byArray[2363] = -128;
        byArray[2364] = -128;
        byArray[2365] = -128;
        byArray[2366] = -128;
        byArray[2367] = -128;
        byArray[2368] = -128;
        byArray[2369] = -128;
        byArray[2370] = -128;
        byArray[2371] = -128;
        byArray[2372] = -128;
        byArray[2373] = -128;
        byArray[2374] = -128;
        byArray[2375] = -128;
        byArray[2376] = -128;
        byArray[2377] = -128;
        byArray[2378] = -128;
        byArray[2379] = -128;
        byArray[2380] = -128;
        byArray[2381] = -128;
        byArray[2382] = -128;
        byArray[2383] = -128;
        byArray[2384] = -128;
        byArray[2385] = -128;
        byArray[2386] = -128;
        byArray[2387] = -128;
        byArray[2388] = -128;
        byArray[2389] = -128;
        byArray[2390] = -128;
        byArray[2391] = -128;
        byArray[2392] = -128;
        byArray[2393] = -128;
        byArray[2394] = -128;
        byArray[2395] = -128;
        byArray[2396] = -128;
        byArray[2397] = -128;
        byArray[2398] = -128;
        byArray[2399] = -128;
        byArray[2400] = -128;
        byArray[2401] = -128;
        byArray[2402] = -128;
        byArray[2403] = -128;
        byArray[2404] = -128;
        byArray[2405] = -128;
        byArray[2406] = -128;
        byArray[2407] = -128;
        byArray[2408] = -128;
        byArray[2409] = -128;
        byArray[2410] = -128;
        byArray[2411] = -128;
        byArray[2412] = -128;
        byArray[2413] = -128;
        byArray[2414] = -128;
        byArray[2415] = -128;
        byArray[2416] = -128;
        byArray[2417] = -128;
        byArray[2418] = -128;
        byArray[2419] = -128;
        byArray[2420] = -128;
        byArray[2421] = -128;
        byArray[2422] = -128;
        byArray[2423] = -128;
        byArray[2424] = -128;
        byArray[2425] = -128;
        byArray[2426] = -128;
        byArray[2427] = -128;
        byArray[2428] = -128;
        byArray[2429] = -128;
        byArray[2430] = -128;
        byArray[2431] = -128;
        byArray[2432] = -128;
        byArray[2433] = -128;
        byArray[2434] = -128;
        byArray[2435] = -128;
        byArray[2436] = -128;
        byArray[2437] = -128;
        byArray[2438] = -128;
        byArray[2439] = -128;
        byArray[2440] = -128;
        byArray[2441] = -128;
        byArray[2442] = -128;
        byArray[2443] = -128;
        byArray[2444] = -128;
        byArray[2445] = -128;
        byArray[2446] = -128;
        byArray[2447] = -128;
        byArray[2448] = -128;
        byArray[2449] = -128;
        byArray[2450] = -128;
        byArray[2451] = -128;
        byArray[2452] = -128;
        byArray[2453] = -128;
        byArray[2454] = -128;
        byArray[2455] = -128;
        byArray[2456] = -128;
        byArray[2457] = -128;
        byArray[2458] = -128;
        byArray[2459] = -128;
        byArray[2460] = -128;
        byArray[2461] = -128;
        byArray[2462] = -128;
        byArray[2463] = -128;
        byArray[2464] = -128;
        byArray[2465] = -128;
        byArray[2466] = -128;
        byArray[2467] = -128;
        byArray[2468] = -128;
        byArray[2469] = -128;
        byArray[2470] = -128;
        byArray[2471] = -128;
        byArray[2472] = -128;
        byArray[2473] = -128;
        byArray[2474] = -128;
        byArray[2475] = -128;
        byArray[2476] = -128;
        byArray[2477] = -128;
        byArray[2478] = -128;
        byArray[2479] = -128;
        byArray[2480] = -128;
        byArray[2481] = -128;
        byArray[2482] = -128;
        byArray[2483] = -128;
        byArray[2484] = -128;
        byArray[2485] = -128;
        byArray[2486] = -128;
        byArray[2487] = -128;
        byArray[2488] = -128;
        byArray[2489] = -128;
        byArray[2490] = -128;
        byArray[2491] = -128;
        byArray[2492] = -128;
        byArray[2493] = -128;
        byArray[2494] = -128;
        byArray[2495] = -128;
        byArray[2496] = -128;
        byArray[2497] = -128;
        byArray[2498] = -128;
        byArray[2499] = -128;
        byArray[2500] = -128;
        byArray[2501] = -128;
        byArray[2502] = -128;
        byArray[2503] = -128;
        byArray[2504] = -128;
        byArray[2505] = -128;
        byArray[2506] = -128;
        byArray[2507] = -128;
        byArray[2508] = -128;
        byArray[2509] = -128;
        byArray[2510] = -128;
        byArray[2511] = -128;
        byArray[2512] = 102;
        byArray[2513] = 102;
        byArray[2514] = -127;
        byArray[2515] = -127;
        byArray[2516] = 102;
        byArray[2517] = 102;
        byArray[2518] = 102;
        byArray[2519] = 102;
        byArray[2520] = -127;
        byArray[2521] = -127;
        byArray[2522] = -127;
        byArray[2523] = 102;
        byArray[2524] = 102;
        byArray[2525] = -128;
        byArray[2526] = -128;
        byArray[2527] = -128;
        byArray[2528] = -128;
        byArray[2529] = -127;
        byArray[2530] = -128;
        byArray[2531] = -128;
        byArray[2532] = -128;
        byArray[2533] = -128;
        byArray[2534] = -128;
        byArray[2535] = -128;
        byArray[2536] = -128;
        byArray[2537] = -128;
        byArray[2538] = -128;
        byArray[2539] = -128;
        byArray[2540] = -128;
        byArray[2541] = -128;
        byArray[2542] = -128;
        byArray[2543] = -128;
        byArray[2544] = -128;
        byArray[2545] = -128;
        byArray[2546] = -128;
        byArray[2547] = -128;
        byArray[2548] = -128;
        byArray[2549] = -128;
        byArray[2550] = -128;
        byArray[2551] = -128;
        byArray[2552] = -128;
        byArray[2553] = -128;
        byArray[2554] = -128;
        byArray[2555] = -128;
        byArray[2556] = -128;
        byArray[2557] = -128;
        byArray[2558] = -128;
        byArray[2559] = -128;
        byArray[2560] = -128;
        byArray[2561] = -128;
        byArray[2562] = -128;
        byArray[2563] = -128;
        byArray[2564] = -128;
        byArray[2565] = -128;
        byArray[2566] = -128;
        byArray[2567] = -128;
        byArray[2568] = -128;
        byArray[2569] = -128;
        byArray[2570] = -128;
        byArray[2571] = -128;
        byArray[2572] = -128;
        byArray[2573] = -128;
        byArray[2574] = -128;
        byArray[2575] = -128;
        byArray[2576] = -128;
        byArray[2577] = -128;
        byArray[2578] = -128;
        byArray[2579] = -128;
        byArray[2580] = -128;
        byArray[2581] = -128;
        byArray[2582] = -128;
        byArray[2583] = -128;
        byArray[2584] = -128;
        byArray[2585] = -128;
        byArray[2586] = -128;
        byArray[2587] = -128;
        byArray[2588] = -128;
        byArray[2589] = -128;
        byArray[2590] = -128;
        byArray[2591] = -128;
        byArray[2592] = -128;
        byArray[2593] = -128;
        byArray[2594] = -128;
        byArray[2595] = -128;
        byArray[2596] = -128;
        byArray[2597] = -128;
        byArray[2598] = -128;
        byArray[2599] = -128;
        byArray[2600] = -128;
        byArray[2601] = -128;
        byArray[2602] = 90;
        byArray[2603] = 100;
        byArray[2604] = 104;
        byArray[2605] = 94;
        byArray[2606] = 96;
        byArray[2607] = 96;
        byArray[2608] = -128;
        byArray[2609] = -128;
        byArray[2610] = -128;
        byArray[2611] = -128;
        byArray[2612] = -128;
        byArray[2613] = -128;
        byArray[2614] = -128;
        byArray[2615] = -128;
        byArray[2616] = -128;
        byArray[2617] = -128;
        byArray[2618] = -128;
        byArray[2619] = -128;
        byArray[2620] = -128;
        byArray[2621] = -128;
        byArray[2622] = -128;
        byArray[2623] = -128;
        byArray[2624] = -128;
        byArray[2625] = -128;
        byArray[2626] = -128;
        byArray[2627] = -128;
        byArray[2628] = -128;
        byArray[2629] = -128;
        byArray[2630] = -128;
        byArray[2631] = -128;
        byArray[2632] = -128;
        byArray[2633] = -128;
        byArray[2634] = -128;
        byArray[2635] = -128;
        byArray[2636] = -128;
        byArray[2637] = -128;
        byArray[2638] = -128;
        byArray[2639] = -128;
        byArray[2640] = -128;
        byArray[2641] = -128;
        byArray[2642] = -128;
        byArray[2643] = -128;
        byArray[2644] = -128;
        byArray[2645] = -128;
        byArray[2646] = -128;
        byArray[2647] = -128;
        byArray[2648] = -128;
        byArray[2649] = -128;
        byArray[2650] = -128;
        byArray[2651] = -128;
        byArray[2652] = -128;
        byArray[2653] = -128;
        byArray[2654] = -128;
        byArray[2655] = -128;
        byArray[2656] = -128;
        byArray[2657] = -128;
        byArray[2658] = -128;
        byArray[2659] = -128;
        byArray[2660] = -128;
        byArray[2661] = -128;
        byArray[2662] = -128;
        byArray[2663] = -128;
        byArray[2664] = -128;
        byArray[2665] = -128;
        byArray[2666] = -128;
        byArray[2667] = -128;
        byArray[2668] = -128;
        byArray[2669] = -128;
        byArray[2670] = -128;
        byArray[2671] = -128;
        byArray[2672] = -128;
        byArray[2673] = -128;
        byArray[2674] = -128;
        byArray[2675] = -128;
        byArray[2676] = -128;
        byArray[2677] = -128;
        byArray[2678] = -128;
        byArray[2679] = -128;
        byArray[2680] = -128;
        byArray[2681] = -128;
        byArray[2682] = -128;
        byArray[2683] = -128;
        byArray[2684] = -128;
        byArray[2685] = -128;
        byArray[2686] = -128;
        byArray[2687] = -128;
        byArray[2688] = -128;
        byArray[2689] = -128;
        byArray[2690] = -128;
        byArray[2691] = -128;
        byArray[2692] = -128;
        byArray[2693] = -128;
        byArray[2694] = -128;
        byArray[2695] = -128;
        byArray[2696] = -128;
        byArray[2697] = -128;
        byArray[2698] = -128;
        byArray[2699] = -128;
        byArray[2700] = -128;
        byArray[2701] = -128;
        byArray[2702] = -128;
        byArray[2703] = -128;
        byArray[2704] = -128;
        byArray[2705] = -128;
        byArray[2706] = -128;
        byArray[2707] = -128;
        byArray[2708] = -128;
        byArray[2709] = -128;
        byArray[2710] = -128;
        byArray[2711] = -128;
        byArray[2712] = -128;
        byArray[2713] = -120;
        byArray[2714] = -120;
        byArray[2715] = -128;
        byArray[2716] = -128;
        byArray[2717] = -128;
        byArray[2718] = -128;
        byArray[2719] = -128;
        byArray[2720] = -128;
        byArray[2721] = -128;
        byArray[2722] = -128;
        byArray[2723] = -128;
        byArray[2724] = -128;
        byArray[2725] = -128;
        byArray[2726] = -128;
        byArray[2727] = -128;
        byArray[2728] = -128;
        byArray[2729] = -128;
        byArray[2730] = -128;
        byArray[2731] = -128;
        byArray[2732] = -128;
        byArray[2733] = -128;
        byArray[2734] = -128;
        byArray[2735] = -128;
        byArray[2736] = -128;
        byArray[2737] = -128;
        byArray[2738] = -128;
        byArray[2739] = -128;
        byArray[2740] = -128;
        byArray[2741] = -128;
        byArray[2742] = -128;
        byArray[2743] = -128;
        byArray[2744] = -128;
        byArray[2745] = -128;
        byArray[2746] = -128;
        byArray[2747] = -128;
        byArray[2748] = -128;
        byArray[2749] = -128;
        byArray[2750] = -128;
        byArray[2751] = -128;
        byArray[2752] = -128;
        byArray[2753] = -128;
        byArray[2754] = -128;
        byArray[2755] = -128;
        byArray[2756] = -128;
        byArray[2757] = -128;
        byArray[2758] = -128;
        byArray[2759] = -128;
        byArray[2760] = -128;
        byArray[2761] = -128;
        byArray[2762] = -128;
        byArray[2763] = -128;
        byArray[2764] = -128;
        byArray[2765] = -128;
        byArray[2766] = -128;
        byArray[2767] = -128;
        byArray[2768] = -128;
        byArray[2769] = -128;
        byArray[2770] = -128;
        byArray[2771] = -128;
        byArray[2772] = -128;
        byArray[2773] = -128;
        byArray[2774] = -128;
        byArray[2775] = -128;
        byArray[2776] = -128;
        byArray[2777] = -128;
        byArray[2778] = -128;
        byArray[2779] = -128;
        byArray[2780] = -128;
        byArray[2781] = -128;
        byArray[2782] = -128;
        byArray[2783] = -128;
        byArray[2784] = -128;
        byArray[2785] = -128;
        byArray[2786] = -128;
        byArray[2787] = -128;
        byArray[2788] = -128;
        byArray[2789] = -128;
        byArray[2790] = -128;
        byArray[2791] = -128;
        byArray[2792] = -128;
        byArray[2793] = -128;
        byArray[2794] = -128;
        byArray[2795] = -128;
        byArray[2796] = -128;
        byArray[2797] = -128;
        byArray[2798] = -128;
        byArray[2799] = -128;
        byArray[2800] = -128;
        byArray[2801] = -128;
        byArray[2802] = -128;
        byArray[2803] = -128;
        byArray[2804] = -128;
        byArray[2805] = -128;
        byArray[2806] = -128;
        byArray[2807] = -128;
        byArray[2808] = -128;
        byArray[2809] = -128;
        byArray[2810] = -128;
        byArray[2811] = -128;
        byArray[2812] = -128;
        byArray[2813] = -128;
        byArray[2814] = -128;
        byArray[2815] = -128;
        byArray[2816] = -128;
        byArray[2817] = -128;
        byArray[2818] = -128;
        byArray[2819] = -128;
        byArray[2820] = -128;
        byArray[2821] = -128;
        byArray[2822] = -128;
        byArray[2823] = -128;
        byArray[2824] = -128;
        byArray[2825] = -128;
        byArray[2826] = -128;
        byArray[2827] = -128;
        byArray[2828] = -128;
        byArray[2829] = -128;
        byArray[2830] = -128;
        byArray[2831] = -128;
        byArray[2832] = -128;
        byArray[2833] = -128;
        byArray[2834] = -128;
        byArray[2835] = -128;
        byArray[2836] = -128;
        byArray[2837] = -128;
        byArray[2838] = -128;
        byArray[2839] = -128;
        byArray[2840] = -128;
        byArray[2841] = -128;
        byArray[2842] = -128;
        byArray[2843] = -128;
        byArray[2844] = -128;
        byArray[2845] = -128;
        byArray[2846] = -102;
        byArray[2847] = -128;
        byArray[2848] = -128;
        byArray[2849] = -128;
        byArray[2850] = -128;
        byArray[2851] = -128;
        byArray[2852] = -128;
        byArray[2853] = -128;
        byArray[2854] = -128;
        byArray[2855] = -128;
        byArray[2856] = -128;
        byArray[2857] = -128;
        byArray[2858] = -128;
        byArray[2859] = -128;
        byArray[2860] = -128;
        byArray[2861] = -128;
        byArray[2862] = -128;
        byArray[2863] = -128;
        byArray[2864] = -128;
        byArray[2865] = -128;
        byArray[2866] = -128;
        byArray[2867] = -128;
        byArray[2868] = -128;
        byArray[2869] = -128;
        byArray[2870] = -128;
        byArray[2871] = -128;
        byArray[2872] = -128;
        byArray[2873] = -128;
        byArray[2874] = -128;
        byArray[2875] = -128;
        byArray[2876] = -128;
        byArray[2877] = -128;
        byArray[2878] = -128;
        byArray[2879] = -128;
        byArray[2880] = -128;
        byArray[2881] = -128;
        byArray[2882] = -128;
        byArray[2883] = -128;
        byArray[2884] = -128;
        byArray[2885] = -128;
        byArray[2886] = -128;
        byArray[2887] = -128;
        byArray[2888] = -128;
        byArray[2889] = -128;
        byArray[2890] = -128;
        byArray[2891] = -128;
        byArray[2892] = -128;
        byArray[2893] = -128;
        byArray[2894] = -128;
        byArray[2895] = -128;
        byArray[2896] = -128;
        byArray[2897] = -128;
        byArray[2898] = -128;
        byArray[2899] = -128;
        byArray[2900] = -128;
        byArray[2901] = -128;
        byArray[2902] = -128;
        byArray[2903] = -128;
        byArray[2904] = -128;
        byArray[2905] = -128;
        byArray[2906] = -128;
        byArray[2907] = -128;
        byArray[2908] = -128;
        byArray[2909] = -128;
        byArray[2910] = -128;
        byArray[2911] = -128;
        byArray[2912] = -128;
        byArray[2913] = -128;
        byArray[2914] = -128;
        byArray[2915] = -128;
        byArray[2916] = -128;
        byArray[2917] = -128;
        byArray[2918] = -128;
        byArray[2919] = -128;
        byArray[2920] = -128;
        byArray[2921] = -128;
        byArray[2922] = -128;
        byArray[2923] = -128;
        byArray[2924] = -128;
        byArray[2925] = -128;
        byArray[2926] = -128;
        byArray[2927] = -128;
        byArray[2928] = -128;
        byArray[2929] = -128;
        byArray[2930] = -128;
        byArray[2931] = -128;
        byArray[2932] = -128;
        byArray[2933] = -128;
        byArray[2934] = -128;
        byArray[2935] = -128;
        byArray[2936] = -128;
        byArray[2937] = -128;
        byArray[2938] = -128;
        byArray[2939] = -128;
        byArray[2940] = -128;
        byArray[2941] = -128;
        byArray[2942] = -128;
        byArray[2943] = -128;
        byArray[2944] = -128;
        byArray[2945] = -128;
        byArray[2946] = -128;
        byArray[2947] = -128;
        byArray[2948] = -128;
        byArray[2949] = -128;
        byArray[2950] = -128;
        byArray[2951] = -128;
        byArray[2952] = -128;
        byArray[2953] = -128;
        byArray[2954] = -128;
        byArray[2955] = -128;
        byArray[2956] = -128;
        byArray[2957] = -128;
        byArray[2958] = -128;
        byArray[2959] = -128;
        byArray[2960] = -128;
        byArray[2961] = -128;
        byArray[2962] = -128;
        byArray[2963] = -128;
        byArray[2964] = -128;
        byArray[2965] = -128;
        byArray[2966] = -128;
        byArray[2967] = -128;
        byArray[2968] = -128;
        byArray[2969] = -128;
        byArray[2970] = -128;
        byArray[2971] = -128;
        byArray[2972] = -128;
        byArray[2973] = -128;
        byArray[2974] = -128;
        byArray[2975] = -128;
        byArray[2976] = 102;
        byArray[2977] = 102;
        byArray[2978] = 102;
        byArray[2979] = 102;
        byArray[2980] = -128;
        byArray[2981] = -128;
        byArray[2982] = -128;
        byArray[2983] = -128;
        byArray[2984] = -128;
        byArray[2985] = -128;
        byArray[2986] = -128;
        byArray[2987] = -128;
        byArray[2988] = -128;
        byArray[2989] = -128;
        byArray[2990] = -128;
        byArray[2991] = -128;
        byArray[2992] = -128;
        byArray[2993] = -128;
        byArray[2994] = -128;
        byArray[2995] = -128;
        byArray[2996] = -128;
        byArray[2997] = -128;
        byArray[2998] = -128;
        byArray[2999] = -128;
        byArray[3000] = -128;
        byArray[3001] = -128;
        byArray[3002] = -128;
        byArray[3003] = -128;
        byArray[3004] = -128;
        byArray[3005] = -128;
        byArray[3006] = -128;
        byArray[3007] = -128;
        byArray[3008] = -128;
        byArray[3009] = -128;
        byArray[3010] = -128;
        byArray[3011] = -128;
        byArray[3012] = -128;
        byArray[3013] = -128;
        byArray[3014] = -128;
        byArray[3015] = -128;
        byArray[3016] = -128;
        byArray[3017] = -128;
        byArray[3018] = -128;
        byArray[3019] = -128;
        byArray[3020] = -128;
        byArray[3021] = -128;
        byArray[3022] = -128;
        byArray[3023] = -128;
        byArray[3024] = -128;
        byArray[3025] = -128;
        byArray[3026] = -128;
        byArray[3027] = -128;
        byArray[3028] = -128;
        byArray[3029] = -128;
        byArray[3030] = -128;
        byArray[3031] = -128;
        byArray[3032] = -128;
        byArray[3033] = -128;
        byArray[3034] = -128;
        byArray[3035] = -128;
        byArray[3036] = -128;
        byArray[3037] = -128;
        byArray[3038] = -128;
        byArray[3039] = -128;
        byArray[3040] = -128;
        byArray[3041] = -128;
        byArray[3042] = -128;
        byArray[3043] = -128;
        byArray[3044] = -128;
        byArray[3045] = -128;
        byArray[3046] = -128;
        byArray[3047] = -128;
        byArray[3048] = -128;
        byArray[3049] = -128;
        byArray[3050] = -128;
        byArray[3051] = -128;
        byArray[3052] = -128;
        byArray[3053] = -128;
        byArray[3054] = -128;
        byArray[3055] = -128;
        byArray[3056] = -128;
        byArray[3057] = -128;
        byArray[3058] = -128;
        byArray[3059] = -128;
        byArray[3060] = -128;
        byArray[3061] = -128;
        byArray[3062] = -128;
        byArray[3063] = -128;
        byArray[3064] = -128;
        byArray[3065] = -128;
        byArray[3066] = -128;
        byArray[3067] = -128;
        byArray[3068] = -128;
        byArray[3069] = -128;
        byArray[3070] = -128;
        byArray[3071] = -128;
        kCanonicalValues = byArray;
        contents = "A\u0300\u0000A\u0301\u0000A\u0302\u0000A\u0303\u0000A\u0308\u0000A\u030a\u0000C\u0327\u0000D\u0335\u0000E\u0300\u0000E\u0301\u0000E\u0302\u0000E\u0308\u0000H\u0335\u0000I\u0300\u0000I\u0301\u0000I\u0302\u0000I\u0308\u0000L\u0337\u0000N\u0303\u0000O\u0300\u0000O\u0301\u0000O\u0302\u0000O\u0303\u0000O\u0308\u0000O\u0338\u0000T\u0335\u0000U\u0300\u0000U\u0301\u0000U\u0302\u0000U\u0308\u0000Y\u0301\u0000a\u0300\u0000a\u0301\u0000a\u0302\u0000a\u0303\u0000a\u0308\u0000a\u030a\u0000c\u0327\u0000d\u0335\u0000e\u0300\u0000e\u0301\u0000e\u0302\u0000e\u0308\u0000h\u0335\u0000i\u0300\u0000i\u0301\u0000i\u0302\u0000i\u0308\u0000l\u0337\u0000n\u0303\u0000o\u0300\u0000o\u0301\u0000o\u0302\u0000o\u0303\u0000o\u0308\u0000o\u0338\u0000t\u0335\u0000u\u0300\u0000u\u0301\u0000u\u0302\u0000u\u0308\u0000y\u0301\u0000y\u0308\u0000A\u0304\u0000a\u0304\u0000A\u0306\u0000a\u0306\u0000A\u0328\u0000a\u0328\u0000C\u0301\u0000c\u0301\u0000C\u0302\u0000c\u0302\u0000C\u0307\u0000c\u0307\u0000C\u030c\u0000c\u030c\u0000D\u030c\u0000d\u030c\u0000E\u0304\u0000e\u0304\u0000E\u0306\u0000e\u0306\u0000E\u0307\u0000e\u0307\u0000E\u0328\u0000e\u0328\u0000E\u030c\u0000e\u030c\u0000G\u0302\u0000g\u0302\u0000G\u0306\u0000g\u0306\u0000G\u0307\u0000g\u0307\u0000G\u0327\u0000g\u0327\u0000H\u0302\u0000h\u0302\u0000I\u0303\u0000i\u0303\u0000I\u0304\u0000i\u0304\u0000I\u0306\u0000i\u0306\u0000I\u0328\u0000i\u0328\u0000I\u0307\u0000J\u0302\u0000j\u0302\u0000K\u0327\u0000k\u0327\u0000L\u0301\u0000l\u0301\u0000L\u0327\u0000l\u0327\u0000L\u030c\u0000l\u030c\u0000N\u0301\u0000n\u0301\u0000N\u0327\u0000n\u0327\u0000N\u030c\u0000n\u030c\u0000O\u0304\u0000o\u0304\u0000O\u0306\u0000o\u0306\u0000O\u030b\u0000o\u030b\u0000R\u0301\u0000r\u0301\u0000R\u0327\u0000r\u0327\u0000R\u030c\u0000r\u030c\u0000S\u0301\u0000s\u0301\u0000S\u0302\u0000s\u0302\u0000S\u0327\u0000s\u0327\u0000S\u030c\u0000s\u030c\u0000T\u0327\u0000t\u0327\u0000T\u030c\u0000t\u030c\u0000U\u0303\u0000u\u0303\u0000U\u0304\u0000u\u0304\u0000U\u0306\u0000u\u0306\u0000U\u030a\u0000u\u030a\u0000U\u030b\u0000u\u030b\u0000U\u0328\u0000u\u0328\u0000W\u0302\u0000w\u0302\u0000Y\u0302\u0000y\u0302\u0000Y\u0308\u0000Z\u0301\u0000z\u0301\u0000Z\u0307\u0000z\u0307\u0000Z\u030c\u0000z\u030c\u0000O\u031b\u0000o\u031b\u0000U\u031b\u0000u\u031b\u0000A\u030c\u0000a\u030c\u0000I\u030c\u0000i\u030c\u0000O\u030c\u0000o\u030c\u0000U\u030c\u0000u\u030c\u0000U\u0308\u0304\u0000u\u0308\u0304\u0000U\u0308\u0301\u0000u\u0308\u0301\u0000U\u0308\u030c\u0000u\u0308\u030c\u0000U\u0308\u0300\u0000u\u0308\u0300\u0000A\u0308\u0304\u0000a\u0308\u0304\u0000A\u0307\u0304\u0000a\u0307\u0304\u0000\u00c6\u0304\u0000\u00e6\u0304\u0000G\u030c\u0000g\u030c\u0000K\u030c\u0000k\u030c\u0000O\u0328\u0000o\u0328\u0000O\u0328\u0304\u0000o\u0328\u0304\u0000\u01b7\u030c\u0000\u0292\u030c\u0000j\u030c\u0000G\u0301\u0000g\u0301\u0000A\u030a\u0301\u0000a\u030a\u0301\u0000\u00c6\u0301\u0000\u00e6\u0301\u0000\u00d8\u0301\u0000\u00f8\u0301\u0000A\u030f\u0000a\u030f\u0000A\u0311\u0000a\u0311\u0000E\u030f\u0000e\u030f\u0000E\u0311\u0000e\u0311\u0000I\u030f\u0000i\u030f\u0000I\u0311\u0000i\u0311\u0000O\u030f\u0000o\u030f\u0000O\u0311\u0000o\u0311\u0000R\u030f\u0000r\u030f\u0000R\u0311\u0000r\u0311\u0000U\u030f\u0000u\u030f\u0000U\u0311\u0000u\u0311\u0000 \u0302\u0000 \u0332\u0000 \u0300\u0000 \u0000 \u0308\u0000a\u0000 \u0304\u00002\u00003\u0000 \u0301\u0000\u03bc\u0000 \u0327\u00001\u0000o\u00001\u20444\u00001\u20442\u00003\u20444\u0000IJ\u0000ij\u0000L\u00b7\u0000l\u00b7\u0000\u02bcn\u0000s\u0000DZ\u030c\u0000Dz\u030c\u0000dz\u030c\u0000LJ\u0000Lj\u0000lj\u0000NJ\u0000Nj\u0000nj\u0000DZ\u0000Dz\u0000dz\u0000h\u0000\u0266\u0000j\u0000r\u0000\u0279\u0000\u027b\u0000\u0281\u0000w\u0000y\u0000 \u0306\u0000 \u0307\u0000 \u030a\u0000 \u0328\u0000 \u0303\u0000 \u030b\u0000\u0263\u0000l\u0000s\u0000x\u0000\u0295\u0000Fr\u0000";
        maximumDecomposition = 888;
        maximumCanonical = 736;
        startOffsets = new CompactShortArray(kOffsetIndex, kOffsetValues);
        canonicals = new CompactByteArray(kCanonicalIndex, kCanonicalValues);
    }
}

