/*
 * Decompiled with CFR 0.152.
 */
package sun.audio;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import sun.audio.InvalidAudioFormatException;

public class NativeAudioStream
extends FilterInputStream {
    private final int SUN_MAGIC = 779316836;
    private final int DEC_MAGIC = 779314176;
    private final int MINHDRSIZE = 24;
    private final int TYPE_ULAW = 1;
    private int length;

    public NativeAudioStream(InputStream inputStream) throws IOException {
        super(inputStream);
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n = dataInputStream.readInt();
        if (n != 779316836 && n != 779314176) {
            System.out.println("NativeAudioStream: invalid file type.");
            throw new InvalidAudioFormatException();
        }
        int n2 = dataInputStream.readInt();
        if (n2 < 24) {
            System.out.println("NativeAudioStream: wrong header size of " + n2 + ".");
            throw new InvalidAudioFormatException();
        }
        this.length = dataInputStream.readInt();
        int n3 = dataInputStream.readInt();
        if (n3 != 1) {
            System.out.println("NativeAudioStream: invalid audio encoding.");
            throw new InvalidAudioFormatException();
        }
        int n4 = dataInputStream.readInt();
        if (n4 / 1000 != 8) {
            System.out.println("NativeAudioStream: invalid sample rate of " + n4 + ".");
            throw new InvalidAudioFormatException();
        }
        int n5 = dataInputStream.readInt();
        if (n5 != 1) {
            System.out.println("NativeAudioStream: wrong number of channels. (wanted 1, actual " + n5 + ")");
            throw new InvalidAudioFormatException();
        }
        inputStream.skip(n2 - 24);
    }

    public int getLength() {
        return this.length;
    }
}

