/*
 * Decompiled with CFR 0.152.
 */
package java.text;

final class DigitList
implements Cloneable {
    public static final int MAX_COUNT = 19;
    public static final int DBL_DIG = 17;
    public int decimalAt;
    public int count;
    public byte[] digits = new byte[19];
    private static final boolean DEBUG = false;
    private static byte[] LONG_MIN_REP;
    private static final double LOG10;

    boolean isZero() {
        int n = 0;
        while (n < this.count) {
            if (this.digits[n] != 48) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void clear() {
        this.decimalAt = 0;
        this.count = 0;
    }

    public void append(int n) {
        if (this.count < 19) {
            this.digits[this.count++] = (byte)n;
        }
    }

    public final double getDouble() {
        if (this.count == 0) {
            return 0.0;
        }
        StringBuffer stringBuffer = new StringBuffer(this.count);
        stringBuffer.append('.');
        int n = 0;
        while (n < this.count) {
            stringBuffer.append((char)this.digits[n]);
            ++n;
        }
        stringBuffer.append('E');
        stringBuffer.append(Integer.toString(this.decimalAt));
        return Double.valueOf(new String(stringBuffer));
    }

    public final long getLong() {
        if (this.count == 0) {
            return 0L;
        }
        if (this.isLongMIN_VALUE()) {
            return Long.MIN_VALUE;
        }
        StringBuffer stringBuffer = new StringBuffer(this.count);
        int n = 0;
        while (n < this.decimalAt) {
            stringBuffer.append(n < this.count ? (char)this.digits[n] : (char)'0');
            ++n;
        }
        String string = new String(stringBuffer);
        return Long.parseLong(string, 10);
    }

    boolean fitsIntoLong(boolean bl) {
        while (this.count > 0 && this.digits[this.count - 1] == 48) {
            --this.count;
        }
        if (this.count == 0) {
            return true;
        }
        if (this.decimalAt < this.count || this.decimalAt > 19) {
            return false;
        }
        if (this.decimalAt < 19) {
            return true;
        }
        int n = 0;
        while (n < this.count) {
            byte by = this.digits[n];
            byte by2 = LONG_MIN_REP[n];
            if (by > by2) {
                return false;
            }
            if (by < by2) {
                return true;
            }
            ++n;
        }
        if (this.count < this.decimalAt) {
            return true;
        }
        return !bl;
    }

    public final void set(double d, int n) {
        this.set(d, n, true);
    }

    final void set(double d, int n, boolean bl) {
        String string = Double.toString(d);
        this.decimalAt = -1;
        this.count = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl2 = false;
        int n4 = 0;
        while (n4 < string.length()) {
            char c = string.charAt(n4);
            if (c == '.') {
                this.decimalAt = this.count;
            } else {
                if (c == 'e' || c == 'E') {
                    String string2 = string.substring(n4 + 1);
                    n2 = new Integer(Integer.parseInt(string2, 10));
                    break;
                }
                if (this.count < 19) {
                    if (!bl2) {
                        boolean bl3 = bl2 = c != '0';
                        if (!bl2 && this.decimalAt != -1) {
                            ++n3;
                        }
                    }
                    if (bl2) {
                        this.digits[this.count++] = (byte)c;
                    }
                }
            }
            ++n4;
        }
        if (this.decimalAt == -1) {
            this.decimalAt = this.count;
        }
        this.decimalAt += n2 - n3;
        if (bl && -this.decimalAt >= n) {
            this.count = 0;
        }
        while (this.count > 1 && this.digits[this.count - 1] == 48) {
            --this.count;
        }
        this.round(bl ? n + this.decimalAt : n);
    }

    private final void round(int n) {
        if (n >= 0 && n < this.count) {
            if (this.digits[n] == 53 && this.digits[n - 1] != 57 && (n + 1 >= this.count || this.digits[n + 1] == 48)) {
                if (this.digits[n - 1] % 2 != 0) {
                    int n2 = n - 1;
                    this.digits[n2] = (byte)(this.digits[n2] + 1);
                }
            } else if (this.digits[n] >= 53) {
                do {
                    if (--n < 0) {
                        this.digits[0] = 49;
                        ++this.decimalAt;
                        n = 0;
                        break;
                    }
                    int n3 = n;
                    this.digits[n3] = (byte)(this.digits[n3] + 1);
                } while (this.digits[n] > 57);
                ++n;
            }
            this.count = n;
        }
    }

    public final void set(long l) {
        this.set(l, 0);
    }

    public final void set(long l, int n) {
        String string = Long.toString(l, 10);
        if (string.charAt(0) == '-') {
            string = string.substring(1);
        }
        this.count = this.decimalAt = string.length();
        while (this.count > 1 && string.charAt(this.count - 1) == '0') {
            --this.count;
        }
        int n2 = 0;
        while (n2 < this.count) {
            this.digits[n2] = (byte)string.charAt(n2);
            ++n2;
        }
        if (n > 0) {
            this.round(n);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DigitList)) {
            return false;
        }
        DigitList digitList = (DigitList)object;
        if (this.count != digitList.count || this.decimalAt != digitList.decimalAt) {
            return false;
        }
        int n = 0;
        while (n < this.count) {
            if (this.digits[n] != digitList.digits[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        int n = this.decimalAt;
        int n2 = 0;
        while (n2 < this.count) {
            n = n * 37 + this.digits[n2];
            ++n2;
        }
        return n;
    }

    private boolean isLongMIN_VALUE() {
        if (this.decimalAt != this.count || this.count != 19) {
            return false;
        }
        int n = 0;
        while (n < this.count) {
            if (this.digits[n] != LONG_MIN_REP[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static final int log10(double d) {
        double d2 = Math.log(d) / LOG10;
        int n = (int)Math.floor(d2);
        if (d2 > 0.0 && d >= Math.pow(10.0, n + 1)) {
            ++n;
        } else if (d2 < 0.0 && d < Math.pow(10.0, n)) {
            --n;
        }
        return n;
    }

    public String toString() {
        if (this.isZero()) {
            return "0";
        }
        StringBuffer stringBuffer = new StringBuffer("0.");
        int n = 0;
        while (n < this.count) {
            stringBuffer.append((char)this.digits[n]);
            ++n;
        }
        stringBuffer.append("x10^");
        int n2 = this.decimalAt;
        stringBuffer.append(Integer.toString(n2, 10));
        return new String(stringBuffer);
    }

    DigitList() {
    }

    static {
        String string = Long.toString(Long.MIN_VALUE);
        LONG_MIN_REP = new byte[19];
        int n = 0;
        while (n < 19) {
            DigitList.LONG_MIN_REP[n] = (byte)string.charAt(n + 1);
            ++n;
        }
        LOG10 = Math.log(10.0);
    }
}

