/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Hashtable;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

class TimeZoneData {
    static final int MAXIMUM_ZONES_PER_OFFSET = 13;
    private static final int millisPerHour = 3600000;
    static SimpleTimeZone[] zones = new SimpleTimeZone[]{new SimpleTimeZone(-39600000, "Pacific/Apia"), new SimpleTimeZone(-36000000, "Pacific/Honolulu"), new SimpleTimeZone(-32400000, "America/Anchorage", 3, 1, -1, 0x6DDD00, 9, -1, 1, 0x6DDD00, 3600000), new SimpleTimeZone(-28800000, "America/Los_Angeles", 3, 1, -1, 0x6DDD00, 9, -1, 1, 0x6DDD00, 3600000), new SimpleTimeZone(-25200000, "America/Phoenix"), new SimpleTimeZone(-25200000, "America/Denver", 3, 1, -1, 0x6DDD00, 9, -1, 1, 0x6DDD00, 3600000), new SimpleTimeZone(-21600000, "America/Chicago", 3, 1, -1, 0x6DDD00, 9, -1, 1, 0x6DDD00, 3600000), new SimpleTimeZone(-18000000, "America/Indianapolis"), new SimpleTimeZone(-18000000, "America/New_York", 3, 1, -1, 0x6DDD00, 9, -1, 1, 0x6DDD00, 3600000), new SimpleTimeZone(-14400000, "America/Caracas"), new SimpleTimeZone(-14400000, "America/Halifax", 3, 1, -1, 0x6DDD00, 9, -1, 1, 0x6DDD00, 3600000), new SimpleTimeZone(-12600000, "America/St_Johns", 3, 1, -1, 0x6DDD00, 9, -1, 1, 0x6DDD00, 3600000), new SimpleTimeZone(-10800000, "America/Buenos_Aires"), new SimpleTimeZone(-10800000, "America/Sao_Paulo", 9, 1, -1, 0, 1, 11, -1, 0, 3600000), new SimpleTimeZone(-3600000, "Atlantic/Cape_Verde"), new SimpleTimeZone(-3600000, "Atlantic/Azores", 2, -1, 1, 0, 9, -1, 1, 0, 3600000), new SimpleTimeZone(0, "Africa/Casablanca"), new SimpleTimeZone(3600000, "Europe/Paris", 2, -1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00, 3600000), new SimpleTimeZone(0x6DDD00, "Europe/Istanbul", 2, -1, 1, 10800000, 9, -1, 1, 10800000, 3600000), new SimpleTimeZone(0x6DDD00, "Africa/Cairo", 3, -1, 6, 0, 8, -1, 6, 0, 3600000), new SimpleTimeZone(10800000, "Asia/Riyadh"), new SimpleTimeZone(12600000, "Asia/Tehran", 2, 4, 0, 0, 8, 4, 0, 0, 3600000), new SimpleTimeZone(14400000, "Asia/Yerevan"), new SimpleTimeZone(18000000, "Asia/Karachi"), new SimpleTimeZone(19800000, "Asia/Calcutta"), new SimpleTimeZone(21600000, "Asia/Dacca"), new SimpleTimeZone(25200000, "Asia/Bangkok"), new SimpleTimeZone(28800000, "Asia/Shanghai"), new SimpleTimeZone(32400000, "Asia/Tokyo"), new SimpleTimeZone(34200000, "Australia/Darwin"), new SimpleTimeZone(34200000, "Australia/Adelaide", 9, -1, 1, 0x6DDD00, 2, -1, 1, 10800000, 3600000), new SimpleTimeZone(36000000, "Australia/Sydney", 9, -1, 1, 0x6DDD00, 2, -1, 1, 10800000, 3600000), new SimpleTimeZone(39600000, "Pacific/Guadalcanal"), new SimpleTimeZone(43200000, "Pacific/Fiji"), new SimpleTimeZone(43200000, "Pacific/Auckland", 9, 1, -1, 0x6DDD00, 2, 15, -1, 10800000, 3600000)};
    private static final String[] compatibilityMap = new String[]{"GMT", "Africa/Casablanca", "UTC", "Africa/Casablanca", "ECT", "Europe/Paris", "CET", "Europe/Paris", "EET", "Europe/Istanbul", "ART", "Africa/Cairo", "EAT", "Asia/Riyadh", "MET", "Asia/Tehran", "NET", "Asia/Yerevan", "PLT", "Asia/Karachi", "IST", "Asia/Calcutta", "BST", "Asia/Dacca", "VST", "Asia/Bangkok", "CTT", "Asia/Shanghai", "JST", "Asia/Tokyo", "ACT", "Australia/Darwin", "AET", "Australia/Sydney", "SST", "Pacific/Guadalcanal", "NST", "Pacific/Fiji", "MIT", "Pacific/Apia", "HST", "Pacific/Honolulu", "AST", "America/Anchorage", "PST", "America/Los_Angeles", "PNT", "America/Phoenix", "MST", "America/Denver", "CST", "America/Chicago", "EST", "America/New_York", "IET", "America/Indianapolis", "PRT", "America/Caracas", "CNT", "America/St_Johns", "AGT", "America/Buenos_Aires", "BET", "America/Sao_Paulo", "CAT", "Atlantic/Cape_Verde"};
    private static Hashtable lookup = new Hashtable(zones.length);

    static final TimeZone get(String string) {
        Object object = lookup.get(string);
        if (object == null) {
            return null;
        }
        return (TimeZone)((TimeZone)object).clone();
    }

    static final String mapLongIDtoShortID(String string) {
        int n = 1;
        while (n < compatibilityMap.length) {
            if (string.equals(compatibilityMap[n])) {
                return compatibilityMap[n - 1];
            }
            n += 2;
        }
        return string;
    }

    TimeZoneData() {
    }

    static {
        int n = 0;
        while (n < zones.length) {
            lookup.put(zones[n].getID(), zones[n]);
            ++n;
        }
        SimpleTimeZone[] simpleTimeZoneArray = new SimpleTimeZone[zones.length + compatibilityMap.length / 2];
        System.arraycopy(zones, 0, simpleTimeZoneArray, 0, zones.length);
        int n2 = 0;
        while (n2 < compatibilityMap.length) {
            SimpleTimeZone simpleTimeZone = (SimpleTimeZone)((TimeZone)lookup.get(compatibilityMap[n2 + 1])).clone();
            simpleTimeZone.setID(compatibilityMap[n2]);
            simpleTimeZoneArray[TimeZoneData.zones.length + n2 / 2] = simpleTimeZone;
            lookup.put(compatibilityMap[n2], simpleTimeZone);
            n2 += 2;
        }
        zones = simpleTimeZoneArray;
    }
}

