/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import sun.misc.BASE64Encoder;
import sun.security.util.BigInt;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AlgorithmId;
import sun.security.x509.X500Name;
import sun.security.x509.X500Signer;
import sun.security.x509.X509Key;

public class PKCS10 {
    private X500Name subject;
    private X509Key subjectPublicKeyInfo;
    private DerValue attributeSet;
    private byte[] certificateRequest;

    public PKCS10(X509Key x509Key) {
        this.subjectPublicKeyInfo = x509Key;
    }

    public PKCS10(byte[] byArray) throws IOException, SignatureException, NoSuchAlgorithmException {
        this.certificateRequest = byArray;
        DerInputStream derInputStream = new DerInputStream(byArray);
        DerValue[] derValueArray = derInputStream.getSequence(3);
        if (derValueArray.length != 3) {
            throw new IllegalArgumentException("not a PKCS #10 request");
        }
        byArray = derValueArray[0].toByteArray();
        AlgorithmId algorithmId = AlgorithmId.parse(derValueArray[1]);
        byte[] byArray2 = derValueArray[2].getBitString();
        BigInt bigInt = derValueArray[0].data.getInteger();
        if (bigInt.toInt() != 0) {
            throw new IllegalArgumentException("not PKCS #10 v1");
        }
        this.subject = new X500Name(derValueArray[0].data);
        this.subjectPublicKeyInfo = X509Key.parse(derValueArray[0].data.getDerValue());
        this.attributeSet = derValueArray[0].data.available() != 0 ? derValueArray[0].data.getDerValue() : null;
        if (derValueArray[0].data.available() != 0) {
            throw new IllegalArgumentException("illegal PKCS #10 data");
        }
        try {
            Signature signature = Signature.getInstance(algorithmId.getName());
            signature.initVerify(this.subjectPublicKeyInfo);
            signature.update(byArray);
            if (!signature.verify(byArray2)) {
                throw new SignatureException("Invalid PKCS #10 signature");
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SignatureException("invalid key");
        }
    }

    public void encodeAndSign(X500Signer x500Signer) throws IOException, SignatureException {
        if (this.certificateRequest != null) {
            throw new SignatureException("request is already signed");
        }
        this.subject = x500Signer.getSigner();
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)-96, derOutputStream);
        this.attributeSet = new DerValue(derOutputStream2.toByteArray());
        derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(new BigInt(0));
        this.subject.emit(derOutputStream);
        this.subjectPublicKeyInfo.emit(derOutputStream);
        this.attributeSet.emit(derOutputStream);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        byte[] byArray = derOutputStream2.toByteArray();
        derOutputStream = derOutputStream2;
        x500Signer.update(byArray, 0, byArray.length);
        byte[] byArray2 = x500Signer.sign();
        x500Signer.getAlgorithmId().emit(derOutputStream);
        derOutputStream.putBitString(byArray2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        this.certificateRequest = derOutputStream2.toByteArray();
    }

    public X500Name getSubjectName() {
        return this.subject;
    }

    public X509Key getSubjectPublicKeyInfo() {
        return this.subjectPublicKeyInfo;
    }

    public byte[] toByteArray() {
        return this.certificateRequest;
    }

    public void print(PrintStream printStream) throws IOException, SignatureException {
        if (this.certificateRequest == null) {
            throw new SignatureException("Cert request was not signed");
        }
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        printStream.println("-----BEGIN NEW CERTIFICATE REQUEST-----");
        bASE64Encoder.encodeBuffer(this.certificateRequest, (OutputStream)printStream);
        printStream.println("-----END NEW CERTIFICATE REQUEST-----");
    }

    public String toString() {
        return "[PKCS #10 certificate request, " + this.subjectPublicKeyInfo.getAlgorithmId().getName() + " public key, for <" + this.subject + ">]";
    }
}

