/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;

public class File
implements Serializable {
    private String path;
    public static final String separator = System.getProperty("file.separator");
    public static final char separatorChar = separator.charAt(0);
    public static final String pathSeparator = System.getProperty("path.separator");
    public static final char pathSeparatorChar = pathSeparator.charAt(0);
    private static final long serialVersionUID = 301077366599181567L;

    public File(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.path = string;
    }

    public File(String string, String string2) {
        if (string2 == null) {
            throw new NullPointerException();
        }
        if (string != null) {
            if (string.endsWith(separator)) {
                this.path = String.valueOf(string) + string2;
                return;
            }
            this.path = String.valueOf(string) + separator + string2;
            return;
        }
        this.path = string2;
    }

    public File(File file, String string) {
        this(file.getPath(), string);
    }

    public String getName() {
        int n = this.path.lastIndexOf(separatorChar);
        if (n < 0) {
            return this.path;
        }
        return this.path.substring(n + 1);
    }

    public String getPath() {
        return this.path;
    }

    public String getAbsolutePath() {
        if (this.isAbsolute()) {
            return this.path;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertyAccess("user.dir");
        }
        return String.valueOf(System.getProperty("user.dir")) + separator + this.path;
    }

    public String getCanonicalPath() throws IOException {
        if (this.isAbsolute()) {
            return this.canonPath(this.path);
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertyAccess("user.dir");
        }
        return this.canonPath(String.valueOf(System.getProperty("user.dir")) + separator + this.path);
    }

    public String getParent() {
        char c;
        String string;
        int n = this.path.lastIndexOf(separatorChar);
        if (n < 0) {
            return null;
        }
        if (!this.isAbsolute() || (string = this.path).indexOf(c = separatorChar, 0) != n) {
            return this.path.substring(0, n);
        }
        if (n < this.path.length() - 1) {
            return this.path.substring(0, n + 1);
        }
        return null;
    }

    private native boolean exists0();

    private native boolean canWrite0();

    private native boolean canRead0();

    private native boolean isFile0();

    private native boolean isDirectory0();

    private native long lastModified0();

    private native long length0();

    private native boolean mkdir0();

    private native boolean renameTo0(File var1);

    private native boolean delete0();

    private native boolean rmdir0();

    private native String[] list0();

    private native String canonPath(String var1) throws IOException;

    public boolean exists() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(this.path);
        }
        return this.exists0();
    }

    public boolean canWrite() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(this.path);
        }
        return this.canWrite0();
    }

    public boolean canRead() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(this.path);
        }
        return this.canRead0();
    }

    public boolean isFile() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(this.path);
        }
        return this.isFile0();
    }

    public boolean isDirectory() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(this.path);
        }
        return this.isDirectory0();
    }

    public native boolean isAbsolute();

    public long lastModified() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(this.path);
        }
        return this.lastModified0();
    }

    public long length() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(this.path);
        }
        return this.length0();
    }

    public boolean mkdir() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(this.path);
        }
        return this.mkdir0();
    }

    public boolean renameTo(File file) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(this.path);
            securityManager.checkWrite(file.path);
        }
        return this.renameTo0(file);
    }

    public boolean mkdirs() {
        if (this.exists()) {
            return false;
        }
        if (this.mkdir()) {
            return true;
        }
        if (this.path.endsWith(separator)) {
            String string = this.getParent();
            return string != null && new File(string).mkdirs();
        }
        String string = this.getParent();
        return string != null && new File(string).mkdirs() && this.mkdir();
    }

    public String[] list() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(this.path);
        }
        return this.list0();
    }

    public String[] list(FilenameFilter filenameFilter) {
        String[] stringArray = this.list();
        if (stringArray == null) {
            return null;
        }
        Vector vector = new Vector();
        int n = 0;
        while (n < stringArray.length) {
            if (filenameFilter == null || filenameFilter.accept(this, stringArray[n])) {
                vector.addElement(stringArray[n]);
            }
            ++n;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public boolean delete() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkDelete(this.path);
        }
        if (this.isDirectory()) {
            return this.rmdir0();
        }
        return this.delete0();
    }

    public int hashCode() {
        return this.path.hashCode() ^ 0x12D591;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof File) {
            return this.path.equals(((File)object).path);
        }
        return false;
    }

    public String toString() {
        return this.getPath();
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeChar(separatorChar);
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        char c = objectInputStream.readChar();
        if (c != separatorChar) {
            this.path = this.path.replace(c, separatorChar);
        }
    }
}

