/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public final class Security {
    static boolean debug;
    static boolean error;
    private static Properties props;
    private static Properties propCache;
    private static Vector providers;

    private static void initialize() {
        props = new Properties();
        propCache = new Properties();
        providers = new Vector();
        File file = Security.securityPropFile("java.security");
        if (!file.exists()) {
            System.err.println("security properties not found. using defaults.");
            props.put("security.provider.1", "sun.security.provider.Sun");
            props.put("system.scope", "sun.security.provider.IdentityDatabase");
        } else {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                props.load(bufferedInputStream);
                ((InputStream)bufferedInputStream).close();
            }
            catch (IOException iOException) {
                String string = "could not load security properties file from " + file + ". using defaults.";
                if (debug) {
                    System.err.println(string);
                }
                props.put("security.provider.1", "sun.security.provider.Sun");
                props.put("system.scope", "sun.security.provider.IdentityDatabase");
            }
        }
        Security.loadProviders();
    }

    private static void initializeStatic() {
        props.put("security.provider.1", "sun.security.provider.Sun");
        props.put("system.scope", "sun.security.provider.IdentityDatabase");
    }

    private Security() {
    }

    private static void loadProviders() {
        int n = 1;
        String string;
        while ((string = props.getProperty("security.provider." + n++)) != null) {
            Provider provider = Provider.loadProvider(string);
            if (provider == null) continue;
            providers.addElement(provider);
        }
        return;
    }

    static File securityPropFile(String string) {
        String string2 = File.separator;
        return new File(String.valueOf(System.getProperty("java.home")) + string2 + "lib" + string2 + "security" + string2 + string);
    }

    static String getProviderProperty(String string) {
        String string2 = propCache.getProperty(string);
        if (string2 != null) {
            return string2;
        }
        int n = 0;
        while (n < providers.size()) {
            Provider provider = (Provider)providers.elementAt(n);
            string2 = provider.getProperty(string);
            if (string2 != null) {
                propCache.put(string, string2);
                return string2;
            }
            ++n;
        }
        return string2;
    }

    static String getStandardName(String string, String string2) {
        return Security.getProviderProperty("Alg.Alias." + string2 + "." + string);
    }

    public static String getAlgorithmProperty(String string, String string2) {
        return Security.getProviderProperty("Alg." + string2 + "." + string);
    }

    static String getPublicKeyClassName(String string, String string2) {
        String string3 = Security.getStandardName(string, "Key");
        if (string3 == null) {
            string3 = string;
        }
        String string4 = "PublicKey." + string2 + "." + string3;
        return Security.getProviderProperty(string4);
    }

    static String getPrivateKeyClassName(String string, String string2) {
        String string3 = Security.getStandardName(string, "Key");
        if (string3 == null) {
            string3 = string;
        }
        return Security.getProviderProperty("PrivateKey." + string2 + "." + string3);
    }

    static String getEngineClassName(String string, String string2) throws NoSuchAlgorithmException {
        String string3 = Security.getStandardName(string, string2);
        if (string3 == null) {
            string3 = string;
        }
        providers.elements();
        String string4 = Security.getProviderProperty(String.valueOf(string2) + "." + string3);
        if (string4 != null) {
            return string4;
        }
        throw new NoSuchAlgorithmException("algorithm " + string + " not available.");
    }

    private static String getEngineClassName(String string, String string2, String string3) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider provider;
        if (string2 == null) {
            return Security.getEngineClassName(string, string3);
        }
        String string4 = Security.getStandardName(string, string3);
        if (string4 == null) {
            string4 = string;
        }
        if ((provider = Security.getProvider(string2)) == null) {
            throw new NoSuchProviderException("no such provider: " + string2);
        }
        String string5 = provider.getProperty(String.valueOf(string3) + "." + string4);
        if (string5 == null) {
            throw new NoSuchAlgorithmException("no such algorithm: " + string + " for provider " + string2);
        }
        return string5;
    }

    public static int insertProviderAt(Provider provider, int n) {
        int n2;
        Security.check();
        Provider provider2 = Security.getProvider(provider.getName());
        if (provider2 != null) {
            return -1;
        }
        if (--n < 0) {
            n = 0;
        }
        if (n > (n2 = providers.size())) {
            n = n2;
        }
        providers.insertElementAt(provider, n);
        propCache = new Properties();
        return n;
    }

    public static int addProvider(Provider provider) {
        return Security.insertProviderAt(provider, providers.size() + 1);
    }

    public static void removeProvider(String string) {
        Security.check();
        Provider provider = Security.getProvider(string);
        if (provider != null) {
            providers.removeElement(provider);
        }
    }

    public static Provider[] getProviders() {
        Security.check();
        Object[] objectArray = new Provider[providers.size()];
        providers.copyInto(objectArray);
        return objectArray;
    }

    public static Provider getProvider(String string) {
        Security.check();
        Enumeration enumeration = providers.elements();
        while (enumeration.hasMoreElements()) {
            Provider provider = (Provider)enumeration.nextElement();
            if (!provider.getName().equals(string)) continue;
            return provider;
        }
        return null;
    }

    private static boolean checkSuperclass(Class clazz, Class clazz2) {
        Class clazz3;
        while (clazz != (clazz3 = clazz2) && !false) {
            if ((clazz = clazz.getSuperclass()) != null) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Object getImpl(String string, String string2, String string3) throws NoSuchAlgorithmException, NoSuchProviderException {
        String string4 = Security.getEngineClassName(string, string3, string2);
        try {
            Class clazz;
            Class clazz2;
            Class clazz3 = Class.forName("java.security." + string2);
            Class clazz4 = clazz2 = Class.forName(string4);
            while (clazz4 != (clazz = clazz3)) {
                if ((clazz4 = clazz4.getSuperclass()) != null) continue;
                boolean bl = false;
                if (bl) break;
                throw new NoSuchAlgorithmException("class configured for " + string2 + ": " + string4 + " not a " + string2);
            }
            return clazz2.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoSuchAlgorithmException("class configured for " + string2 + "(provider: " + string3 + ")" + "cannot be found.\n" + classNotFoundException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            throw new NoSuchAlgorithmException("class " + string4 + " configured for " + string2 + "(provider: " + string3 + ") cannot be instantiated.\n" + instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new NoSuchAlgorithmException("class " + string4 + " configured for " + string2 + "(provider: " + string3 + ") cannot be accessed.\n" + illegalAccessException.getMessage());
        }
    }

    public static String getProperty(String string) {
        Security.check();
        return props.getProperty(string);
    }

    public static void setProperty(String string, String string2) {
        Security.check();
        props.put(string, string2);
    }

    private static void check() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess("java");
        }
    }

    static void error(String string) {
        if (debug) {
            System.err.println(string);
        }
    }

    static void error(String string, Throwable throwable) {
        if (debug) {
            System.err.println(string);
        }
        if (debug) {
            throwable.printStackTrace();
        }
    }

    static void debug(String string) {
        if (debug) {
            System.err.println(string);
        }
    }

    static void debug(String string, Throwable throwable) {
        if (debug) {
            throwable.printStackTrace();
            System.err.println(string);
        }
    }

    static {
        error = true;
        Security.initialize();
    }
}

