/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Checksum;

public class CheckedInputStream
extends FilterInputStream {
    private Checksum cksum;

    public CheckedInputStream(InputStream inputStream, Checksum checksum) {
        super(inputStream);
        this.cksum = checksum;
    }

    public int read() throws IOException {
        int n = this.in.read();
        if (n != -1) {
            this.cksum.update(n);
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if ((n2 = this.in.read(byArray, n, n2)) != -1) {
            this.cksum.update(byArray, n, n2);
        }
        return n2;
    }

    public long skip(long l) throws IOException {
        byte[] byArray = new byte[512];
        long l2 = 0L;
        while (l2 < l) {
            long l3 = l - l2;
            l3 = this.read(byArray, 0, l3 < (long)byArray.length ? (int)l3 : byArray.length);
            if (l3 == -1L) {
                return l2;
            }
            l2 += l3;
        }
        return l2;
    }

    public Checksum getChecksum() {
        return this.cksum;
    }
}

