/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.CharConversionException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import sun.io.ByteToCharConverter;
import sun.io.CharToByteConverter;

public final class String
implements Serializable {
    private char[] value;
    private int offset;
    private int count;
    private static final long serialVersionUID = -6849794470754667710L;

    public String() {
        this.value = new char[0];
    }

    public String(String string) {
        this.count = string.count;
        this.value = new char[this.count];
        string.getChars(0, this.count, this.value, 0);
    }

    public String(char[] cArray) {
        this.count = cArray.length;
        this.value = new char[this.count];
        System.arraycopy(cArray, 0, this.value, 0, this.count);
    }

    public String(char[] cArray, int n, int n2) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > cArray.length - n2) {
            throw new StringIndexOutOfBoundsException(n + n2);
        }
        this.value = new char[n2];
        this.count = n2;
        System.arraycopy(cArray, n, this.value, 0, n2);
    }

    public String(byte[] byArray, int n, int n2, int n3) {
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n3 < 0) {
            throw new StringIndexOutOfBoundsException(n3);
        }
        if (n2 > byArray.length - n3) {
            throw new StringIndexOutOfBoundsException(n2 + n3);
        }
        char[] cArray = new char[n3];
        this.count = n3;
        this.value = cArray;
        if (n == 0) {
            int n4 = n3;
            while (n4-- > 0) {
                cArray[n4] = (char)(byArray[n4 + n2] & 0xFF);
            }
            return;
        }
        n <<= 8;
        int n5 = n3;
        while (n5-- > 0) {
            cArray[n5] = (char)(n | byArray[n5 + n2] & 0xFF);
        }
    }

    public String(byte[] byArray, int n) {
        this(byArray, n, 0, byArray.length);
    }

    private String(byte[] byArray, int n, int n2, ByteToCharConverter byteToCharConverter) {
        int n3 = byteToCharConverter.getMaxCharsPerByte() * n2;
        this.value = new char[n3];
        try {
            this.count = byteToCharConverter.convert(byArray, n, n + n2, this.value, 0, n3);
            this.count += byteToCharConverter.flush(this.value, byteToCharConverter.nextCharIndex(), n3);
        }
        catch (CharConversionException charConversionException) {
            this.count = byteToCharConverter.nextCharIndex();
        }
        if (this.count < n3) {
            char[] cArray = new char[this.count];
            System.arraycopy(this.value, 0, cArray, 0, this.count);
            this.value = cArray;
        }
    }

    public String(byte[] byArray, int n, int n2, String string) throws UnsupportedEncodingException {
        this(byArray, n, n2, ByteToCharConverter.getConverter(string));
    }

    public String(byte[] byArray, String string) throws UnsupportedEncodingException {
        this(byArray, 0, byArray.length, string);
    }

    public String(byte[] byArray, int n, int n2) {
        this(byArray, n, n2, ByteToCharConverter.getDefault());
    }

    public String(byte[] byArray) {
        this(byArray, 0, byArray.length, ByteToCharConverter.getDefault());
    }

    public String(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            stringBuffer.setShared();
            this.value = stringBuffer.getValue();
            this.offset = 0;
            this.count = stringBuffer.length();
            return;
        }
    }

    private String(int n, int n2, char[] cArray) {
        this.value = cArray;
        this.offset = n;
        this.count = n2;
    }

    public int length() {
        return this.count;
    }

    public char charAt(int n) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        return this.value[n + this.offset];
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException(n2 - n);
        }
        System.arraycopy(this.value, this.offset + n, cArray, n3, n2 - n);
    }

    public void getBytes(int n, int n2, byte[] byArray, int n3) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException(n2 - n);
        }
        int n4 = n3;
        int n5 = this.offset + n2;
        int n6 = this.offset + n;
        char[] cArray = this.value;
        while (n6 < n5) {
            byArray[n4++] = (byte)cArray[n6++];
        }
    }

    private byte[] getBytes(CharToByteConverter charToByteConverter) {
        int n;
        charToByteConverter.reset();
        int n2 = charToByteConverter.getMaxBytesPerChar() * this.count;
        byte[] byArray = new byte[n2];
        try {
            n = charToByteConverter.convert(this.value, this.offset, this.offset + this.count, byArray, 0, n2);
            n += charToByteConverter.flush(byArray, charToByteConverter.nextByteIndex(), n2);
        }
        catch (CharConversionException charConversionException) {
            n = charToByteConverter.nextByteIndex();
        }
        if (n < n2) {
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            return byArray2;
        }
        return byArray;
    }

    public byte[] getBytes(String string) throws UnsupportedEncodingException {
        return this.getBytes(CharToByteConverter.getConverter(string));
    }

    public byte[] getBytes() {
        return this.getBytes(CharToByteConverter.getDefault());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof String) {
            String string = (String)object;
            int n = this.count;
            if (n == string.count) {
                char[] cArray = this.value;
                char[] cArray2 = string.value;
                int n2 = this.offset;
                int n3 = string.offset;
                while (n-- != 0) {
                    if (cArray[n2++] == cArray2[n3++]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public boolean equalsIgnoreCase(String string) {
        return string != null && string.count == this.count && this.regionMatches(true, 0, string, 0, this.count);
    }

    public int compareTo(String string) {
        int n = this.count;
        int n2 = string.count;
        int n3 = n <= n2 ? n : n2;
        char[] cArray = this.value;
        char[] cArray2 = string.value;
        int n4 = this.offset;
        int n5 = string.offset;
        while (n3-- != 0) {
            char c;
            char c2;
            if ((c2 = cArray[n4++]) == (c = cArray2[n5++])) continue;
            return c2 - c;
        }
        return n - n2;
    }

    /*
     * Unable to fully structure code
     */
    public boolean regionMatches(int var1_1, String var2_2, int var3_3, int var4_4) {
        var5_5 = this.value;
        var6_6 = this.offset + var1_1;
        var7_7 = var2_2.value;
        var8_8 = var2_2.offset + var3_3;
        if (var3_3 >= 0 && var1_1 >= 0 && var1_1 <= this.count - var4_4 && var3_3 <= var2_2.count - var4_4) ** GOTO lbl9
        return false;
lbl-1000:
        // 1 sources

        {
            if (var5_5[var6_6++] == var7_7[var8_8++]) continue;
            return false;
lbl9:
            // 2 sources

            ** while (var4_4-- > 0)
        }
lbl10:
        // 1 sources

        return true;
    }

    /*
     * Unable to fully structure code
     */
    public boolean regionMatches(boolean var1_1, int var2_2, String var3_3, int var4_4, int var5_5) {
        var6_6 = this.value;
        var7_7 = this.offset + var2_2;
        var8_8 = var3_3.value;
        var9_9 = var3_3.offset + var4_4;
        if (var4_4 >= 0 && var2_2 >= 0 && var2_2 <= this.count - var5_5 && var4_4 <= var3_3.count - var5_5) ** GOTO lbl9
        return false;
lbl-1000:
        // 1 sources

        {
            if ((var10_10 = var6_6[var7_7++]) == (var11_11 = var8_8[var9_9++]) || var1_1 && ((var12_12 = Character.toUpperCase(var10_10)) == (var13_13 = Character.toUpperCase(var11_11)) || Character.toLowerCase(var12_12) == Character.toLowerCase(var13_13))) continue;
            return false;
lbl9:
            // 2 sources

            ** while (var5_5-- > 0)
        }
lbl10:
        // 1 sources

        return true;
    }

    /*
     * Unable to fully structure code
     */
    public boolean startsWith(String var1_1, int var2_2) {
        var3_3 = this.value;
        var4_4 = this.offset + var2_2;
        var5_5 = var1_1.value;
        var6_6 = var1_1.offset;
        var7_7 = var1_1.count;
        if (var2_2 >= 0 && var2_2 <= this.count - var7_7) ** GOTO lbl10
        return false;
lbl-1000:
        // 1 sources

        {
            if (var3_3[var4_4++] == var5_5[var6_6++]) continue;
            return false;
lbl10:
            // 2 sources

            ** while (--var7_7 >= 0)
        }
lbl11:
        // 1 sources

        return true;
    }

    public boolean startsWith(String string) {
        return this.startsWith(string, 0);
    }

    public boolean endsWith(String string) {
        return this.startsWith(string, this.count - string.count);
    }

    public int hashCode() {
        int n = 0;
        int n2 = this.offset;
        char[] cArray = this.value;
        int n3 = this.count;
        if (n3 < 16) {
            int n4 = n3;
            while (n4 > 0) {
                n = n * 37 + cArray[n2++];
                --n4;
            }
        } else {
            int n5 = n3 / 8;
            int n6 = n3;
            while (n6 > 0) {
                n = n * 39 + cArray[n2];
                n6 -= n5;
                n2 += n5;
            }
        }
        return n;
    }

    public int indexOf(int n) {
        return this.indexOf(n, 0);
    }

    public int indexOf(int n, int n2) {
        int n3 = this.offset + this.count;
        char[] cArray = this.value;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= this.count) {
            return -1;
        }
        int n4 = this.offset + n2;
        while (n4 < n3) {
            if (cArray[n4] == n) {
                return n4 - this.offset;
            }
            ++n4;
        }
        return -1;
    }

    public int lastIndexOf(int n) {
        return this.lastIndexOf(n, this.count - 1);
    }

    public int lastIndexOf(int n, int n2) {
        int n3 = this.offset;
        char[] cArray = this.value;
        int n4 = this.offset + (n2 >= this.count ? this.count - 1 : n2);
        while (n4 >= n3) {
            if (cArray[n4] == n) {
                return n4 - this.offset;
            }
            --n4;
        }
        return -1;
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        char[] cArray = this.value;
        char[] cArray2 = string.value;
        int n2 = this.offset + (this.count - string.count);
        if (n >= this.count) {
            return -1;
        }
        if (n < 0) {
            n = 0;
        }
        if (string.count == 0) {
            return n;
        }
        int n3 = string.offset;
        char c = cArray2[n3];
        int n4 = this.offset + n;
        block0: while (true) {
            if (n4 <= n2 && cArray[n4] != c) {
                ++n4;
                continue;
            }
            if (n4 > n2) {
                return -1;
            }
            int n5 = n4 + 1;
            int n6 = n5 + string.count - 1;
            int n7 = n3 + 1;
            while (n5 < n6) {
                if (cArray[n5++] == cArray2[n7++]) continue;
                ++n4;
                continue block0;
            }
            break;
        }
        return n4 - this.offset;
    }

    public int lastIndexOf(String string) {
        return this.lastIndexOf(string, this.count);
    }

    public int lastIndexOf(String string, int n) {
        int n2;
        int n3 = this.count - string.count;
        if (n < 0) {
            return -1;
        }
        if (n > n3) {
            n = n3;
        }
        if (string.count == 0) {
            return n;
        }
        char[] cArray = this.value;
        char[] cArray2 = string.value;
        int n4 = string.offset + string.count - 1;
        char c = cArray2[n4];
        int n5 = this.offset + string.count - 1;
        int n6 = n5 + n;
        block0: while (true) {
            if (n6 >= n5 && cArray[n6] != c) {
                --n6;
                continue;
            }
            if (n6 < n5) {
                return -1;
            }
            int n7 = n6 - 1;
            n2 = n7 - (string.count - 1);
            int n8 = n4 - 1;
            while (n7 > n2) {
                if (cArray[n7--] == cArray2[n8--]) continue;
                --n6;
                continue block0;
            }
            break;
        }
        return n2 - this.offset + 1;
    }

    public String substring(int n) {
        return this.substring(n, this.count);
    }

    public String substring(int n, int n2) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException(n2 - n);
        }
        if (n == 0 && n2 == this.count) {
            return this;
        }
        return new String(this.offset + n, n2 - n, this.value);
    }

    public String concat(String string) {
        int n = string.count;
        if (n == 0) {
            return this;
        }
        char[] cArray = new char[this.count + n];
        this.getChars(0, this.count, cArray, 0);
        string.getChars(0, n, cArray, this.count);
        return new String(0, this.count + n, cArray);
    }

    public String replace(char c, char c2) {
        if (c != c2) {
            int n = this.count;
            int n2 = -1;
            char[] cArray = this.value;
            int n3 = this.offset;
            while (++n2 < n) {
                if (cArray[n3 + n2] == c) break;
            }
            if (n2 < n) {
                char[] cArray2 = new char[n];
                int n4 = 0;
                while (n4 < n2) {
                    cArray2[n4] = cArray[n3 + n4];
                    ++n4;
                }
                while (n2 < n) {
                    char c3 = cArray[n3 + n2];
                    cArray2[n2] = c3 == c ? c2 : c3;
                    ++n2;
                }
                return new String(0, n, cArray2);
            }
        }
        return this;
    }

    public String toLowerCase(Locale locale) {
        char[] cArray = new char[this.count];
        int n = this.count;
        int n2 = this.offset;
        char[] cArray2 = this.value;
        if (locale.getLanguage().equals("tr")) {
            int n3 = 0;
            while (n3 < n) {
                char c = cArray2[n2 + n3];
                cArray[n3] = c == 'I' ? 305 : (c == '\u0130' ? 105 : Character.toLowerCase(c));
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < n) {
                cArray[n4] = Character.toLowerCase(cArray2[n2 + n4]);
                ++n4;
            }
        }
        return new String(cArray);
    }

    public String toLowerCase() {
        return this.toLowerCase(Locale.getDefault());
    }

    public String toUpperCase(Locale locale) {
        char[] cArray = new char[this.count];
        int n = 0;
        int n2 = this.count;
        int n3 = this.offset;
        char[] cArray2 = this.value;
        if (locale.getLanguage().equals("tr")) {
            int n4 = 0;
            while (n4 < n2) {
                char c = cArray2[n3 + n4];
                if (c == 'i') {
                    cArray[n4 + n] = 304;
                } else if (c == '\u0131') {
                    cArray[n4 + n] = 73;
                } else if (c == '\u00df') {
                    char[] cArray3 = new char[cArray.length + 1];
                    System.arraycopy(cArray, 0, cArray3, 0, n4 + 1 + n);
                    cArray3[n4 + n] = 83;
                    cArray3[n4 + ++n] = 83;
                    cArray = cArray3;
                } else {
                    cArray[n4 + n] = Character.toUpperCase(c);
                }
                ++n4;
            }
        } else {
            int n5 = 0;
            while (n5 < n2) {
                char c = cArray2[n3 + n5];
                if (c == '\u00df') {
                    char[] cArray4 = new char[cArray.length + 1];
                    System.arraycopy(cArray, 0, cArray4, 0, n5 + 1 + n);
                    cArray4[n5 + n] = 83;
                    cArray4[n5 + ++n] = 83;
                    cArray = cArray4;
                } else {
                    cArray[n5 + n] = Character.toUpperCase(c);
                }
                ++n5;
            }
        }
        return new String(cArray);
    }

    public String toUpperCase() {
        return this.toUpperCase(Locale.getDefault());
    }

    public String trim() {
        int n = this.count;
        int n2 = 0;
        int n3 = this.offset;
        char[] cArray = this.value;
        while (n2 < n && cArray[n3 + n2] <= ' ') {
            ++n2;
        }
        while (n2 < n && cArray[n3 + n - 1] <= ' ') {
            --n;
        }
        if (n2 > 0 || n < this.count) {
            return this.substring(n2, n);
        }
        return this;
    }

    public String toString() {
        return this;
    }

    public char[] toCharArray() {
        int n = this.count;
        char[] cArray = new char[n];
        this.getChars(0, n, cArray, 0);
        return cArray;
    }

    public static String valueOf(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString();
    }

    public static String valueOf(char[] cArray) {
        return new String(cArray);
    }

    public static String valueOf(char[] cArray, int n, int n2) {
        return new String(cArray, n, n2);
    }

    public static String copyValueOf(char[] cArray, int n, int n2) {
        return new String(cArray, n, n2);
    }

    public static String copyValueOf(char[] cArray) {
        int n = cArray.length;
        return new String(cArray, 0, n);
    }

    public static String valueOf(boolean bl) {
        if (bl) {
            return "true";
        }
        return "false";
    }

    public static String valueOf(char c) {
        char[] cArray = new char[]{c};
        return new String(0, 1, cArray);
    }

    public static String valueOf(int n) {
        return Integer.toString(n, 10);
    }

    public static String valueOf(long l) {
        return Long.toString(l, 10);
    }

    public static String valueOf(float f) {
        return new FloatingDecimal(f).toJavaFormatString();
    }

    public static String valueOf(double d) {
        return new FloatingDecimal(d).toJavaFormatString();
    }

    public native String intern();

    int utfLength() {
        int n = this.offset + this.count;
        int n2 = 0;
        char[] cArray = this.value;
        int n3 = this.offset;
        while (n3 < n) {
            char c = cArray[n3];
            n2 = c >= '\u0001' && c <= '\u007f' ? ++n2 : (c > '\u07ff' ? (n2 += 3) : (n2 += 2));
            ++n3;
        }
        return n2;
    }
}

