/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocketImpl;
import java.net.InetAddress;
import java.net.SocketException;

public class DatagramSocket {
    DatagramSocketImpl impl;
    static Class implClass;

    public DatagramSocket() throws SocketException {
        this.create(0, null);
    }

    public DatagramSocket(int n) throws SocketException {
        this(n, null);
    }

    public DatagramSocket(int n, InetAddress inetAddress) throws SocketException {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("Port out of range:" + n);
        }
        this.create(n, inetAddress);
    }

    void create(int n, InetAddress inetAddress) throws SocketException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkListen(n);
        }
        try {
            this.impl = (DatagramSocketImpl)implClass.newInstance();
        }
        catch (Exception exception) {
            throw new SocketException("can't instantiate DatagramSocketImpl");
        }
        this.impl.create();
        if (inetAddress == null) {
            inetAddress = InetAddress.anyLocalAddress;
        }
        this.impl.bind(n, inetAddress);
    }

    public void send(DatagramPacket datagramPacket) throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        DatagramPacket datagramPacket2 = datagramPacket;
        synchronized (datagramPacket2) {
            if (securityManager != null) {
                if (datagramPacket.getAddress().isMulticastAddress()) {
                    securityManager.checkMulticast(datagramPacket.getAddress());
                } else {
                    securityManager.checkConnect(datagramPacket.getAddress().getHostAddress(), datagramPacket.getPort());
                }
            }
            this.impl.send(datagramPacket);
            return;
        }
    }

    public synchronized void receive(DatagramPacket datagramPacket) throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        DatagramPacket datagramPacket2 = datagramPacket;
        synchronized (datagramPacket2) {
            if (securityManager != null) {
                while (true) {
                    InetAddress inetAddress = new InetAddress();
                    int n = this.impl.peek(inetAddress);
                    try {
                        securityManager.checkConnect(inetAddress.getHostAddress(), n);
                    }
                    catch (SecurityException securityException) {
                        DatagramPacket datagramPacket3 = new DatagramPacket(new byte[1], 1);
                        this.impl.receive(datagramPacket3);
                        continue;
                    }
                    break;
                }
            }
            this.impl.receive(datagramPacket);
            return;
        }
    }

    public InetAddress getLocalAddress() {
        InetAddress inetAddress = null;
        try {
            inetAddress = (InetAddress)this.impl.getOption(15);
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkConnect(inetAddress.getHostAddress(), -1);
            }
        }
        catch (Exception exception) {
            inetAddress = InetAddress.anyLocalAddress;
        }
        return inetAddress;
    }

    public int getLocalPort() {
        return this.impl.getLocalPort();
    }

    public synchronized void setSoTimeout(int n) throws SocketException {
        this.impl.setOption(4102, new Integer(n));
    }

    public synchronized int getSoTimeout() throws SocketException {
        Object object = this.impl.getOption(4102);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return 0;
    }

    public void close() {
        this.impl.close();
    }

    static {
        String string = "";
        try {
            string = System.getProperty("impl.prefix", "Plain");
            implClass = Class.forName("java.net." + string + "DatagramSocketImpl");
        }
        catch (Exception exception) {
            System.err.println("Can't find class: java.net." + string + "DatagramSocketImpl: check impl.prefix property");
        }
        if (implClass == null) {
            try {
                implClass = Class.forName("java.net.PlainDatagramSocketImpl");
            }
            catch (Exception exception) {
                throw new Error("System property impl.prefix incorrect");
            }
        }
    }
}

