use utf8;
use strict;

use Test::More 'no_plan';
use File::stat;
use lib 't/lib';

use TreePath::Graph::Test;

#       /
#       |
#       A
#      / \
#     B   ♥
#    /   / \
#   C   G   E
#  / \     / \
# D   E   I   J
#
my $simpletree = {
             '1' => {
                     parent => '0',
                     name => '/',
                     type => 'T1'},
             '2'=> {
                    parent => '1',
                    name => 'A'},
             '3'=> {
                    parent => '2',
                    name => 'B'},
             '4'=> {
                    parent => '3',
                    name => 'C'},
             '5'=> {
                    parent => '4',
                    name => 'D'},
             '6'=> {
                    parent => '4',
                    name => 'E'},
             '7'=> {
                    parent => '2',
                    name => '♥'},
             '8'=> {
                    parent => '7',
                    name => 'G',
                    position => 1},
             '9'=> {
                    parent => '7',
                    name => 'E',
                    type => 'T2'},
             '10'=> {
                     parent => '9',
                     name => 'I'},
             '11'=> {
                     parent => '9',
                     name => 'J'}
            };

ok( my $tp = TreePath::Graph::Test->new(  conf  => $simpletree,
                                          output => 't/test.png'  ),
    "New TreePath ( conf => $simpletree)");

$tp->graph;

my $sb = stat($tp->output);
is( $sb->size, 17159, "png has the same size as during testing");

unlink $tp->output;
