#--- manual.t -----------------------------------------------------------------
# function: Test HTML::ToC generating a manual.

use strict;
use Test::More tests => 1;
use Test::Differences;


use Data::Dumper;
use File::Find;
use HTML::Toc;
use HTML::TocGenerator;
use HTML::TocInsertor;
use HTML::TocUpdator;


	# Create objects
my $toc          = HTML::Toc->new();
my $tocGenerator = HTML::TocGenerator->new();
my @fileList;


#--- TestSiteMap() ------------------------------------------------------------
# function: Test specifying numbered list.

sub TestSiteMap {
		# Set ToC options
	$toc->setOptions({
		'doLinkToFile'       => 1,
		'templateAnchorName' => '""',
		'templateAnchorHref' => '"<a href=\"$file"."#".$groupId.$level."\">"',
		'doLinkTocToToken'   => 1,
		'tokenToToc'         => [{
			'groupId'         => 'dir',
			'level'           => 1,
			'tokenBegin'      => '<title>',
			'tokenEnd'        => '</title>',
			'fileSpec'        => '\./[^/]+$'
		}, {
			'groupId'         => 'dir',
			'level'           => 2,
			'tokenBegin'      => '<title>',
			'tokenEnd'        => '</title>',
			'fileSpec'        => '\./[^/]+?/[^/]+$'
		}, {
			'groupId'         => 'dir',
			'level'           => 3,
			'tokenBegin'      => '<title>',
			'tokenEnd'        => '</title>',
			'fileSpec'        => '\./[^/]+?/[^/]+?/[^/]+$'
		}]
	});
		# Change current directory
	chdir("t/SiteMap");
		# Find files, filling 'fileList'
	find({wanted => \&WantedSiteMap, no_chdir => 1}, '.');
		# Generate ToC of case-insensitively sorted file list
	$tocGenerator->extendFromFile(
		$toc, [sort {uc($a) cmp uc($b)} @fileList]
	);
		# Restore current directory
	chdir("../..");
		# Test ToC
	eq_or_diff($toc->format(), <<EOT, 'specifying numbered list', {max_width => 120});

<!-- Table of Contents generated by Perl - HTML::Toc -->
<ul>
   <li><a href="./index.htm#">Main</a>
      <ul>
         <li><a href="./SubDir1/index.htm#">Sub1</a>
            <ul>
               <li><a href="./SubDir1/SubSubDir1/index.htm#">SubSub1</a></li>
            </ul>
         </li>
         <li><a href="./SubDir2/index.htm#">Sub2</a>
            <ul>
               <li><a href="./SubDir2/SubSubDir1/index.htm#">SubSub1</a></li>
               <li><a href="./SubDir2/SubSubDir2/index.htm#">SubSub2</a></li>
            </ul>
         </li>
         <li><a href="./SubDir3/index.htm#">Sub3</a></li>
      </ul>
   </li>
</ul>
<!-- End of generated Table of Contents -->
EOT
}  # TestSiteMap()


#--- WantedSiteMap() ----------------------------------------------------------
# function: 'Wanted' function, used by File::Find of 'TestSiteMap()'.

sub WantedSiteMap {
		# Add file to 'fileList' if extension matches '.htm'
	push (@fileList, $File::Find::name) if (m/\.htm$/);
} # WantedSiteMap()


	# Test site map
TestSiteMap();
