# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

#########################

use Test::More tests => 4;
require 't/utils.pl';
my $loaded = 0;
use lib qw(./t/lib ./blib/lib);

# 1 - test whether HTTP::WebTest::Plugin::DateTest can be loaded
require_ok 'HTTP::WebTest::Plugin::DateTest';

# 2 - test whether HTTP::WebTest is installed
require_ok 'HTTP::WebTest';
my $WEBTEST = HTTP::WebTest->new;

# 3 - do some real request
{
    my $tests = [
        {
          test_name => 'datetest',
          url => 't/in.html',
          date_start => [ 'starttest', 'Updated:', '$Date:' ],
          date_maxage => [ '9999 weeks', '9999 weeks', '9999 weeks' ],
          date_end => [ 'endtest', '</p>', '$' ],
        } ];

    check_webtest(webtest => $WEBTEST,
                  tests => $tests,
                  opts => { plugins => ['::DateTest', '::FileRequest'], terse => 'summary' },
                  check_file => 't/test.out/basic');
}


# 4 - dynamically generated file
{
    my $tmdiff = 10 + time() - 1041337000;
    open(FH, '> t/dyn.txt') or die "Can't create t/dyn.txt, $!";
    print FH "File generated by 't/01_basic.t', do not edit\n";
    print FH "START Tue Dec 31 12:16:40 2002 GMT END\nEOF\n";
    close FH;
    my $tests = [
        {
          test_name => 'datetest',
          url => 't/dyn.txt',
          date_start => [ 'START' ],
          date_maxage => [ "$tmdiff s" ],
          date_end => [ 'END' ],
        } ];
    check_webtest(webtest => $WEBTEST,
                  tests => $tests,
                  opts => { plugins => ['::DateTest', '::FileRequest'], terse => 'summary' },
                  check_file => 't/test.out/dyn.txt');
}


