use strict;
use warnings;
use Data::Dumper;
use lib './lib';
use JavaScript::Duktape;

my $js = JavaScript::Duktape->new();
my $duk = $js->duk;

$duk->push_function( sub {
    my $i = shift->require_pointer(0);
    print Dumper $i;
    print "XXXXXXXXXXXXXXXXXXXXXXXXX\n";
    return 100;
}, 1);

$duk->put_global_string('_sendbackpointer');

$js->set('_sendbackpointer2', sub {
    print Dumper $_[1];
});

$duk->peval_string(qq~
    function test (){
        print("called");
    }

    function test2 (p) {
        print(p);
        _sendbackpointer(p);
        _sendbackpointer2(p);
    }

    var t = Duktape.Pointer(test);
    t;
~);

$duk->dump();


my $p = $duk->to_perl(0);
print Dumper $p;
$duk->push_heapptr($$p);
$duk->pcall(0);
$duk->dump();


$duk->pop_n(2);
$duk->dump();


my $test = TEST->new();
print Dumper $test;


$duk->peval_string('test2');
$duk->push_pointer($$test);
$duk->pcall(1);

$duk->dump();
$duk->pop();



my $test2 = TEST2->new();
$duk->push_perl($test2);
$duk->dump();

package TEST; {
    sub new {
        my $t = 999;
        return bless \$t, __PACKAGE__;
    }
};

package TEST2; {
    sub new {
        return bless {}, __PACKAGE__;
    }
};
