# Generated by default/object.tt
package Paws::IoT::JobTemplateSummary;
  use Moose;
  has CreatedAt => (is => 'ro', isa => 'Str', request_name => 'createdAt', traits => ['NameInRequest']);
  has Description => (is => 'ro', isa => 'Str', request_name => 'description', traits => ['NameInRequest']);
  has JobTemplateArn => (is => 'ro', isa => 'Str', request_name => 'jobTemplateArn', traits => ['NameInRequest']);
  has JobTemplateId => (is => 'ro', isa => 'Str', request_name => 'jobTemplateId', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoT::JobTemplateSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoT::JobTemplateSummary object:

  $service_obj->Method(Att1 => { CreatedAt => $value, ..., JobTemplateId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoT::JobTemplateSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->CreatedAt

=head1 DESCRIPTION

An object that contains information about the job template.

=head1 ATTRIBUTES


=head2 CreatedAt => Str

The time, in seconds since the epoch, when the job template was
created.


=head2 Description => Str

A description of the job template.


=head2 JobTemplateArn => Str

The ARN of the job template.


=head2 JobTemplateId => Str

The unique identifier of the job template.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoT>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

