# Generated by default/object.tt
package Paws::Synthetics::CanaryRunTimeline;
  use Moose;
  has Completed => (is => 'ro', isa => 'Str');
  has Started => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Synthetics::CanaryRunTimeline

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Synthetics::CanaryRunTimeline object:

  $service_obj->Method(Att1 => { Completed => $value, ..., Started => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Synthetics::CanaryRunTimeline object:

  $result = $service_obj->Method(...);
  $result->Att1->Completed

=head1 DESCRIPTION

This structure contains the start and end times of a single canary run.

=head1 ATTRIBUTES


=head2 Completed => Str

The end time of the run.


=head2 Started => Str

The start time of the run.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Synthetics>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

