use strict;
use warnings;
use Test::More;
BEGIN { use_ok 'UUID', qw(uuid parse type variant) }

my $bin;
my $str = uuid();
note '';
note $str;

ok defined($str),      'defined';
ok length($str) == 36, 'length';
ok !parse($str, $bin), 'parsable';

# could be v1 or v4
my $type = type($bin);
ok $type == 1 || $type == 4, 'correct type';

# all are variant 1
is variant($bin), 1, 'correct variant';

done_testing;
