import QtQuick
import QtQuick.Controls
import Generated.DesignSystem

Button {
    id: themeButton
    width: 83
    height: 37
    property alias titleText: title.text
    checkable: true
    background: Item {}

    Rectangle {
        id: marker
        x: 28
        y: 33
        width: 28
        height: 4
        visible: parent.checked
        color: Colors.currentTheme.primary
        radius: 1
    }

    Text {
        id: title
        x: 0
        y: 0
        width: 84
        height: 27
        color: parent.checked ? Colors.currentTheme.primary : Colors.currentTheme.secondary
        text: qsTr("Light")
        font.pixelSize: 20
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignTop
        wrapMode: Text.Wrap
        font.weight: Font.Medium
        font.family: "Exo"
    }
}

/*##^##
Designer {
    D{i:0;uuid:"38bdc4c1-31de-5ac3-b38e-47879212d596"}D{i:1;uuid:"dfa6713d-2803-5f84-8722-f7b9b787d78e"}
D{i:2;uuid:"8f21f3dd-6fca-52b0-b6a3-a37f125f0103"}
}
##^##*/

