//
// MODTOOL
//
// Copyright (c) !998 David Lindauer (LADSOFT)
//
// see license.txt for licensing info
//
// ==============================================================
//
// PASSWORD.CPP
//
// password encryption/decryption uses an xor scheme with some goodies
// added
//

#include <string.h>
#include <stdio.h>

static unsigned char password[] = "xydzylohgrx";


// ==============================================================
//
// encryption
//
static void render (char **out, unsigned char value, unsigned char pw,unsigned i)
{
	unsigned nv = (pw ^ value)- 7*i;
	unsigned nv2 = nv / 16;
	nv = nv %16;
	*(*out)++ = 'd' + nv;
	*(*out)++ = 'p' - nv2;
}
void encrypt( char * out, char *in)
{
	unsigned elen = strlen(password);
	unsigned len = strlen(in);
	unsigned i,j=0;
	for (i=0; i < len; i++) {
		render(&out,(unsigned char)in[i],(unsigned char)password[j],i);
		if (++j >=elen)
			j = 0;
	}
	*out++ = 0;
}
// ==============================================================
//
// decryption
//
static unsigned char unrender(char **out, unsigned char pw,unsigned i)
{
	unsigned char nv = *(*out)++- 'd';
	unsigned char nv2 = 'p' - *(*out)++ ;
	return((nv2*16 + nv) +7*i)^ pw;
}
void decrypt(char *out, char *in)
{
	unsigned elen = strlen(password);
	unsigned len = strlen(in)/2;
	unsigned i,j=0;
	for (i=0; i < len; i++) {
		*out++ = unrender(&in,(unsigned char)password[j],i);
		if (++j >=elen)
			j = 0;
	}
	*out++ = 0;
}