//
// MODTOOL
//
// Copyright (c) !998 David Lindauer (LADSOFT)
//
// see license.txt for licensing info
//
// ==============================================================
// SEND.CPP
//
// This file processes the SEND menu item, dispatching outgoing messages
// either to SMTP or NNTP as required by the presence or absence of a
// TO: header
//
#define STRICT
#include <windows.h>
#include <stdio.h>

#include "send.h"
#include "mailfile.h"
#include "profile.h"
#include "effects.h"
#include "archive.h"
#include "progress.h"
#include "pop3.h"
#include "nntp.h"
#include "analyze.h"

extern int batchflags;
extern long int currentsize;
extern long totalsize,currentsize;
extern HINSTANCE hInst;
extern int batchflags;

static int usingnntp;
static char *tempname = "out.tmp";
static FILE *infil;
static int skippedmail;
static int mozillapos;
static int isfeof;
static int NeedPost;
// ==============================================================
//
// parse the recipient out of the TO: header for use with SMTP
//
// first try to find something in <>
// else get rid of '()' and '""' quoted stuff
//    then use whatever is left
void MakeRecipientField(char *rcpt, char *tobuf)
{
	char *q;

	// if we return prematuraly make sure it gets logged
	rcpt[0] = 0;
	q = strchr(tobuf,'<');
	// case one: in angle brackets
	if (q) {
		strcpy(rcpt,q+1);
		q = strchr(rcpt,'>');
		if (!q)
			return;
		*q = 0;
	}	
	else {
		// case two, delete quoted text
		if (q = strchr(tobuf,'"')) {
			*q++ = ' ';
			while (*q && *q != '"') 
				*q++ = ' ';
			if (*q)
				*q = ' ';
		}
		else {
			// case three, delete parenned text
			if (q = strchr(tobuf,'(')) {
				*q++ = ' ';
				while (*q && *q != ')') 
					*q++ = ' ';
				if (*q)
					*q = ' ';
			}
		}
		// Now delete excess spaces at the beginning
		q = tobuf+4;
		while (*q == ' ' || *q == '\t' || *q == '\n')
			q++;

		// copy to rcpt buffer
		strcpy(rcpt,tobuf+4);
		
		// and delete excess spaces at the end
		if (strlen(rcpt)) {
			q = rcpt + strlen(rcpt) -1;
			while (*q == '\n' || *q == ' ' || *q == '\t')
				*q-- = 0;
		}			
	}
}
// ==============================================================
//
// add a recpipient field to the list
//
static int AddRecipient(int *count, char **rcpt, char *newrcpt)
{
	int i;
	for (i=0; i < *count ; i++)
		if (!strcmp(rcpt[i],newrcpt))
			return 0;
	rcpt[*count] = litlate(newrcpt);
	if (rcpt[*count] == 0)
		return 1;
	(*count)++;
	return 0;
}
// ==============================================================
//
// process the CC: line
//
static int ProcessCC(int *count, char **rcpt, char *cc)
{
	char buf[256],buf2[256],*q = cc;
	while (TRUE) {
		char *p = buf;
		while (*q && *q != ',' && *q != '\n')
			*p++ = *q++;
		q++;
		*p++ = 0;
		MakeRecipientField(buf2,buf);
		if (AddRecipient(count,rcpt,buf2))
			return 1;
		if (!*q)
			break;
	}
	return 0;
}
// ==============================================================
//
// send the next message
//
// when we get here the last message has been completely processed and it is
// time to send another one
//
int SendNext(HWND hWnd)
{
	static char *rcpt[100];
restart:
	char tobuf[256],ccbuf[512];
	FILE *out = fopen(tempname,"w");
	int usingsmtp;
	int rcount = 0;

	// quit if input file is at the end
	if (feof(infil) || isfeof) {

		// close and erase output file
		fclose(infil);
		if (!skippedmail) {
			fclose(fopen(outbox,"w"));
			ExtendedMessageBox("Send ok",MB_ICONINFORMATION,"Messages sent ok");
		}
		else
			ExtendedMessageBox("Post error",MB_ICONERROR,"%d message(s) left in outbox",skippedmail);
		DeleteProgress();
		if (batchflags)
			PostQuitMessage(0);
		return FILE_OK;
	}

	// open the output file
	if (!out) {
		ExtendedMessageBox("File error",MB_ICONERROR,"Can't open temporary posting file");
		DeleteProgress();
		return FILE_WRITEERR;
	}
	char **header, *next;
	int count,rv;

	// read the headers
	switch(rv = ReadHeaders(infil,&count,&header,&next,&mozillapos)) {
		case FILE_OK:
			break;
		case FILE_READERR:
			fclose(infil);
			fclose(out);
			DeleteProgress();
			ExtendedMessageBox("File error",MB_ICONERROR,"Can't read outbox");
			break;
		case FILE_NOMALLOC:
			fclose (infil);
			DeleteProgress();
			fclose(out);
			ExtendedMessageBox("Memory error",MB_ICONERROR,"Can't read headers from outbox");
			break;
	}
	// decide whether it gets sent using SMTP
	// presence of a TO: or CC: line mesans SMTP
	//
	usingsmtp = FALSE;
	if ((rv = FindHeader(0,count,header,"To:")) != -1) {
		strcpy(tobuf,header[rv]);
		usingsmtp = TRUE;
	}
	else tobuf[0] = 0;
	if ((rv = FindHeader(0,count,header,"CC:")) != -1) {
		strcpy(ccbuf,header[rv]);
		usingsmtp = TRUE;
	}
	else ccbuf[0] = 0;

	// decide whether it gets sent using NNTP
	// if it has a newsgroups line without our group it gets sent
	// if it has a newsgroups line with our group and an approval
	//    it gets sent
	// otherwise it doesn't get sent
	if ((rv = FindHeader(0,count,header,"Newsgroups:")) != -1) {
		if (stristr(header[rv],groupid)) {
			if (FindHeader(0,count,header,"Approved:") == -1)
				usingnntp = FALSE;
			else
				usingnntp = TRUE;
		}
		else usingnntp = TRUE;
	}
	else usingnntp = FALSE;
		
	
	// check if this message should be ignored
	int ignore = CheckMozillaIgnore(count,header);

	// write the headers back out
	switch(WriteHeaders(out,count,header)) {
		case FILE_OK:
			break;
		case FILE_WRITEERR:
			DeleteProgress();
			fclose(infil);
			fclose(out);
			ExtendedMessageBox("File error",MB_ICONERROR,"Can't write to temporary output file");
			break;
	}

	if (fputs(next,out) == EOF) {
			DeleteProgress();
			fclose(infil);
			fclose(out);
			ExtendedMessageBox("File error",MB_ICONERROR,"Can't write to temporary output file");
			return FILE_WRITEERR;
	}
	free(next);
	//now copy the rest of the message to the temp file
	while (!feof(infil) && (rv = ReadMailfileLine(infil,FALSE,&next))== FILE_OK) {
		if (fputs(next,out) == EOF) {
			DeleteProgress();
			fclose(infil);
			fclose(out);
			ExtendedMessageBox("File error",MB_ICONERROR,"Can't write to temporary output file");
			return FILE_WRITEERR;
		}
		free(next);
	}
	fclose(out);

	// see if message is being sent or not
	if (ignore || (!usingsmtp && !usingnntp)) {
		if (!ignore) {
			ExtendedMessageBox("Send",MB_ICONWARNING,"Message not sent anywyere, leaving messages in outbox");
			skippedmail++;
		}
		goto restart;
	}

	// hack in the size of the From - line
	currentsize += 34;

	if (usingnntp) {
		if (usingsmtp)
			NeedPost = TRUE;
		else
			PostNews(tempname,FALSE);
	}
	if (usingsmtp) {
		static char rcptbuf[256];
		// make the recipient field 
		if (tobuf[0]) {
			MakeRecipientField(rcptbuf, tobuf);
			AddRecipient(&rcount,rcpt,rcptbuf);
		}
		if (ccbuf[0])
			ProcessCC(&rcount,rcpt,ccbuf);
		
 		if (count == 0) {
			// if we still haven't got a recipient go on
			// but leave it in the outbox
			ExtendedMessageBox("Mail",MB_ICONERROR,"Can't parse To: field of message to mail");
			skippedmail++;
			goto restart;
		}
		SendMail(rcount,rcpt,tempname,FALSE,!usingnntp);
	}
	return FILE_OK;
}
// ==============================================================
//
// Sets up the program for sending the contents of the outbox
//
int SendOutbox(HWND hWnd)
{
	skippedmail = 0;
	NeedPost = FALSE;
	isfeof = 0;
	infil = fopen(outbox,"r+");
	if (!infil) {
	
		// error if can't open outbox
		ExtendedMessageBox("File error",MB_ICONERROR,"Can't open outbox");
		return FILE_WRITEERR;
	}
	else {

		// else get total len
		fseek(infil,0,2);
		fgetpos(infil,&totalsize);
		currentsize = 0;
		fseek(infil,0,0);

		// find the first from - line
		int done=0,rv;
		char *next;
		while (!done) {
			switch( rv = ReadMailfileLine(infil,FALSE,&next)) {
				case FILE_READERR:
					fclose(infil);
					ExtendedMessageBox("File error",MB_ICONERROR,"Can't read outbox");
					break;
				case FILE_READFROM:
					done = 1;
					break;
				case FILE_OK:
					free(next);
					if (feof(infil)) {
						fclose(infil);
						ExtendedMessageBox("Post",MB_ICONINFORMATION,"No messages to send");
						return FILE_OK;
					}
					break;
				case FILE_NOMALLOC:
					fclose (infil);
			  		ExtendedMessageBox("Memory error",MB_ICONERROR,"Can't read headers from outbox");
					break;
			}
		}
		// Now we need a progress bar
		MakeProgress(hWnd,hInst,"Posting news and mailing rejects",1000);

		// now send the first message
		return SendNext(hWnd);
	}
}
// ==============================================================
//
// updates the mozilla status of the posted message to 0009 (deleted)
//
int UpdateMozilla(void)
{
	static char *buf="0009";
	long oldpos,newpos = mozillapos + 18;
	if (!mozillapos)
		return 0;
	if (feof(infil))
		isfeof = 1;
	else
		isfeof = 0;
	fgetpos(infil,&oldpos);
	fseek(infil,newpos,0);
	fwrite(buf,4,1,infil);
	fseek(infil,oldpos,0);
	return 0;
}
// ==============================================================
//
// a message has been sent, save it to all the relevant archive files
//
int MessageSave(HWND hWnd,int success)
{
	int dontarchive = 0;
	if (success) {
		// mark it as sent
		if (!NeedPost)
			UpdateMozilla();
	}
	else {
		// if we got here the mail or post was rejected
		skippedmail++;
		dontarchive = 1;
	}
	if (NeedPost) {
		PostNews(tempname,FALSE);
		NeedPost = FALSE;
		return 1;
	}
	int rv;

	if (!dontarchive && !datedarchive && usingnntp) {
		// if we get here we are doing archive at post time, so
		// archive it.
		switch (AppendNewToMailFile(GetArchiveName(),tempname)) {
			case FILE_OK:
				break;
			case FILE_READERR:
				ExtendedMessageBox("File error",MB_ICONERROR,"Failure to read temporary send file");
				DeleteProgress();
				return rv;
			case FILE_WRITEERR:
				ExtendedMessageBox("File error",MB_ICONERROR,"Failure to write archive file");
				DeleteProgress();
				return rv;
		}
	}
	return FILE_OK;
}