/*
 * Copyright (c) 2003 Juli Mallett.  All rights reserved.
 *
 * This software was written by Juli Mallett <jmallett@FreeBSD.org> for the
 * FreeBSD project.  Redistribution and use in source and binary forms, with
 * or without modification, are permitted provided that the following
 * conditions are met:
 *
 * 1. Redistribution of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistribution in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <sys/cdefs.h>
__FBSDID("$FreeBSD: stable/7/lib/libufs/cgroup.c 204419 2010-02-27 17:55:29Z mckusick $");

#include <sys/param.h>
#include <sys/mount.h>
#include <sys/disklabel.h>
#include <sys/stat.h>

#include <ufs/ufs/ufsmount.h>
#include <ufs/ufs/dinode.h>
#include <ufs/ffs/fs.h>

#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include <libufs.h>

int
cgread(struct uufsd *disk)
{
	return (cgread1(disk, disk->d_ccg++));
}

int
cgread1(struct uufsd *disk, int c)
{
	struct fs *fs;
	off_t ccg;

	fs = &disk->d_fs;

	if ((unsigned)c >= fs->fs_ncg) {
		return (0);
	}
	ccg = fsbtodb(fs, cgtod(fs, c)) * disk->d_bsize;
	if (bread(disk, fsbtodb(fs, cgtod(fs, c)), disk->d_cgunion.d_buf,
	    fs->fs_bsize) == -1) {
		ERROR(disk, "unable to read cylinder group");
		return (-1);
	}
	disk->d_lcg = c;
	return (1);
}

int
cgwrite1(struct uufsd *disk, int c)
{
	struct fs *fs;

	fs = &disk->d_fs;
	if (bwrite(disk, fsbtodb(fs, cgtod(fs, c)),
	    disk->d_cgunion.d_buf, fs->fs_bsize) == -1) {
		ERROR(disk, "unable to write cylinder group");
		return (-1);
	}
	return (0);
}
