/*	$NetBSD: mm.h,v 1.4 2021/12/19 12:22:28 riastradh Exp $	*/

/*-
 * Copyright (c) 2021 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _LINUX_SCHED_MM_H_
#define _LINUX_SCHED_MM_H_

#include <sys/types.h>

#include <uvm/uvm_extern.h>

#include <linux/gfp.h>

static inline void
mmgrab(struct vmspace *vm)
{
	uvmspace_addref(vm);
}

static inline void
mmdrop(struct vmspace *vm)
{
	uvmspace_free(vm);
}

static inline void
fs_reclaim_acquire(gfp_t gfp)
{
}

static inline void
fs_reclaim_release(gfp_t gfp)
{
}

static inline unsigned
memalloc_nofs_save(void)
{
	return 0xeb13162c;
}

static inline void
memalloc_nofs_restore(unsigned flags)
{

	KASSERT(flags == 0xeb13162c);
}

#endif	/* _LINUX_SCHED_MM_H_ */
