/*	$NetBSD: linux32_termios.h,v 1.1 2021/11/25 03:08:04 ryo Exp $ */

/*-
 * Copyright (c) 2006 Emmanuel Dreyfus, all rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Emmanuel Dreyfus
 * 4. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE THE AUTHOR AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _AARCH64_LINUX32_TERMIOS_H_
#define _AARCH64_LINUX32_TERMIOS_H_

typedef unsigned char linux32_cc_t;
typedef netbsd32_long linux32_speed_t;
typedef netbsd32_long linux32_tcflag_t;

#define LINUX32_NCC	8
#define LINUX32_NCCS	19

#define LINUX32_TCGETS		_LINUX32_IO('T', 1)
#define LINUX32_TCSETS		_LINUX32_IO('T', 2)
#define LINUX32_TCSETSW		_LINUX32_IO('T', 3)
#define LINUX32_TCSETSF		_LINUX32_IO('T', 4)
#define LINUX32_TCGETA		_LINUX32_IO('T', 5)
#define LINUX32_TCSETA		_LINUX32_IO('T', 6)
#define LINUX32_TCSETAW		_LINUX32_IO('T', 7)
#define LINUX32_TCSETAF		_LINUX32_IO('T', 8)
#define LINUX32_TCSBRK		_LINUX32_IO('T', 9)
#define LINUX32_TCXONC		_LINUX32_IO('T', 10)
#define LINUX32_TCFLSH		_LINUX32_IO('T', 11)
#define LINUX32_TIOCEXCL	_LINUX32_IO('T', 12)
#define LINUX32_TIOCNXCL	_LINUX32_IO('T', 13)
#define LINUX32_TIOCSCTTY	_LINUX32_IO('T', 14)
#define LINUX32_TIOCGPGRP	_LINUX32_IO('T', 15)
#define LINUX32_TIOCSPGRP	_LINUX32_IO('T', 16)
#define LINUX32_TIOCOUTQ	_LINUX32_IO('T', 17)
#define LINUX32_TIOCSTI		_LINUX32_IO('T', 18)
#define LINUX32_TIOCGWINSZ	_LINUX32_IO('T', 19)
#define LINUX32_TIOCSWINSZ	_LINUX32_IO('T', 20)
#define LINUX32_TIOCMGET	_LINUX32_IO('T', 21)
#define LINUX32_TIOCMBIS	_LINUX32_IO('T', 22)
#define LINUX32_TIOCMBIC	_LINUX32_IO('T', 23)
#define LINUX32_TIOCMSET	_LINUX32_IO('T', 24)
#define LINUX32_TIOCGSOFTCAR	_LINUX32_IO('T', 25)
#define LINUX32_TIOCSSOFTCAR	_LINUX32_IO('T', 26)
#define LINUX32_FIONREAD	_LINUX32_IO('T', 27)
#define LINUX32_TIOCINQ		LINUX32_FIONREAD
#define LINUX32_TIOCLINUX	_LINUX32_IO('T', 28)
#define LINUX32_TIOCCONS	_LINUX32_IO('T', 29)
#define LINUX32_TIOCGSERIAL	_LINUX32_IO('T', 30)
#define LINUX32_TIOCSSERIAL	_LINUX32_IO('T', 31)
#define LINUX32_TIOCPKT		_LINUX32_IO('T', 32)
#define LINUX32_FIONBIO		_LINUX32_IO('T', 33)
#define LINUX32_TIOCNOTTY	_LINUX32_IO('T', 34)
#define LINUX32_TIOCSETD	_LINUX32_IO('T', 35)
#define LINUX32_TIOCGETD	_LINUX32_IO('T', 36)
#define LINUX32_TCSBRKP		_LINUX32_IO('T', 37)
#define LINUX32_TIOCTTYGSTRUCT	_LINUX32_IO('T', 38)

#define LINUX32_TIOCGPTN	_LINUX32_IOR('T', 48, unsigned int)
#define LINUX32_TIOCSPTLCK	_LINUX32_IOW('T', 49, int)

#define LINUX32_FIONCLEX	_LINUX32_IO('T', 80)
#define LINUX32_FIOCLEX		_LINUX32_IO('T', 81)
#define LINUX32_FIOASYNC	_LINUX32_IO('T', 82)
#define LINUX32_TIOCSERCONFIG	_LINUX32_IO('T', 83)
#define LINUX32_TIOCSERGWILD	_LINUX32_IO('T', 84)
#define LINUX32_TIOCSERSWILD	_LINUX32_IO('T', 85)
#define LINUX32_TIOCGLCKTRMIOS	_LINUX32_IO('T', 86)
#define LINUX32_TIOCSLCKTRMIOS	_LINUX32_IO('T', 87)
#define LINUX32_TIOCSERGSTRUCT	_LINUX32_IO('T', 88)
#define LINUX32_TIOCSERGETLSR	_LINUX32_IO('T', 89)

/* linux32_termios c_cc chars: */
#define LINUX32_VINTR 0
#define LINUX32_VQUIT 1
#define LINUX32_VERASE 2
#define LINUX32_VKILL 3
#define LINUX32_VEOF 4
#define LINUX32_VTIME 5
#define LINUX32_VMIN 6
#define LINUX32_VSWTC 7
#define LINUX32_VSTART 8
#define LINUX32_VSTOP 9
#define LINUX32_VSUSP 10
#define LINUX32_VEOL 11
#define LINUX32_VREPRINT 12
#define LINUX32_VDISCARD 13
#define LINUX32_VWERASE 14
#define LINUX32_VLNEXT 15
#define LINUX32_VEOL2 16

/* Old style linux_termio */
#define	LINUX32_OLD_VINTR	LINUX32_VINTR
#define	LINUX32_OLD_VQUIT	LINUX32_VQUIT
#define	LINUX32_OLD_VERASE	LINUX32_VERASE
#define	LINUX32_OLD_VKILL	LINUX32_VKILL
#define	LINUX32_OLD_VEOF	LINUX32_VEOF
#define	LINUX32_OLD_VMIN	LINUX32_VMIN
#define	LINUX32_OLD_VEOL	LINUX32_VEOL
#define	LINUX32_OLD_VTIME	LINUX32_VTIME
#define	LINUX32_OLD_VEOL2	LINUX32_VEOL2
#define	LINUX32_OLD_VSWTC	LINUX32_VSWTC

/* Linux c_iflag masks */
#define LINUX32_IGNBRK	0x0000001
#define LINUX32_BRKINT	0x0000002
#define LINUX32_IGNPAR	0x0000004
#define LINUX32_PARMRK	0x0000008
#define LINUX32_INPCK	0x0000010
#define LINUX32_ISTRIP	0x0000020
#define LINUX32_INLCR	0x0000040
#define LINUX32_IGNCR	0x0000080
#define LINUX32_ICRNL	0x0000100
#define LINUX32_IUCLC	0x0000200
#define LINUX32_IXON	0x0000400
#define LINUX32_IXANY	0x0000800
#define LINUX32_IXOFF	0x0001000
#define LINUX32_IMAXBEL	0x0002000

/* Linux c_oflag masks */
#define LINUX32_OPOST	0x0000001
#define LINUX32_OLCUC	0x0000002
#define LINUX32_ONLCR	0x0000004
#define LINUX32_OCRNL	0x0000008
#define LINUX32_ONOCR	0x0000010
#define LINUX32_ONLRET	0x0000020
#define LINUX32_OFILL	0x0000040
#define LINUX32_OFDEL	0x0000080
#define LINUX32_NLDLY	0x0000100

#define LINUX32_NL0	0x0000000
#define LINUX32_NL1	0x0000100
#define LINUX32_CRDLY	0x0000600
#define LINUX32_CR0	0x0000000
#define LINUX32_CR1	0x0000200
#define LINUX32_CR2	0x0000400
#define LINUX32_CR3	0x0000600
#define LINUX32_TABDLY	0x0001800
#define LINUX32_TAB0	0x0000000
#define LINUX32_TAB1	0x0000800
#define LINUX32_TAB2	0x0001000
#define LINUX32_TAB3	0x0001800
#define LINUX32_XTABS	0x0001800
#define LINUX32_BSDLY	0x0002000
#define LINUX32_BS0	0x0000000
#define LINUX32_BS1	0x0002000
#define LINUX32_VTDLY	0x0004000
#define LINUX32_VT0	0x0000000
#define LINUX32_VT1	0x0004000
#define LINUX32_FFDLY	0x0008000
#define LINUX32_FF0	0x0000000
#define LINUX32_FF1	0x0008000

/* Linux c_cflag bit masks */

#define LINUX32_NSPEEDS   16
#define LINUX32_NXSPEEDS   3	/* XXX Add B460800, NXSPEEDS=4 */

#define LINUX32_CBAUD	0x0000100f

#define LINUX32_B0	0x00000000
#define LINUX32_B50	0x00000001
#define LINUX32_B75	0x00000002
#define LINUX32_B110	0x00000003
#define LINUX32_B134	0x00000004
#define LINUX32_B150	0x00000005
#define LINUX32_B200	0x00000006
#define LINUX32_B300	0x00000007
#define LINUX32_B600	0x00000008
#define LINUX32_B1200	0x00000009
#define LINUX32_B1800	0x0000000a
#define LINUX32_B2400	0x0000000b
#define LINUX32_B4800	0x0000000c
#define LINUX32_B9600	0x0000000d
#define LINUX32_B19200	0x0000000e
#define LINUX32_B38400	0x0000000f
#define LINUX32_EXTA	LINUX32_B19200
#define LINUX32_EXTB	LINUX32_B38400
#define LINUX32_CBAUDEX	0x00001000
#define LINUX32_B57600	0x00001001
#define LINUX32_B115200	0x00001002
#define LINUX32_B230400	0x00001003

#define LINUX32_CSIZE	0x00000030
#define LINUX32_CS5	0x00000000
#define LINUX32_CS6	0x00000010
#define LINUX32_CS7	0x00000020
#define LINUX32_CS8	0x00000030
#define LINUX32_CSTOPB	0x00000040
#define LINUX32_CREAD	0x00000080
#define LINUX32_PARENB	0x00000100
#define LINUX32_PARODD	0x00000200
#define LINUX32_HUPCL	0x00000400
#define LINUX32_CLOCAL	0x00000800

#define LINUX32_CRTSCTS	0x80000000

/* Linux c_lflag masks */
#define LINUX32_ISIG	0x00000001
#define LINUX32_ICANON	0x00000002
#define LINUX32_XCASE	0x00000004
#define LINUX32_ECHO	0x00000008
#define LINUX32_ECHOE	0x00000010
#define LINUX32_ECHOK	0x00000020
#define LINUX32_ECHONL	0x00000040
#define LINUX32_NOFLSH	0x00000080
#define LINUX32_TOSTOP	0x00000100
#define LINUX32_ECHOCTL	0x00000200
#define LINUX32_ECHOPRT	0x00000400
#define LINUX32_ECHOKE	0x00000800
#define LINUX32_FLUSHO	0x00001000
#define LINUX32_PENDIN	0x00002000
#define LINUX32_IEXTEN	0x00008000

#endif /* _AARCH64_LINUX32_TERMIOS_H_ */
