/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.indexing;

import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.core.index.Index;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.jdt.internal.core.search.indexing.IndexRequest;
import org.eclipse.jdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.jdt.internal.core.search.processing.JobManager;
import org.eclipse.jdt.internal.core.util.Util;

class RemoveFolderFromIndex
extends IndexRequest {
    IPath folderPath;
    char[][] inclusionPatterns;
    char[][] exclusionPatterns;
    IProject project;

    public RemoveFolderFromIndex(IPath folderPath, char[][] inclusionPatterns, char[][] exclusionPatterns, IProject project, IndexManager manager) {
        super(project.getFullPath(), manager);
        this.folderPath = folderPath;
        this.inclusionPatterns = inclusionPatterns;
        this.exclusionPatterns = exclusionPatterns;
        this.project = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(IProgressMonitor progressMonitor) {
        if (this.isCancelled || progressMonitor != null && progressMonitor.isCanceled()) {
            return true;
        }
        Index index = this.manager.getIndex(this.containerPath, true, false);
        if (index == null) {
            return true;
        }
        ReadWriteMonitor monitor = index.monitor;
        if (monitor == null) {
            return true;
        }
        try {
            monitor.enterRead();
            String[] paths = index.queryDocumentNames(this.folderPath.toString());
            if (this.exclusionPatterns == null && this.inclusionPatterns == null) {
                int max;
                int n = max = paths == null ? 0 : paths.length;
                for (int i = 0; i < max; ++i) {
                    this.manager.remove(paths[i], this.containerPath);
                }
            } else {
                int max;
                int n = max = paths == null ? 0 : paths.length;
                for (int i = 0; i < max; ++i) {
                    String documentPath = paths[i];
                    if (Util.isExcluded((IPath)new Path(documentPath), this.inclusionPatterns, this.exclusionPatterns, false)) continue;
                    this.manager.remove(documentPath, this.containerPath);
                }
            }
        }
        catch (IOException e) {
            if (JobManager.VERBOSE) {
                Util.verbose("-> failed to remove " + this.folderPath + " from index because of the following exception:", System.err);
                e.printStackTrace();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            monitor.exitRead();
        }
        return true;
    }

    public String toString() {
        return "removing " + this.folderPath + " from index " + this.containerPath;
    }
}

