/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.internal.ccvs.core.CVSCompareSubscriber;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.Util;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.TagSelectionDialog;
import org.eclipse.team.internal.ccvs.ui.actions.SyncAction;
import org.eclipse.team.internal.ccvs.ui.actions.WorkspaceAction;
import org.eclipse.team.internal.ccvs.ui.subscriber.CompareParticipant;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;

public class CompareWithTagAction
extends WorkspaceAction {
    public void execute(IAction action) throws InvocationTargetException, InterruptedException {
        IResource[] resources = this.getSelectedResources();
        CVSTag tag = this.promptForTag(resources);
        if (tag == null) {
            return;
        }
        CVSCompareSubscriber compareSubscriber = new CVSCompareSubscriber(resources, tag);
        if (SyncAction.isSingleFile(resources)) {
            SyncAction.showSingleFileComparison(this.getShell(), (Subscriber)compareSubscriber, resources[0]);
            compareSubscriber.dispose();
        } else {
            try {
                compareSubscriber.primeRemoteTree();
            }
            catch (CVSException e) {
                // empty catch block
            }
            CompareParticipant participant = CompareParticipant.getMatchingParticipant(resources, tag);
            if (participant == null) {
                CVSCompareSubscriber s = compareSubscriber;
                participant = new CompareParticipant(s, this.getLocalResourcesTag(resources));
                TeamUI.getSynchronizeManager().addSynchronizeParticipants(new ISynchronizeParticipant[]{participant});
            }
            participant.refresh(resources, Policy.bind("Participant.comparing"), participant.getName(), null);
        }
    }

    protected CVSTag promptForTag(IResource[] resources) {
        IProject[] projects = new IProject[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            projects[i] = resources[i].getProject();
        }
        CVSTag tag = TagSelectionDialog.getTagToCompareWith(this.getShell(), projects);
        return tag;
    }

    private CVSTag getLocalResourcesTag(IResource[] resources) {
        try {
            int i = 0;
            if (i < resources.length) {
                ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)resources[i]);
                CVSTag tag = null;
                if (cvsResource.isFolder()) {
                    FolderSyncInfo info = ((ICVSFolder)cvsResource).getFolderSyncInfo();
                    if (info != null) {
                        tag = info.getTag();
                    }
                    if (tag != null && tag.getType() == 1) {
                        tag = Util.getAccurateFolderTag((IResource)resources[i], (CVSTag)tag);
                    }
                } else {
                    tag = Util.getAccurateFileTag((ICVSResource)cvsResource);
                }
                if (tag == null) {
                    tag = new CVSTag();
                }
                return tag;
            }
            return new CVSTag();
        }
        catch (CVSException e) {
            return new CVSTag();
        }
    }

    protected boolean isEnabledForNonExistantResources() {
        return true;
    }
}

