/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.view;

import java.text.DateFormat;
import java.util.Date;
import org.eclipse.pde.internal.core.FileAdapter;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class FileAdapterPropertySource
implements IPropertySource {
    private IPropertyDescriptor[] descriptors;
    private FileAdapter adapter;

    public void setAdapter(FileAdapter adapter) {
        this.adapter = adapter;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.descriptors == null) {
            this.descriptors = new IPropertyDescriptor[5];
            this.descriptors[0] = new PropertyDescriptor((Object)"editable", "editable");
            this.descriptors[1] = new PropertyDescriptor((Object)"last", "last modified");
            this.descriptors[2] = new PropertyDescriptor((Object)"name", "name");
            this.descriptors[3] = new PropertyDescriptor((Object)"path", "path");
            this.descriptors[4] = new PropertyDescriptor((Object)"size", "size");
        }
        return this.descriptors;
    }

    public Object getPropertyValue(Object id) {
        String key = id.toString();
        if (key.equals("editable")) {
            return "false";
        }
        if (key.equals("last")) {
            Date date = new Date(this.adapter.getFile().lastModified());
            return DateFormat.getInstance().format(date);
        }
        if (key.equals("name")) {
            return this.adapter.getFile().getName();
        }
        if (key.equals("path")) {
            return this.adapter.getFile().getAbsolutePath();
        }
        if (key.equals("size")) {
            return "" + this.adapter.getFile().length();
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

