/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.tools;

import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.WizardCheckboxTablePart;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.help.WorkbenchHelp;

public class UpdateBuildpathWizardPage
extends WizardPage {
    private IPluginModelBase[] selected;
    private CheckboxTableViewer pluginListViewer;
    private static final String KEY_TITLE = "UpdateBuildpathWizard.title";
    private static final String KEY_DESC = "UpdateBuildpathWizard.desc";
    private static final String KEY_PLUGIN_LIST = "UpdateBuildpathWizard.availablePlugins";
    private TablePart tablePart;

    public UpdateBuildpathWizardPage(IPluginModelBase[] selected) {
        super("UpdateBuildpathWizardPage");
        this.setTitle(PDEPlugin.getResourceString(KEY_TITLE));
        this.setDescription(PDEPlugin.getResourceString(KEY_DESC));
        this.selected = selected;
        this.tablePart = new TablePart(PDEPlugin.getResourceString(KEY_PLUGIN_LIST));
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
    }

    public void dispose() {
        super.dispose();
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 5;
        container.setLayout((Layout)layout);
        this.tablePart.createControl(container);
        this.pluginListViewer = this.tablePart.getTableViewer();
        this.pluginListViewer.setContentProvider((IContentProvider)new BuildpathContentProvider());
        this.pluginListViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        GridData gd = (GridData)this.tablePart.getControl().getLayoutData();
        gd.heightHint = 300;
        gd.widthHint = 300;
        this.pluginListViewer.setInput((Object)PDEPlugin.getDefault());
        this.tablePart.setSelection(this.selected);
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        WorkbenchHelp.setHelp((Control)container, (String)"org.eclipse.pde.doc.user.update_classpath");
    }

    public void storeSettings() {
    }

    public Object[] getSelected() {
        return this.tablePart.getSelection();
    }

    private void dialogChanged() {
        this.setPageComplete(this.tablePart.getSelectionCount() > 0);
    }

    public boolean isPageComplete() {
        return this.tablePart.getSelectionCount() > 0;
    }

    private Object[] getModels() {
        Vector<IPluginModelBase> result = new Vector<IPluginModelBase>();
        try {
            IPluginModelBase[] models = PDECore.getDefault().getWorkspaceModelManager().getAllModels();
            for (int i = 0; i < models.length; ++i) {
                if (!models[i].getUnderlyingResource().getProject().hasNature("org.eclipse.jdt.core.javanature")) continue;
                result.add(models[i]);
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        return result.toArray();
    }

    class TablePart
    extends WizardCheckboxTablePart {
        public TablePart(String mainLabel) {
            super(mainLabel);
        }

        public void updateCounter(int count) {
            super.updateCounter(count);
            UpdateBuildpathWizardPage.this.dialogChanged();
        }

        protected StructuredViewer createStructuredViewer(Composite parent, int style, FormToolkit toolkit) {
            StructuredViewer viewer = super.createStructuredViewer(parent, style, toolkit);
            viewer.setSorter(ListUtil.PLUGIN_SORTER);
            return viewer;
        }
    }

    public class BuildpathContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object parent) {
            return UpdateBuildpathWizardPage.this.getModels();
        }
    }
}

