/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.model.loader;

import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.ui.internal.intro.impl.model.IntroContentProvider;
import org.eclipse.ui.internal.intro.impl.model.loader.ModelLoaderUtil;
import org.eclipse.ui.internal.intro.impl.util.Log;
import org.eclipse.ui.intro.config.IIntroContentProvider;
import org.eclipse.ui.intro.config.IIntroContentProviderSite;

public class ContentProviderManager {
    private static ContentProviderManager inst = new ContentProviderManager();
    private Hashtable contentProviders = new Hashtable();

    protected ContentProviderManager() {
    }

    public static ContentProviderManager getInst() {
        return inst;
    }

    public IIntroContentProvider getContentProvider(IntroContentProvider provider) {
        IIntroContentProvider providerClass = (IIntroContentProvider)this.contentProviders.get(provider);
        return providerClass;
    }

    public IIntroContentProvider createContentProvider(IntroContentProvider provider, IIntroContentProviderSite site) {
        String pluginId = provider.getPluginId() != null ? provider.getPluginId() : provider.getBundle().getSymbolicName();
        IIntroContentProvider aClass = (IIntroContentProvider)ModelLoaderUtil.createClassInstance(pluginId, provider.getClassName());
        IIntroContentProvider providerClass = null;
        if (aClass != null && aClass instanceof IIntroContentProvider) {
            providerClass = aClass;
            providerClass.init(site);
            this.contentProviders.put(provider, providerClass);
        } else {
            Log.warning("Failed to create Intro model content provider: " + provider.getClassName());
        }
        return providerClass;
    }

    public void clear() {
        Iterator it = this.contentProviders.values().iterator();
        while (it.hasNext()) {
            Object provider = it.next();
            if (!(provider instanceof IIntroContentProvider)) continue;
            ((IIntroContentProvider)provider).dispose();
        }
        this.contentProviders.clear();
        Log.info("Cleared Intro model content providers");
    }
}

