/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.forms.widgets;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.graphics.GC;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.internal.forms.widgets.HyperlinkSegment;
import org.eclipse.ui.internal.forms.widgets.Locator;
import org.eclipse.ui.internal.forms.widgets.ParagraphSegment;
import org.eclipse.ui.internal.forms.widgets.TextSegment;

public class Paragraph {
    public static final String HTTP = "http://";
    private Vector segments;
    private boolean addVerticalSpace = true;

    public Paragraph(boolean addVerticalSpace) {
        this.addVerticalSpace = addVerticalSpace;
    }

    public int getIndent() {
        return 0;
    }

    public boolean getAddVerticalSpace() {
        return this.addVerticalSpace;
    }

    public ParagraphSegment[] getSegments() {
        if (this.segments == null) {
            return new ParagraphSegment[0];
        }
        return this.segments.toArray(new ParagraphSegment[this.segments.size()]);
    }

    public void addSegment(ParagraphSegment segment) {
        if (this.segments == null) {
            this.segments = new Vector();
        }
        this.segments.add(segment);
    }

    public void parseRegularText(String text, boolean expandURLs, HyperlinkSettings settings, String fontId) {
        this.parseRegularText(text, expandURLs, settings, fontId, null);
    }

    public void parseRegularText(String text, boolean expandURLs, HyperlinkSettings settings, String fontId, String colorId) {
        if (text.length() == 0) {
            return;
        }
        if (expandURLs) {
            int loc = text.indexOf(HTTP);
            if (loc == -1) {
                this.addSegment(new TextSegment(text, fontId, colorId));
            } else {
                int textLoc = 0;
                while (loc != -1) {
                    this.addSegment(new TextSegment(text.substring(textLoc, loc), fontId, colorId));
                    boolean added = false;
                    for (textLoc = loc; textLoc < text.length(); ++textLoc) {
                        char c = text.charAt(textLoc);
                        if (!Character.isSpaceChar(c)) continue;
                        this.addHyperlinkSegment(text.substring(loc, textLoc), settings, fontId);
                        added = true;
                        break;
                    }
                    if (!added) {
                        this.addHyperlinkSegment(text.substring(loc), settings, fontId);
                        break;
                    }
                    loc = text.indexOf(HTTP, textLoc);
                }
                if (textLoc < text.length()) {
                    this.addSegment(new TextSegment(text.substring(textLoc), fontId, colorId));
                }
            }
        } else {
            this.addSegment(new TextSegment(text, fontId, colorId));
        }
    }

    private void addHyperlinkSegment(String text, HyperlinkSettings settings, String fontId) {
        HyperlinkSegment hs = new HyperlinkSegment(text, settings, fontId);
        hs.setWordWrapAllowed(false);
        hs.setHref(text);
        this.addSegment(hs);
    }

    protected void computeRowHeights(GC gc, int width, Locator loc, int lineHeight, Hashtable resourceTable) {
        ArrayList heights;
        ParagraphSegment[] segments = this.getSegments();
        Locator hloc = loc.create();
        hloc.heights = heights = new ArrayList();
        hloc.rowCounter = 0;
        for (int j = 0; j < segments.length; ++j) {
            ParagraphSegment segment = segments[j];
            segment.advanceLocator(gc, width, hloc, resourceTable, true);
        }
        hloc.collectHeights(false);
        loc.heights = heights;
        loc.rowCounter = 0;
    }

    public void paint(GC gc, int width, Locator loc, int lineHeight, Hashtable resourceTable, HyperlinkSegment selectedLink) {
        ParagraphSegment[] segments = this.getSegments();
        if (segments.length > 0) {
            if (segments[0] instanceof TextSegment && ((TextSegment)segments[0]).isSelectable()) {
                ++loc.x;
            }
            if (loc.heights == null) {
                this.computeRowHeights(gc, width, loc, lineHeight, resourceTable);
            }
            for (int j = 0; j < segments.length; ++j) {
                ParagraphSegment segment = segments[j];
                boolean doSelect = false;
                if (selectedLink != null && segment.equals(selectedLink)) {
                    doSelect = true;
                }
                segment.paint(gc, width, loc, resourceTable, doSelect);
            }
            loc.heights = null;
            loc.y += loc.rowHeight;
        } else {
            loc.y += lineHeight;
        }
    }

    public String getAccessibleText() {
        ParagraphSegment[] segments = this.getSegments();
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter(swriter);
        for (int i = 0; i < segments.length; ++i) {
            ParagraphSegment segment = segments[i];
            if (!(segment instanceof TextSegment)) continue;
            String text = ((TextSegment)segment).getText();
            writer.print(text);
        }
        writer.println();
        swriter.flush();
        return swriter.toString();
    }

    public TextSegment findSegmentAt(int x, int y) {
        if (this.segments != null) {
            for (int i = 0; i < this.segments.size(); ++i) {
                TextSegment textSegment;
                ParagraphSegment segment = (ParagraphSegment)this.segments.get(i);
                if (!(segment instanceof TextSegment) || !(textSegment = (TextSegment)segment).contains(x, y)) continue;
                return textSegment;
            }
        }
        return null;
    }
}

