/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.util;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.ui.JavaPlugin;

public final class JavaModelUtil {
    private static boolean PRIMARY_ONLY = false;
    private static Boolean fgIsJDTCore_1_5 = null;

    public static IType findType(IJavaProject jproject, String fullyQualifiedName) throws JavaModelException {
        IType type = jproject.findType(fullyQualifiedName);
        if (type != null) {
            return type;
        }
        IPackageFragmentRoot[] roots = jproject.getPackageFragmentRoots();
        for (int i = 0; i < roots.length; ++i) {
            IPackageFragmentRoot root = roots[i];
            type = JavaModelUtil.findType(root, fullyQualifiedName);
            if (type == null || !type.exists()) continue;
            return type;
        }
        return null;
    }

    public static boolean isReferenced(IPackageFragmentRoot root) {
        IResource resource = root.getResource();
        if (resource != null) {
            IProject jarProject = resource.getProject();
            IProject container = root.getJavaProject().getProject();
            return !container.equals(jarProject);
        }
        return false;
    }

    private static IType findType(IPackageFragmentRoot root, String fullyQualifiedName) throws JavaModelException {
        IJavaElement[] children = root.getChildren();
        for (int i = 0; i < children.length; ++i) {
            IType type;
            IPackageFragment pack;
            IJavaElement element = children[i];
            if (element.getElementType() != 4 || !fullyQualifiedName.startsWith((pack = (IPackageFragment)element).getElementName()) || (type = JavaModelUtil.findType(pack, fullyQualifiedName)) == null || !type.exists()) continue;
            return type;
        }
        return null;
    }

    private static IType findType(IPackageFragment pack, String fullyQualifiedName) throws JavaModelException {
        ICompilationUnit[] cus = pack.getCompilationUnits();
        for (int i = 0; i < cus.length; ++i) {
            ICompilationUnit unit = cus[i];
            IType type = JavaModelUtil.findType(unit, fullyQualifiedName);
            if (type == null || !type.exists()) continue;
            return type;
        }
        return null;
    }

    private static IType findType(ICompilationUnit cu, String fullyQualifiedName) throws JavaModelException {
        IType[] types = cu.getAllTypes();
        for (int i = 0; i < types.length; ++i) {
            IType type = types[i];
            if (!JavaModelUtil.getFullyQualifiedName(type).equals(fullyQualifiedName)) continue;
            return type;
        }
        return null;
    }

    public static IType findType(IJavaProject jproject, String pack, String typeQualifiedName) throws JavaModelException {
        return jproject.findType(pack, typeQualifiedName);
    }

    public static IJavaElement findTypeContainer(IJavaProject jproject, String typeContainerName) throws JavaModelException {
        Path path;
        IType result = jproject.findType(typeContainerName);
        if (result == null && !((result = jproject.findElement((IPath)(path = new Path(typeContainerName.replace('.', '/'))))) instanceof IPackageFragment)) {
            result = null;
        }
        return result;
    }

    public static IType findTypeInCompilationUnit(ICompilationUnit cu, String typeQualifiedName) throws JavaModelException {
        IType[] types = cu.getAllTypes();
        for (int i = 0; i < types.length; ++i) {
            String currName = JavaModelUtil.getTypeQualifiedName(types[i]);
            if (!typeQualifiedName.equals(currName)) continue;
            return types[i];
        }
        return null;
    }

    public static IMember findMemberInCompilationUnit(ICompilationUnit cu, IMember member) {
        IJavaElement[] elements = cu.findElements((IJavaElement)member);
        if (elements != null && elements.length > 0) {
            return (IMember)elements[0];
        }
        return null;
    }

    public static IJavaElement findInCompilationUnit(ICompilationUnit cu, IJavaElement element) {
        IJavaElement[] elements = cu.findElements(element);
        if (elements != null && elements.length > 0) {
            return elements[0];
        }
        return null;
    }

    public static String getTypeQualifiedName(IType type) {
        return type.getTypeQualifiedName('.');
    }

    public static String getFullyQualifiedName(IType type) {
        return type.getFullyQualifiedName('.');
    }

    public static String getTypeContainerName(IType type) {
        IType outerType = type.getDeclaringType();
        if (outerType != null) {
            return outerType.getFullyQualifiedName('.');
        }
        return type.getPackageFragment().getElementName();
    }

    public static String concatenateName(String name1, String name2) {
        StringBuffer buf = new StringBuffer();
        if (name1 != null && name1.length() > 0) {
            buf.append(name1);
        }
        if (name2 != null && name2.length() > 0) {
            if (buf.length() > 0) {
                buf.append('.');
            }
            buf.append(name2);
        }
        return buf.toString();
    }

    public static String concatenateName(char[] name1, char[] name2) {
        StringBuffer buf = new StringBuffer();
        if (name1 != null && name1.length > 0) {
            buf.append(name1);
        }
        if (name2 != null && name2.length > 0) {
            if (buf.length() > 0) {
                buf.append('.');
            }
            buf.append(name2);
        }
        return buf.toString();
    }

    public static boolean isVisible(IMember member, IPackageFragment pack) throws JavaModelException {
        int type = member.getElementType();
        if (type == 10 || type == 9 && member.getElementName().startsWith("<")) {
            return false;
        }
        int otherflags = member.getFlags();
        IType declaringType = member.getDeclaringType();
        if (Flags.isPublic((int)otherflags) || declaringType != null && declaringType.isInterface()) {
            return true;
        }
        if (Flags.isPrivate((int)otherflags)) {
            return false;
        }
        IPackageFragment otherpack = (IPackageFragment)JavaModelUtil.findParentOfKind((IJavaElement)member, 4);
        return pack != null && otherpack != null && JavaModelUtil.isSamePackage(pack, otherpack);
    }

    public static boolean isVisibleInHierarchy(IMember member, IPackageFragment pack) throws JavaModelException {
        int type = member.getElementType();
        if (type == 10 || type == 9 && member.getElementName().startsWith("<")) {
            return false;
        }
        int otherflags = member.getFlags();
        IType declaringType = member.getDeclaringType();
        if (Flags.isPublic((int)otherflags) || Flags.isProtected((int)otherflags) || declaringType != null && declaringType.isInterface()) {
            return true;
        }
        if (Flags.isPrivate((int)otherflags)) {
            return false;
        }
        IPackageFragment otherpack = (IPackageFragment)JavaModelUtil.findParentOfKind((IJavaElement)member, 4);
        return pack != null && pack.equals(otherpack);
    }

    public static IPackageFragmentRoot getPackageFragmentRoot(IJavaElement element) {
        return (IPackageFragmentRoot)element.getAncestor(3);
    }

    public static IJavaElement findParentOfKind(IJavaElement element, int kind) {
        if (element != null && element.getParent() != null) {
            return element.getParent().getAncestor(kind);
        }
        return null;
    }

    public static IMethod findMethod(String name, String[] paramTypes, boolean isConstructor, IType type) throws JavaModelException {
        return JavaModelUtil.findMethod(name, paramTypes, isConstructor, type.getMethods());
    }

    public static IMethod findMethod(String name, String[] paramTypes, boolean isConstructor, IMethod[] methods) throws JavaModelException {
        for (int i = methods.length - 1; i >= 0; --i) {
            if (!JavaModelUtil.isSameMethodSignature(name, paramTypes, isConstructor, methods[i])) continue;
            return methods[i];
        }
        return null;
    }

    public static IMethod findMethodDeclarationInHierarchy(ITypeHierarchy hierarchy, IType type, String name, String[] paramTypes, boolean isConstructor) throws JavaModelException {
        IType[] superTypes = hierarchy.getAllSupertypes(type);
        for (int i = superTypes.length - 1; i >= 0; --i) {
            IMethod first = JavaModelUtil.findMethod(name, paramTypes, isConstructor, superTypes[i]);
            if (first == null || Flags.isPrivate((int)first.getFlags())) continue;
            IMethod res = JavaModelUtil.findMethodDeclarationInHierarchy(hierarchy, first.getDeclaringType(), name, paramTypes, isConstructor);
            if (res != null) {
                return res;
            }
            return first;
        }
        return null;
    }

    public static IMethod findMethodImplementationInHierarchy(ITypeHierarchy hierarchy, IType type, String name, String[] paramTypes, boolean isConstructor) throws JavaModelException {
        IType[] superTypes = hierarchy.getAllSuperclasses(type);
        for (int i = 0; i < superTypes.length; ++i) {
            IMethod found = JavaModelUtil.findMethod(name, paramTypes, isConstructor, superTypes[i]);
            if (found == null) continue;
            if (Flags.isAbstract((int)found.getFlags())) {
                return null;
            }
            return found;
        }
        return null;
    }

    private static IMethod findMethodInHierarchy(ITypeHierarchy hierarchy, IType type, String name, String[] paramTypes, boolean isConstructor) throws JavaModelException {
        IMethod res;
        IMethod method = JavaModelUtil.findMethod(name, paramTypes, isConstructor, type);
        if (method != null) {
            return method;
        }
        IType superClass = hierarchy.getSuperclass(type);
        if (superClass != null && (res = JavaModelUtil.findMethodInHierarchy(hierarchy, superClass, name, paramTypes, isConstructor)) != null) {
            return res;
        }
        if (!isConstructor) {
            IType[] superInterfaces = hierarchy.getSuperInterfaces(type);
            for (int i = 0; i < superInterfaces.length; ++i) {
                IMethod res2 = JavaModelUtil.findMethodInHierarchy(hierarchy, superInterfaces[i], name, paramTypes, false);
                if (res2 == null) continue;
                return res2;
            }
        }
        return method;
    }

    public static IMethod findMethodDefininition(ITypeHierarchy typeHierarchy, IType type, String methodName, String[] paramTypes, boolean isConstructor, boolean testVisibility) throws JavaModelException {
        IMethod res;
        IType superClass = typeHierarchy.getSuperclass(type);
        if (!(superClass == null || (res = JavaModelUtil.findMethodInHierarchy(typeHierarchy, superClass, methodName, paramTypes, isConstructor)) == null || Flags.isPrivate((int)res.getFlags()) || testVisibility && !JavaModelUtil.isVisibleInHierarchy((IMember)res, type.getPackageFragment()))) {
            return res;
        }
        if (!isConstructor) {
            IType[] interfaces = typeHierarchy.getSuperInterfaces(type);
            for (int i = 0; i < interfaces.length; ++i) {
                IMethod res2 = JavaModelUtil.findMethodInHierarchy(typeHierarchy, interfaces[i], methodName, paramTypes, false);
                if (res2 == null) continue;
                return res2;
            }
        }
        return null;
    }

    public static boolean isSameMethodSignature(String name, String[] paramTypes, boolean isConstructor, IMethod curr) throws JavaModelException {
        String[] currParamTypes;
        if ((isConstructor || name.equals(curr.getElementName())) && isConstructor == curr.isConstructor() && paramTypes.length == (currParamTypes = curr.getParameterTypes()).length) {
            for (int i = 0; i < paramTypes.length; ++i) {
                String t2;
                String t1 = Signature.getSimpleName((String)Signature.toString((String)paramTypes[i]));
                if (t1.equals(t2 = Signature.getSimpleName((String)Signature.toString((String)currParamTypes[i])))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isSamePackage(IPackageFragment pack1, IPackageFragment pack2) {
        return pack1.getElementName().equals(pack2.getElementName());
    }

    public static boolean hasMainMethod(IType type) throws JavaModelException {
        IMethod[] methods = type.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].isMainMethod()) continue;
            return true;
        }
        return false;
    }

    public static boolean isBoolean(IField field) throws JavaModelException {
        return field.getTypeSignature().equals("Z");
    }

    public static boolean isOnBuildPath(IJavaProject jproject, IJavaElement element) {
        return jproject.isOnClasspath(element);
    }

    public static boolean isOnClasspath(IJavaElement element) {
        IJavaProject project = element.getJavaProject();
        if (!project.exists()) {
            return false;
        }
        return project.isOnClasspath(element);
    }

    public static String getResolvedTypeName(String refTypeSig, IType declaringType) throws JavaModelException {
        int arrayCount = Signature.getArrayCount((String)refTypeSig);
        char type = refTypeSig.charAt(arrayCount);
        if (type == 'Q') {
            int semi = refTypeSig.indexOf(59, arrayCount + 1);
            if (semi == -1) {
                throw new IllegalArgumentException();
            }
            String name = refTypeSig.substring(arrayCount + 1, semi);
            String[][] resolvedNames = declaringType.resolveType(name);
            if (resolvedNames != null && resolvedNames.length > 0) {
                return JavaModelUtil.concatenateName(resolvedNames[0][0], resolvedNames[0][1]);
            }
            return null;
        }
        return Signature.toString((String)refTypeSig.substring(arrayCount));
    }

    public static boolean isEditable(ICompilationUnit cu) {
        IResource resource = JavaModelUtil.toOriginal(cu).getResource();
        return resource.exists() && !resource.isReadOnly();
    }

    public static IImportDeclaration findImport(ICompilationUnit cu, String simpleName) throws JavaModelException {
        IImportDeclaration[] existing = cu.getImports();
        for (int i = 0; i < existing.length; ++i) {
            int dotPos;
            String curr = existing[i].getElementName();
            if (!curr.endsWith(simpleName) || (dotPos = curr.length() - simpleName.length() - 1) != -1 && (dotPos <= 0 || curr.charAt(dotPos) != '.')) continue;
            return existing[i];
        }
        return null;
    }

    public static IMember toOriginal(IMember member) {
        if (PRIMARY_ONLY) {
            JavaModelUtil.testCompilationUnitOwner("toOriginal", member.getCompilationUnit());
        }
        if (member instanceof IMethod) {
            return JavaModelUtil.toOriginalMethod((IMethod)member);
        }
        return (IMember)member.getPrimaryElement();
    }

    private static IMethod toOriginalMethod(IMethod method) {
        ICompilationUnit cu = method.getCompilationUnit();
        if (cu == null || JavaModelUtil.isPrimary(cu)) {
            return method;
        }
        try {
            if (!method.getElementName().equals(method.getDeclaringType().getElementName())) {
                return (IMethod)method.getPrimaryElement();
            }
            IType originalType = (IType)JavaModelUtil.toOriginal((IMember)method.getDeclaringType());
            IMethod[] methods = originalType.findMethods(method);
            boolean isConstructor = method.isConstructor();
            for (int i = 0; i < methods.length; ++i) {
                if (methods[i].isConstructor() != isConstructor) continue;
                return methods[i];
            }
            return null;
        }
        catch (JavaModelException e) {
            return null;
        }
    }

    public static ICompilationUnit toOriginal(ICompilationUnit cu) {
        if (PRIMARY_ONLY) {
            JavaModelUtil.testCompilationUnitOwner("toOriginal", cu);
        }
        if (cu == null) {
            return cu;
        }
        return cu.getPrimary();
    }

    public static IJavaElement toOriginal(IJavaElement element) {
        return element.getPrimaryElement();
    }

    private static void testCompilationUnitOwner(String methodName, ICompilationUnit cu) {
        if (cu == null) {
            return;
        }
        if (!JavaModelUtil.isPrimary(cu)) {
            JavaPlugin.logErrorMessage(methodName + ": operating with non-primary cu");
        }
    }

    public static IMember toWorkingCopy(IMember member) {
        return member;
    }

    public static IPackageDeclaration toWorkingCopy(IPackageDeclaration declaration) {
        return declaration;
    }

    public static IJavaElement toWorkingCopy(IJavaElement elem) {
        return elem;
    }

    public static IImportContainer toWorkingCopy(IImportContainer container) {
        return container;
    }

    public static IImportDeclaration toWorkingCopy(IImportDeclaration importDeclaration) {
        return importDeclaration;
    }

    public static ICompilationUnit toWorkingCopy(ICompilationUnit cu) {
        return cu;
    }

    public static boolean isPrimary(ICompilationUnit cu) {
        return cu.getOwner() == null;
    }

    public static boolean filterNotPresentException(CoreException exception) {
        if (!(exception instanceof JavaModelException)) {
            return true;
        }
        JavaModelException je = (JavaModelException)((Object)exception);
        if (!je.isDoesNotExist()) {
            return true;
        }
        IJavaElement[] elements = je.getJavaModelStatus().getElements();
        for (int i = 0; i < elements.length; ++i) {
            IJavaElement element = elements[i];
            ICompilationUnit unit = (ICompilationUnit)element.getAncestor(5);
            if (unit == null) {
                return true;
            }
            if (unit.isWorkingCopy()) continue;
            return true;
        }
        return false;
    }

    public static IType[] getAllSuperTypes(IType type, IProgressMonitor pm) throws JavaModelException {
        HashSet<IType> types = new HashSet<IType>(Arrays.asList(type.newSupertypeHierarchy(pm).getAllSupertypes(type)));
        IType objekt = type.getJavaProject().findType("java.lang.Object");
        if (objekt != null) {
            types.add(objekt);
        }
        return types.toArray(new IType[types.size()]);
    }

    public static boolean isExcludedPath(IPath resourcePath, IPath[] exclusionPatterns) {
        char[] path = resourcePath.toString().toCharArray();
        int length = exclusionPatterns.length;
        for (int i = 0; i < length; ++i) {
            char[] pattern = exclusionPatterns[i].toString().toCharArray();
            if (!CharOperation.pathMatch((char[])pattern, (char[])path, (boolean)true, (char)'/')) continue;
            return true;
        }
        return false;
    }

    public static final boolean isExcluded(IPath resourcePath, char[][] exclusionPatterns) {
        if (exclusionPatterns == null) {
            return false;
        }
        char[] path = resourcePath.toString().toCharArray();
        int length = exclusionPatterns.length;
        for (int i = 0; i < length; ++i) {
            if (!CharOperation.pathMatch((char[])exclusionPatterns[i], (char[])path, (boolean)true, (char)'/')) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reconcile(ICompilationUnit unit) throws JavaModelException {
        ICompilationUnit iCompilationUnit = unit;
        synchronized (iCompilationUnit) {
            unit.reconcile();
        }
    }

    public static boolean isJDTCore_1_5() {
        if (fgIsJDTCore_1_5 == null) {
            fgIsJDTCore_1_5 = new Boolean(JavaCore.getDefaultOptions().containsKey("org.eclipse.jdt.core.compiler.problem.unsafeTypeOperation"));
        }
        return fgIsJDTCore_1_5;
    }

    public static IClasspathEntry getClasspathEntryToEdit(IJavaProject jproject, IPath containerPath, IPath libPath) throws JavaModelException {
        IClasspathContainer container = JavaCore.getClasspathContainer((IPath)containerPath, (IJavaProject)jproject);
        ClasspathContainerInitializer initializer = JavaCore.getClasspathContainerInitializer((String)containerPath.segment(0));
        if (container != null && initializer != null && initializer.canUpdateClasspathContainer(containerPath, jproject)) {
            IClasspathEntry[] entries = container.getClasspathEntries();
            for (int i = 0; i < entries.length; ++i) {
                IClasspathEntry curr = entries[i];
                IClasspathEntry resolved = JavaCore.getResolvedClasspathEntry((IClasspathEntry)curr);
                if (resolved == null || !libPath.equals(resolved.getPath())) continue;
                return curr;
            }
        }
        return null;
    }
}

