/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.launcher;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.junit.launcher.JUnitBaseLaunchConfiguration;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jface.util.Assert;

public class JUnitLaunchConfiguration
extends JUnitBaseLaunchConfiguration {
    public static final String ID_JUNIT_APPLICATION = "org.eclipse.jdt.junit.launchconfig";

    protected VMRunnerConfiguration createVMRunner(ILaunchConfiguration configuration, IType[] testTypes, int port, String runMode) throws CoreException {
        int i;
        String[] classPath = this.createClassPath(configuration);
        String progArgs = this.getProgramArguments(configuration);
        VMRunnerConfiguration vmConfig = new VMRunnerConfiguration("org.eclipse.jdt.internal.junit.runner.RemoteTestRunner", classPath);
        String testName = configuration.getAttribute("org.eclipse.jdt.junit.TESTNAME", "");
        Vector<String> argv = new Vector<String>(10);
        ExecutionArguments execArgs = new ExecutionArguments("", progArgs);
        String[] pa = execArgs.getProgramArgumentsArray();
        for (i = 0; i < pa.length; ++i) {
            argv.add(pa[i]);
        }
        argv.add("-version");
        argv.add("3");
        argv.add("-port");
        argv.add(Integer.toString(port));
        if (this.keepAlive(configuration) && runMode.equals("debug")) {
            argv.add(0, "-keepalive");
        }
        if (testName.length() > 0) {
            argv.add("-test");
            argv.add(testTypes[0].getFullyQualifiedName() + ":" + testName);
        } else if (testTypes.length > 1) {
            String fileName = this.createTestNamesFile(testTypes);
            argv.add("-testNameFile");
            argv.add(fileName);
        } else {
            argv.add("-classNames");
            for (i = 0; i < testTypes.length; ++i) {
                argv.add(testTypes[i].getFullyQualifiedName());
            }
        }
        Object[] args = new String[argv.size()];
        argv.copyInto(args);
        vmConfig.setProgramArguments((String[])args);
        return vmConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createTestNamesFile(IType[] testTypes) throws CoreException {
        try {
            File file = File.createTempFile("testNames", ".txt");
            file.deleteOnExit();
            BufferedWriter bw = null;
            try {
                bw = new BufferedWriter(new FileWriter(file));
                for (int i = 0; i < testTypes.length; ++i) {
                    String testName = testTypes[i].getFullyQualifiedName();
                    bw.write(testName);
                    bw.newLine();
                }
            }
            finally {
                if (bw != null) {
                    bw.close();
                }
            }
            return file.getAbsolutePath();
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.junit", 4, "", (Throwable)e));
        }
    }

    private String[] createClassPath(ILaunchConfiguration configuration) throws CoreException {
        String[] classPath;
        block11: {
            URL runtimeURL = Platform.getBundle((String)"org.eclipse.jdt.junit.runtime").getEntry("/");
            URL url = Platform.getBundle((String)"org.eclipse.jdt.junit").getEntry("/");
            String[] cp = this.getClasspath(configuration);
            classPath = null;
            try {
                if (BootLoader.inDevelopmentMode()) {
                    ArrayList<String> junitEntries = new ArrayList<String>();
                    try {
                        junitEntries.add(Platform.asLocalURL((URL)new URL(url, "bin")).getFile());
                    }
                    catch (IOException e3) {
                        try {
                            junitEntries.add(Platform.asLocalURL((URL)new URL(url, "junitsupport.jar")).getFile());
                        }
                        catch (IOException e4) {
                            // empty catch block
                        }
                    }
                    try {
                        junitEntries.add(Platform.asLocalURL((URL)new URL(runtimeURL, "bin")).getFile());
                    }
                    catch (IOException e1) {
                        try {
                            junitEntries.add(Platform.asLocalURL((URL)new URL(runtimeURL, "junitruntime.jar")).getFile());
                        }
                        catch (IOException e4) {
                            // empty catch block
                        }
                    }
                    Assert.isTrue((junitEntries.size() == 2 ? 1 : 0) != 0, (String)"Required JARs available");
                    classPath = new String[cp.length + junitEntries.size()];
                    Object[] jea = junitEntries.toArray();
                    System.arraycopy(cp, 0, classPath, 0, cp.length);
                    System.arraycopy(jea, 0, classPath, cp.length, jea.length);
                    break block11;
                }
                classPath = new String[cp.length + 2];
                System.arraycopy(cp, 0, classPath, 2, cp.length);
                classPath[0] = Platform.asLocalURL((URL)new URL(url, "junitsupport.jar")).getFile();
                classPath[1] = Platform.asLocalURL((URL)new URL(runtimeURL, "junitruntime.jar")).getFile();
            }
            catch (IOException e) {
                JUnitPlugin.log(e);
            }
        }
        return classPath;
    }
}

