/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.IUndoManager;
import org.eclipse.ltk.core.refactoring.IUndoManagerListener;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.internal.core.refactoring.ContentStamps;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;

public class SaveListener
implements IResourceChangeListener,
IUndoManagerListener {
    private DeltaVisitor fVisitor = new DeltaVisitor();
    private int fInChangeExecution;
    private static final SaveListener INSTANCE = new SaveListener();

    public static SaveListener getInstance() {
        return INSTANCE;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            IResourceDelta delta = event.getDelta();
            if (delta != null && this.fInChangeExecution == 0) {
                delta.accept((IResourceDeltaVisitor)this.fVisitor);
            }
        }
        catch (CoreException e) {
            RefactoringCorePlugin.log(e);
        }
    }

    public void undoStackChanged(IUndoManager manager) {
    }

    public void redoStackChanged(IUndoManager manager) {
    }

    public void aboutToPerformChange(IUndoManager manager, Change change) {
        ++this.fInChangeExecution;
    }

    public void changePerformed(IUndoManager manager, Change change) {
        --this.fInChangeExecution;
    }

    public void startup() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        RefactoringCore.getUndoManager().addListener(this);
    }

    public void shutdown() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        RefactoringCore.getUndoManager().removeListener(this);
    }

    private class DeltaVisitor
    implements IResourceDeltaVisitor {
        private DeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) {
            IResource resource = delta.getResource();
            if (resource.getType() == 1 && delta.getKind() == 4 && (delta.getFlags() & 0x100) != 0) {
                IFile file = (IFile)resource;
                ContentStamps.increment(file);
            }
            return true;
        }
    }
}

