/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.ResourceNode;
import org.eclipse.compare.internal.BufferedResourceNode;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class LocalResourceTypedElement
extends ResourceNode {
    private boolean fDirty = false;
    private IFile fDeleteFile;

    public LocalResourceTypedElement(IResource resource) {
        super(resource);
    }

    protected IStructureComparator createChild(IResource child) {
        return new LocalResourceTypedElement(child);
    }

    public void setContent(byte[] contents) {
        this.fDirty = true;
        super.setContent(contents);
    }

    public void update(IResource resource) {
        this.discardBuffer();
        this.fireContentChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(IProgressMonitor pm) throws CoreException {
        if (this.fDirty) {
            if (this.fDeleteFile != null) {
                this.fDeleteFile.delete(true, true, pm);
                return;
            }
            IResource resource = this.getResource();
            if (resource instanceof IFile) {
                ByteArrayInputStream is = new ByteArrayInputStream(this.getContent());
                try {
                    IFile file = (IFile)resource;
                    if (file.exists()) {
                        file.setContents((InputStream)is, false, true, pm);
                    } else {
                        file.create((InputStream)is, false, pm);
                    }
                    this.fDirty = false;
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this.fireContentChanged();
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                this.fireContentChanged();
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
    }

    public ITypedElement replace(ITypedElement child, ITypedElement other) {
        IFile file;
        IFolder folder;
        IResource resource;
        if (child == null && (resource = this.getResource()) instanceof IFolder) {
            folder = (IFolder)resource;
            file = folder.getFile(other.getName());
            child = new BufferedResourceNode((IResource)file);
        }
        if (other == null) {
            resource = this.getResource();
            if (resource instanceof IFolder && (file = (folder = (IFolder)resource).getFile(child.getName())) != null && file.exists()) {
                this.fDeleteFile = file;
                this.fDirty = true;
            }
            return null;
        }
        if (other instanceof IStreamContentAccessor && child instanceof IEditableContent) {
            IEditableContent dst = (IEditableContent)child;
            try {
                InputStream is = ((IStreamContentAccessor)other).getContents();
                byte[] bytes = LocalResourceTypedElement.readBytes(is);
                if (bytes != null) {
                    dst.setContent(bytes);
                }
            }
            catch (CoreException ex) {
                // empty catch block
            }
        }
        this.fireContentChanged();
        return child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static byte[] readBytes(InputStream in) {
        ByteArrayOutputStream bos;
        block18: {
            IOException x2;
            block15: {
                int c;
                bos = new ByteArrayOutputStream();
                while ((c = in.read()) != -1) {
                    bos.write(c);
                }
                Object var5_4 = null;
                if (in == null) break block15;
                try {
                    in.close();
                }
                catch (IOException x2) {
                    // empty catch block
                }
            }
            try {
                bos.close();
            }
            catch (IOException x2) {}
            break block18;
            {
                catch (IOException ex) {
                    byte[] byArray = null;
                    Object var5_5 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException x2) {
                            // empty catch block
                        }
                    }
                    try {
                        bos.close();
                    }
                    catch (IOException x2) {
                        // empty catch block
                    }
                    return byArray;
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException x2) {
                        // empty catch block
                    }
                }
                try {
                    bos.close();
                }
                catch (IOException x2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return bos.toByteArray();
    }

    public InputStream getContents() throws CoreException {
        if (this.getResource().exists()) {
            return super.getContents();
        }
        return null;
    }
}

