/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.launching;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathProvider;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;

public class StandardClasspathProvider
implements IRuntimeClasspathProvider {
    public IRuntimeClasspathEntry[] computeUnresolvedClasspath(ILaunchConfiguration configuration) throws CoreException {
        boolean useDefault = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, true);
        if (useDefault) {
            IJavaProject proj = JavaRuntime.getJavaProject(configuration);
            if (proj == null) {
                return this.computeJRELibraries(configuration);
            }
            return JavaRuntime.computeUnresolvedRuntimeClasspath(proj);
        }
        return this.recoverRuntimePath(configuration, IJavaLaunchConfigurationConstants.ATTR_CLASSPATH);
    }

    private IRuntimeClasspathEntry[] computeJRELibraries(ILaunchConfiguration configuration) throws CoreException {
        IVMInstall vm = JavaRuntime.computeVMInstall(configuration);
        Path path = new Path(JavaRuntime.JRE_CONTAINER);
        path = path.append(vm.getVMInstallType().getId()).append(vm.getName());
        IRuntimeClasspathEntry entry = JavaRuntime.newRuntimeContainerClasspathEntry((IPath)path, 1);
        return new IRuntimeClasspathEntry[]{entry};
    }

    public IRuntimeClasspathEntry[] resolveClasspath(IRuntimeClasspathEntry[] entries, ILaunchConfiguration configuration) throws CoreException {
        ArrayList<IRuntimeClasspathEntry> all = new ArrayList<IRuntimeClasspathEntry>(entries.length);
        for (int i = 0; i < entries.length; ++i) {
            IRuntimeClasspathEntry[] resolved = JavaRuntime.resolveRuntimeClasspathEntry(entries[i], configuration);
            for (int j = 0; j < resolved.length; ++j) {
                all.add(resolved[j]);
            }
        }
        return all.toArray(new IRuntimeClasspathEntry[all.size()]);
    }

    protected IRuntimeClasspathEntry[] recoverRuntimePath(ILaunchConfiguration configuration, String attribute) throws CoreException {
        List entries = configuration.getAttribute(attribute, Collections.EMPTY_LIST);
        IRuntimeClasspathEntry[] rtes = new IRuntimeClasspathEntry[entries.size()];
        Iterator iter = entries.iterator();
        int i = 0;
        while (iter.hasNext()) {
            rtes[i] = JavaRuntime.newRuntimeClasspathEntry((String)iter.next());
            ++i;
        }
        return rtes;
    }
}

