/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IConfirmQuery;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;

class ReadOnlyResourceFinder {
    private ReadOnlyResourceFinder() {
    }

    static boolean confirmDeleteOfReadOnlyElements(IJavaElement[] javaElements, IResource[] resources, IReorgQueries queries) throws CoreException {
        String queryTitle = RefactoringCoreMessages.getString("ReadOnlyResourceFinder.0");
        String question = RefactoringCoreMessages.getString("ReadOnlyResourceFinder.1");
        return ReadOnlyResourceFinder.confirmOperationOnReadOnlyElements(queryTitle, question, javaElements, resources, queries);
    }

    static boolean confirmMoveOfReadOnlyElements(IJavaElement[] javaElements, IResource[] resources, IReorgQueries queries) throws CoreException {
        String queryTitle = RefactoringCoreMessages.getString("ReadOnlyResourceFinder.2");
        String question = RefactoringCoreMessages.getString("ReadOnlyResourceFinder.3");
        return ReadOnlyResourceFinder.confirmOperationOnReadOnlyElements(queryTitle, question, javaElements, resources, queries);
    }

    private static boolean confirmOperationOnReadOnlyElements(String queryTitle, String question, IJavaElement[] javaElements, IResource[] resources, IReorgQueries queries) throws CoreException {
        boolean hasReadOnlyResources = ReadOnlyResourceFinder.hasReadOnlyResourcesAndSubResources(javaElements, resources);
        if (hasReadOnlyResources) {
            IConfirmQuery query = queries.createYesNoQuery(queryTitle, false, 5);
            return query.confirm(question);
        }
        return true;
    }

    private static boolean hasReadOnlyResourcesAndSubResources(IJavaElement[] javaElements, IResource[] resources) throws CoreException {
        return ReadOnlyResourceFinder.hasReadOnlyResourcesAndSubResources(resources) || ReadOnlyResourceFinder.hasReadOnlyResourcesAndSubResources(javaElements);
    }

    private static boolean hasReadOnlyResourcesAndSubResources(IJavaElement[] javaElements) throws CoreException {
        for (int i = 0; i < javaElements.length; ++i) {
            if (!ReadOnlyResourceFinder.hasReadOnlyResourcesAndSubResources(javaElements[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean hasReadOnlyResourcesAndSubResources(IJavaElement javaElement) throws CoreException {
        switch (javaElement.getElementType()) {
            case 6: {
                Assert.isTrue(((IClassFile)javaElement).getResource() instanceof IFile);
            }
            case 5: {
                IResource resource = ReorgUtils.getResource(javaElement);
                return resource != null && resource.isReadOnly();
            }
            case 4: {
                IResource packResource = ReorgUtils.getResource(javaElement);
                if (packResource == null) {
                    return false;
                }
                IPackageFragment pack = (IPackageFragment)javaElement;
                if (packResource.isReadOnly()) {
                    return true;
                }
                Object[] nonJava = pack.getNonJavaResources();
                for (int i = 0; i < nonJava.length; ++i) {
                    Object object = nonJava[i];
                    if (!(object instanceof IResource) || !ReadOnlyResourceFinder.hasReadOnlyResourcesAndSubResources((IResource)object)) continue;
                    return true;
                }
                return ReadOnlyResourceFinder.hasReadOnlyResourcesAndSubResources(pack.getChildren());
            }
            case 3: {
                IPackageFragmentRoot root = (IPackageFragmentRoot)javaElement;
                if (root.isArchive()) {
                    return false;
                }
                IResource pfrResource = ReorgUtils.getResource(javaElement);
                if (pfrResource == null) {
                    return false;
                }
                if (pfrResource.isReadOnly()) {
                    return true;
                }
                Object[] nonJava1 = root.getNonJavaResources();
                for (int i = 0; i < nonJava1.length; ++i) {
                    Object object = nonJava1[i];
                    if (!(object instanceof IResource) || !ReadOnlyResourceFinder.hasReadOnlyResourcesAndSubResources((IResource)object)) continue;
                    return true;
                }
                return ReadOnlyResourceFinder.hasReadOnlyResourcesAndSubResources(root.getChildren());
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return false;
            }
        }
        Assert.isTrue(false);
        return false;
    }

    private static boolean hasReadOnlyResourcesAndSubResources(IResource[] resources) throws CoreException {
        for (int i = 0; i < resources.length; ++i) {
            if (!ReadOnlyResourceFinder.hasReadOnlyResourcesAndSubResources(resources[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean hasReadOnlyResourcesAndSubResources(IResource resource) throws CoreException {
        if (resource.isLinked()) {
            return false;
        }
        if (resource.isReadOnly()) {
            return true;
        }
        if (resource instanceof IContainer) {
            return ReadOnlyResourceFinder.hasReadOnlyResourcesAndSubResources(((IContainer)resource).members());
        }
        return false;
    }
}

